/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeListScrollButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewPanel;
import se.prediktera.breeze.frontend.wizard.model.QuantificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;

public class TabViewContainer
extends AbstractViewPanel {
    private final List<ViewClass> groupList = new ArrayList<ViewClass>();
    private Object entrydata;
    private Object viewdata;
    private final JPanel cardPanel;
    private final BreezeListScrollButton groupViewList;
    private final BreezeListScrollButton viewList;

    public TabViewContainer(BreezeMainPanel breezeMainPanel) {
        super(breezeMainPanel);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setLayout(new GridBagLayout());
        this.cardPanel = new JPanel();
        this.cardPanel.setBackground(breezeTheme.getPanelBackground());
        this.cardPanel.setLayout(new CardLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.cardPanel, gridBagConstraints);
        this.groupViewList = this.createViewList(breezeMainPanel, 35);
        this.groupViewList.addListSelectionListener(this::groupViewListValueChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.groupViewList, gridBagConstraints);
        this.viewList = this.createViewList(breezeMainPanel, 35);
        this.viewList.addListSelectionListener(this::viewListValueChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.viewList, gridBagConstraints);
        this.groupViewList.setListFont(new Font(this.groupViewList.getListFont().getFontName(), 1, this.groupViewList.getListFont().getSize()));
        this.groupViewList.setListBackground(Color.gray);
        this.groupViewList.setListForeground(Color.white);
        this.groupViewList.setSelectionBackground(this.viewList.getListBackground());
        this.groupViewList.setVisible(false);
    }

    private BreezeListScrollButton createViewList(EntryMainPanelInterface entryMainPanelInterface, int n) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        BreezeListScrollButton breezeListScrollButton = new BreezeListScrollButton();
        breezeListScrollButton.setMinimumSize(new Dimension(25, n));
        breezeListScrollButton.setPreferredSize(new Dimension(53, n));
        breezeListScrollButton.setListBackground(breezeTheme.getSettingPanelBackground());
        breezeListScrollButton.setListForeground(breezeTheme.getLabelForegroundDifuse());
        breezeListScrollButton.setSelectionBackground(new Color(239, 239, 239));
        breezeListScrollButton.setSelectionForeground(entryMainPanelInterface.getPageColor());
        ViewPanel viewPanel = new ViewPanel(entryMainPanelInterface);
        breezeListScrollButton.setCellRenderer(viewPanel);
        breezeListScrollButton.setListFont(new Font("Tahoma", 0, 14));
        breezeListScrollButton.setSelectedIndex(0);
        breezeListScrollButton.setForeground(new Color(110, 110, 110));
        breezeListScrollButton.setSelectionMode(0);
        breezeListScrollButton.setLayoutOrientation(2);
        breezeListScrollButton.setVisibleRowCount(1);
        return breezeListScrollButton;
    }

    public ViewClass addGroup(String string) {
        ViewClass viewClass = new ViewClass(string, null, new ArrayList());
        this.groupList.add(viewClass);
        return viewClass;
    }

    public void insertTab(AbstractViewPanel abstractViewPanel) {
        this.addTab(abstractViewPanel.getTitle(), abstractViewPanel);
    }

    public void insertTab(String string, AbstractViewPanel abstractViewPanel) {
        this.addTab("Group", string, null, abstractViewPanel, 0);
    }

    public void addTab(AbstractViewPanel abstractViewPanel) {
        this.addTab(abstractViewPanel.getTitle(), abstractViewPanel);
    }

    public void addTab(String string, AbstractViewPanel abstractViewPanel) {
        this.addTab("Group", string, null, abstractViewPanel, -1);
    }

    public void addTab(String string, String string2, Object object, AbstractViewPanel abstractViewPanel) {
        this.addTab(string, string2, object, abstractViewPanel, -1);
    }

    public void addTab(String string, String string2, Object object, AbstractViewPanel abstractViewPanel, int n) {
        ViewClass viewClass = this.getSummaryViewGroupViewClass(string);
        if (viewClass == null) {
            viewClass = this.addGroup(string);
        }
        List list = (List)viewClass.getValue();
        ViewClass viewClass2 = new ViewClass(string2, abstractViewPanel, object);
        if (n >= 0) {
            list.add(n, viewClass2);
        } else {
            list.add(viewClass2);
        }
        this.groupViewList.setModel(new ArrayListModel(this.groupList));
        this.groupViewList.checkIfIconsNeeded();
        this.groupViewList.setVisible(this.groupList.size() > 1);
        this.cardPanel.add(abstractViewPanel.getTypeId(), (Component)((Object)abstractViewPanel));
    }

    public boolean hasPanel(AbstractViewPanel abstractViewPanel) {
        ViewClass viewClass = this.getSummaryViewGroupViewClass("Group");
        List list = (List)viewClass.getValue();
        return TabViewContainer.getViewPanel(list, abstractViewPanel) != null;
    }

    private static ViewClass getViewPanel(List<ViewClass> list, AbstractViewPanel abstractViewPanel) {
        for (ViewClass viewClass : list) {
            if (!viewClass.getPanel().equals(abstractViewPanel)) continue;
            return viewClass;
        }
        return null;
    }

    public void removeTabs() {
        ViewClass viewClass = this.getSummaryViewGroupViewClass("Group");
        if (viewClass != null) {
            List list = (List)viewClass.getValue();
            for (ViewClass viewClass2 : new ArrayList(list)) {
                this.removeTab(viewClass2.getPanel(), list);
            }
        }
    }

    public void removeTab(AbstractViewPanel abstractViewPanel) {
        ViewClass viewClass = this.getSummaryViewGroupViewClass("Group");
        this.removeTab(abstractViewPanel, (List)viewClass.getValue());
    }

    private void removeTab(AbstractViewPanel abstractViewPanel, List<ViewClass> list) {
        ViewClass viewClass = TabViewContainer.getViewPanel(list, abstractViewPanel);
        if (viewClass != null) {
            list.remove(viewClass);
            this.groupViewListValueChanged(null);
        }
    }

    private ViewClass getSummaryViewGroupViewClass(String string) {
        for (ViewClass viewClass : this.groupList) {
            String string2 = viewClass.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return viewClass;
        }
        return null;
    }

    public int getGroups() {
        return this.groupList.size();
    }

    public int getTabs(int n) {
        ViewClass viewClass = this.groupList.get(n);
        List list = (List)viewClass.getValue();
        return list.size();
    }

    public ViewClass getTabAt(int n, int n2) {
        ViewClass viewClass = this.groupList.get(n);
        List list = (List)viewClass.getValue();
        return (ViewClass)list.get(n2);
    }

    public void clearTabs() {
        this.groupList.clear();
        this.cardPanel.removeAll();
        this.groupViewList.setVisible(false);
        this.viewList.setModel(new ArrayListModel(new ArrayList()));
        this.viewList.checkIfIconsNeeded();
    }

    @Override
    public String getType() {
        return "TabViewContainer";
    }

    @Override
    public void beginUpdate() {
        ViewClass viewClass = (ViewClass)this.viewList.getSelectedValue();
        if (viewClass != null) {
            viewClass.getPanel().beginUpdate();
        }
    }

    @Override
    public void endUpdate() {
        ViewClass viewClass = (ViewClass)this.viewList.getSelectedValue();
        if (viewClass != null) {
            viewClass.getPanel().endUpdate();
        }
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.entrydata = object;
        this.viewdata = object2;
        this.updateSelected(this.getSelectedTab());
    }

    public void setSelectedTab(int n, int n2) {
        this.groupViewList.setSelectedIndex(n);
        this.viewList.setSelectedIndex(n2);
    }

    public ViewClass getSelectedTab() {
        return (ViewClass)this.viewList.getSelectedValue();
    }

    public int getSelectedTabIndex() {
        return this.viewList.getSelectedIndex();
    }

    public void updateSelected(ViewClass viewClass) {
        if (viewClass != null) {
            AbstractViewPanel abstractViewPanel = viewClass.getPanel();
            abstractViewPanel.showEntry(this.entrydata, this.viewdata);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.entrydata = null;
        this.viewdata = null;
    }

    private void groupViewListValueChanged(ListSelectionEvent listSelectionEvent) {
        ViewClass viewClass;
        if (!(listSelectionEvent != null && listSelectionEvent.getValueIsAdjusting() || (viewClass = (ViewClass)this.groupViewList.getSelectedValue()) == null)) {
            List list = (List)viewClass.getValue();
            this.viewList.setModel(new ArrayListModel(list));
            this.viewList.checkIfIconsNeeded();
            this.viewList.setSelectedIndex(0);
            this.viewList.ensureIndexIsVisible(0);
        }
    }

    private void viewListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ViewClass viewClass = this.getSelectedTab();
            if (viewClass != null) {
                CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
                cardLayout.show(this.cardPanel, viewClass.getPanel().getTypeId());
            }
            this.updateSelected(viewClass);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setBackground(Color.white);
        ArrayList<PPModelInfo> arrayList = new ArrayList<PPModelInfo>();
        arrayList.add(new SampleModelWizard.Info());
        arrayList.add(new QuantificationModelWizard.Info());
        EntryMainPanel entryMainPanel = new EntryMainPanel(){};
        TabViewContainer tabViewContainer = new TabViewContainer(entryMainPanel);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                tabViewContainer.addTab("Group" + i, "Test" + i + j, null, new TestViewPanel());
            }
        }
        tabViewContainer.setSelectedTab(0, 0);
        jFrame.getContentPane().add((Component)((Object)tabViewContainer));
        jFrame.setSize(600, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    private static class TestViewPanel
    extends AbstractViewPanel {
        private TestViewPanel() {
        }

        @Override
        public void showEntry(Object object, Object object2) {
        }

        @Override
        public String getType() {
            return "Test";
        }
    }
}

