/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.MainViewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.AbstractVisualizationPanel;

public class ViewContainer
extends AbstractViewPanel {
    private Dimension defaultsize;
    private final JPanel scrollPanel;

    public ViewContainer() {
        this(false);
    }

    public ViewContainer(boolean bl) {
        this(null, false);
    }

    public ViewContainer(BreezeMainPanel breezeMainPanel, boolean bl) {
        super(breezeMainPanel);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setLayout(new BorderLayout());
        breezeScrollPane.setBackground(breezeTheme.getPanelBackground());
        breezeScrollPane.setBorder(null);
        this.scrollPanel = new JPanel();
        this.scrollPanel.setBackground(breezeTheme.getPanelBackground());
        this.scrollPanel.setLayout(new GridBagLayout());
        breezeScrollPane.setViewportView(this.scrollPanel);
        this.add(breezeScrollPane, "Center");
        if (!bl) {
            this.removeAll();
            this.add(this.scrollPanel, "Center");
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        AbstractViewPanel abstractViewPanel = this.getLastPanel();
        if (abstractViewPanel != null) {
            abstractViewPanel.addActionListener(actionListener);
        }
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        for (int i = 0; i < this.scrollPanel.getComponentCount(); ++i) {
            Component component = this.scrollPanel.getComponent(i);
            if (component instanceof AbstractViewPanel) {
                AbstractViewPanel abstractViewPanel = (AbstractViewPanel)((Object)component);
                abstractViewPanel.addComponent(breezeMainPanel);
                continue;
            }
            if (!(component instanceof MainViewPanel)) continue;
            MainViewPanel mainViewPanel = (MainViewPanel)component;
            mainViewPanel.getViewPanel().addComponent(breezeMainPanel);
        }
    }

    public void addViewPanel(Component component) {
        this.addViewPanel(component, this.scrollPanel.getComponentCount(), 0);
    }

    public void addViewPanel(Component component, int n, int n2) {
        this.addViewPanel(component, n, n2, 1, 1);
    }

    public void addViewPanel(Component component, int n, int n2, int n3, int n4) {
        this.addViewPanel(component, n, n2, n3, n4, null);
    }

    public void addViewPanel(Component component, int n, int n2, int n3, int n4, Insets insets) {
        this.addViewPanel(component, n, n2, n3, n4, insets, 1.0, 1.0);
    }

    public void addViewPanel(Component component, int n, int n2, int n3, int n4, Insets insets, double d, double d2) {
        if (this.defaultsize != null) {
            component.setPreferredSize(this.defaultsize);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (insets == null) {
            insets = new Insets(n2 > 0 ? 15 : 0, n > 0 ? 15 : 0, 0, 0);
        }
        gridBagConstraints.insets = insets;
        this.scrollPanel.add(component, gridBagConstraints);
        component.setBackground(this.getBackground());
        if (component instanceof AbstractVisualizationPanel) {
            ((AbstractVisualizationPanel)((Object)component)).setViewPanel(this);
        }
    }

    public void removeViewPanels() {
        this.scrollPanel.removeAll();
    }

    public void removeViewPanel(Component component) {
        this.scrollPanel.remove(component);
    }

    @Override
    public String getType() {
        return "Container";
    }

    @Override
    public boolean hasActionListener() {
        AbstractViewPanel abstractViewPanel = this.getLastPanel();
        if (abstractViewPanel != null) {
            return abstractViewPanel.hasActionListener();
        }
        return false;
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        AbstractViewPanel abstractViewPanel = this.getLastPanel();
        if (abstractViewPanel != null) {
            abstractViewPanel.removeActionListener(actionListener);
        }
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
        this.scrollPanel.setBackground(color);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        for (int i = 0; i < this.scrollPanel.getComponentCount(); ++i) {
            AbstractViewPanel abstractViewPanel = (AbstractViewPanel)((Object)this.scrollPanel.getComponent(i));
            if (!abstractViewPanel.isVisible()) continue;
            abstractViewPanel.showEntry(object, object2);
        }
    }

    @Override
    public void beginUpdate() {
        for (int i = 0; i < this.scrollPanel.getComponentCount(); ++i) {
            ((AbstractViewPanel)((Object)this.scrollPanel.getComponent(i))).beginUpdate();
        }
    }

    @Override
    public void endUpdate() {
        for (int i = 0; i < this.scrollPanel.getComponentCount(); ++i) {
            ((AbstractViewPanel)((Object)this.scrollPanel.getComponent(i))).endUpdate();
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        for (int i = this.scrollPanel.getComponentCount() - 1; i >= 0; --i) {
            AbstractViewPanel abstractViewPanel = (AbstractViewPanel)((Object)this.scrollPanel.getComponent(i));
            abstractViewPanel.cleanUp();
        }
    }

    private AbstractViewPanel getLastPanel() {
        for (int i = this.scrollPanel.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.scrollPanel.getComponent(i);
            if (!(component instanceof AbstractViewPanel)) continue;
            return (AbstractViewPanel)((Object)component);
        }
        return null;
    }

    public int getViewPanelCount() {
        return this.scrollPanel.getComponentCount();
    }

    public AbstractViewPanel getViewPanelAt(int n) {
        if (n < this.scrollPanel.getComponentCount()) {
            return (AbstractViewPanel)((Object)this.scrollPanel.getComponent(n));
        }
        return null;
    }

    @Override
    public boolean contentReady() {
        for (int i = 0; i < this.getViewPanelCount(); ++i) {
            AbstractViewPanel abstractViewPanel = this.getViewPanelAt(i);
            if (!abstractViewPanel.isVisible() || abstractViewPanel.contentReady()) continue;
            return false;
        }
        return true;
    }
}

