/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeListScrollButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.ViewPanel;

public class ViewList
extends BreezeListScrollButton {
    private final ViewPanel viewPanel = new ViewPanel();

    public ViewList() {
        this.setCellRenderer(this.viewPanel);
        this.setSelectionMode(0);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(1);
        this.setListForeground(BreezeTheme.getInstance().getLabelForegroundDifuse());
        this.setSelectionBackground(Color.white);
        this.setListFont(new Font("Tahoma", 0, 14));
        final BreezeList breezeList = this.getList();
        breezeList.addMouseMotionListener(new MouseMotionAdapter(this){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = breezeList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    ViewPanel viewPanel = (ViewPanel)breezeList.getCellRenderer();
                    viewPanel.setHoverIndex(n);
                    breezeList.repaint();
                }
            }
        });
        breezeList.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ViewPanel viewPanel = (ViewPanel)breezeList.getCellRenderer();
                viewPanel.setHoverIndex(-1);
                breezeList.repaint();
            }
        });
    }

    public Object getObjectAt(int n) {
        ArrayListModel arrayListModel = (ArrayListModel)this.getModel();
        return arrayListModel.getElementAt(n);
    }

    public void setMainPanel(EntryMainPanelInterface entryMainPanelInterface) {
        this.viewPanel.setMainPanel(entryMainPanelInterface);
    }
}

