/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import lombok.Generated;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.notification.NotificationPanel;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;

public class ViewPanel
extends JPanel
implements ListCellRenderer {
    private final ImageIcon notificationsIcon;
    private EntryMainPanelInterface mainPanel;
    private final JPanel borderPanel = new JPanel();
    private final JLabel textLabel = new JLabel();
    private int hoverIndex = -1;
    private final ImageIcon errorIcon;

    public ViewPanel() {
        this((EntryMainPanelInterface)null);
        this.textLabel.setVerticalTextPosition(0);
    }

    public ViewPanel(EntryMainPanelInterface entryMainPanelInterface) {
        this.mainPanel = entryMainPanelInterface;
        this.setCursor(new Cursor(0));
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.borderPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Tahoma", 0, 18));
        jLabel.setForeground(new Color(30, 30, 30));
        jLabel.setHorizontalAlignment(0);
        jLabel.setIcon(ImageHelper.getResourceIcon("warningSmall"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.borderPanel.add((Component)jLabel, gridBagConstraints);
        this.textLabel.setFont(new Font("Tahoma", 0, 14));
        this.textLabel.setForeground(new Color(30, 30, 30));
        this.textLabel.setHorizontalAlignment(0);
        this.textLabel.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.borderPanel.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.borderPanel, gridBagConstraints);
        this.notificationsIcon = ImageHelper.getResourceIcon("upcoming");
        this.errorIcon = ImageHelper.getResourceIcon("error");
        jLabel.setVisible(false);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, BreezeTheme.getInstance().getPanelGradientBackground2()));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof ViewClass) {
            Measurement measurement;
            ViewClass viewClass = (ViewClass)object;
            this.textLabel.setText(viewClass.getName());
            this.textLabel.setIcon(null);
            AbstractViewPanel abstractViewPanel = viewClass.getPanel();
            if (abstractViewPanel instanceof NotificationPanel && this.mainPanel != null) {
                Measurement measurement2 = Measurement.getMeasurement(this.mainPanel.getSelectedEntry());
                if (measurement2 != null) {
                    if (measurement2.hasCriticalWarning()) {
                        this.textLabel.setIcon(this.notificationsIcon);
                    } else if (measurement2.applyChangesNeeded()) {
                        this.textLabel.setIcon(this.notificationsIcon);
                    }
                }
            } else if (abstractViewPanel instanceof SpectralPanel && this.mainPanel != null && (measurement = Measurement.getMeasurement(this.mainPanel.getSelectedEntry())) != null && measurement.hasError()) {
                this.textLabel.setIcon(this.errorIcon);
            }
        } else {
            this.textLabel.setText(object.toString());
        }
        if (bl) {
            this.borderPanel.setBackground(jList.getSelectionBackground());
            this.textLabel.setForeground(jList.getSelectionForeground());
        } else if (n == this.hoverIndex) {
            this.borderPanel.setBackground(BreezeTheme.getInstance().getEntrySelectionHoverBackground());
            this.textLabel.setForeground(jList.getForeground());
        } else {
            this.borderPanel.setBackground(jList.getBackground());
            this.textLabel.setForeground(jList.getForeground());
        }
        this.textLabel.setFont(jList.getFont());
        this.setPreferredSize(new Dimension(Math.max(100, this.textLabel.getPreferredSize().width + 40), 40));
        return this;
    }

    @Generated
    public void setMainPanel(EntryMainPanelInterface entryMainPanelInterface) {
        this.mainPanel = entryMainPanelInterface;
    }

    @Generated
    public void setHoverIndex(int n) {
        this.hoverIndex = n;
    }
}

