/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectralViewer;
import se.prediktera.breeze.common.util.average.FileAverageSpectrum;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailClassification;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailRgb;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.preview.PreviewHelper;
import se.prediktera.breeze.frontend.common.view.preview.PreviewValuePanel;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;
import se.prediktera.breeze.frontend.common.view.preview.VisualisationToolbar;
import se.prediktera.breeze.frontend.common.view.preview.ZoomAxis;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.ResolutionDialog;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.axisplot.rubberband.RubberbandRectangle;

public class BasicPreviewPanel
extends EntrySettingsPanel.SettingsSidePanel {
    public static final int legendDividerSize = 120;
    private static final int zoomSize = 100;
    private static double zoomLastSize = 100.0;
    private static boolean BorderSelected = true;
    private static boolean ShowBackground = true;
    protected Measurement measurement;
    protected BufferedImage origImage;
    protected Image image;
    protected double scale = 1.0;
    private String message = "";
    private static final BasicStroke normalStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
    private final BreezeSplitPane.BreezeLegendSplitPane legendSplitPane = new BreezeSplitPane.BreezeLegendSplitPane(120);
    private final JPanel splitPaneLegend = new JPanel(new GridBagLayout());
    private final Renderer renderer = new Renderer();
    private final ThumbnailComboBox thumbnailComboBox = new ThumbnailComboBox();
    protected final LegendPanel legend;
    private final PreviewValuePanel valuePanel = new PreviewValuePanel();
    private boolean updating = true;
    private final VisualisationToolbar toolbar;
    private int segmentationLevel = -1;
    private String segmentationHashId = null;
    private final SwingTimer updateImageTimer = new SwingTimer(100, actionEvent -> this.reloadImage(true));
    protected Workflow workflow;
    private int changeIndex;
    private boolean showObjectBorder = BorderSelected;
    private boolean showBackground = ShowBackground;
    private int segLevel;
    private final BreezeToggleButton objectBorderButton;
    private final BreezeToggleButton showBackgroundButton;
    private Thumbnail thumbnail;
    private LegendCallback legendCallback;
    private AverageSpectralViewer SpectralViewer;
    private SelectionMode selectionMode = SelectionMode.None;
    private Rectangle interactionArea;
    private Shape selectionArea;

    public BasicPreviewPanel(Workflow workflow) {
        super(new GridBagLayout());
        this.workflow = workflow;
        this.setMinimumSize(new Dimension(300, 200));
        this.setPreferredSize(new Dimension(300, 200));
        this.setBackground(BreezeTheme.getInstance().getPreviewPanelBackground());
        this.legendSplitPane.setLeftComponent(this.renderer);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.legendSplitPane, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.toolbar = new VisualisationToolbar(null, this.thumbnailComboBox.getComboBox(), new VisualisationToolbar.ToolbarCallback(){

            @Override
            public void itemChanged(Object object) {
                if (!BasicPreviewPanel.this.updating) {
                    BasicPreviewPanel.this.reloadImage(false);
                }
            }

            @Override
            public void blend(boolean bl) {
                BasicPreviewPanel.this.reloadImage(false);
            }

            @Override
            public void legend(boolean bl) {
                BasicPreviewPanel.this.showLegend(bl);
            }
        });
        this.add((Component)this.toolbar, gridBagConstraints2);
        this.objectBorderButton = this.toolbar.addButton("", "objectborder", "Mark object borders", this.workflow != null ? this.workflow.getObjectBorder() : BorderSelected, bl -> {
            if (this.workflow != null) {
                this.workflow.setObjectBorder(bl);
                this.workflow.save();
            } else {
                BorderSelected = bl;
            }
            this.setShowObjectBorder(bl);
            this.reloadImage(false);
        });
        this.showBackgroundButton = this.toolbar.addButton("", "material/layers", "Show background layer", this.workflow != null ? this.workflow.getShowBackground() : ShowBackground, bl -> {
            if (this.workflow != null) {
                this.workflow.setShowBackground(bl);
                this.workflow.save();
            } else {
                ShowBackground = bl;
            }
            this.setShowBackground(bl);
            this.reloadImage(false);
        });
        this.legendSplitPane.setLegend(this.splitPaneLegend);
        GridBagConstraints gridBagConstraints3 = GridBagHelper.create(0, new Insets(0, 0, 0, 0));
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        this.legendCallback = new LegendCallback();
        this.legend = new LegendPanel(this, this.legendCallback);
        this.splitPaneLegend.add((Component)this.legend, gridBagConstraints3);
        this.legend.setListener((descriptorTreeNode, factor, object) -> {
            if (factor instanceof CategoryFactor) {
                ArrayList<Sample> arrayList = new ArrayList<Sample>();
                CatClass catClass = (CatClass)object;
                int n = ((CategoryFactor)factor).getClassIndex(catClass);
                for (Sample sample : this.getSampleToPaint()) {
                    int n2 = 0;
                    if (descriptorTreeNode != null) {
                        n2 = (int)sample.getDescriptorHolder().getDescriptorValue(descriptorTreeNode);
                    } else {
                        Float f = sample.getSampleValues().getValue(factor);
                        if (f != null) {
                            n2 = f.intValue();
                        }
                    }
                    if (n2 != n) continue;
                    arrayList.add(sample);
                }
                this.setData(this.measurement, arrayList);
                this.selectSamples(arrayList);
            }
        });
        this.setWorkflow(this.workflow);
        this.renderer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!BasicPreviewPanel.this.updating) {
                    BasicPreviewPanel.this.calculateScaleAndPaint();
                }
            }
        });
    }

    public void setSpectralViewer(AverageSpectralViewer averageSpectralViewer) {
        this.SpectralViewer = averageSpectralViewer;
    }

    public void setWorkflow(Workflow workflow) {
        if (workflow != null) {
            this.workflow = workflow;
            this.thumbnailComboBox.populateThumbnailComboBox(workflow);
            this.objectBorderButton.setSelected(workflow.getObjectBorder());
            this.setShowObjectBorder(workflow.getObjectBorder());
            this.showBackgroundButton.setSelected(workflow.getShowBackground());
            this.setShowBackground(workflow.getShowBackground());
        }
    }

    public BreezeToggleButton getObjectBorderButton() {
        return this.objectBorderButton;
    }

    public void setShowObjectBorder(boolean bl) {
        this.showObjectBorder = bl;
    }

    public void setShowBackground(boolean bl) {
        this.showBackground = bl;
    }

    public void showLegend(boolean bl) {
        this.legendSplitPane.showLegend(bl);
        if (bl) {
            this.splitPaneLegend.add((Component)this.valuePanel, GridBagHelper.create(1, new Insets(0, 0, 0, 0)));
        } else {
            this.add((Component)this.valuePanel, GridBagHelper.create(2, new Insets(0, 0, 0, 0)));
        }
        this.valuePanel.update(bl);
        this.revalidate();
        this.repaint();
    }

    public VisualisationToolbar getToolbar() {
        return this.toolbar;
    }

    public LegendCallback getLegendCallback() {
        return this.legendCallback;
    }

    protected void selectSamples(List<Sample> list) {
    }

    public Color getBlurred() {
        return new Color(100, 100, 100, 100);
    }

    protected Sample getSelectedSample() {
        return null;
    }

    private Point getGlobalPoint(Point point) {
        Sample sample = this.getSelectedSample();
        if (sample == null || sample.getPath().getOrCreateGeneralPath() == null) {
            return point;
        }
        Rectangle2D rectangle2D = sample.getPath().getOrCreateGeneralPath().getBounds2D();
        return new Point(point.x + (int)rectangle2D.getX(), point.y + (int)rectangle2D.getY());
    }

    public void clearSelection() {
        this.clearSelection("Loading image");
    }

    public void clearSelection(String string) {
        this.message = string;
        this.measurement = null;
        this.clearImage();
        this.repaint();
    }

    @Override
    public void showEntry(Object object, Object object2, boolean bl) {
        this.setWorkflow(Workflow.getWorkflow(object));
    }

    public void setData(Measurement measurement, List list) {
        this.setData(measurement, list, false);
    }

    public void setData(Measurement measurement, List list, boolean bl) {
        if (measurement == null) {
            this.clearSelection("No measurement selected");
            return;
        }
        this.renderer.setSelectedSamples(list);
        this.renderer.setValue(new Point(0, 0));
        boolean bl2 = true;
        if (this.measurement != measurement || this.changeIndex != measurement.getChangeIndex() || this.segLevel != measurement.getSegmentationLevel() || !this.showBackground) {
            this.measurement = measurement;
            this.changeIndex = this.measurement.getChangeIndex();
            this.segLevel = this.measurement.getSegmentationLevel();
            this.reloadImage();
        } else if (bl) {
            this.reloadImage(false);
            bl2 = false;
        } else {
            this.repaint();
        }
        if (bl2) {
            this.updating = true;
            this.thumbnailComboBox.populateThumbnailComboBox(measurement.getWorkflow());
            this.updating = false;
        }
        if (this.SpectralViewer != null) {
            this.SpectralViewer.setMeasurement(measurement);
        }
    }

    public void reloadImage() {
        this.message = "Loading image";
        this.updateImageTimer.restart();
    }

    public void setSelectedSamples(List<Sample> list) {
        this.renderer.setSelectedSamples(list);
        if (this.showBackground) {
            this.repaint();
        } else {
            this.reloadImage(false);
        }
    }

    public List<Sample> getSelectedSamples() {
        return this.renderer.getSelectedSamples();
    }

    protected void reloadImage(final boolean bl) {
        BreezeThread breezeThread = new BreezeThread(this, this.getClass().getSimpleName()){
            final /* synthetic */ BasicPreviewPanel this$0;
            {
                this.this$0 = basicPreviewPanel;
                super(string);
            }

            @Override
            public void run() {
                this.this$0.reloadImage(this.this$0.measurement, this.this$0.renderer.getFirstSelectedSample(), bl);
                if (this.isInterrupted()) {
                    this.this$0.clearImage();
                }
                this.this$0.repaint();
            }
        };
        breezeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadImage(Measurement measurement, Sample sample, boolean bl) {
        try {
            this.measurement = measurement;
            this.origImage = this.readImage(measurement, sample, this.showBackground);
            if (this.origImage != null) {
                this.calculateScales();
                this.image = this.origImage;
            } else if (measurement != null) {
                this.clearImage();
                this.message = "No image available";
                SwingUtilities.invokeLater(() -> this.thumbnailComboBox.changeThumbnail(null, null));
            }
        }
        catch (Exception exception) {
            this.clearImage();
            ErrorHandler.logAndReportException((Throwable)exception);
        }
        finally {
            if (bl) {
                this.renderer.clear();
            }
        }
    }

    private void calculateScaleAndPaint() {
        this.calculateScales();
        this.repaint();
    }

    private void calculateScales() {
        this.scale = this.calculateScaleOnPanel(this.renderer);
        this.renderer.zoomOverviewPanel.calculateScale();
    }

    private double calculateScaleOnPanel(JPanel jPanel) {
        double d = jPanel.getWidth();
        double d2 = jPanel.getHeight();
        if (this.origImage != null && d > 0.0 && d2 > 0.0) {
            double d3;
            double d4;
            double d5 = this.origImage.getWidth(null);
            double d6 = d / (d5 + 1.0);
            if (d6 < (d4 = d2 / ((d3 = (double)this.origImage.getHeight(null)) + 1.0))) {
                return d6;
            }
            return d4;
        }
        return 1.0;
    }

    private void clearImage() {
        this.origImage = null;
        this.image = null;
    }

    protected BufferedImage readImage(Measurement measurement, Sample sample, boolean bl) throws Exception {
        Object object;
        this.thumbnail = null;
        this.renderer.setFactorOrDescriptor(null, null);
        this.renderer.setDrawSamples(true);
        if (measurement == null) {
            return null;
        }
        Object object2 = this.thumbnailComboBox.getSelectedItem();
        boolean bl2 = this.toolbar.isLegend();
        if (object2 instanceof ThumbnailComboBox.ThumbnailWithDescriptor) {
            object = (ThumbnailComboBox.ThumbnailWithDescriptor)object2;
            Workflow workflow = measurement.getWorkflow();
            LimitConfiguration limitConfiguration = workflow.getVisualisationNode().getDefaultLimitNode(measurement.getParent());
            DescriptorTreeNode descriptorTreeNode = ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getNode().getHierarchyNode(sample, true);
            if (descriptorTreeNode == null) {
                return null;
            }
            this.legend.setTitle(((ThumbnailComboBox.ThumbnailWithDescriptor)object).getLegendTitle(descriptorTreeNode));
            if (((ThumbnailComboBox.ThumbnailWithDescriptor)object).isObject()) {
                Factor factor = descriptorTreeNode.getVisualizationFactor();
                MinMax minMax = null;
                if (factor instanceof CategoryFactor) {
                    CategoryFactor categoryFactor = (CategoryFactor)factor;
                    this.legend.setClassTypes(descriptorTreeNode, categoryFactor, ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getIncluded(measurement, categoryFactor));
                } else if (factor instanceof PropertyFactor) {
                    PropertyFactor propertyFactor = (PropertyFactor)factor;
                    minMax = new MinMax(propertyFactor.getMinMax(limitConfiguration));
                    this.legend.setMinMax(measurement.getWorkflow(), propertyFactor, limitConfiguration, minMax, null);
                } else {
                    minMax = ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getOrCreateMinMax(measurement.getWorkflow());
                    this.legend.setMinMax(measurement.getWorkflow(), null, null, minMax, ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getNode());
                }
                this.renderer.setFactorOrDescriptor(descriptorTreeNode, minMax);
            } else {
                this.thumbnail = ThumbnailHelper.create(measurement, sample, descriptorTreeNode, ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getAdditionalFactor(), false, bl);
                if (this.thumbnail != null) {
                    BufferedImage bufferedImage = null;
                    Thumbnail thumbnail = this.thumbnail;
                    if (thumbnail instanceof ThumbnailProperty) {
                        ThumbnailProperty thumbnailProperty = (ThumbnailProperty)thumbnail;
                        bufferedImage = thumbnailProperty.render(limitConfiguration);
                        this.legend.setMinMax(measurement.getWorkflow(), thumbnailProperty.getFactor(), limitConfiguration, new MinMax(thumbnailProperty.getMinMax(limitConfiguration)), ((ThumbnailComboBox.ThumbnailWithDescriptor)object).getNode());
                    } else {
                        thumbnail = this.thumbnail;
                        if (thumbnail instanceof ThumbnailClassification) {
                            ThumbnailClassification thumbnailClassification = (ThumbnailClassification)thumbnail;
                            thumbnailClassification.setBlending(this.toolbar.isBlend());
                            bufferedImage = this.thumbnail.render(limitConfiguration);
                            this.legend.setClassTypes(descriptorTreeNode, thumbnailClassification.getFactor(), thumbnailClassification.getIncluded());
                        } else {
                            thumbnail = this.thumbnail;
                            if (thumbnail instanceof ThumbnailRgb) {
                                ThumbnailRgb thumbnailRgb = (ThumbnailRgb)thumbnail;
                                bufferedImage = this.thumbnail.render(limitConfiguration);
                                this.legend.setClassTypes(descriptorTreeNode, thumbnailRgb.getFactor(), null);
                            } else {
                                bufferedImage = this.thumbnail.render(limitConfiguration);
                                this.renderer.setDrawSamples(false);
                                bl2 = false;
                            }
                        }
                    }
                    this.legend.repaint();
                    this.showLegend(bl2);
                    return bufferedImage;
                }
            }
        } else if (object2 instanceof PropertyFactor) {
            PropertyFactor propertyFactor = (PropertyFactor)object2;
            this.legend.setTitle(propertyFactor.getName());
            this.legend.setMinMax(measurement.getWorkflow(), propertyFactor, null, propertyFactor.getMinMax(), null);
            this.renderer.setFactorOrDescriptor(propertyFactor, null);
        } else if (object2 instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)object2;
            this.legend.setTitle(categoryFactor.getName());
            this.legend.setClassTypes(null, categoryFactor, categoryFactor.getIncluded(measurement));
            this.renderer.setFactorOrDescriptor(categoryFactor, null);
        } else {
            bl2 = false;
        }
        this.showLegend(bl2);
        if (measurement != null && ((File)(object = measurement.getThumbnailFile())).exists()) {
            if (bl) {
                return this.readImage((File)object);
            }
            return new ThumbnailSample((File)object, measurement, sample, false).render(null);
        }
        return null;
    }

    protected BufferedImage readImage(File file) throws IOException {
        return ThumbnailManager.getInstance(0).getImage(file);
    }

    public Image getImage() {
        return this.image;
    }

    public void setSegmentationLevel(int n, String string) {
        this.segmentationLevel = n;
        this.segmentationHashId = string;
    }

    public List<Sample> getSampleForCurrentLevel() {
        if (this.measurement != null) {
            if (this.segmentationLevel < 0) {
                return this.measurement.getSamplesForCurrentLevel();
            }
            return this.measurement.getSamples(new SegmentationIdentifier(this.segmentationLevel, this.segmentationHashId));
        }
        return new ArrayList<Sample>();
    }

    public final List<Sample> getSampleToPaint() {
        return this.getSampleToPaint(false);
    }

    public List<Sample> getSampleToPaint(boolean bl) {
        return this.getSampleForCurrentLevel();
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public LegendPanel getLegend() {
        return this.legend;
    }

    protected void showPopupInternal(MouseEvent mouseEvent, BreezeFrame breezeFrame, BreezeContextMenu.PopupCallback popupCallback) {
        if (this.measurement != null && this.origImage != null) {
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            breezeContextMenu.addButtonCloseClick("Save image as...", () -> this.saveSelectedImages(null));
            List<Object> list = this.getSelectedEntries();
            if (this.hasMultiple(list)) {
                breezeContextMenu.addButtonCloseClick("Save all images", () -> this.saveSelectedImages(list));
            }
            breezeContextMenu.addButtonCloseClick("Print image", () -> this.printImage());
            breezeContextMenu.addButtonCloseClick("Copy to clipboard", () -> PlotPopupMenu.copyToClipboard((PlotPopupMenu.ImageSaveCallback)new MeasurementSaveCallback(), (int)this.origImage.getWidth(), (int)this.origImage.getHeight(), (boolean)true));
            if (popupCallback != null) {
                popupCallback.addCustom(breezeContextMenu);
            }
            if (breezeContextMenu.resize()) {
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(mouseEvent);
            }
        }
    }

    private void printImage() {
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getCustomizePath(), "FaceScanner.png");
        if (file.exists()) {
            try {
                PlotPopupMenu.printImage((BufferedImage)ImageHelper.combineImagesVerticallyWithScaling(this.origImage, ImageIO.read(file)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            PlotPopupMenu.printImage((BufferedImage)this.origImage);
        }
    }

    private boolean hasMultiple(List<Object> list) {
        if (list != null && list.size() > 0) {
            Object object = list.get(0);
            return object instanceof Workflow || object instanceof Group || list.size() > 1;
        }
        return false;
    }

    protected List<Object> getSelectedEntries() {
        return null;
    }

    private void saveSelectedImages(final List<Object> list) {
        BreezeFrame breezeFrame = BreezeFrame.getInstance();
        if (list != null) {
            final jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose folder to save images", (Component)breezeFrame);
            jopensaveDialog2.setDialogType(1);
            jopensaveDialog2.setFileSelectionMode(1);
            final ResolutionDialog.ResolutionPanel resolutionPanel = new ResolutionDialog.ResolutionPanel(0, 0);
            jopensaveDialog2.setPreview((PreviewInterface)resolutionPanel, false);
            if (jopensaveDialog2.saveshow()) {
                BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                    final /* synthetic */ BasicPreviewPanel this$0;
                    {
                        this.this$0 = basicPreviewPanel;
                    }

                    @Override
                    public void runAction() {
                        Measurement measurement = this.this$0.measurement;
                        List<Sample> list2 = this.this$0.getSelectedSamples();
                        File file = jopensaveDialog2.getSelectedFile();
                        for (Measurement measurement2 : Measurement.getMeasurements(list)) {
                            this.setInfoText("Saving image: " + measurement2.getName());
                            this.this$0.reloadImage(measurement2, null, true);
                            this.this$0.saveImage(new File(file, measurement2.getName() + ".png"), resolutionPanel.getResolution(), resolutionPanel.isIncludeSelection());
                        }
                        this.this$0.setData(measurement, list2);
                    }
                }, "Saving images");
            }
        } else {
            PlotPopupMenu.showSaveDialog((Frame)breezeFrame, (String)(this.measurement.getName() + "_" + this.getThumbnailComboBox().getSelectedItem().toString()), (boolean)false, (int)this.origImage.getWidth(), (int)this.origImage.getHeight(), (boolean)true, (PlotPopupMenu.ImageSaveCallback)new MeasurementSaveCallback());
        }
    }

    private void saveImage(File file, int n, boolean bl) {
        if (this.origImage != null) {
            MeasurementSaveCallback measurementSaveCallback = new MeasurementSaveCallback();
            PlotPopupMenu.save((BufferedImage)measurementSaveCallback.makeBufferedImageScreenShot(this.origImage.getWidth() * n, this.origImage.getHeight() * n, false), (File)file, (String)"png");
        }
    }

    public void zoomTo(Rectangle rectangle) {
        this.renderer.zoomTo(rectangle);
    }

    public void zoomAll() {
        this.renderer.clear();
    }

    public void panSamples(Point point) {
        this.renderer.panSamples(point);
    }

    protected Object getSelectedItem() {
        return this.thumbnailComboBox.getSelectedItem();
    }

    public void interact(Rectangle rectangle) {
        this.interactionArea = rectangle;
        this.repaint();
    }

    public void selectionArea(Shape shape) {
        this.selectionArea = shape;
        this.repaint();
    }

    @Override
    public Component getPanel() {
        return this;
    }

    public ThumbnailComboBox getThumbnailComboBox() {
        return this.thumbnailComboBox;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public void showPopup(MouseEvent mouseEvent) {
        this.showPopupInternal(mouseEvent, BreezeFrame.getInstance(), null);
    }

    public static BufferedImage createImageWithLegend(JPanel jPanel, BufferedImage bufferedImage) {
        boolean bl = bufferedImage.getHeight() < 500;
        double d = 1.0;
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        if (bl) {
            d = 500.0 / (double)bufferedImage.getHeight();
            n = (int)((double)bufferedImage.getHeight() * d);
            n2 = (int)((double)bufferedImage.getWidth() * d);
        }
        double d2 = (double)n / (double)jPanel.getHeight();
        int n3 = (int)((double)jPanel.getHeight() * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n2 + (int)Math.ceil((double)jPanel.getWidth() * d2), Math.max(n3, n), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (bl) {
            graphics2D.drawImage(bufferedImage.getScaledInstance(n2, n, 4), 0, bufferedImage2.getHeight() / 2 - n / 2, null);
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, bufferedImage2.getHeight() / 2 - bufferedImage.getHeight() / 2, null);
        }
        graphics2D.translate(n2, bufferedImage2.getHeight() / 2 - n3 / 2);
        graphics2D.scale(d2, d2);
        if (jPanel instanceof LegendPanel) {
            LegendPanel legendPanel = (LegendPanel)jPanel;
            legendPanel.takeScreenshot(graphics2D);
        } else {
            jPanel.paint(graphics2D);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public class Renderer
    extends JPanel {
        private final List<Sample> selectedSamples;
        private final ZoomAxis xZoom;
        private final ZoomAxis yZoom;
        private Object factorOrDescriptor;
        private boolean drawSamples;
        private Point panStartPoint;
        private final int[][] colorIndex;
        private MinMax resultMinMax;
        private double ratio;
        private Point panSamples;
        private AbstractRubberband rubberBand;
        private final ZoomOverviewPanel zoomOverviewPanel;

        public Renderer() {
            super(null);
            this.selectedSamples = new ArrayList<Sample>();
            this.xZoom = new ZoomAxis();
            this.yZoom = new ZoomAxis();
            this.factorOrDescriptor = null;
            this.drawSamples = true;
            this.rubberBand = new RubberbandRectangle((Component)this);
            this.zoomOverviewPanel = new ZoomOverviewPanel(this);
            this.add(this.zoomOverviewPanel);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    Point point;
                    if (BasicPreviewPanel.this.measurement == null) {
                        return;
                    }
                    if (Renderer.this.panSamples != null) {
                        point = Renderer.this.getPointOnImage(mouseEvent.getPoint());
                        for (Sample sample : Renderer.this.selectedSamples) {
                            sample.getSamplePath().pan(Renderer.this.panSamples.getX() - point.getX(), Renderer.this.panSamples.getY() - point.getY());
                        }
                        if (BasicPreviewPanel.this.SpectralViewer != null) {
                            BasicPreviewPanel.this.SpectralViewer.update(BasicPreviewPanel.this.measurement, Renderer.this.selectedSamples);
                        }
                        Renderer.this.panSamples = point;
                        Renderer.this.repaint();
                    } else {
                        Renderer.this.setCursorFromPoint(mouseEvent.getPoint());
                        Renderer.this.setValue(mouseEvent.getPoint());
                    }
                    if (BasicPreviewPanel.this.SpectralViewer != null && BasicPreviewPanel.this.SpectralViewer.showLiveSpectrum() && BasicPreviewPanel.this.measurement.hasData()) {
                        point = BasicPreviewPanel.this.renderer.getPointOnImage(mouseEvent.getPoint());
                        Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
                        if (rectangle.intersects(BasicPreviewPanel.this.measurement.getBounds())) {
                            BasicPreviewPanel.this.SpectralViewer.getting(BasicPreviewPanel.this.measurement, rectangle, fArray -> BasicPreviewPanel.this.SpectralViewer.liveSpectrum(null, point.x, point.y, fArray));
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (Renderer.this.panStartPoint != null) {
                        Renderer.this.xZoom.pan(Renderer.this.panStartPoint.getX(), mouseEvent.getX(), 1.0);
                        Renderer.this.yZoom.pan(Renderer.this.panStartPoint.getY(), mouseEvent.getY(), 1.0);
                        Renderer.this.panStartPoint = mouseEvent.getPoint();
                        Renderer.this.repaint();
                        Renderer.this.zoomOverviewPanel.repaint();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        SelectionMode selectionMode;
                        SelectionMode selectionMode2 = selectionMode = mouseEvent.isShiftDown() ? SelectionMode.Selection : BasicPreviewPanel.this.selectionMode;
                        if (!mouseEvent.isControlDown() && !selectionMode.equals((Object)SelectionMode.Move)) {
                            Renderer.this.selectedSamples.clear();
                        }
                        ArrayList<Sample> arrayList = new ArrayList<Sample>();
                        List<Sample> list = BasicPreviewPanel.this.getSampleToPaint();
                        if (Renderer.this.rubberBand.isActive()) {
                            var5_5 = point -> BasicPreviewPanel.this.getGlobalPoint(Renderer.this.getPointOnImage((Point)point));
                            boolean bl = selectionMode.equals((Object)SelectionMode.Zoom);
                            Shape shape = Renderer.this.rubberBand.getShape(!bl);
                            if (bl) {
                                var8_10 = PreviewHelper.convertShapeToGlobal(shape, var5_5);
                                Renderer.this.zoomTo(var8_10.getBounds());
                            } else if (BasicPreviewPanel.this.SpectralViewer != null && selectionMode.equals((Object)SelectionMode.Add)) {
                                var8_10 = Renderer.this.getSampleAtPoint(list, mouseEvent.getPoint());
                                if (var8_10 != null && shape.getBounds().width == 1 && shape.getBounds().height == 1) {
                                    arrayList.add((Sample)var8_10);
                                } else if (!FileAverageSpectrum.gettingSpectrum) {
                                    Shape shape2 = PreviewHelper.convertShapeToGlobal(shape, var5_5);
                                    Shape shape3 = PreviewHelper.clipToSamples(BasicPreviewPanel.this.getSampleForCurrentLevel(), shape2);
                                    if (shape3 != null) {
                                        ArrayList<Sample> arrayList2 = new ArrayList<Sample>();
                                        List<int[][]> list2 = PreviewHelper.getShapeBorderPointsArray(shape3);
                                        new AverageSpectralViewer.SampleAreaInputPanel(BasicPreviewPanel.this.SpectralViewer, PreviewHelper.computeArea(shape3)).addAreas(arrayList2, BasicPreviewPanel.this.measurement, list2, () -> BasicPreviewPanel.this.SpectralViewer.update(BasicPreviewPanel.this.measurement, arrayList2, fArray -> {
                                            for (Sample sample : arrayList2) {
                                                if (sample.getSamplePath().getAverageProfile() == null) continue;
                                                list.add(sample);
                                                Renderer.this.selectedSamples.add(sample);
                                            }
                                            BasicPreviewPanel.this.SpectralViewer.drawSamples();
                                            Renderer.this.repaint();
                                        }), !mouseEvent.isControlDown());
                                    } else {
                                        FileAverageSpectrum.gettingSpectrum = false;
                                    }
                                }
                            } else {
                                Renderer.this.addSampleInsideRect(list, shape, arrayList);
                            }
                            Renderer.this.rubberBand.setActive(false);
                        } else {
                            var5_5 = Renderer.this.getSampleAtPoint(list, mouseEvent.getPoint());
                            if (var5_5 != null) {
                                arrayList.add((Sample)var5_5);
                            }
                        }
                        for (Sample sample : arrayList) {
                            boolean bl = Renderer.this.selectedSamples.contains(sample);
                            if (mouseEvent.isControlDown() && bl) {
                                Renderer.this.selectedSamples.remove(sample);
                                continue;
                            }
                            if (bl) continue;
                            Renderer.this.selectedSamples.add(sample);
                        }
                        BasicPreviewPanel.this.selectSamples(Renderer.this.selectedSamples);
                        Renderer.this.repaint();
                    }
                    if (Renderer.this.panStartPoint != null) {
                        Renderer.this.setCursorFromPoint(mouseEvent.getPoint());
                        Renderer.this.panStartPoint = null;
                    }
                    if (mouseEvent.isPopupTrigger() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        BasicPreviewPanel.this.showPopup(mouseEvent);
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    SelectionMode selectionMode;
                    SelectionMode selectionMode2 = selectionMode = mouseEvent.isShiftDown() ? SelectionMode.Selection : BasicPreviewPanel.this.selectionMode;
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        Renderer.this.panStartPoint = mouseEvent.getPoint();
                        Renderer.this.setCursor(Cursor.getPredefinedCursor(13));
                    } else {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (selectionMode.supportDrag() || mouseEvent.isShiftDown())) {
                            Renderer.this.rubberBand.setActive(true);
                        }
                        Renderer.this.panStartPoint = null;
                    }
                    if (Renderer.this.panSamples != null) {
                        Renderer.this.setCursorFromPoint(mouseEvent.getPoint());
                        Renderer.this.panSamples = null;
                        BasicPreviewPanel.this.measurement.save();
                    } else if (selectionMode.equals((Object)SelectionMode.Move)) {
                        Renderer.this.selectedSamples.clear();
                        Renderer.this.panSamples(mouseEvent.getPoint());
                    }
                    if (mouseEvent.isPopupTrigger() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        BasicPreviewPanel.this.showPopup(mouseEvent);
                    }
                }
            });
            this.addMouseWheelListener(mouseWheelEvent -> {
                int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
                Image image = BasicPreviewPanel.this.image;
                if (image != null && BasicPreviewPanel.this.scale > 0.0) {
                    Point point = this.getPointOnImage(mouseWheelEvent.getPoint());
                    if (this.xZoom.zoom(point.getX(), n) || this.yZoom.zoom(point.getY(), n)) {
                        this.xZoom.reset();
                        this.yZoom.reset();
                        this.zoomOverviewPanel.setVisible(false);
                    } else {
                        this.zoomOverviewPanel.setVisible(true);
                    }
                    this.zoomOverviewPanel.repaint();
                    this.repaint();
                }
            });
            this.colorIndex = BreezeProperties.getInstance().getColorScale().create().createColorIndex();
            this.setSelectionTool(AbstractRubberband.RubberType.Rectangle);
        }

        private void setValue(Point point) {
            List<Sample> list = BasicPreviewPanel.this.getSampleToPaint(true);
            if (list != null) {
                Point point2 = BasicPreviewPanel.this.getGlobalPoint(this.getPointOnImage(point));
                Sample sample = Renderer.getSampleAtGlobalPoint(list, point2);
                BasicPreviewPanel.this.valuePanel.setValue(BasicPreviewPanel.this.measurement, point2, sample, BasicPreviewPanel.this.getSelectedItem());
            }
        }

        public void setSelectionTool(AbstractRubberband.RubberType rubberType) {
            this.rubberBand = AbstractRubberband.createRubberband((AbstractRubberband.RubberType)rubberType, (int)5, (Component)this);
        }

        public void setSelectionMode(SelectionMode selectionMode) {
            BasicPreviewPanel.this.selectionMode = selectionMode;
        }

        public void zoomTo(Rectangle rectangle) {
            double d;
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            double d2 = (double)rectangle.width / (double)rectangle.height;
            if (d2 > this.ratio) {
                d = (double)rectangle.height / (this.ratio / d2);
                rectangle.y += (int)((double)rectangle.height - d) / 2;
                rectangle.height = (int)d;
            } else {
                d = (double)rectangle.width * this.ratio / d2;
                rectangle.x += (int)((double)rectangle.width - d) / 2;
                rectangle.width = (int)d;
            }
            d = (double)rectangle.width * 0.1;
            this.xZoom.set((double)rectangle.x - d, (double)(rectangle.x + rectangle.width) + d * 2.0);
            double d3 = (double)rectangle.height * 0.1;
            this.yZoom.set((double)rectangle.y - d3, (double)(rectangle.y + rectangle.height) + d3 * 2.0);
            this.zoomOverviewPanel.setVisible(true);
            this.zoomOverviewPanel.repaint();
        }

        private void setCursorFromPoint(Point point) {
            List<Sample> list = BasicPreviewPanel.this.getSampleToPaint();
            if (list != null) {
                Sample sample = this.getSampleAtPoint(list, point);
                if (sample != null) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        public void clear() {
            this.xZoom.clear();
            this.yZoom.clear();
        }

        public void panSamples(Point point) {
            this.panSamples = this.getPointOnImage(point);
            List<Sample> list = BasicPreviewPanel.this.getSampleToPaint();
            Sample sample = this.getSampleAtPoint(list, point);
            if (sample != null && !this.selectedSamples.contains(sample)) {
                this.selectedSamples.add(sample);
            }
            this.setCursor(Cursor.getPredefinedCursor(13));
        }

        public Point getPointOnImage(Point point) {
            Image image = BasicPreviewPanel.this.image;
            if (image != null) {
                double d = (double)this.getWidth() / 2.0 - (double)image.getWidth(null) * BasicPreviewPanel.this.scale / 2.0;
                double d2 = (double)this.getHeight() / 2.0 - (double)image.getHeight(null) * BasicPreviewPanel.this.scale / 2.0;
                return new Point((int)(((double)point.x - d) / this.xZoom.relative() + this.xZoom.min), (int)(((double)point.y - d2) / this.yZoom.relative() + this.yZoom.min));
            }
            return point;
        }

        private Sample getSampleAtPoint(List<Sample> list, Point point) {
            if (list != null) {
                Point point2 = BasicPreviewPanel.this.getGlobalPoint(this.getPointOnImage(point));
                return Renderer.getSampleAtGlobalPoint(list, point2);
            }
            return null;
        }

        private static Sample getSampleAtGlobalPoint(List<Sample> list, Point point) {
            for (Sample sample : list) {
                Shape shape = sample.getPath().getOrCreateGeneralPath();
                if (shape == null || !shape.contains(point)) continue;
                return sample;
            }
            return null;
        }

        private void addSampleInsideRect(List<Sample> list, Shape shape, List<Sample> list2) {
            if (list != null) {
                Function<Point, Point> function = point -> BasicPreviewPanel.this.getGlobalPoint(this.getPointOnImage((Point)point));
                Shape shape2 = PreviewHelper.convertShapeToGlobal(shape, function);
                Area area = new Area(shape2);
                for (Sample sample : list) {
                    Shape shape3 = sample.getPath().getOrCreateGeneralPath();
                    Area area2 = new Area(shape3);
                    area2.intersect(area);
                    if (shape3 == null || area2.isEmpty()) continue;
                    list2.add(sample);
                }
            }
        }

        public Sample getFirstSelectedSample() {
            if (this.selectedSamples.isEmpty()) {
                return null;
            }
            return this.selectedSamples.get(0);
        }

        public void setSelectedSamples(List<Sample> list) {
            this.selectedSamples.clear();
            this.selectedSamples.addAll(list);
        }

        public List<Sample> getSelectedSamples() {
            return this.selectedSamples;
        }

        public void setDrawSamples(boolean bl) {
            this.drawSamples = bl;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            this.paint(graphics, this.getWidth(), this.getHeight(), BasicPreviewPanel.this.image, BasicPreviewPanel.this.scale, true);
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
        }

        public void paint(Graphics graphics, int n, int n2, Image image, double d, boolean bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            graphics2D.setColor(breezeTheme.getPreviewPanelBackground());
            graphics2D.fillRect(0, 0, n, n2);
            if (image != null && d > 0.0) {
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                this.ratio = (double)n3 / (double)n4;
                if (this.xZoom.imageSize != n3 || this.yZoom.imageSize != n4) {
                    this.xZoom.reset(n3);
                    this.yZoom.reset(n4);
                    this.zoomOverviewPanel.setVisible(false);
                }
                this.xZoom.setScale(d);
                this.yZoom.setScale(d);
                int n5 = (int)((double)n / 2.0 - (double)n3 * d / 2.0);
                int n6 = (int)((double)n2 / 2.0 - (double)n4 * d / 2.0);
                graphics2D.drawImage(image, this.xZoom.min(n5), this.yZoom.min(n6), this.xZoom.max(), this.yZoom.max(), null);
                double d2 = this.xZoom.relative();
                graphics2D.setFont(new Font("Dialog", 0, (int)(20.0 / d2)));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                if (this.drawSamples && BasicPreviewPanel.this.measurement != null) {
                    graphics2D.setStroke(normalStroke);
                    graphics2D.setColor(new Color(100, 100, 100, 150));
                    BasicStroke basicStroke = new BasicStroke((float)Math.max(1.0E-4, 0.5 / d2), 0, 0, 10.0f);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.translate(n5, n6);
                    graphics2D.scale(this.xZoom.relative(), this.yZoom.relative());
                    graphics2D.translate(-this.xZoom.min, -this.yZoom.min);
                    if (BasicPreviewPanel.this.SpectralViewer != null) {
                        this.drawSamples(graphics2D, fontMetrics, BasicPreviewPanel.this.getSampleForCurrentLevel(), false, BasicPreviewPanel.this.showObjectBorder);
                        this.drawSamples(graphics2D, fontMetrics, BasicPreviewPanel.this.getSampleToPaint(), bl && this.hasSelectedSamples(), BasicPreviewPanel.this.showObjectBorder);
                    } else {
                        this.drawSamples(graphics2D, fontMetrics, BasicPreviewPanel.this.getSampleToPaint(), bl && this.hasSelectedSamples(), BasicPreviewPanel.this.showObjectBorder);
                    }
                    if (bl) {
                        for (Sample object : this.selectedSamples) {
                            Shape shape;
                            if (object == null || (shape = object.getPath().getOrCreateGeneralPath()) == null) continue;
                            graphics2D.setColor(this.getDrawColor(object, shape, true));
                            graphics2D.draw(shape);
                        }
                        BasicStroke basicStroke2 = new BasicStroke((float)(1.0 / d2), 0, 0, 10.0f);
                        graphics2D.setStroke(basicStroke2);
                        graphics2D.setColor(Color.white);
                        for (Sample sample : this.selectedSamples) {
                            Shape shape;
                            if (sample == null || (shape = sample.getPath().getOrCreateGeneralPath()) == null) continue;
                            Rectangle rectangle = shape.getBounds();
                            if (rectangle.width > 5 || rectangle.height > 5) continue;
                            this.drawSmallRect(graphics2D, rectangle);
                        }
                    }
                    if (BasicPreviewPanel.this.interactionArea != null) {
                        graphics2D.setColor(Color.yellow);
                        graphics2D.fillRect(BasicPreviewPanel.this.interactionArea.x, BasicPreviewPanel.this.interactionArea.y, 1, 1);
                        this.drawSmallRect(graphics2D, BasicPreviewPanel.this.interactionArea);
                    }
                    if (BasicPreviewPanel.this.selectionArea != null) {
                        graphics2D.setColor(Color.yellow);
                        graphics2D.fill(BasicPreviewPanel.this.selectionArea);
                    }
                }
            } else {
                graphics2D.setColor(breezeTheme.getLabelForeground());
                graphics2D.setFont(new Font("Tahoma", 0, 18));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                graphics2D.drawString(BasicPreviewPanel.this.message, n / 2 - fontMetrics.stringWidth(BasicPreviewPanel.this.message) / 2, n2 / 2 - fontMetrics.getHeight() / 2);
            }
        }

        private void drawSmallRect(Graphics2D graphics2D, Rectangle rectangle) {
            Rectangle rectangle2 = new Rectangle(rectangle.x - 5, rectangle.y - 5, rectangle.width + 10, rectangle.height + 10);
            int n = rectangle2.x + rectangle2.width;
            int n2 = rectangle2.y + rectangle2.height;
            int n3 = (int)Math.ceil(2.0);
            graphics2D.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + n3, rectangle2.y);
            graphics2D.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + n3);
            graphics2D.drawLine(n, rectangle2.y, n - n3, rectangle2.y);
            graphics2D.drawLine(n, rectangle2.y, n, rectangle2.y + n3);
            graphics2D.drawLine(rectangle2.x, n2, rectangle2.x + n3, n2);
            graphics2D.drawLine(rectangle2.x, n2, rectangle2.x, n2 - n3);
            graphics2D.drawLine(n, n2, n - n3, n2);
            graphics2D.drawLine(n, n2, n, n2 - n3);
        }

        private void drawSamples(Graphics2D graphics2D, FontMetrics fontMetrics, List<Sample> list, boolean bl, boolean bl2) {
            HashSet<Sample> hashSet = new HashSet<Sample>(this.selectedSamples);
            boolean bl3 = BasicPreviewPanel.this.SpectralViewer != null || BasicPreviewPanel.this.toolbar.isBlend();
            Color color = BasicPreviewPanel.this.getBlurred();
            for (Sample sample : list) {
                Shape shape;
                boolean bl4;
                boolean bl5 = hashSet.contains(sample);
                boolean bl6 = bl4 = bl && bl5;
                if (bl5) {
                    // empty if block
                }
                if ((shape = sample.getPath().getOrCreateGeneralPath()) == null) continue;
                Color color2 = this.getFillColor(sample);
                if (color2 != null) {
                    if (bl3) {
                        graphics2D.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 150));
                    } else {
                        graphics2D.setColor(color2);
                    }
                    graphics2D.fill(shape);
                    graphics2D.draw(shape);
                }
                if (!bl2) continue;
                if (bl && !bl4) {
                    graphics2D.setColor(color);
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.getDrawColor(sample, shape, bl4));
                graphics2D.draw(shape);
            }
        }

        private boolean hasSelectedSamples() {
            return this.selectedSamples.size() > 0;
        }

        private Color getDrawColor(Sample sample, Shape shape, boolean bl) {
            Color color;
            if (bl) {
                return Color.yellow;
            }
            Rectangle rectangle = shape.getBounds();
            int n = rectangle.width * rectangle.height;
            if ((rectangle.width <= 1 || rectangle.height <= 1 || n <= 10) && (color = this.getFillColor(sample)) != null) {
                return color;
            }
            return Color.red;
        }

        private Color getFillColor(Sample sample) {
            DescriptorTreeNode descriptorTreeNode;
            if (sample instanceof AveragePlotPanel.SampleArea) {
                AveragePlotPanel.SampleArea sampleArea = (AveragePlotPanel.SampleArea)sample;
                return sampleArea.getColor();
            }
            Object object = this.factorOrDescriptor;
            if (object instanceof PropertyFactor) {
                PropertyFactor propertyFactor = (PropertyFactor)object;
                return propertyFactor.getColor(sample, this.colorIndex);
            }
            object = this.factorOrDescriptor;
            if (object instanceof CategoryFactor) {
                CategoryFactor categoryFactor = (CategoryFactor)object;
                return categoryFactor.getColor(sample);
            }
            object = this.factorOrDescriptor;
            if (object instanceof DescriptorTreeNode && (object = sample.getFunctionResult((descriptorTreeNode = (DescriptorTreeNode)object).getUid())) != null) {
                Factor factor = ((FunctionResult)object).getVisualizationFactor();
                if (factor instanceof CategoryFactor) {
                    CategoryFactor categoryFactor = (CategoryFactor)factor;
                    CatClass catClass = categoryFactor.getClassByValueIdx((int)((FunctionResult)object).getValue());
                    if (catClass != null) {
                        return catClass.getColor();
                    }
                } else {
                    if (this.resultMinMax != null) {
                        float f = ((FunctionResult)object).getNormalisedFloatValue(this.resultMinMax);
                        return PropertyFactor.getColor(Float.valueOf(f), this.colorIndex);
                    }
                    if (factor instanceof PropertyFactor) {
                        PropertyFactor propertyFactor = (PropertyFactor)factor;
                        Float f = propertyFactor.getNormalisedFloatValue(Float.valueOf(((FunctionResult)object).getValue()));
                        return PropertyFactor.getColor(f, this.colorIndex);
                    }
                }
            }
            return null;
        }

        public void setFactorOrDescriptor(Object object, MinMax minMax) {
            this.factorOrDescriptor = object;
            this.resultMinMax = minMax;
        }
    }

    public static enum SelectionMode {
        None,
        Selection,
        Add,
        Move,
        Zoom;


        public boolean supportDrag() {
            return this.equals((Object)Selection) || this.equals((Object)Add) || this.equals((Object)Zoom);
        }
    }

    public class LegendCallback
    implements LegendPanel.LegendChangedCallback {
        private BreezeTable table;

        @Override
        public void onChange() {
            Thumbnail thumbnail;
            BasicPreviewPanel.this.reloadImage();
            if (this.table != null && (thumbnail = BasicPreviewPanel.this.thumbnail) instanceof ThumbnailProperty) {
                ThumbnailProperty thumbnailProperty = (ThumbnailProperty)thumbnail;
                this.table.clearThumbnailCache(thumbnailProperty.getFactor());
            }
        }

        public void setTable(BreezeTable breezeTable) {
            this.table = breezeTable;
        }
    }

    private class ZoomOverviewPanel
    extends JPanel {
        private Point panStartPoint;
        private Point resizeStartPoint;
        private boolean resizeHoriztonal;
        private final ZoomAxis xZoom;
        private final ZoomAxis yZoom;
        private double ratio;

        public ZoomOverviewPanel(final Renderer renderer) {
            this.xZoom = renderer.xZoom;
            this.yZoom = renderer.yZoom;
            this.setBounds(0, 0, (int)zoomLastSize, (int)zoomLastSize);
            this.setVisible(false);
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                final /* synthetic */ ZoomOverviewPanel this$1;
                {
                    this.this$1 = zoomOverviewPanel;
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    int n = Math.abs(this.this$1.getWidth() - mouseEvent.getX());
                    int n2 = Math.abs(this.this$1.getHeight() - mouseEvent.getY());
                    if (n < 5) {
                        this.this$1.setCursor(Cursor.getPredefinedCursor(11));
                    } else if (n2 < 5) {
                        this.this$1.setCursor(Cursor.getPredefinedCursor(9));
                    } else {
                        this.this$1.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    Image image = this.this$1.BasicPreviewPanel.this.image;
                    if (image != null) {
                        if (this.this$1.panStartPoint != null) {
                            this.this$1.xZoom.pan(mouseEvent.getX(), this.this$1.panStartPoint.getX(), 1.0 / this.this$1.ratio);
                            this.this$1.yZoom.pan(mouseEvent.getY(), this.this$1.panStartPoint.getY(), 1.0 / this.this$1.ratio);
                            renderer.repaint();
                            this.this$1.repaint();
                            this.this$1.panStartPoint = mouseEvent.getPoint();
                        } else if (this.this$1.resizeStartPoint != null) {
                            double d = zoomLastSize / (double)(this.this$1.resizeHoriztonal ? this.this$1.getWidth() : this.this$1.getHeight()) * (double)(this.this$1.resizeHoriztonal ? mouseEvent.getX() - this.this$1.resizeStartPoint.x : mouseEvent.getY() - this.this$1.resizeStartPoint.y);
                            if (zoomLastSize + d > 50.0) {
                                zoomLastSize += d;
                                this.this$1.calculateScale();
                                this.this$1.revalidate();
                                this.this$1.repaint();
                            }
                            this.this$1.resizeStartPoint = mouseEvent.getPoint();
                        }
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int n = Math.abs(ZoomOverviewPanel.this.getWidth() - mouseEvent.getX());
                        int n2 = Math.abs(ZoomOverviewPanel.this.getHeight() - mouseEvent.getY());
                        if (n < 5) {
                            ZoomOverviewPanel.this.resizeStartPoint = mouseEvent.getPoint();
                            ZoomOverviewPanel.this.resizeHoriztonal = true;
                        } else if (n2 < 5) {
                            ZoomOverviewPanel.this.resizeStartPoint = mouseEvent.getPoint();
                            ZoomOverviewPanel.this.resizeHoriztonal = false;
                        } else {
                            ZoomOverviewPanel.this.panStartPoint = mouseEvent.getPoint();
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    ZoomOverviewPanel.this.resizeStartPoint = null;
                    ZoomOverviewPanel.this.panStartPoint = null;
                }
            });
            this.addMouseWheelListener(mouseWheelEvent -> {
                int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
                Image image = BasicPreviewPanel.this.image;
                if (image != null && BasicPreviewPanel.this.scale > 0.0) {
                    Point point = this.getPointOnImage(mouseWheelEvent.getPoint());
                    if (this.xZoom.zoom(point.getX(), n) || this.yZoom.zoom(point.getY(), n)) {
                        this.xZoom.reset();
                        this.yZoom.reset();
                        this.setVisible(false);
                    }
                    renderer.repaint();
                    this.repaint();
                }
            });
        }

        public void calculateScale() {
            BufferedImage bufferedImage = BasicPreviewPanel.this.origImage;
            if (bufferedImage != null) {
                double d;
                double d2;
                double d3 = bufferedImage.getWidth(null);
                double d4 = zoomLastSize / (d3 + 1.0);
                this.ratio = d4 < (d2 = zoomLastSize / ((d = (double)bufferedImage.getHeight(null)) + 1.0)) ? d4 : d2;
                this.setSize((int)(d3 * this.ratio), (int)(d * this.ratio));
            }
        }

        private Point getPointOnImage(Point point) {
            Image image = BasicPreviewPanel.this.image;
            if (image != null) {
                double d = this.ratio * BasicPreviewPanel.this.scale;
                return new Point((int)((double)point.x * d / this.xZoom.relative() + this.xZoom.min), (int)((double)point.y * d / this.yZoom.relative() + this.yZoom.min));
            }
            return point;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Image image = BasicPreviewPanel.this.getImage();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            graphics2D.setColor(breezeTheme.getPanelBackground());
            if (image != null && BasicPreviewPanel.this.scale > 0.0) {
                graphics2D.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), null);
                int n = (int)(this.xZoom.min * this.ratio);
                int n2 = (int)(this.yZoom.min * this.ratio);
                int n3 = (int)(this.xZoom.max * this.ratio);
                int n4 = (int)(this.yZoom.max * this.ratio);
                graphics2D.setColor(Color.white);
                graphics2D.drawRect(n, n2, Math.max(5, n3 - n - 1), Math.max(5, n4 - n2 - 1));
                graphics2D.setColor(breezeTheme.getLabelForegroundDifuse());
                graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    public class MeasurementSaveCallback
    implements PlotPopupMenu.ImageSaveCallback {
        public void saveSVG(File file) {
        }

        public BufferedImage makeBufferedImageScreenShot(int n, int n2, boolean bl) {
            LegendPanel legendPanel = BasicPreviewPanel.this.getLegend();
            BufferedImage bufferedImage = new BufferedImage(n + 1, n2 + 1, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            BasicPreviewPanel.this.getRenderer().paint(graphics2D, n, n2, BasicPreviewPanel.this.origImage, (double)n / (double)BasicPreviewPanel.this.origImage.getWidth(), bl);
            graphics2D.dispose();
            if (BasicPreviewPanel.this.splitPaneLegend.isVisible()) {
                return BasicPreviewPanel.createImageWithLegend(legendPanel, bufferedImage);
            }
            return bufferedImage;
        }
    }

    public static interface TooltipCustomValue {
        public String getSample(int var1, int var2);

        public String getValue(int var1, int var2);

        public double getScaleX();

        public double getScaleY();
    }
}

