/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;

public class CoordinateImagePanel
extends AbstractBreezeCustomPanel {
    private final double[][] coordinates;
    private double scale;
    private GeneralPath generalPath;
    private Point dragFrom;
    private double[] dragCoord;

    public CoordinateImagePanel(File file, double[][] dArray) {
        this(CropImagePanel.readImage(file), dArray);
    }

    public CoordinateImagePanel(final BufferedImage bufferedImage, final double[][] dArray) {
        this.coordinates = dArray;
        this.setLayout(new GridBagLayout());
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        Dimension dimension = BreezeFrame.getScreenSize();
        double d = dimension.getWidth() * 0.6;
        double d2 = dimension.getHeight() * 0.6;
        double d3 = (double)bufferedImage.getWidth() / d;
        double d4 = (double)bufferedImage.getHeight() / d2;
        this.scale = 1.0;
        this.scale = d3 > d4 ? d / (double)bufferedImage.getWidth() : d2 / (double)bufferedImage.getHeight();
        this.updatePathAndRepaint();
        final DepthRegistrationPanel.PositionPanel positionPanel = new DepthRegistrationPanel.PositionPanel();
        JPanel jPanel = new JPanel(this){
            final /* synthetic */ CoordinateImagePanel this$0;
            {
                this.this$0 = coordinateImagePanel;
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawImage(bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
                graphics2D.setColor(Color.white);
                graphics2D.draw(this.this$0.generalPath);
                for (double[] dArray2 : dArray) {
                    if (dArray2 == null) continue;
                    graphics2D.setColor(Color.red);
                    graphics2D.fillRect((int)(dArray2[0] * this.this$0.scale - 2.0), (int)(dArray2[1] * this.this$0.scale - 2.0), 5, 5);
                    graphics2D.setColor(Color.white);
                    graphics2D.drawRect((int)(dArray2[0] * this.this$0.scale - 2.0), (int)(dArray2[1] * this.this$0.scale - 2.0), 5, 5);
                }
            }
        };
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n;
                    int n2 = (int)((double)mouseEvent.getX() / CoordinateImagePanel.this.scale);
                    double[] dArray = CoordinateImagePanel.this.getCoord(n2, n = (int)((double)mouseEvent.getY() / CoordinateImagePanel.this.scale));
                    if (dArray != null) {
                        CoordinateImagePanel.this.dragCoord = dArray;
                        CoordinateImagePanel.this.dragFrom = mouseEvent.getPoint();
                    } else if (CoordinateImagePanel.this.generalPath.contains(mouseEvent.getPoint())) {
                        CoordinateImagePanel.this.dragFrom = mouseEvent.getPoint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CoordinateImagePanel.this.dragFrom = null;
                CoordinateImagePanel.this.dragCoord = null;
            }
        });
        jPanel.addMouseMotionListener(new MouseMotionListener(){
            final /* synthetic */ CoordinateImagePanel this$0;
            {
                this.this$0 = coordinateImagePanel;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = (int)((double)mouseEvent.getX() / this.this$0.scale);
                int n2 = (int)((double)mouseEvent.getY() / this.this$0.scale);
                positionPanel.setPositon(n, n2, 1.0);
                double[] dArray2 = this.this$0.getCoord(n, n2);
                if (dArray2 != null) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(13));
                } else if (this.this$0.generalPath.contains(mouseEvent.getPoint())) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.this$0.dragFrom != null) {
                    double d = ((double)mouseEvent.getX() - this.this$0.dragFrom.getX()) / this.this$0.scale;
                    double d2 = ((double)mouseEvent.getY() - this.this$0.dragFrom.getY()) / this.this$0.scale;
                    if (this.this$0.dragCoord != null) {
                        this.this$0.dragCoord[0] = this.this$0.dragCoord[0] + d;
                        this.this$0.dragCoord[1] = this.this$0.dragCoord[1] + d2;
                    } else {
                        for (double[] dArray2 : dArray) {
                            if (dArray2 == null) continue;
                            dArray2[0] = dArray2[0] + d;
                            dArray2[1] = dArray2[1] + d2;
                        }
                    }
                    this.this$0.updatePathAndRepaint();
                    this.this$0.dragFrom = mouseEvent.getPoint();
                }
            }
        });
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        this.add((Component)jPanel, gridBagConstraints);
        this.add((Component)positionPanel, GridBagHelper.create(1, new Insets(0, 0, 0, 0)));
        Dimension dimension2 = new Dimension((int)((double)bufferedImage.getWidth() * this.scale), (int)((double)bufferedImage.getHeight() * this.scale));
        jPanel.setPreferredSize(dimension2);
        jPanel.setMinimumSize(dimension2);
        this.setPreferredSize(new Dimension(Math.max(400, dimension2.width + 50), Math.max(400, dimension2.height + 200)));
    }

    private double[] getCoord(int n, int n2) {
        for (double[] dArray : this.coordinates) {
            if (dArray == null) continue;
            double d = Math.abs((double)n - dArray[0]);
            double d2 = Math.abs((double)n2 - dArray[1]);
            if (!(d < 5.0) || !(d2 < 5.0)) continue;
            return dArray;
        }
        return null;
    }

    private void updatePathAndRepaint() {
        this.generalPath = new GeneralPath();
        for (double[] dArray : this.coordinates) {
            if (dArray == null) continue;
            int n = (int)(dArray[0] * this.scale);
            int n2 = (int)(dArray[1] * this.scale);
            if (this.generalPath.getCurrentPoint() == null) {
                this.generalPath.moveTo(n, n2);
                continue;
            }
            this.generalPath.lineTo(n, n2);
        }
        this.generalPath.closePath();
        this.repaint();
    }

    public String getCoordinateString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (double[] dArray : this.coordinates) {
            if (dArray == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append((int)dArray[0]);
            stringBuilder.append(",");
            stringBuilder.append((int)dArray[1]);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Coordinate image preview");
        jFrame.setDefaultCloseOperation(3);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(){

            @Override
            public File getThumbnailFile() {
                return new File("E:\\Data\\BreezeDemo2222\\Record\\Study\\Group\\Box 128_ref\\measurement.jpg");
            }
        };
        CoordinateImagePanel coordinateImagePanel = new CoordinateImagePanel(measurementWithoutIO.getCustomImageFile(), (double[][])new double[][]{{0.0, 0.0}, {50.0, 0.0}, {50.0, 50.0}, {0.0, 50.0}});
        jFrame.getContentPane().add((Component)coordinateImagePanel, "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

