/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;

public class CropImagePanel
extends AbstractBreezeCustomPanel {
    private final InsetsPanel insetsPanel;
    private final BufferedImage image;
    private final BreezeCheckBox saveAsCheckBox = new BreezeCheckBox("", false, this::setInfo);
    private final InputPanel inputPanel;

    public CropImagePanel(File file, InsetsPanel.InsetsType insetsType) {
        this(CropImagePanel.readImage(file), 0, 0, 0, 0, insetsType);
    }

    public static BufferedImage readImage(File file) {
        if (!file.exists()) {
            throw new RuntimeException("Cannot find image file: " + file.getAbsolutePath());
        }
        return ThumbnailManager.getInstance(0).getImage(file);
    }

    public CropImagePanel(BufferedImage bufferedImage, int n, int n2, int n3, int n4, InsetsPanel.InsetsType insetsType) {
        this(bufferedImage, n, n2, n3, n4, insetsType, false, 1, 1);
    }

    public CropImagePanel(final BufferedImage bufferedImage, int n, int n2, int n3, int n4, InsetsPanel.InsetsType insetsType, boolean bl, int n5, int n6) {
        GridBagConstraints gridBagConstraints;
        this.image = bufferedImage;
        this.setLayout(new GridBagLayout());
        this.insetsPanel = new InsetsPanel(this, bufferedImage.getWidth(), bufferedImage.getHeight(), insetsType){
            final /* synthetic */ CropImagePanel this$0;
            {
                this.this$0 = cropImagePanel;
                super(n, n2, insetsType);
            }

            @Override
            public void drawContent(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
                graphics2D.drawImage(bufferedImage, n, n2, n3, n4, null);
            }
        };
        this.insetsPanel.setInsets(n, n2, n3, n4);
        this.insetsPanel.setGrid(bl);
        this.insetsPanel.setGrid(n5, n6);
        this.inputPanel = new InputPanel(this.insetsPanel, insetsType, this::setInfo);
        this.insetsPanel.setInsetsChanged(nArray -> {
            this.setInsetsChanged(nArray);
            this.inputPanel.update();
        });
        this.setOpaque(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        this.add((Component)this.insetsPanel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = GridBagHelper.create(1, 0, new Insets(0, 12, 0, 0));
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.fill = 3;
        BreezeScrollPane.VerticalOnly verticalOnly = new BreezeScrollPane.VerticalOnly(this.inputPanel);
        verticalOnly.setPreferredSize(new Dimension(150, 0));
        this.add((Component)verticalOnly, gridBagConstraints3);
        if (insetsType.equals((Object)InsetsPanel.InsetsType.Segmentation)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            this.add((Component)this.saveAsCheckBox, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Tip, "Hold Shift and left-click to draw a rectangle. Drag the red lines to adjust.\nUse the mouse wheel to zoom and middle-click and drag to pan."), gridBagConstraints);
        this.setInfo(false);
        Dimension dimension = BreezeFrame.getScreenSize();
        double d = dimension.getWidth() * 0.9;
        double d2 = dimension.getHeight() * 0.9;
        double d3 = d2 / (double)bufferedImage.getHeight();
        if ((double)bufferedImage.getWidth() * d3 > d) {
            d3 = d / (double)bufferedImage.getWidth();
        }
        this.setPreferredSize(new Dimension((int)Math.max((double)bufferedImage.getWidth() * d3 + 55.0, 750.0), (int)d2));
    }

    public void setAspectRatio(boolean bl) {
        this.insetsPanel.setAspectRatio(bl);
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    public void setInsetsChanged(int[] nArray) {
    }

    public int top() {
        return this.insetsPanel.getInsetsArray()[0];
    }

    public int left() {
        return this.insetsPanel.getInsetsArray()[2];
    }

    public int bottom() {
        return this.insetsPanel.getInsetsArray()[1];
    }

    public int bottomPos() {
        return this.image.getHeight() - this.bottom();
    }

    public int right() {
        return this.insetsPanel.getInsetsArray()[3];
    }

    public int rightPos() {
        return this.image.getWidth() - this.right();
    }

    @Override
    public void okPressed(boolean bl) {
        if (bl) {
            this.inputPanel.triggerChange();
            super.okPressed(true);
        }
    }

    @Override
    public Object getResult() {
        return null;
    }

    public boolean saveAsNewMeasurement() {
        return this.saveAsCheckBox.isSelected() || this.hasGrid();
    }

    public boolean hasGrid() {
        return this.insetsPanel.hasGrid();
    }

    public int getGridRows() {
        return this.insetsPanel.getGridRows();
    }

    public int getGridColumns() {
        return this.insetsPanel.getGridColumns();
    }

    private void setInfo(boolean bl) {
        boolean bl2 = this.inputPanel.gridCheckBox.isSelected();
        String string = bl2 ? "Save grid cells as " + this.getGridColumns() * this.getGridRows() + " new measurements. Leave the original intact." : "Save cropped image as a new measurement. Leave the original intact.";
        this.saveAsCheckBox.setText(string);
        this.saveAsCheckBox.setEnabled(!bl2);
        if (this.inputPanel.gridCheckBox.isSelected()) {
            this.saveAsCheckBox.setSelected(bl2);
        }
    }

    public void setTopText(String string) {
        this.inputPanel.setTopText(string);
    }

    public void setBottomText(String string) {
        this.inputPanel.setBottomText(string);
    }

    public void setLeftText(String string) {
        this.inputPanel.setLeftText(string);
    }

    public void setRightText(String string) {
        this.inputPanel.setRightText(string);
    }

    public boolean shouldCrop() {
        return this.insetsPanel.shouldCrop();
    }

    @Generated
    public InsetsPanel getInsetsPanel() {
        return this.insetsPanel;
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    private class InputPanel
    extends JPanel {
        private final BreezeInputField top;
        private final BreezeInputField left;
        private final BreezeInputField bottom;
        private final BreezeInputField right;
        private final BreezeCheckBox gridCheckBox;
        private final BreezeInputField gridColumns;
        private final BreezeInputField gridRows;

        public InputPanel(InsetsPanel insetsPanel, InsetsPanel.InsetsType insetsType, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
            super(new GridBagLayout());
            this.top = new BreezeInputField.Number("Top", "", "");
            this.left = new BreezeInputField.Number("Left", "", "");
            this.bottom = new BreezeInputField.Number("Bottom", "", "");
            this.right = new BreezeInputField.Number("Right", "", "");
            this.gridCheckBox = new BreezeCheckBox("Split", false);
            this.gridColumns = new BreezeInputField.Number("Grid columns", "", "");
            this.gridRows = new BreezeInputField.Number("Grid rows", "", "");
            this.setOpaque(true);
            if (!insetsType.equals((Object)InsetsPanel.InsetsType.WidthOnly)) {
                this.add((Component)this.top, GridBagHelper.createWithWeigthX1(0, new Insets(5, 0, 0, 0)));
                this.add((Component)this.bottom, GridBagHelper.createWithWeigthX1(2, new Insets(12, 0, 0, 0)));
            }
            if (!insetsType.equals((Object)InsetsPanel.InsetsType.HeightOnly)) {
                this.add((Component)this.left, GridBagHelper.createWithWeigthX1(1, new Insets(12, 0, 0, 0)));
                this.add((Component)this.right, GridBagHelper.createWithWeigthX1(3, new Insets(12, 0, 0, 0)));
            }
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
            int[] nArray = insetsPanel.getInsetsArray();
            this.top.setValue(nArray[0]);
            this.left.setValue(nArray[2]);
            this.bottom.setValue(CropImagePanel.this.image.getHeight() - nArray[1]);
            this.right.setValue(CropImagePanel.this.image.getWidth() - nArray[3]);
            TextActionEvent.TextActionListener textActionListener = textActionEvent -> insetsPanel.setInsets(this.top.getNumberInt(), this.left.getNumberInt(), cropImagePanel.image.getHeight() - this.bottom.getNumberInt(), cropImagePanel.image.getWidth() - this.right.getNumberInt());
            this.top.addChangeListener(textActionListener);
            this.left.addChangeListener(textActionListener);
            this.bottom.addChangeListener(textActionListener);
            this.right.addChangeListener(textActionListener);
            this.gridCheckBox.setSelected(insetsPanel.isGridEnabled());
            this.gridCheckBox.setFontSize(12);
            this.gridCheckBox.addCallback(bl -> {
                this.gridColumns.setEnabled(bl);
                this.gridRows.setEnabled(bl);
                checkBoxCallback.changed(bl);
                insetsPanel.setGrid(this.gridCheckBox.isSelected());
            });
            this.gridColumns.setEnabled(insetsPanel.isGridEnabled());
            this.gridColumns.setValue(insetsPanel.getGridColumns());
            this.gridRows.setEnabled(insetsPanel.isGridEnabled());
            this.gridRows.setValue(insetsPanel.getGridRows());
            if (insetsType.equals((Object)InsetsPanel.InsetsType.Segmentation) || insetsType.equals((Object)InsetsPanel.InsetsType.Import)) {
                this.add((Component)new BreezeSeparator(), GridBagHelper.createWithWeigthX1(5, new Insets(12, 0, 0, 0)));
                this.add((Component)this.gridCheckBox, GridBagHelper.createWithWeigthX1(6, new Insets(12, 0, 0, 0)));
                this.add((Component)this.gridColumns, GridBagHelper.createWithWeigthX1(7, new Insets(12, 0, 0, 0)));
                this.add((Component)this.gridRows, GridBagHelper.createWithWeigthX1(8, new Insets(12, 0, 0, 0)));
            }
            TextActionEvent.TextActionListener textActionListener2 = textActionEvent -> {
                insetsPanel.setGrid(this.gridRows.getNumberInt(), this.gridColumns.getNumberInt());
                CropImagePanel.this.setInfo(true);
            };
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
            this.gridColumns.addChangeListener(textActionListener2);
            this.gridRows.addChangeListener(textActionListener2);
        }

        public void update() {
            this.top.setValue(CropImagePanel.this.top());
            this.left.setValue(CropImagePanel.this.left());
            this.bottom.setValue(CropImagePanel.this.bottomPos());
            this.right.setValue(CropImagePanel.this.rightPos());
        }

        public void setTopText(String string) {
            this.top.setDescription(string);
        }

        public void setBottomText(String string) {
            this.bottom.setDescription(string);
        }

        public void setLeftText(String string) {
            this.left.setDescription(string);
        }

        public void setRightText(String string) {
            this.right.setDescription(string);
        }

        public void triggerChange() {
            this.top.triggerChange(true);
            this.left.triggerChange(true);
            this.bottom.triggerChange(true);
            this.right.triggerChange(true);
        }
    }
}

