/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;

public class CropSamplesPanel
extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
    private final BreezeCheckBox deleteMeasurementCheckBox = new BreezeCheckBox("Delete original measurement after crop", false);
    private final BreezeCheckBox keepFullWidthCheckBox = new BreezeCheckBox("Keep full width", false);
    private final BreezeInputField.Number paddingInputField = new BreezeInputField.Number("Padding", "", 0.0, "px");

    public CropSamplesPanel(int n, int n2) {
        BreezeTextArea breezeTextArea = new BreezeTextArea(4, false);
        breezeTextArea.setText("Are you sure that you want to crop (" + (String)(n > 1 ? n + ") measurements and totally (" : "") + n2 + ") samples into new measurements?");
        breezeTextArea.setEditable(false);
        breezeTextArea.setBorder(BorderFactory.createEmptyBorder());
        breezeTextArea.setTextBackground(BreezeTheme.getInstance().getPanelBackground());
        this.add((Component)breezeTextArea, GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 1, new Insets(24, 12, 12, 12)));
        this.paddingInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        this.paddingInputField.addValidator(new NumericMinMaxValidator(0.0, 2.147483647E9));
        this.add((Component)this.paddingInputField, GridBagHelper.create(this.getComponentCount(), new Insets(12, 30, 0, 24)));
        this.add((Component)this.keepFullWidthCheckBox, GridBagHelper.create(this.getComponentCount(), new Insets(12, 30, 0, 24)));
        this.add((Component)this.deleteMeasurementCheckBox, GridBagHelper.create(this.getComponentCount(), new Insets(12, 30, 0, 24)));
    }

    @Override
    public Object getResult() {
        return null;
    }

    public boolean keepFullWidth() {
        return this.keepFullWidthCheckBox.isSelected();
    }

    public int getPadding() {
        return this.paddingInputField.getNumberInt();
    }

    public boolean isDeleteMeasurement() {
        return this.deleteMeasurementCheckBox.isSelected();
    }

    public Rectangle updateBounds(Rectangle rectangle, RawHeader rawHeader) {
        int n = rawHeader.pixelWidth().value;
        int n2 = rawHeader.frameCount().value;
        boolean bl = this.keepFullWidth();
        int n3 = this.getPadding();
        if (n3 > 0) {
            rectangle = new Rectangle(Math.max(0, rectangle.x - n3), Math.max(0, rectangle.y - n3), Math.min(n, rectangle.width + n3 * 2), Math.min(rectangle.height + n3 * 2, n2));
        }
        if (bl) {
            rectangle = new Rectangle(0, rectangle.y, n, rectangle.height);
        }
        return rectangle;
    }
}

