/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.CreateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.VisualizationJobQueue;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.entry.InteractionTable;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableSorter;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupMainPanel;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.model.AbstractModel;

public class InteractionPreviewPanel
extends BasicPreviewPanel
implements InteractionTable.InteractionObject,
EntrySettingsPanel.SettingsComponent {
    private static InteractionPreviewPanel selectedInstance;
    private boolean created = false;
    private InteractionTable entryTable;
    private MeasurementDataSource dataSource;
    private final List<Sample> samples = new ArrayList<Sample>();
    private PPEntryMainInterface pmi;
    private final BreezeList measurementList = new BreezeList();
    private final BreezeList samplesList = new BreezeList();
    private CollapsePanel highlightedSamplesPanel;
    private Model model;

    public InteractionPreviewPanel(Workflow workflow) {
        this(workflow, null);
    }

    public InteractionPreviewPanel(Workflow workflow, final Model model) {
        super(workflow);
        this.model = model;
        this.clearSelection();
        CollapsePanel collapsePanel = new CollapsePanel("Selected Measurements", true, true, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(6, 10, 6, 0);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane((Component)((Object)this.measurementList));
        breezeScrollPane.setPreferredSize(new Dimension(0, 100));
        breezeScrollPane.setMinimumSize(new Dimension(0, 100));
        collapsePanel.addPanel(breezeScrollPane);
        this.add((Component)collapsePanel, gridBagConstraints);
        this.measurementList.setSelectionMode(0);
        this.measurementList.setFont(new Font("Tahoma", 0, 14));
        this.measurementList.addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            Measurement measurement = (Measurement)this.measurementList.getSelectedValue();
            if (measurement != null) {
                Measurement measurement2 = measurement;
                ArrayList<Sample> arrayList = new ArrayList<Sample>();
                for (Sample sample : this.samples) {
                    Measurement measurement3 = sample.measurement();
                    if (measurement3 != measurement2) continue;
                    arrayList.add(sample);
                }
                this.setData(measurement2, arrayList);
            }
        });
        this.highlightedSamplesPanel = new CollapsePanel("Pinned Samples", true, true, 0);
        this.highlightedSamplesPanel.setCollapsed(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 11;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(6, 10, 6, 0);
        BreezeScrollPane breezeScrollPane2 = new BreezeScrollPane((Component)((Object)this.samplesList));
        breezeScrollPane2.setPreferredSize(new Dimension(0, 100));
        breezeScrollPane2.setMinimumSize(new Dimension(0, 100));
        this.highlightedSamplesPanel.addPanel(breezeScrollPane2);
        this.add((Component)this.highlightedSamplesPanel, gridBagConstraints2);
        this.updateHighlightSamples();
        this.samplesList.setSelectionMode(2);
        this.samplesList.setFont(new Font("Tahoma", 0, 14));
        this.samplesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent(jList, ((Sample)object).getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE), n, bl, bl2);
            }
        });
        this.samplesList.addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ InteractionPreviewPanel this$0;
            {
                this.this$0 = interactionPreviewPanel;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting() || this.this$0.workflow == null) {
                    return;
                }
                int n = this.getSegmentationLevel();
                ArrayList<Sample> arrayList = new ArrayList<Sample>();
                for (Object e : this.this$0.samplesList.getSelectedValuesList()) {
                    this.addSamplesFromLevel(n, arrayList, (Sample)e);
                }
                if (arrayList.size() > 0) {
                    this.this$0.setData(((Sample)arrayList.get(0)).measurement(), arrayList);
                    this.this$0.selectSamples(arrayList);
                }
            }

            private int getSegmentationLevel() {
                if (model instanceof Model.ModelWithSample) {
                    Model.ModelWithSample modelWithSample = (Model.ModelWithSample)model;
                    return modelWithSample.getSegmentationLevel();
                }
                return this.this$0.workflow.getSegmentationLevel();
            }

            private void addSamplesFromLevel(int n, List<Sample> list, Sample sample) {
                if (sample == null) {
                    return;
                }
                if (sample.getSegmentationLevel() == n) {
                    list.add(sample);
                } else if (sample.getSegmentationLevel() < n) {
                    for (BasicSample basicSample : sample.getChildList()) {
                        this.addSamplesFromLevel(n, list, (Sample)basicSample);
                    }
                } else {
                    this.addSamplesFromLevel(n, list, (Sample)sample.getParent());
                }
            }
        });
    }

    @Override
    public void showEntry(Object object, Object object2, boolean bl) {
        super.showEntry(object, object2, bl);
        this.updateHighlightSamples();
        selectedInstance = this;
    }

    public static InteractionPreviewPanel getSelectedInstance() {
        return selectedInstance;
    }

    public void updateMeasurementList() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        if (this.samples.size() > 0) {
            HashSet<Measurement> hashSet = new HashSet<Measurement>();
            for (Sample sample : this.samples) {
                Measurement measurement;
                if (sample == null || hashSet.contains(measurement = sample.measurement())) continue;
                hashSet.add(measurement);
                arrayList.add(measurement);
            }
        }
        this.measurementList.setModel(arrayList);
        if (arrayList.size() > 0) {
            this.measurementList.setSelectedIndex(0);
        }
    }

    public void updateHighlightSamples() {
        if (this.highlightedSamplesPanel != null) {
            ArrayList<Sample> arrayList = new ArrayList<Sample>();
            if (this.workflow != null) {
                arrayList.addAll(this.workflow.getHighlighedSamples().getSamples());
            }
            arrayList.sort(BreezeTableSorter::compareSamples);
            this.samplesList.setModel(arrayList);
            this.highlightedSamplesPanel.setVisible(arrayList.size() > 0);
        }
    }

    public void enableInteraction(final PPEntryMainInterface pPEntryMainInterface) {
        this.pmi = pPEntryMainInterface;
        if (!this.created) {
            VisualizationJobQueue.getInstance().addToQueue(new CreateVisualizationJob(this){
                final /* synthetic */ InteractionPreviewPanel this$0;
                {
                    this.this$0 = interactionPreviewPanel;
                }

                @Override
                protected void createVisualization(BreezeProgressManager breezeProgressManager) {
                    this.this$0.entryTable = InteractionTable.create(breezeProgressManager, pPEntryMainInterface, this.this$0);
                }
            });
            this.created = true;
        }
    }

    @Override
    public void doInteraction(InteractionArray interactionArray) {
        this.dataSource = this.getDataSource(interactionArray);
        this.samples.clear();
        if (this.dataSource != null && interactionArray.hasSelection()) {
            for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
                Sample sample;
                if (!interactionArray.get(i) || (sample = this.dataSource.getSampleAt(i)) == null) continue;
                this.samples.add(sample);
            }
        }
        this.updateMeasurementList();
        this.updateHighlightSamples();
        if (this.samples.isEmpty()) {
            this.clearSelection("No selection");
        }
    }

    private MeasurementDataSource getDataSource(InteractionArray interactionArray) {
        if (interactionArray.getRoot() instanceof Case) {
            return this.getDataSource((Case)interactionArray.getRoot());
        }
        return null;
    }

    private MeasurementDataSource getDataSource(Case case_) {
        if (case_ != null) {
            if (case_.getDataSource() instanceof MeasurementDataSource) {
                return (MeasurementDataSource)case_.getDataSource();
            }
            if (case_.getLinkedDataSource() instanceof MeasurementDataSource) {
                return (MeasurementDataSource)case_.getLinkedDataSource();
            }
        }
        return null;
    }

    private MeasurementDataSource getDataSource() {
        AbstractModel abstractModel;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.model != null && (abstractModel = this.model.getModel()) != null) {
            return this.getDataSource(abstractModel.getCase());
        }
        return null;
    }

    @Override
    public void selectSamples(List<Sample> list) {
        this.samples.clear();
        this.samples.addAll(list);
        this.updateMeasurementList();
        if (this.entryTable != null) {
            this.entryTable.getProject_GUI().doInteraction((InteractionInterface)this.entryTable);
        }
    }

    @Override
    public int[] getSelectionRows() {
        this.dataSource = this.getDataSource();
        if (this.dataSource != null) {
            List<BasicSample> list = this.dataSource.getAllSamples();
            int[] nArray = new int[this.samples.size()];
            for (int i = 0; i < this.samples.size(); ++i) {
                nArray[i] = list.indexOf(this.samples.get(i));
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public int getRowCount() {
        this.dataSource = this.getDataSource();
        if (this.dataSource != null) {
            return this.dataSource.getRowCount();
        }
        return 0;
    }

    @Override
    protected List<Object> getSelectedEntries() {
        PPEntryMainInterface pPEntryMainInterface = this.pmi;
        if (pPEntryMainInterface instanceof EntryMainPanel) {
            EntryMainPanel entryMainPanel = (EntryMainPanel)pPEntryMainInterface;
            return entryMainPanel.getSelectedEntries();
        }
        return null;
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        if (this.pmi != null) {
            BreezeFrame breezeFrame = this.pmi.getFrame();
            this.showPopupInternal(mouseEvent, breezeFrame, breezeContextMenu -> {
                if (this.pmi instanceof WorkflowMainPanel || this.pmi instanceof GroupMainPanel) {
                    breezeContextMenu.addButtonCloseClick("Go to measurement", () -> EntryMainHelper.showMeasurementPanel((BreezeMainPanel)((EntryMainItemPanel)this.pmi), this.getMeasurement()));
                }
            });
        } else {
            super.showPopup(mouseEvent);
        }
    }
}

