/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.ImmutablePair;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.average.AverageSpectrumViewPanel;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.raw.QgisLauncher;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.entry.workflow.WorkflowMergeHandler;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.evince.data.PixelDataHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.dialog.WizardCustomPanel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.common.view.preview.CropSamplesPanel;
import se.prediktera.breeze.frontend.common.view.preview.PreviewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.frontend.main.settings.hardware.MultiCameraSettingsPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.ReferenceStatusCustomPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.raw.RawCropHelper;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class MeasurementPopup {
    public static void showMeasurementsPopup(EntryMainItemPanel entryMainItemPanel, List<Object> list, MouseEvent mouseEvent) {
        BreezeFrame breezeFrame = entryMainItemPanel.getFrame();
        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
        MeasurementPopup.addMeasurementsPopup(breezeFrame, entryMainItemPanel, null, list, breezeContextMenu, mouseEvent.getPoint(), string -> entryMainItemPanel.setDirty(true));
        breezeContextMenu.addSeparator();
        breezeContextMenu.addButtonCloseClick("Select all", () -> entryMainItemPanel.getEntryList().selectAll());
        breezeContextMenu.addButtonCloseClick("Delete", () -> entryMainItemPanel.entryDeleteClicked(entryMainItemPanel.getSelectedEntry()));
        if (breezeContextMenu.resize()) {
            breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
            breezeContextMenu.setPositionLater(mouseEvent);
        }
    }

    public static void addMeasurementsPopup(BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, PreviewPanel previewPanel, final List<Object> list, BreezeContextMenu breezeContextMenu2, Point point, final EntryPopupCallback entryPopupCallback) {
        Object object;
        Object object2;
        Entry entry;
        Object object3;
        List<Measurement> list2 = Measurement.getMeasurements(list);
        if (list.size() == 1 && (object3 = list.getFirst()) instanceof Entry) {
            entry = (Entry)object3;
            breezeContextMenu2.addButtonCloseClick("Rename", () -> BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Rename", "Enter new name:", entry.getName(), breezeActionEvent -> {
                try {
                    String string = breezeActionEvent.getInputText();
                    if (!string.isEmpty() && !string.equals(entry.getName())) {
                        FileHelper.checkValidNameOrThrow(string);
                        entry.rename(string);
                        entryMainPanel.setFormatedTitle(entry);
                        ToastHandler.getInstance().showToast(breezeFrame, "Renamed");
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.ERROR_OPTION, "Rename failed", "'" + String.valueOf(entry) + "' could not be renamed on disk since the chosen name is not allowed\n\nAvoid special characters like \\ / : * ? \" < > | ;");
                    Logg.error((String)"Renamed failed", (Throwable)invalidPathException);
                }
                catch (Exception exception) {
                    BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.ERROR_OPTION, "Rename failed", "'" + String.valueOf(entry) + "' could not be renamed on disk\n\nPlease close any explorer window or files that are opened and try again");
                    Logg.error((String)"Renamed failed", (Throwable)exception);
                }
            }));
        }
        if (!list.isEmpty() && (object3 = list.getFirst()) instanceof Entry) {
            entry = (Entry)object3;
            breezeContextMenu2.addSubMenu("Open in", breezeContextMenu -> {
                breezeContextMenu.addButtonCloseClick("File Browser", () -> FileHelper.openExplorerOnPath(entry));
                if (!list2.isEmpty()) {
                    if (EvinceHelper.exists()) {
                        breezeContextMenu.addButtonCloseClick("Evince", () -> EvinceHelper.startEvince(list2));
                    }
                    if (QgisLauncher.isQgisInstalled()) {
                        QgisLauncher qgisLauncher = QgisLauncher.builder().build();
                        breezeContextMenu.addButtonCloseClick("QGIS", () -> qgisLauncher.openMeasurementsAsLayers(list2));
                    }
                }
            });
        }
        if (list2.isEmpty()) {
            return;
        }
        breezeContextMenu2.addSeparator();
        entry = list2.getFirst();
        object3 = list2.size() > 1 ? "s" : "";
        breezeContextMenu2.addButtonCloseClick("Apply Changes", () -> ApplyChanges.applyChanges(entryMainPanel.getFrame(), list2));
        breezeContextMenu2.addButtonCloseClick("Set RGB bands", () -> MeasurementPopup.lambda$addMeasurementsPopup$7((Measurement)entry, breezeFrame, entryMainPanel, list2, entryPopupCallback, (String)object3));
        breezeContextMenu2.addButtonCloseClick("Set reflectance target", () -> SpectralPanel.applyReflectanceTargetOnMeasurements(entryMainPanel, list2));
        if (breezeFrame.getProduct().equals((Object)UpdateHelper.Product.BreezeRuntimeClient)) {
            return;
        }
        breezeContextMenu2.addSubMenu("Transform", arg_0 -> MeasurementPopup.lambda$addMeasurementsPopup$10(entryMainPanel, list2, entryPopupCallback, (Measurement)entry, arg_0));
        if (list2.size() == 1 && (object2 = list.getFirst()) instanceof Measurement) {
            object = (Measurement)object2;
            breezeContextMenu2.addButtonCloseClick("Crop", () -> MeasurementPopup.lambda$addMeasurementsPopup$30(breezeFrame, entryMainPanel, entryPopupCallback, (Measurement)object));
        }
        breezeContextMenu2.addButtonCloseClick("Crop samples...", () -> MeasurementPopup.lambda$addMeasurementsPopup$31(list2, breezeFrame, entryMainPanel, (Measurement)entry));
        if (list2.size() == 1 && list.getFirst() instanceof Measurement) {
            breezeContextMenu2.addButtonCloseClick("Extract white reference", () -> MeasurementPopup.lambda$addMeasurementsPopup$33(breezeFrame, entryMainPanel, (Measurement)entry));
            if (previewPanel != null) {
                object = previewPanel.getSelectedSamples();
                breezeContextMenu2.addSubMenu("Zoom", arg_0 -> MeasurementPopup.lambda$addMeasurementsPopup$34((List)object, previewPanel, arg_0));
                if (!object.isEmpty() && (object2 = ((Measurement)entry).getWorkflow().getSegmentationNodes().getSegmentation(((Sample)object.getFirst()).getSegmentationHashId())) != null && ((SegmentationNode)object2).getFunction() instanceof ManualSegmentation) {
                    breezeContextMenu2.addButtonCloseClick("Move samples(s)", () -> previewPanel.panSamples(point));
                }
                breezeContextMenu2.addButtonCloseClick("Spectral Viewer", () -> MeasurementPopup.lambda$addMeasurementsPopup$37(breezeFrame, entryMainPanel, (Measurement)entry));
            }
        }
        if (list2.size() > 1 && list.getFirst() instanceof Measurement) {
            breezeContextMenu2.addButtonCloseClick("Merge", () -> BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Merge", "", (AbstractBreezeCustomPanel)new MergePanel(list2), null, breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(entryMainPanel.getFrame(), new ProgressAction(){

                @Override
                public void runAction() {
                    ImmutablePair<Measurement, TcpManager.CommandErrorException> immutablePair = ((MergePanel)breezeActionEvent.getBreezeCustomPanel()).apply(this.getProgressManager());
                    entryPopupCallback.onFinished("Update Image");
                    entryMainPanel.getEntryList().sort();
                    entryMainPanel.getEntryList().setSelectedValue(immutablePair.left);
                    entryMainPanel.setDirty(true);
                    entryMainPanel.getEntryList().repaint();
                    if (immutablePair.right != null) {
                        throw new ErrorHandler.InformationMessageException(((TcpManager.CommandErrorException)immutablePair.right).getReply().getMessage());
                    }
                }
            }, "Merging")));
        }
        if (list.size() > 1 && list.getFirst() instanceof Workflow) {
            breezeContextMenu2.addButtonCloseClick("Merge Studies", () -> {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object e : list) {
                    stringBuilder.append("\n").append(e.toString());
                }
                BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Merge Studies", "Do you want to merge:\n" + String.valueOf(stringBuilder) + "\n\nInto one study?", null, (Object)EntryMainHelper.getUniqueName("Merged Study", list), breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(entryMainPanel.getFrame(), new ProgressAction(){

                    @Override
                    public void runAction() {
                        entryMainPanel.addEntry(WorkflowMergeHandler.merge(this.getProgressManager(), WorkflowMergeHandler.getWorkflows(list), breezeActionEvent.getInputText()));
                        entryPopupCallback.onFinished("Merged");
                        entryMainPanel.setDirty(true);
                    }
                }, "Merging"));
            });
        }
    }

    public static void cropImage(BreezeFrame breezeFrame, EntryMainPanel entryMainPanel, EntryPopupCallback entryPopupCallback, Measurement measurement) {
        BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Crop Image", "", (AbstractBreezeCustomPanel)new CropImagePanel(measurement.getThumbnailFile(), InsetsPanel.InsetsType.Segmentation), null, breezeActionEvent2 -> {
            CropImagePanel cropImagePanel = (CropImagePanel)breezeActionEvent2.getBreezeCustomPanel();
            if (cropImagePanel.saveAsNewMeasurement()) {
                List list = entryMainPanel.getEntryList().getList();
                BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "New measurement", "Enter name for the cropped measurement:", EntryMainHelper.getUniqueName(measurement.getName() + "_crop", list), breezeActionEvent -> {
                    String string = breezeActionEvent.result().toString();
                    if (cropImagePanel.hasGrid()) {
                        RawCropHelper.cropMeasurementIntoGrid(breezeFrame, entryMainPanel, measurement, list, cropImagePanel, entryPopupCallback, string);
                    } else {
                        RawCropHelper.crop(breezeFrame, entryMainPanel, cropImagePanel, measurement, RawCropHelper.createMeasurement(measurement, list, string), entryPopupCallback);
                    }
                });
            } else {
                RawCropHelper.crop(breezeFrame, entryMainPanel, cropImagePanel, measurement, measurement, entryPopupCallback);
            }
        });
    }

    public static void extractWhiteReference(BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, final Measurement measurement) {
        BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.WIZARD_OPTION, "", "", (AbstractBreezeCustomPanel)new WizardCustomPanel(new String[]{"Select white reference", "Set calibrated reflectance target"}, new CropImagePanel(measurement.getThumbnailFile(), InsetsPanel.InsetsType.WhiteReference), new SpectralPanel.ReflectanceTargetPanel(entryMainPanel)), null, breezeActionEvent -> {
            final WizardCustomPanel wizardCustomPanel = (WizardCustomPanel)breezeActionEvent.getBreezeCustomPanel();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

                @Override
                public void runAction() {
                    CropImagePanel cropImagePanel = (CropImagePanel)wizardCustomPanel.getPanel(0);
                    final File file = FileHelper.createTempFileInWorkspace("raw");
                    RawHelper.extractWhite(measurement.rawFile().file(), file, new MeasurementFileLocation.DarkRef().file(measurement), new int[]{cropImagePanel.top(), cropImagePanel.bottomPos(), cropImagePanel.left(), cropImagePanel.rightPos()});
                    final FakeCamera.FakeCameraFromMeasurement fakeCameraFromMeasurement = new FakeCamera.FakeCameraFromMeasurement(measurement);
                    fakeCameraFromMeasurement.setWhiteReference(new SpectralReference.WhiteReference(file));
                    ReferenceHelper.takeReferenceWithQualityDialog(entryMainPanel, fakeCameraFromMeasurement, new ReferenceHelper.TakeReferenceAction(){
                        final /* synthetic */ 5 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @Override
                        public ReferenceStatus take() {
                            return ReferenceHelper.qualityCheckWhiteReference(this.this$0.getProgressManager(), file, fakeCameraFromMeasurement.getIntegrationTime(), fakeCameraFromMeasurement.getMaxsignal());
                        }

                        @Override
                        public void complete() {
                            FileHelper.moveReference(file, new MeasurementFileLocation.WhiteRef().file(measurement));
                        }
                    }, ReferenceStatusCustomPanel.ReferenceStatusDialogType.Import);
                    measurement.clearCache();
                    SpectralPanel.ReflectanceTargetPanel reflectanceTargetPanel = (SpectralPanel.ReflectanceTargetPanel)wizardCustomPanel.getPanel(1);
                    reflectanceTargetPanel.perform(this.getProgressManager(), List.of(measurement));
                    measurement.clearCache();
                }
            }, "Extracting white reference");
        });
    }

    private static FrameCube dataTransform(BreezeProgressManager breezeProgressManager, Measurement measurement, Camera.TransformAlgorithm transformAlgorithm) {
        TcpManager.getInstance().transformData(breezeProgressManager, Collections.singletonList(measurement), transformAlgorithm, !measurement.hasBackup(), "", "");
        return null;
    }

    private static FrameCube dataTransformMaskSpectrum(BreezeProgressManager breezeProgressManager, Measurement measurement, boolean[] blArray) {
        String string = IntStream.range(0, blArray.length).filter(n -> blArray[n]).mapToObj(String::valueOf).collect(Collectors.joining(";"));
        TcpManager.getInstance().transformDataMaskSpectrum(breezeProgressManager, Collections.singletonList(measurement), !measurement.hasBackup(), string);
        return null;
    }

    private static FrameCube dataTransformMaskPixels(BreezeProgressManager breezeProgressManager, Measurement measurement, List<SegmentationNode> list) {
        ApplyChanges.applyChangesOnNeeded(breezeProgressManager, Collections.singletonList(measurement));
        Workflow workflow = measurement.getWorkflow();
        File file = FileHelper.createTempFileInWorkspace("xml");
        PPExportBreezeRuntime.export(BreezeProgressManager.createEmpty(), workflow, workflow.getName(), "", file, new RtPredictionMode(RtPredictionMode.PredictionMode.Rgb), workflow.getSegmentationLevel(), workflow.isParallelMeasurementSegmentation(), workflow.isIncludeChildObjects(), false, null, true, false, null);
        TcpManager.getInstance().transformDataMaskPixels(breezeProgressManager, Collections.singletonList(measurement), !measurement.hasBackup(), file, list);
        return null;
    }

    private static FrameCube dataTransformSmooth(BreezeProgressManager breezeProgressManager, Measurement measurement, int n) {
        TcpManager.getInstance().transformDataSmooth(breezeProgressManager, Collections.singletonList(measurement), !measurement.hasBackup(), n);
        return null;
    }

    private static boolean hasBackup(List<Measurement> list, boolean bl) {
        for (Measurement measurement : list) {
            if (measurement.hasBackup() && (!bl || measurement.isMultiCamera())) continue;
            return false;
        }
        return true;
    }

    private static void addTransformButton(EntryMainPanel entryMainPanel, BreezeContextMenu breezeContextMenu, List<Measurement> list, String string, String string2, String string3, TransformCallback transformCallback, boolean bl, boolean bl2, EntryPopupCallback entryPopupCallback) {
        BreezeFrame breezeFrame = entryMainPanel.getFrame();
        breezeContextMenu.addButtonCloseClick(string, () -> {
            if (string2 != null) {
                if (string2.equals("confirm")) {
                    BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm", "Confirm " + string, null, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(entryMainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                } else if (string2.equals("wavelength")) {
                    Measurement measurement = (Measurement)list.getFirst();
                    boolean[] blArray = measurement.getBandNames().getWaterAbsoptionIndexes();
                    BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Select wavelengths to mask - included wavelengths are removed from the image", "", (AbstractBreezeCustomPanel)new SpectralRoiInputField.SpectralROIInputPanel(measurement.getBandNames(), blArray, measurement.getRootSample()), null, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(entryMainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                } else {
                    BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Option", string2, string3, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(entryMainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                }
            } else {
                MeasurementPopup.transformImagesWithProgress(entryMainPanel, list, string, transformCallback, null, bl, bl2, entryPopupCallback, breezeFrame);
            }
        });
    }

    public static void transformImagesWithProgress(final EntryMainPanel entryMainPanel, final List<Measurement> list, final String string, final TransformCallback transformCallback, final Object object, final boolean bl, final boolean bl2, final EntryPopupCallback entryPopupCallback, BreezeFrame breezeFrame) {
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() {
                MeasurementPopup.transformImages(entryMainPanel, list, this.getProgressManager(), string, transformCallback, object, bl, bl2, entryPopupCallback);
            }
        }, string + " image(s)");
    }

    private static void transformImages(EntryMainPanel entryMainPanel, List<Measurement> list, BreezeProgressManager breezeProgressManager, String string, TransformCallback transformCallback, Object object, boolean bl, boolean bl2, EntryPopupCallback entryPopupCallback) {
        int n = breezeProgressManager.setGroupMaximumAndReset(list.size());
        breezeProgressManager.setInfoText(string + " image(s)");
        for (Measurement measurement : list) {
            if (breezeProgressManager.isAborted()) break;
            int n2 = measurement.rawFileThrowIfNotExists().header().pixelWidth().value;
            Double d = measurement.getMetaProperties().getMetaNumberNullIfMissing("FieldOfView");
            MeasurementPopup.transformAndSave(transformCallback, breezeProgressManager, measurement, measurement.rawFile(), object);
            if (bl && measurement.hasReferences()) {
                SpectralReference.WhiteReference whiteReference = measurement.whiteReference();
                if (!whiteReference.isEmpty()) {
                    MeasurementPopup.transformAndSave(transformCallback, breezeProgressManager, measurement, whiteReference, object);
                }
                MeasurementPopup.transformAndSave(transformCallback, breezeProgressManager, measurement, measurement.darkReference(), object);
            }
            ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(measurement);
            measurement.clearCache();
            PixelDataHelper.clearSpectralMatrixCache();
            DataSetCache.clearParents(measurement);
            measurement.deleteResultFiles();
            if (bl2) {
                measurement.reload(true);
            } else {
                RawCropHelper.updateMetaProperties(measurement, n2, d, measurement.rawFile().header());
                measurement.save();
            }
            breezeProgressManager.incStepGroup(n);
        }
        ApplyChanges.applyChanges(breezeProgressManager, list, true);
        entryMainPanel.getEntryList().repaint();
        entryPopupCallback.onFinished("Update Image");
        entryMainPanel.setDirty(true);
    }

    private static void transformAndSave(TransformCallback transformCallback, BreezeProgressManager breezeProgressManager, Measurement measurement, RawFile rawFile, Object object) {
        FrameCube frameCube = transformCallback.onAction(breezeProgressManager, measurement, rawFile, object);
        if (frameCube != null) {
            frameCube.save(rawFile.file());
        }
    }

    private static int getTotalSamples(List<Measurement> list) {
        int n = 0;
        for (Measurement measurement : list) {
            n += measurement.getSamplesForCurrentLevel().size();
        }
        return n;
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$37(BreezeFrame breezeFrame, EntryMainPanel entryMainPanel, Measurement measurement) {
        BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION, "Spectral Viewer", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new AverageSpectrumViewPanel(entryMainPanel, measurement, ""), measurement.getWorkflow(), 0.95), null, null);
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$34(List list, PreviewPanel previewPanel, BreezeContextMenu breezeContextMenu) {
        if (!list.isEmpty()) {
            breezeContextMenu.addButtonCloseClick("To selected sample(s)", () -> {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                int n4 = 0;
                for (Sample sample : list) {
                    Rectangle rectangle = sample.getSamplePath().getOrCreateGeneralPath().getBounds();
                    n = Math.min(n, rectangle.x);
                    n2 = Math.min(n2, rectangle.y);
                    n3 = Math.max(n3, rectangle.x + rectangle.width);
                    n4 = Math.max(n4, rectangle.y + rectangle.height);
                }
                previewPanel.zoomTo(new Rectangle(n, n2, n3 - n, n4 - n2));
            });
        }
        breezeContextMenu.addButtonCloseClick("All", previewPanel::zoomAll);
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$33(BreezeFrame breezeFrame, EntryMainPanel entryMainPanel, Measurement measurement) {
        MeasurementPopup.extractWhiteReference(breezeFrame, entryMainPanel, measurement);
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$31(final List list, BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, final Measurement measurement) {
        final int n = MeasurementPopup.getTotalSamples(list);
        BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Crop samples into measurements", "", (AbstractBreezeCustomPanel)new CropSamplesPanel(list.size(), n), null, breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() {
                CropSamplesPanel cropSamplesPanel = (CropSamplesPanel)breezeActionEvent.getBreezeCustomPanel();
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                int n2 = breezeProgressManager.setGroupMaximumAndReset(n);
                ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
                for (Measurement measurement3 : list) {
                    RawHeader rawHeader = measurement3.rawFileThrowIfNotExists().header();
                    breezeProgressManager.setInfoText("Cropping " + measurement3.getName() + " into samples");
                    Group group = measurement3.getParent();
                    for (Sample sample : measurement3.getSamplesForCurrentLevel()) {
                        Rectangle rectangle = cropSamplesPanel.updateBounds(sample.getSamplePath().getOrCreateGeneralPath().getBounds(), rawHeader);
                        Measurement measurement2 = RawCropHelper.createMeasurementUniqueName(measurement3, group.getChildList(), measurement3.getName() + "_" + sample.getRecursiveName(Sample.DefaultSampleLabel.SAMPLE_ONLY).replace(':', '_'));
                        RawCropHelper.cropImage(breezeProgressManager, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, measurement3, measurement2);
                        arrayList.add(measurement2);
                        entryMainPanel.getEntryList().insertElement(measurement2);
                        breezeProgressManager.incStepGroup(n2);
                    }
                    if (!cropSamplesPanel.isDeleteMeasurement()) continue;
                    measurement3.delete(true);
                    entryMainPanel.getEntryList().removeItem(measurement3);
                }
                ApplyChanges.applyChanges(breezeProgressManager, arrayList, true);
                entryMainPanel.selectEntry(measurement);
                entryMainPanel.setDirty(true);
            }
        }, "Cropping samples into measurements"));
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$30(BreezeFrame breezeFrame, EntryMainPanel entryMainPanel, EntryPopupCallback entryPopupCallback, Measurement measurement) {
        MeasurementPopup.cropImage(breezeFrame, entryMainPanel, entryPopupCallback, measurement);
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$10(EntryMainPanel entryMainPanel, List list, EntryPopupCallback entryPopupCallback, Measurement measurement2, BreezeContextMenu breezeContextMenu3) {
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Spectral binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpectral(rawFile, RtDataFormat.toNumberInt(object.toString())), true, false, entryPopupCallback);
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Pixel binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpatialPixels(rawFile, RtDataFormat.toNumberInt(object.toString())), true, false, entryPopupCallback);
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Frames binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpatialFrames(rawFile, RtDataFormat.toNumberInt(object.toString())), false, false, entryPopupCallback);
        breezeContextMenu3.addSeparator();
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Mirror horizontal", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.mirrorHorizontal(rawFile), true, false, entryPopupCallback);
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Mirror vertical", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.mirrorVertical(rawFile), false, false, entryPopupCallback);
        breezeContextMenu3.addSeparator();
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Rotate left", null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransform(breezeProgressManager, measurement, Camera.TransformAlgorithm.RotateLeft), false, true, entryPopupCallback);
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Rotate right", null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransform(breezeProgressManager, measurement, Camera.TransformAlgorithm.RotateRight), false, true, entryPopupCallback);
        breezeContextMenu3.addSeparator();
        MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Pseudo reflectance", "confirm", null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.pseudoReflectance(breezeProgressManager, measurement), false, false, entryPopupCallback);
        breezeContextMenu3.addSubMenu("Mask", breezeContextMenu2 -> {
            MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu2, list, "Water absorption wavelengths", "wavelength", null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransformMaskSpectrum(breezeProgressManager, measurement, (boolean[])object), true, true, entryPopupCallback);
            ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
            SegmentationNode.addSegmentationsRecursive(arrayList, measurement2.getWorkflow().getRoot());
            breezeContextMenu2.addSubMenu("Segmentation pixels", breezeContextMenu -> {
                for (SegmentationNode segmentationNode : arrayList) {
                    MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu, list, segmentationNode.getAliasOrNodeString(), null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransformMaskPixels(breezeProgressManager, measurement, List.of(segmentationNode)), false, true, entryPopupCallback);
                }
            });
        });
        if (BreezeFrame.isSmoothFeature()) {
            breezeContextMenu3.addSubMenu("Smooth", breezeContextMenu -> {
                MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu, list, "Low - 5 px", null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransformSmooth(breezeProgressManager, measurement, 5), false, true, entryPopupCallback);
                MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu, list, "Medium - 10 px", null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransformSmooth(breezeProgressManager, measurement, 10), false, true, entryPopupCallback);
                MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu, list, "High - 15 px", null, null, (breezeProgressManager, measurement, rawFile, object) -> MeasurementPopup.dataTransformSmooth(breezeProgressManager, measurement, 15), false, true, entryPopupCallback);
            });
        }
        if (MeasurementPopup.hasBackup(list, false)) {
            breezeContextMenu3.addSeparator();
            MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Revert from backup", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.revertBackup(breezeProgressManager, measurement, rawFile), false, true, entryPopupCallback);
            MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Delete backup", "confirm", null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.deleteBackup(measurement), false, true, entryPopupCallback);
            if (MeasurementPopup.hasBackup(list, true)) {
                breezeContextMenu3.addSeparator();
                MeasurementPopup.addTransformButton(entryMainPanel, breezeContextMenu3, list, "Realign dual camera", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.realginBackup(breezeProgressManager, measurement, rawFile), false, true, entryPopupCallback);
            }
        }
    }

    private static /* synthetic */ void lambda$addMeasurementsPopup$7(Measurement measurement, BreezeFrame breezeFrame, final EntryMainPanel entryMainPanel, final List list, final EntryPopupCallback entryPopupCallback, String string) {
        RawHeader rawHeader = measurement.rawFileThrowIfNotExists().header();
        BreezeOptionDialog.showDialog(breezeFrame, entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Set RGB bands", "", (AbstractBreezeCustomPanel)new RgbBandPanel(rawHeader.rgbBands(), rawHeader.bandNames()), null, breezeActionEvent -> {
            final RgbBands rgbBands = ((RgbBandPanel)breezeActionEvent.getBreezeCustomPanel()).getRgbBands();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

                @Override
                public void runAction() {
                    for (Measurement measurement : list) {
                        ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(measurement);
                        RawHeader rawHeader = measurement.rawFile().header();
                        rawHeader.setRgbBands(rgbBands);
                        rawHeader.save();
                    }
                    ApplyChanges.applyChanges(this.getProgressManager(), list, false, false, true, false);
                    entryPopupCallback.onFinished("Update Image");
                    entryMainPanel.setDirty(true);
                    entryMainPanel.getEntryList().repaint();
                }
            }, "Updating image" + string);
        });
    }

    public static interface EntryPopupCallback {
        public void onFinished(String var1);
    }

    public static interface TransformCallback {
        public FrameCube onAction(BreezeProgressManager var1, Measurement var2, RawFile var3, Object var4);
    }

    public static class MergePanel
    extends AbstractBreezeCustomPanel {
        private final List<Measurement> measurements;
        private final BreezeComboBoxInputField<Camera.MultiCameraMode> methodComboBox = new BreezeComboBoxInputField("Merge method");
        private static Camera.MultiCameraMode lastMultiCameraMode = Camera.MultiCameraMode.ScaleDown;
        private final BreezeInputField nameInputField;
        private final Group group;
        private MultiCameraSettingsPanel multiCameraSettingsPanel;

        public MergePanel(List<Measurement> list) {
            this.measurements = list;
            list.sort((measurement, measurement2) -> {
                String string = measurement.getBandNames().get(0);
                String string2 = measurement2.getBandNames().get(0);
                if (RtDataFormat.isNumber(string) && RtDataFormat.isNumber(string2)) {
                    double d = RtDataFormat.toNumber(string);
                    double d2 = RtDataFormat.toNumber(string2);
                    return Double.compare(d, d2);
                }
                return 0;
            });
            this.group = list.getFirst().getParent();
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(700, 650));
            int n = 0;
            JLabel jLabel = new JLabel("Merge data from two or more images into a new measurement.");
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getFontName(), font.getStyle(), 12));
            BreezeExternalLinkPanel breezeExternalLinkPanel = new BreezeExternalLinkPanel(jLabel, "merging-images");
            this.add((Component)breezeExternalLinkPanel, GridBagHelper.createWithWeigthX1(n++, new Insets(20, 0, 20, 0)));
            String string = "Merged_" + list.stream().map(Measurement::getName).collect(Collectors.joining("_"));
            this.nameInputField = new BreezeInputField("New measurement name", EntryMainHelper.getUniqueName(string, this.group.getChildList()), "");
            this.add((Component)this.nameInputField, GridBagHelper.createWithWeigthX1(n++, new Insets(20, 0, 0, 0)));
            this.methodComboBox.setLabelWidth(110);
            this.add(this.methodComboBox, GridBagHelper.createWithWeigthX1(n++, new Insets(20, 0, 0, 0)));
            this.methodComboBox.addItem(Camera.MultiCameraMode.ScaleUp);
            this.methodComboBox.addItem(Camera.MultiCameraMode.ScaleDown);
            this.methodComboBox.addItem(Camera.MultiCameraMode.Parallel);
            this.methodComboBox.setChangedListener(multiCameraMode -> {
                lastMultiCameraMode = multiCameraMode;
                this.multiCameraSettingsPanel.setMultiCameraMode((Camera.MultiCameraMode)((Object)multiCameraMode));
            });
            this.multiCameraSettingsPanel = new MultiCameraSettingsPanel(BreezeFrame.getInstance(), (Boolean)false);
            this.add((Component)this.multiCameraSettingsPanel, GridBagHelper.createLast(n, new Insets(20, 0, 0, 0)));
            this.methodComboBox.setSelectedItem(lastMultiCameraMode);
        }

        public ImmutablePair<Measurement, TcpManager.CommandErrorException> apply(BreezeProgressManager breezeProgressManager) {
            File file = ApplyChanges.createRuntimeWorkflow(breezeProgressManager, ApplyChanges.createWorkflow(this.measurements, false), this.measurements);
            Camera.MultiCameraMode multiCameraMode = this.methodComboBox.getValue();
            TcpManager.getInstance().merge(breezeProgressManager, file, this.measurements, multiCameraMode.name(), new File(this.group.getFolder(), EntryMainHelper.getUniqueName(this.nameInputField.getValue(), this.group.getChildList())));
            Measurement measurement = this.getMerged(breezeProgressManager, this.group);
            TcpManager.CommandErrorException commandErrorException = null;
            if (measurement != null) {
                if (multiCameraMode.isScale()) {
                    commandErrorException = this.multiCameraSettingsPanel.realignMergedData(breezeProgressManager, measurement);
                }
                ApplyChanges.applyChanges(breezeProgressManager, List.of(measurement), true);
            }
            return ImmutablePair.of((Object)measurement, commandErrorException);
        }

        private Measurement getMerged(BreezeProgressManager breezeProgressManager, Group group) {
            group.syncToExisting(breezeProgressManager);
            int n = group.getChildList().size();
            if (n > 0) {
                return group.getChildList().get(n - 1);
            }
            return null;
        }

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }
    }

    public static class RgbBandPanel
    extends AbstractBreezeCustomPanel {
        private final RgbBandSlider redSlider;
        private final RgbBandSlider greenSlider;
        private final RgbBandSlider blueSlider;

        public RgbBandPanel(RgbBands rgbBands, BandNames bandNames) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(650, 550));
            this.add((Component)new BreezeLabel("Set RGB bands:"), GridBagHelper.createWithWeigthX1(0, new Insets(10, 0, 0, 0)));
            this.redSlider = new RgbBandSlider("Red", Color.red, rgbBands.get(0), bandNames);
            this.add((Component)this.redSlider, GridBagHelper.createWithWeigthX1(1, new Insets(10, 0, 0, 0)));
            this.greenSlider = new RgbBandSlider("Green", Color.green, rgbBands.get(1), bandNames);
            this.add((Component)this.greenSlider, GridBagHelper.createWithWeigthX1(2, new Insets(10, 0, 0, 0)));
            this.blueSlider = new RgbBandSlider("Blue", Color.blue, rgbBands.get(2), bandNames);
            this.add((Component)this.blueSlider, GridBagHelper.createWithWeigthX1(3, new Insets(10, 0, 0, 0)));
        }

        @Override
        public Object getResult() {
            this.redSlider.triggerChange();
            this.greenSlider.triggerChange();
            this.blueSlider.triggerChange();
            return null;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        public RgbBands getRgbBands() {
            return new RgbBands(this.redSlider.getBand(), this.greenSlider.getBand(), this.blueSlider.getBand());
        }

        private static class RgbBandSlider
        extends JPanel {
            private final BreezeInputField bandTextField = new BreezeInputField.Number("Band", "", "");
            private final BreezeLabel wavelengthLabel = new BreezeLabel();
            private final BreezeSlider bandSlider = new BreezeSlider();

            public RgbBandSlider(String string, Color color, int n, BandNames bandNames) {
                super(new GridBagLayout());
                this.setOpaque(false);
                this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()), string, 4, 0, new Font("Tahoma", 0, 14), BreezeTheme.getInstance().getLabelForeground()));
                JPanel jPanel = new JPanel();
                jPanel.setPreferredSize(new Dimension(20, 20));
                jPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForeground()));
                jPanel.setBackground(color);
                GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(5, 5, 0, 0));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                this.add((Component)jPanel, gridBagConstraints);
                this.bandTextField.setFormat(BreezeInputFieldHelper.Format.OneRow);
                this.bandTextField.setPreferredSize(new Dimension(150, 30));
                this.bandTextField.setValue(n);
                if (bandNames != null) {
                    this.bandTextField.addValidator(new NumericMinMaxValidator(0.0, bandNames.size() - 1));
                    this.bandTextField.addChangeListener(textActionEvent -> this.bandSlider.setValue(textActionEvent.getValueInt()));
                }
                GridBagConstraints gridBagConstraints2 = GridBagHelper.create(0, new Insets(0, 10, 0, 0));
                gridBagConstraints2.gridx = 1;
                if (bandNames != null) {
                    gridBagConstraints2.fill = 0;
                } else {
                    gridBagConstraints2.fill = 2;
                    gridBagConstraints2.weightx = 1.0;
                }
                gridBagConstraints2.anchor = 18;
                this.add((Component)this.bandTextField, gridBagConstraints2);
                if (bandNames != null) {
                    this.wavelengthLabel.setPreferredSize(new Dimension(80, 30));
                    this.wavelengthLabel.setText(" " + bandNames.getFormated(n));
                    this.wavelengthLabel.setBorder(BorderFactory.createDashedBorder(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse()));
                    GridBagConstraints gridBagConstraints3 = GridBagHelper.create(0, new Insets(0, 0, 0, 10));
                    gridBagConstraints3.gridx = 2;
                    gridBagConstraints3.fill = 0;
                    gridBagConstraints3.anchor = 12;
                    this.add((Component)this.wavelengthLabel, gridBagConstraints3);
                    this.bandSlider.setFocusable(false);
                    Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                    int n2 = (int)Math.ceil((double)bandNames.size() / 5.0);
                    for (int i = 0; i < bandNames.size(); i += n2) {
                        JLabel jLabel = new JLabel(bandNames.getFormated(i));
                        jLabel.setFont(new Font("Tahoma", 0, 12));
                        jLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
                        hashtable.put(i, jLabel);
                    }
                    this.bandSlider.setOpaque(false);
                    this.bandSlider.setLabelTable(hashtable);
                    this.bandSlider.setPaintLabels(true);
                    this.bandSlider.setMaximum(bandNames.size() - 1);
                    this.bandSlider.setMinorTickSpacing(1);
                    this.bandSlider.setMajorTickSpacing(n2);
                    this.bandSlider.setValue(n);
                    this.bandSlider.addChangeListener(changeEvent -> {
                        this.bandTextField.getTextField().setFormatedNumber(this.bandSlider.getValue());
                        this.wavelengthLabel.setText(" " + bandNames.getFormated(this.bandSlider.getValue()));
                    });
                    this.bandSlider.setPreferredSize(new Dimension(0, 30));
                    GridBagConstraints gridBagConstraints4 = GridBagHelper.createWithWeigthX1(1, new Insets(10, 0, 10, 0));
                    gridBagConstraints4.gridwidth = 0;
                    this.add((Component)this.bandSlider, gridBagConstraints4);
                }
            }

            public void triggerChange() {
                this.bandTextField.triggerChange(true);
            }

            public int getBand() {
                return this.bandTextField.getValueInt();
            }
        }
    }
}

