/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.FrameListForBand;
import se.prediktera.breeze.common.util.raw.PredictionDataCache;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;

public class PredictionValues {
    private FrameListForBand predictions;
    private int factorLayer;
    private Factor factor;
    private final Measurement measurement;
    private final BandNames bandNames;

    public PredictionValues(Measurement measurement) {
        this.measurement = measurement;
        this.bandNames = new RawHeader(measurement.getPredictionHdrFile()).bandNames();
    }

    public void setLayer(DescriptorTreeNode descriptorTreeNode, AdditionalFactor additionalFactor) {
        this.factor = PredictionValues.getFactor(descriptorTreeNode, additionalFactor);
        if (this.factor != null) {
            this.factorLayer = ThumbnailImage.getBandLayer(this.bandNames, descriptorTreeNode.getAnalyse(), this.factor);
        }
        this.predictions = PredictionDataCache.getPredictionDataLayer(this.measurement, this.factorLayer);
    }

    public void setBandLayer(DescriptorTreeNode descriptorTreeNode, AdditionalFactor additionalFactor) {
        this.factor = PredictionValues.getFactor(descriptorTreeNode, additionalFactor);
        if (this.factor instanceof MwlDescriptor.PropertyFactorMwl) {
            this.factorLayer = ThumbnailImage.getBandLayer(this.bandNames, descriptorTreeNode.getAnalyse(), ((MwlDescriptor.PropertyFactorMwl)this.factor).getBandFactor());
        }
        this.predictions = PredictionDataCache.getPredictionDataLayer(this.measurement, this.factorLayer);
    }

    public float getValue(int n, int n2) {
        if (n2 >= 0 && n2 < this.predictions.size()) {
            float[] fArray = this.predictions.getFrame(n2);
            if (n >= 0 && n < fArray.length) {
                return fArray[n];
            }
        }
        return 0.0f;
    }

    public String formatValue(int n, int n2) {
        float f = this.getValue(n, n2);
        if (this.factor instanceof CategoryFactor) {
            int n3 = (int)f;
            CatClass catClass = ((CategoryFactor)this.factor).getClassByValueIdx(n3);
            if (catClass != null) {
                return catClass.getName();
            }
            return "";
        }
        return RtDataFormat.toString(f, 8);
    }

    private static Factor getFactor(DescriptorTreeNode descriptorTreeNode, AdditionalFactor additionalFactor) {
        BasicAnalyse basicAnalyse;
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        if (abstractBreezeFunction instanceof ThumbnailDescriptor && (basicAnalyse = descriptorTreeNode.getAnalyse()) != null) {
            if (additionalFactor != null) {
                return additionalFactor.getFactor();
            }
            if (basicAnalyse.getModelMethod().isClassification() && descriptorTreeNode.getIndex() == 0) {
                return basicAnalyse.getCategoryFactors().getByUid(descriptorTreeNode.getFactorUid());
            }
            return basicAnalyse.getPropertyFactors().getByUid(descriptorTreeNode.getFactorUid());
        }
        return null;
    }
}

