/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import se.prediktera.breeze.entry.sample.Sample;

public class PreviewHelper {
    public static Shape convertShapeToGlobal(Shape shape, Function<Point, Point> function) {
        Rectangle rectangle = shape.getBounds();
        if (rectangle.width == 1 && rectangle.height == 1) {
            Point point = function.apply(PreviewHelper.createPoint(rectangle.x, rectangle.y));
            return new Rectangle(point.x, point.y, 1, 1);
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        Path2D.Double double_ = new Path2D.Double();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    Point point = function.apply(PreviewHelper.createPoint(dArray[0], dArray[1]));
                    double_.moveTo(point.x, point.y);
                    break;
                }
                case 1: {
                    Point point = function.apply(PreviewHelper.createPoint(dArray[0], dArray[1]));
                    double_.lineTo(point.x, point.y);
                    break;
                }
                case 2: {
                    Point point = function.apply(PreviewHelper.createPoint(dArray[0], dArray[1]));
                    Point point2 = function.apply(PreviewHelper.createPoint(dArray[2], dArray[3]));
                    double_.quadTo(point.x, point.y, point2.x, point2.y);
                    break;
                }
                case 3: {
                    Point point = function.apply(PreviewHelper.createPoint(dArray[0], dArray[1]));
                    Point point2 = function.apply(PreviewHelper.createPoint(dArray[2], dArray[3]));
                    Point point3 = function.apply(PreviewHelper.createPoint(dArray[4], dArray[5]));
                    double_.curveTo(point.x, point.y, point2.x, point2.y, point3.x, point3.y);
                    break;
                }
                case 4: {
                    double_.closePath();
                }
            }
            pathIterator.next();
        }
        return double_;
    }

    public static double computeArea(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null, 0.5);
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d = d3 = dArray[0];
                    d2 = d4 = dArray[1];
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    d5 += d3 * d7 - d6 * d4;
                    d3 = d6;
                    d4 = d7;
                    break;
                }
                case 4: {
                    d5 += d3 * d2 - d * d4;
                    d3 = d;
                    d4 = d2;
                }
            }
            pathIterator.next();
        }
        return Math.abs(d5) / 2.0;
    }

    private static Point createPoint(double d, double d2) {
        return new Point((int)Math.round(d), (int)Math.round(d2));
    }

    public static List<int[][]> getShapeBorderPointsArray(Shape shape) {
        ArrayList<int[][]> arrayList = new ArrayList<int[][]>();
        for (Shape shape2 : PreviewHelper.decomposeShape(shape)) {
            List<Point> list = PreviewHelper.getShapeBorderPoints(shape2);
            int[][] nArray = new int[list.size()][2];
            for (int i = 0; i < list.size(); ++i) {
                Point point = list.get(i);
                nArray[i][0] = point.x;
                nArray[i][1] = point.y;
            }
            arrayList.add(nArray);
        }
        return arrayList;
    }

    public static List<Point> getShapeBorderPoints(Shape shape) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        PathIterator pathIterator = shape.getPathIterator(null, 0.5);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            Point point = new Point((int)Math.round(dArray[0]), (int)Math.round(dArray[1]));
            if (n == 0 || n == 1) {
                arrayList.add(point);
            }
            pathIterator.next();
        }
        return arrayList;
    }

    public static Shape clipToSamples(List<Sample> list, Shape shape) {
        if (shape == null || list == null || list.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (Sample sample : list) {
            area.add(new Area(sample.getOrCreateGeneralPath()));
        }
        Area area2 = new Area(shape);
        area2.intersect(area);
        return area2;
    }

    public static List<Shape> decomposeShape(Shape shape) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        PathIterator pathIterator = shape.getPathIterator(null);
        Path2D path2D = null;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    if (path2D != null) {
                        arrayList.add(new Area(path2D));
                    }
                    path2D = new GeneralPath();
                    ((Path2D.Float)path2D).moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    if (path2D == null) break;
                    ((Path2D.Float)path2D).lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (path2D == null) break;
                    ((Path2D.Float)path2D).quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (path2D == null) break;
                    ((Path2D.Float)path2D).curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (path2D == null) break;
                    path2D.closePath();
                }
            }
            pathIterator.next();
        }
        if (path2D != null) {
            arrayList.add(new Area(path2D));
        }
        return arrayList;
    }
}

