/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.PredictionValues;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class PreviewValuePanel
extends JPanel {
    private static int nw = 40;
    private static int vo = 20;
    private static int vw = 100;
    private static int h = 16;
    private static int fs = 12;
    private final BreezeLabelField xyValue = new BreezeLabelField("X,Y", nw, vo, "", vw, h, fs);
    private final BreezeLabelField sampleValue = new BreezeLabelField("Sample", nw, vo, "", vw, h, fs);
    private final BreezeLabelField valueValue = new BreezeLabelField("Value", nw, vo, "", vw, h, fs);
    private final BreezeLabelField nameValue = new BreezeLabelField("", nw, vo, "", vw, h, fs);
    private boolean vertcial;

    public PreviewValuePanel() {
        super(new GridBagLayout());
        this.update(true);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PreviewValuePanel.this.setAllVisible();
                if (!PreviewValuePanel.this.vertcial) {
                    int n = PreviewValuePanel.this.getWidth();
                    if (n < 200) {
                        PreviewValuePanel.this.sampleValue.setVisible(false);
                    }
                    if (n < 400) {
                        PreviewValuePanel.this.valueValue.setVisible(false);
                    }
                    if (n < 600) {
                        PreviewValuePanel.this.nameValue.setVisible(false);
                    }
                }
            }
        });
    }

    public void update(boolean bl) {
        this.vertcial = bl;
        if (bl) {
            this.setPreferredSize(new Dimension(20, 85));
            this.setMinimumSize(new Dimension(20, 85));
            this.setLabelWidth(40);
            this.add((Component)this.xyValue, GridBagHelper.create(0, new Insets(4, 5, 0, 2)));
            this.add((Component)this.sampleValue, GridBagHelper.create(1, new Insets(4, 5, 0, 2)));
            this.add((Component)this.valueValue, GridBagHelper.create(2, new Insets(4, 5, 0, 2)));
            this.add((Component)this.nameValue, GridBagHelper.createLast(3, new Insets(4, 5, 4, 2)));
        } else {
            this.setPreferredSize(new Dimension(85, 18));
            this.setMinimumSize(new Dimension(85, 18));
            this.setLabelWidth(0);
            this.add((Component)this.xyValue, GridBagHelper.create(0, new Insets(2, 2, 0, 2), true));
            this.add((Component)this.sampleValue, GridBagHelper.create(1, new Insets(2, 2, 0, 2), true));
            this.add((Component)this.valueValue, GridBagHelper.create(2, new Insets(2, 2, 0, 2), true));
            this.add((Component)this.nameValue, GridBagHelper.create(3, new Insets(2, 2, 0, 2), true));
        }
    }

    public void setLabelWidth(int n) {
        for (BreezeLabelField breezeLabelField : new BreezeLabelField[]{this.xyValue, this.sampleValue, this.valueValue, this.nameValue}) {
            breezeLabelField.setLabelWidth(n);
        }
    }

    public void setAllVisible() {
        for (BreezeLabelField breezeLabelField : new BreezeLabelField[]{this.xyValue, this.sampleValue, this.valueValue, this.nameValue}) {
            breezeLabelField.setVisible(true);
        }
    }

    public void setValue(Measurement measurement, Point point, Sample sample, Object object) {
        this.xyValue.setValue(point.x + 1 + ", " + (point.y + 1));
        this.nameValue.setValue("");
        if (object instanceof ThumbnailComboBox.ThumbnailWithDescriptor) {
            ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor = (ThumbnailComboBox.ThumbnailWithDescriptor)object;
            this.sampleValue.setValue(this.getName(sample));
            if (sample != null && thumbnailWithDescriptor.isObject()) {
                Factor factor = thumbnailWithDescriptor.getNode().getFactor();
                float f = sample.getDescriptorValue(thumbnailWithDescriptor.getNode());
                if (factor instanceof CategoryFactor) {
                    CatClass catClass = ((CategoryFactor)factor).getClassByValueIdx((int)f);
                    if (catClass != null) {
                        this.valueValue.setValue(catClass.getName());
                    } else {
                        this.valueValue.setValue("");
                    }
                } else {
                    this.valueValue.setValue(RtDataFormat.toString(f, 8));
                }
            } else if (measurement != null) {
                PredictionValues predictionValues = new PredictionValues(measurement);
                if (thumbnailWithDescriptor.getNode().getFunction() instanceof MwlDescriptor) {
                    predictionValues.setBandLayer(thumbnailWithDescriptor.getNode(), thumbnailWithDescriptor.getAdditionalFactor());
                    float f = predictionValues.getValue(point.x, point.y);
                    if (f >= 0.0f) {
                        this.nameValue.setValue(f);
                    } else {
                        this.nameValue.setValue("N/A");
                    }
                }
                predictionValues.setLayer(thumbnailWithDescriptor.getNode(), thumbnailWithDescriptor.getAdditionalFactor());
                this.valueValue.setValue(predictionValues.formatValue(point.x, point.y));
            } else {
                this.valueValue.setValue("");
            }
        } else if (object instanceof Factor) {
            this.sampleValue.setValue(this.getName(sample));
            this.valueValue.setValue(((Factor)object).getStringValue(sample));
        } else if (object instanceof BasicPreviewPanel.TooltipCustomValue) {
            BasicPreviewPanel.TooltipCustomValue tooltipCustomValue = (BasicPreviewPanel.TooltipCustomValue)object;
            this.xyValue.setValue((int)((double)point.x * tooltipCustomValue.getScaleX() + 1.0) + ", " + RtDataFormat.toString((double)point.y * tooltipCustomValue.getScaleY() + 1.0));
            this.sampleValue.setValue(tooltipCustomValue.getSample(point.x, point.y));
            this.valueValue.setValue(tooltipCustomValue.getValue(point.x, point.y));
        } else {
            this.sampleValue.setValue(this.getName(sample));
            this.valueValue.setValue("");
        }
    }

    private String getName(Sample sample) {
        if (sample == null) {
            return "";
        }
        if (sample instanceof AveragePlotPanel.SampleArea) {
            AveragePlotPanel.SampleArea sampleArea = (AveragePlotPanel.SampleArea)sample;
            return sampleArea.getName();
        }
        return sample.getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE);
    }
}

