/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import lombok.Generated;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.ConstrainedSpectralUnmixerDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.SaturationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.SegmentationLabelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.SpectralAngleMapperDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.function.FunctionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.function.RgbDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.function.TernaryRgbDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.function.VegetationIndexDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.ClusterClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PcaQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.TrainTestDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.AxisPercentageDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.DataSlicingDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.ExpressionClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.ExpressionUpdateClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthDescriptor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailClassification;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailPackedRgb;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;

public class ThumbnailComboBox {
    private final BreezeComboBox thumbnailComboBox = new BreezeComboBox();
    private Workflow workflow;
    private int changeIndex;
    private int segmentationLevel;
    private String segmentationHashId;
    private boolean triggerChangedIndex = true;

    public void populateThumbnailComboBox(Workflow workflow) {
        if (this.workflowChanged(workflow)) {
            List<DescriptorTreeNode> list2;
            this.workflow = workflow;
            this.segmentationLevel = workflow.getSegmentationLevel();
            this.segmentationHashId = workflow.getSegmentationHashId();
            this.changeIndex = workflow.getChangeIndex();
            this.thumbnailComboBox.removeAllItems();
            this.thumbnailComboBox.addItem("Original");
            PropertyList propertyList = workflow.getPropertyFactors();
            if (!propertyList.isEmpty()) {
                this.thumbnailComboBox.addSeparator();
            }
            for (List<DescriptorTreeNode> list2 : propertyList) {
                this.thumbnailComboBox.addItem(list2);
            }
            CategoryList categoryList = workflow.getCategoryFactors();
            if (!categoryList.isEmpty()) {
                this.thumbnailComboBox.addSeparator();
            }
            list2 = categoryList.iterator();
            while (list2.hasNext()) {
                CategoryFactor categoryFactor = (CategoryFactor)list2.next();
                this.thumbnailComboBox.addItem(categoryFactor);
            }
            list2 = this.getDescriptorWithThumbnails();
            if (!list2.isEmpty()) {
                this.thumbnailComboBox.addSeparator();
            }
            for (DescriptorTreeNode descriptorTreeNode : list2) {
                Object object;
                Object object2;
                Object object3;
                AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
                if (abstractBreezeFunction instanceof AbstractModelDescriptor) {
                    object3 = (AbstractModelDescriptor)abstractBreezeFunction;
                    if (object3 instanceof PlsPredClassificationDescriptor || object3 instanceof PlsPredDescriptor) {
                        if (((AbstractModelDescriptor)object3).isCalculatePixel()) {
                            this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                        }
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                    } else if (((AbstractModelDescriptor)object3).isCalculatePixel()) {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Normal));
                    }
                } else if (abstractBreezeFunction instanceof UsgsDescriptor) {
                    object2 = (UsgsDescriptor)abstractBreezeFunction;
                    if (descriptorTreeNode.getIndex() == 0) {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                        if (((UsgsDescriptor)object2).hasResult(0)) {
                            this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                        }
                    } else {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Normal));
                    }
                } else if (abstractBreezeFunction instanceof SpectralAngleMapperDescriptor || abstractBreezeFunction instanceof SaturationDescriptor || abstractBreezeFunction instanceof DataSlicingDescriptor) {
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                } else if (abstractBreezeFunction instanceof MwlDescriptor) {
                    object = (MwlDescriptor)abstractBreezeFunction;
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                    if (((MwlDescriptor)object).hasResult(0)) {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                    }
                } else if (abstractBreezeFunction instanceof PcaQuantificationDescriptor || abstractBreezeFunction instanceof ClusterClassificationDescriptor || abstractBreezeFunction instanceof RgbDescriptor || abstractBreezeFunction instanceof TernaryRgbDescriptor) {
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                } else if (abstractBreezeFunction instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor.ObjectOrPixelsParameter)abstractBreezeFunction.getParameterByName("type")).isObject()) {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Normal));
                    } else {
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                        this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                    }
                } else if (abstractBreezeFunction instanceof ConstrainedSpectralUnmixerDescriptor) {
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel));
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Object));
                } else if (abstractBreezeFunction.hasThumbnail(descriptorTreeNode.getIndex()) || ThumbnailComboBox.isDescriptorObject(abstractBreezeFunction)) {
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Normal));
                }
                if ((object3 = abstractBreezeFunction.getAdditionalFactors()) == null) continue;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (AdditionalFactor)object2.next();
                    this.thumbnailComboBox.addItem(new ThumbnailWithDescriptor(descriptorTreeNode, ThumbType.Pixel, (AdditionalFactor)object));
                }
            }
            this.thumbnailComboBox.setEnabled(this.thumbnailComboBox.getItemCount() > 1);
        }
    }

    private boolean workflowChanged(Workflow workflow) {
        return this.workflow != workflow || this.segmentationLevel != workflow.getSegmentationLevel() || !Objects.equals(this.segmentationHashId, workflow.getSegmentationHashId()) || this.triggerChangedIndex && this.changeIndex != workflow.getChangeIndex();
    }

    public void changeThumbnail(Sample sample, Object object) {
        this.thumbnailComboBox.setSelectedIndex(this.getIndexOf(sample, object));
    }

    public int getIndexOf(Sample sample, Object object) {
        for (int i = 0; i < this.thumbnailComboBox.getItemCount(); ++i) {
            if (!this.equals(object, sample, this.thumbnailComboBox.getItemAt(i))) continue;
            return i;
        }
        return 0;
    }

    public int getTableColumn(BreezeTable breezeTable) {
        int n = breezeTable.getSelectedRow();
        Sample sample = BreezeTableCellRenderer.getSampleAt((JTable)((Object)breezeTable), n);
        int n2 = this.getSelectedIndex();
        if (n2 == 0) {
            return 2;
        }
        for (int i = 0; i < breezeTable.getColumnCount(); ++i) {
            if (n2 != this.getIndexOf(sample, breezeTable.getValueAt(n, i))) continue;
            return i;
        }
        return -1;
    }

    private boolean equals(Object object, Sample sample, Object object2) {
        if (object2 instanceof ThumbnailWithDescriptor) {
            ThumbnailWithDescriptor thumbnailWithDescriptor = (ThumbnailWithDescriptor)object2;
            if (object instanceof Thumbnail) {
                Thumbnail thumbnail = (Thumbnail)((Object)object);
                if (thumbnail instanceof ThumbnailProperty) {
                    FunctionResult functionResult;
                    DescriptorTreeNode descriptorTreeNode = thumbnailWithDescriptor.getNode().getHierarchyNode(sample, false);
                    if (descriptorTreeNode != null && (functionResult = sample.getFunctionResult(descriptorTreeNode.getUid())) != null) {
                        return functionResult.equalTo(descriptorTreeNode) && thumbnailWithDescriptor.isPixel();
                    }
                } else {
                    if (thumbnail instanceof ThumbnailClassification) {
                        ThumbnailClassification thumbnailClassification = (ThumbnailClassification)thumbnail;
                        return thumbnailClassification.equalTo(thumbnailWithDescriptor);
                    }
                    if (thumbnail instanceof ThumbnailPackedRgb) {
                        ThumbnailPackedRgb thumbnailPackedRgb = (ThumbnailPackedRgb)thumbnail;
                        return thumbnailPackedRgb.equalTo(thumbnailWithDescriptor);
                    }
                }
                return thumbnail.equalTo(thumbnailWithDescriptor);
            }
            if (object instanceof FunctionResult) {
                FunctionResult functionResult = (FunctionResult)object;
                return functionResult.equalTo(thumbnailWithDescriptor.getNode()) && !thumbnailWithDescriptor.isPixel();
            }
        }
        if (object2 instanceof Factor) {
            return object2.equals(object);
        }
        return false;
    }

    public BreezeComboBox getComboBox() {
        return this.thumbnailComboBox;
    }

    public void addItemListener(ItemListener itemListener) {
        this.thumbnailComboBox.addItemListener(itemListener);
    }

    public Object getSelectedItem() {
        return this.thumbnailComboBox.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.thumbnailComboBox.getSelectedIndex();
    }

    public boolean setSelectedValue(String string) {
        for (int i = 0; i < this.thumbnailComboBox.getItemCount(); ++i) {
            if (!this.thumbnailComboBox.getItemAt(i).toString().equals(string)) continue;
            this.thumbnailComboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private List<DescriptorTreeNode> getDescriptorWithThumbnails() {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        for (DescriptorTreeNode descriptorTreeNode : this.workflow.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(this.segmentationLevel, this.segmentationHashId), true)) {
            if (!MeasurementTableModel.showInTable(descriptorTreeNode, MeasurementTableModel.TableSource.Table) || !descriptorTreeNode.getFunction().isDescriptor() || descriptorTreeNode.isHieararchyConnectionDescriptor()) continue;
            arrayList.add(descriptorTreeNode);
        }
        return arrayList;
    }

    private static boolean isDescriptorObject(AbstractBreezeFunction abstractBreezeFunction) {
        if (abstractBreezeFunction instanceof ExpressionClassificationDescriptor || abstractBreezeFunction instanceof ExpressionUpdateClassificationDescriptor || abstractBreezeFunction instanceof TrainTestDescriptor) {
            return true;
        }
        return abstractBreezeFunction instanceof FunctionDescriptor || abstractBreezeFunction instanceof SpatialDescriptor || abstractBreezeFunction instanceof SegmentationLabelDescriptor || abstractBreezeFunction instanceof DepthDescriptor || abstractBreezeFunction instanceof AxisPercentageDescriptor;
    }

    @Generated
    public void setTriggerChangedIndex(boolean bl) {
        this.triggerChangedIndex = bl;
    }

    public static class ThumbnailWithDescriptor {
        private final DescriptorTreeNode descriptor;
        private final ThumbType type;
        private MinMax minMax;
        private final AdditionalFactor additionalFactor;

        public ThumbnailWithDescriptor(DescriptorTreeNode descriptorTreeNode, ThumbType thumbType) {
            this(descriptorTreeNode, thumbType, null);
        }

        public ThumbnailWithDescriptor(DescriptorTreeNode descriptorTreeNode, ThumbType thumbType, AdditionalFactor additionalFactor) {
            this.descriptor = descriptorTreeNode;
            this.type = thumbType;
            this.additionalFactor = additionalFactor;
        }

        public DescriptorTreeNode getNode() {
            return this.descriptor;
        }

        public String getId() {
            return this.descriptor.getUid();
        }

        public boolean isPixel() {
            return this.type.equals((Object)ThumbType.Pixel);
        }

        public boolean isObject() {
            if (this.type.equals((Object)ThumbType.Pixel)) {
                return false;
            }
            if (ThumbnailComboBox.isDescriptorObject(this.descriptor.getFunction())) {
                // empty if block
            }
            return true;
        }

        public String toString() {
            String string;
            String string2 = string = this.additionalFactor != null ? this.additionalFactor.getName() : this.descriptor.getAliasOrNodeString(FunctionTreeNode.TextType.Table);
            if (!this.type.equals((Object)ThumbType.Normal)) {
                return string + " (" + String.valueOf((Object)this.type) + ")";
            }
            return string;
        }

        public String getLegendTitle(DescriptorTreeNode descriptorTreeNode) {
            if (this.additionalFactor != null) {
                return this.additionalFactor.getName();
            }
            String string = this.descriptor.getAlias();
            if (string != null && !string.isEmpty()) {
                return string;
            }
            if (this.descriptor.getFunction() instanceof VegetationIndexDescriptor) {
                return this.descriptor.getAliasOrNodeString();
            }
            Factor factor = descriptorTreeNode.getFactor();
            if (factor != null) {
                return factor.getName();
            }
            return this.getName();
        }

        public String getName() {
            return this.descriptor.getAliasOrNodeString();
        }

        public MinMax getOrCreateMinMax(Workflow workflow) {
            if (this.minMax == null) {
                if (this.getNode().getLegendMin() != null && this.getNode().getLegendMax() != null) {
                    this.minMax = new MinMax(this.getNode().getLegendMin().floatValue(), this.getNode().getLegendMax().floatValue());
                    return this.minMax;
                }
                this.minMax = new MinMax();
                for (Measurement measurement : workflow.getAllMeasurements()) {
                    for (Sample sample : measurement.getSamplesForCurrentLevel()) {
                        FunctionResult functionResult = sample.getFunctionResult(this.descriptor.getUid());
                        if (functionResult == null) continue;
                        this.minMax.add(functionResult.getValue());
                    }
                }
            }
            if (this.getNode().getLegendMin() != null && !Objects.equals(this.getNode().getLegendMin(), this.minMax.min())) {
                this.minMax = new MinMax(this.getNode().getLegendMin().floatValue(), this.minMax.max().floatValue());
            }
            if (this.getNode().getLegendMax() != null && !Objects.equals(this.getNode().getLegendMax(), this.minMax.max())) {
                this.minMax = new MinMax(this.minMax.min().floatValue(), this.getNode().getLegendMax().floatValue());
            }
            return this.minMax;
        }

        public boolean[] getIncluded(Measurement measurement, CategoryFactor categoryFactor) {
            boolean[] blArray = new boolean[categoryFactor.getMaxSize()];
            for (Sample sample : measurement.getSamplesForCurrentLevel()) {
                int n;
                FunctionResult functionResult = sample.getFunctionResult(this.descriptor.getUid());
                if (functionResult == null || (n = (int)functionResult.getValue()) >= blArray.length) continue;
                blArray[n] = true;
            }
            return blArray;
        }

        @Generated
        public ThumbType getType() {
            return this.type;
        }

        @Generated
        public AdditionalFactor getAdditionalFactor() {
            return this.additionalFactor;
        }
    }

    public static enum ThumbType {
        Normal,
        Pixel,
        Object;

    }
}

