/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtCategoryVariable;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class VisualisationToolbar
extends JPanel {
    private final BreezeComboBox comboBox;
    private final JPanel emptyPanel = new JPanel(new BorderLayout());
    private final BreezeToggleButton blendButton;
    private final BreezeToggleButton legendButton;
    public static int insets = 5;

    public VisualisationToolbar(String string, BreezeComboBox breezeComboBox, ToolbarCallback toolbarCallback) {
        super(new GridBagLayout());
        Serializable serializable;
        this.comboBox = breezeComboBox;
        if (string != null) {
            serializable = new BreezeLabel(string);
            serializable.setResourceIcon("material/videocam");
            this.add((Component)serializable, GridBagHelper.create(this.getComponentCount(), new Insets(0, insets, 0, insets), false));
        }
        serializable = GridBagHelper.create(this.getComponentCount(), new Insets(insets, insets, insets, insets), true);
        ((GridBagConstraints)serializable).fill = 2;
        this.add((Component)breezeComboBox, serializable);
        this.emptyPanel.setVisible(false);
        this.add((Component)this.emptyPanel, serializable);
        this.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
        this.blendButton = this.addButton("", "blend", "Blend background", BreezeProperties.getInstance().isBlend(), bl -> {
            toolbarCallback.blend(bl);
            BreezeProperties.getInstance().setBlend(bl);
        }, 100);
        this.legendButton = this.addButton("", "legend", "Legend", false, toolbarCallback::legend, 101);
        breezeComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.triggerChange(toolbarCallback, breezeComboBox.getSelectedItem());
            }
        });
        this.triggerChange(toolbarCallback, breezeComboBox.getSelectedItem());
    }

    public BreezeToggleButton addButton(String string, String string2, String string3, boolean bl, ToggleButtonCallback toggleButtonCallback) {
        return this.addButton(string, string2, string3, bl, toggleButtonCallback, this.getComponentCount());
    }

    public BreezeToggleButton addButton(String string, String string2, String string3, boolean bl, ToggleButtonCallback toggleButtonCallback, int n) {
        BreezeToggleButton breezeToggleButton = VisualisationToolbar.createButton(string, string2, string3, bl, toggleButtonCallback);
        this.addWithIndex(breezeToggleButton, n);
        return breezeToggleButton;
    }

    public void addWithIndex(Component component, int n) {
        this.add(component, GridBagHelper.create(n, new Insets(insets, 0, insets, insets), false));
    }

    public static BreezeToggleButton createButton(String string, String string2, String string3, boolean bl, ToggleButtonCallback toggleButtonCallback) {
        BreezeToggleButton breezeToggleButton = new BreezeToggleButton(string, string3);
        breezeToggleButton.setResourceIcon(string2);
        breezeToggleButton.setPreferredSize(new Dimension(25, 25));
        breezeToggleButton.setSelected(bl);
        breezeToggleButton.addActionListener(actionEvent -> toggleButtonCallback.changed(breezeToggleButton.isSelected()));
        return breezeToggleButton;
    }

    private void triggerChange(ToolbarCallback toolbarCallback, Object object) {
        this.blendButton.setEnabled(this.supportBlend(object));
        this.legendButton.setEnabled(this.supportLegend(object));
        toolbarCallback.itemChanged(object);
    }

    private boolean supportBlend(Object object) {
        if (object instanceof Factor) {
            return true;
        }
        if (object instanceof ThumbnailComboBox.ThumbnailWithDescriptor) {
            AbstractBreezeFunction abstractBreezeFunction;
            ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor = (ThumbnailComboBox.ThumbnailWithDescriptor)object;
            DescriptorTreeNode descriptorTreeNode = thumbnailWithDescriptor.getNode();
            if (descriptorTreeNode != null && (abstractBreezeFunction = descriptorTreeNode.getFunction()) instanceof ThumbnailDescriptor) {
                ThumbnailDescriptor thumbnailDescriptor = (ThumbnailDescriptor)((Object)abstractBreezeFunction);
                return thumbnailDescriptor.getThumbType(descriptorTreeNode.getIndex()).equals((Object)ThumbnailDescriptor.ThumbType.ThumbClassification);
            }
            return true;
        }
        return object instanceof RtCategoryVariable;
    }

    public void initBlending(RtPredictionMode rtPredictionMode) {
        RtPredictionMode.PredictionModeSetup predictionModeSetup = rtPredictionMode.getPredictionSetup();
        if (predictionModeSetup instanceof RtPredictionMode.RgbModeSetup) {
            RtPredictionMode.RgbModeSetup rgbModeSetup = (RtPredictionMode.RgbModeSetup)predictionModeSetup;
            this.blendButton.setVisible(true);
            this.blendButton.setSelected(rgbModeSetup.isBlending());
        } else {
            this.blendButton.setVisible(false);
        }
    }

    private boolean supportLegend(Object object) {
        AbstractBreezeFunction abstractBreezeFunction;
        ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor;
        DescriptorTreeNode descriptorTreeNode;
        if (object instanceof RtBasicVariable) {
            RtBasicVariable rtBasicVariable = (RtBasicVariable)object;
            return rtBasicVariable.supportLegend();
        }
        if (object instanceof ThumbnailComboBox.ThumbnailWithDescriptor && (descriptorTreeNode = (thumbnailWithDescriptor = (ThumbnailComboBox.ThumbnailWithDescriptor)object).getNode()) != null && (abstractBreezeFunction = descriptorTreeNode.getFunction()) instanceof ThumbnailDescriptor) {
            ThumbnailDescriptor thumbnailDescriptor = (ThumbnailDescriptor)((Object)abstractBreezeFunction);
            return thumbnailDescriptor.getThumbType(descriptorTreeNode.getIndex()).hasLegend();
        }
        return this.supportBlend(object);
    }

    public boolean isLegend() {
        return this.legendButton.isSelected();
    }

    public boolean isBlend() {
        return this.blendButton.isSelected();
    }

    public void setItem(Object object) {
        int n = this.getIndexForObject(object);
        if (n < this.comboBox.getItemCount()) {
            this.comboBox.setSelectedIndex(n);
        }
    }

    private int getIndexForObject(Object object) {
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            Object e = this.comboBox.getItemAt(i);
            if (e != object && (!(e instanceof ThumbnailComboBox.ThumbnailWithDescriptor) || ((ThumbnailComboBox.ThumbnailWithDescriptor)e).getNode() != object)) continue;
            return i;
        }
        return 0;
    }

    public void showComboBox(boolean bl) {
        this.comboBox.setVisible(bl);
        this.emptyPanel.setVisible(!bl);
    }

    @Generated
    public BreezeComboBox getComboBox() {
        return this.comboBox;
    }

    @Generated
    public JPanel getEmptyPanel() {
        return this.emptyPanel;
    }

    @Generated
    public BreezeToggleButton getBlendButton() {
        return this.blendButton;
    }

    @Generated
    public BreezeToggleButton getLegendButton() {
        return this.legendButton;
    }

    public static interface ToolbarCallback {
        public void itemChanged(Object var1);

        public void blend(boolean var1);

        public void legend(boolean var1);
    }

    public static interface ToggleButtonCallback {
        public void changed(boolean var1);
    }
}

