/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.preview;

public class ZoomAxis {
    public int imageSize;
    private double scale;
    public double max;
    public double min;

    public boolean zoom(double d, int n) {
        double d2 = 1.0 + (double)n / 40.0;
        double d3 = this.abs();
        double d4 = Math.max(Math.min(d, (double)this.imageSize), 0.0);
        double d5 = (d4 - this.min) / d3;
        d3 = Math.min((double)this.imageSize, d3 * d2);
        this.min = d4 - d5 * d3;
        this.max = this.min + d3;
        return this.min < 0.0 || this.max >= (double)this.imageSize;
    }

    public void set(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public void pan(double d, double d2, double d3) {
        double d4 = (d - d2) * d3;
        this.min += d4;
        this.max += d4;
        double d5 = this.abs();
        if (this.min < 0.0) {
            this.min = 0.0;
            this.max = d5;
        } else if (this.max > (double)this.imageSize) {
            this.max = this.imageSize;
            this.min = this.max - d5;
        }
    }

    public double abs() {
        return this.max - this.min;
    }

    public void clear() {
        this.imageSize = 0;
        this.max = 0.0;
        this.min = 0.0;
    }

    public void reset(int n) {
        this.imageSize = n;
        this.reset();
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public void reset() {
        this.min = 0.0;
        this.max = this.imageSize;
    }

    public int min(int n) {
        return n - (int)(this.relative() * this.min);
    }

    public int max() {
        return (int)((double)this.imageSize * this.relative());
    }

    public double relative() {
        return (double)this.imageSize / this.abs() * this.scale;
    }
}

