/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionGroup;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;

public abstract class AbstractVisualizationPanel
extends AbstractViewPanel {
    private final PPEntryMainInterface pmi;
    private AbstractWindow visualization;
    private Object lastentrydata;
    protected boolean showProgressBar = true;
    private SwingTimer refreshTimer = null;
    protected boolean dirty;
    private boolean visualisationReady = false;
    private final List<JComponent> buttonList = new ArrayList<JComponent>();
    private Case source;
    private AbstractViewPanel viewPanel;

    public AbstractVisualizationPanel(PPEntryMainInterface pPEntryMainInterface) {
        this.pmi = pPEntryMainInterface;
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(100, 100));
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        for (JComponent jComponent : this.buttonList) {
            breezeMainPanel.addRightButton(jComponent);
        }
    }

    public void addSeparator() {
        this.addComponent(new BreezeSeparator(1));
    }

    public void addComponent(JComponent jComponent) {
        this.buttonList.add(jComponent);
    }

    public void setViewPanel(AbstractViewPanel abstractViewPanel) {
        this.viewPanel = abstractViewPanel;
    }

    public AbstractViewPanel getViewPanel() {
        return this.viewPanel;
    }

    public abstract JPanel getChildPanel();

    public abstract JPanel getContentPanel();

    @Override
    public abstract String getTitle();

    public Object getLastentrydata() {
        return this.lastentrydata;
    }

    @Override
    public BreezeFrame getFrame() {
        PPEntryMainInterface pPEntryMainInterface = this.pmi;
        if (pPEntryMainInterface instanceof BreezeMainPanel) {
            BreezeMainPanel breezeMainPanel = (BreezeMainPanel)pPEntryMainInterface;
            return breezeMainPanel.getFrame();
        }
        if (this.pmi instanceof AbstractViewPanel) {
            return ((AbstractViewPanel)((Object)this.pmi)).getFrame();
        }
        return super.getFrame();
    }

    @Override
    public BreezeMainPanel getMainPanel() {
        PPEntryMainInterface pPEntryMainInterface = this.pmi;
        if (pPEntryMainInterface instanceof BreezeMainPanel) {
            BreezeMainPanel breezeMainPanel = (BreezeMainPanel)pPEntryMainInterface;
            return breezeMainPanel;
        }
        return super.getMainPanel();
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        return this.pmi.getOrCreateEvinceProject();
    }

    public AbstractWindow getVisualization() {
        return this.visualization;
    }

    public JPanel getInnerVisualizationPanel() {
        return this.getChildPanel();
    }

    public boolean hasInteraction(boolean bl) {
        return bl;
    }

    public boolean hideProgressAnimation() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setShowProgressBar(boolean bl) {
        this.showProgressBar = bl;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.visualisationReady = false;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl && this.refreshTimer == null) {
            this.refreshTimer = new SwingTimer(200, actionEvent -> {
                if (this.isDirty()) {
                    this.showEntry(this.lastentrydata, null);
                    this.dirty = false;
                }
            }, true);
            this.refreshTimer.start();
        }
    }

    public void setLastentrydata(Object object) {
        this.lastentrydata = object;
    }

    public void setVisualization(AbstractWindow abstractWindow) {
        this.visualization = abstractWindow;
    }

    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string, Analyse analyse, int n) throws Exception {
        Object object = this.pmi.getInData(breezeProgressManager, updateVisualizationJob, string);
        if (object == null) {
            return VisualizationDataHelper.getInData(this.getOrCreateEvinceProject(), breezeProgressManager, updateVisualizationJob, string, analyse, n);
        }
        return object;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
    }

    public static Case createCase(Project_GUI project_GUI) {
        Case case_ = null;
        Iterator iterator = project_GUI.getCases();
        while (iterator.hasNext()) {
            Case case_2 = (Case)iterator.next();
            if (!case_2.getName().equals("%temp%")) continue;
            case_ = case_2;
            break;
        }
        if (case_ == null && (case_ = project_GUI.createNewCase()) != null) {
            case_.setVisibleInTree(false);
            case_.setName("%temp%");
            case_.setDsContainer(new DataContainer("dscontainer", -1));
            case_.setCalibrationType((byte)1);
        }
        return case_;
    }

    public void showProgressBar(BreezeProgressManager breezeProgressManager) {
        JPanel jPanel = this.getContentPanel();
        breezeProgressManager.setHolderPanel(jPanel);
        if (jPanel != null) {
            jPanel.removeAll();
        }
        breezeProgressManager.setInfoText("Rendering visualization");
        if (jPanel != null) {
            breezeProgressManager.getContentPane().setTouchScreen(jPanel.getBackground());
            if (this.hideProgressAnimation()) {
                breezeProgressManager.hideAnimationPanel();
            }
        }
    }

    public void hideProgressBar(BreezeProgressManager breezeProgressManager) {
        JPanel jPanel = this.getContentPanel();
        JPanel jPanel2 = this.getInnerVisualizationPanel();
        jPanel.remove((Component)breezeProgressManager.getContentPane());
        jPanel2.removeAll();
        AbstractWindow abstractWindow = this.getVisualization();
        if (abstractWindow != null) {
            jPanel2.add((Component)abstractWindow, "Center");
        }
        jPanel.add((Component)this.getChildPanel(), "Center");
        jPanel.revalidate();
        jPanel.repaint();
    }

    public void setContentReady(boolean bl) {
        AbstractWindow abstractWindow = this.getVisualization();
        if (abstractWindow != null) {
            abstractWindow.setContentReady(bl);
        }
    }

    public void setContentInformationAndClearSourceOnException(String string) {
        this.setContentInformation(string);
        this.updateInteractionIfNeeded(this.getVisualization().getProject_GUI(), null);
    }

    public void setContentInformation(String string) {
        AbstractWindow abstractWindow = this.getVisualization();
        if (abstractWindow != null) {
            abstractWindow.setContentInformation(string);
        }
    }

    public void setVisualisationReady(boolean bl) {
        this.visualisationReady = bl;
    }

    @Override
    public boolean contentReady() {
        return this.visualisationReady;
    }

    protected void updateInteractionIfNeeded(Project_GUI project_GUI, Object object) {
        InteractionGroup interactionGroup;
        this.source = object instanceof DataTreeClass ? ((DataTreeClass)object).getCase() : null;
        if (project_GUI != null && (interactionGroup = project_GUI.getInteractionGroup(0)) != null && interactionGroup.getFirstInteractionRoot() != this.source) {
            interactionGroup.clearInteractionArrays();
        }
    }

    public void selectFirstRowIfNoSelection() {
        block4: {
            Case case_ = this.source;
            Project_GUI project_GUI = this.getVisualization().getProject_GUI();
            if (project_GUI != null) {
                InteractionArray interactionArray;
                if (!(case_ == null || (interactionArray = project_GUI.getInteractionArray(1, 0)) != null && interactionArray.hasSelection())) {
                    AbstractDataMatrix abstractDataMatrix = case_.getOriginalMatrix();
                    interactionArray = project_GUI.getInteractionArray((DataTreeInterface)case_, 1, abstractDataMatrix != null ? abstractDataMatrix.getN() : 0, 0);
                    interactionArray.set(0);
                }
                try {
                    project_GUI.doInteractionOnly();
                }
                catch (Exception exception) {
                    if (!WorkspaceManager.logError()) break block4;
                    Logg.error((String)("Could not initiate interaction: " + exception.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }
}

