/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;
import se.prediktera.breeze.frontend.main.record.edit.common.EditEntryInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class PlotSettingsPanel
extends DefaultSettingsPanel {
    private final ViewContainer viewContainer;
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private final PixelExploreInterface.PretreatmentSectionPanel pretreatmentSectionPanel;
    private final EditPlotSections editPlotSections;

    public PlotSettingsPanel(ViewContainer viewContainer, PlotViewPanel plotViewPanel, InteractionPreviewPanel interactionPreviewPanel, boolean bl) {
        this.viewContainer = viewContainer;
        BreezeMainPanel breezeMainPanel = viewContainer.getMainPanel();
        ActiveVisualization activeVisualization = new ActiveVisualization();
        DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Include / Exclude");
        sectionPanel.addComponent(ModelButtonHelper.createIncludeButtonScatter(breezeMainPanel, activeVisualization));
        sectionPanel.addComponent(ModelButtonHelper.createIncludeOnlyButtonScatter(breezeMainPanel, activeVisualization));
        sectionPanel.addComponentLast(ModelButtonHelper.createExcludeButtonScatter(breezeMainPanel, activeVisualization));
        this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this, breezeMainPanel, plotViewPanel, bl);
        this.pretreatmentSectionPanel = new PixelExploreInterface.PretreatmentSectionPanel(breezeMainPanel, this, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.GroupExplore, workflow -> {
            DataSetCache.clearRecursive(workflow);
            breezeMainPanel.setDirty(true);
        });
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.addSection("Other");
        sectionPanel2.addComponentLast(ModelButtonHelper.createResetButton(breezeMainPanel, activeVisualization, () -> {}));
        this.editPlotSections = new EditPlotSections(viewContainer.getFrame(), interactionPreviewPanel, this);
    }

    public void setData(Entry entry, boolean bl, PlotViewPanel plotViewPanel) {
        this.editPlotSections.setData(plotViewPanel, entry);
        this.componentSectionPanel.setVisible(!bl);
        this.pretreatmentSectionPanel.update(plotViewPanel, Workflow.getWorkflow(entry));
        this.editPlotSections.updateListsWhenReady(this.viewContainer, null);
    }

    public PixelExploreInterface.ComponentSectionPanel getComponentSectionPanel() {
        return this.componentSectionPanel;
    }

    public List<RtModule> getTransformationModules() {
        return this.pretreatmentSectionPanel.getTransformationModules();
    }

    public Factor getSelectedFactor() {
        return this.editPlotSections.getSelectedFactor();
    }

    private class ActiveVisualization
    implements ModelButtonHelper.VisualizationInterface {
        private ActiveVisualization() {
        }

        @Override
        public AbstractPlotLayout getVisualization() {
            return PlotSettingsPanel.this.editPlotSections.getVisualization();
        }
    }

    public static class EditPlotSections
    implements EditEntryInterface,
    ModelButtonHelper.VisualizationInterface {
        private final BreezeFrame breezeFrame;
        private final DefaultSettingsPanel settingsPanel;
        private final List<EditBreezeList> editLists = new ArrayList<EditBreezeList>();
        private final EditBreezeList editLabels;
        private final EditBreezeList noneColor;
        private final EditBreezeList editProperties;
        private final EditBreezeList editCategories;
        private final EditBreezeList editDescriptors;
        private PlotViewPanel activeViewPanel;
        private Entry entry;
        private final InteractionPreviewPanel previewPanel;

        public EditPlotSections(BreezeFrame breezeFrame, InteractionPreviewPanel interactionPreviewPanel, DefaultSettingsPanel defaultSettingsPanel) {
            this.breezeFrame = breezeFrame;
            this.previewPanel = interactionPreviewPanel;
            this.settingsPanel = defaultSettingsPanel;
            DefaultSettingsPanel.SectionPanel sectionPanel = defaultSettingsPanel.addSection("Label");
            this.editLabels = this.addBreezeList(sectionPanel, EditBreezeList.BreezeListType.Identifier);
            this.editLabels.setCollapsed(true);
            DefaultSettingsPanel.SectionPanel sectionPanel2 = defaultSettingsPanel.addSection("Color");
            this.noneColor = this.addBreezeList(sectionPanel2, EditBreezeList.BreezeListType.Settings);
            this.editProperties = this.addBreezeList(sectionPanel2, EditBreezeList.BreezeListType.Property);
            this.editCategories = this.addBreezeList(sectionPanel2, EditBreezeList.BreezeListType.Category);
            this.editDescriptors = this.addBreezeList(sectionPanel2, EditBreezeList.BreezeListType.Descriptor);
        }

        @Override
        public AbstractPlotLayout getVisualization() {
            return this.activeViewPanel.getVisualization();
        }

        private EditBreezeList addBreezeList(DefaultSettingsPanel.SectionPanel sectionPanel, EditBreezeList.BreezeListType breezeListType) {
            EditBreezeList editBreezeList = new EditBreezeList(breezeListType, (int)((double)this.settingsPanel.settingsWidth * 0.8));
            editBreezeList.setText(breezeListType.getName());
            editBreezeList.setList(this, new ArrayList());
            editBreezeList.setEditable(false);
            editBreezeList.setCollapsed(false);
            if (breezeListType != EditBreezeList.BreezeListType.Identifier) {
                this.editLists.add(editBreezeList);
            }
            sectionPanel.addComponentHorizontal(editBreezeList);
            return editBreezeList;
        }

        public void setData(PlotViewPanel plotViewPanel, Entry entry) {
            this.activeViewPanel = plotViewPanel;
            this.entry = entry;
        }

        public void updateListsWhenReady(final ViewContainer viewContainer, final Factor factor) {
            if (this.entry != null) {
                ThreadUtil.runAfterConditionIsMet(new ThreadUtil.RunAfterConditionIsMetCallback(){
                    final /* synthetic */ EditPlotSections this$0;
                    {
                        this.this$0 = editPlotSections;
                    }

                    @Override
                    public boolean conditionIsMet() {
                        return viewContainer.contentReady();
                    }

                    @Override
                    public void actionToRun() {
                        SwingUtilities.invokeLater(() -> this.this$0.updateLists(this.this$0.entry, factor));
                    }
                });
            }
        }

        private void updateLists(Entry entry, Factor factor) {
            DataTreeInterface dataTreeInterface;
            Workflow workflow = Workflow.getWorkflow(entry);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("None");
            AbstractPlotLayout abstractPlotLayout = this.activeViewPanel.getVisualization();
            if (abstractPlotLayout != null && abstractPlotLayout.getPlotInit() != null && (dataTreeInterface = DataTreeManager.getAncestor((DataTreeInterface)abstractPlotLayout.getPlotInit().getDataTreeInterface(), DataSet.class)) instanceof DataSet) {
                DataSet dataSet = (DataSet)dataTreeInterface;
                ObservationInfo observationInfo = dataSet.getObsDataInfo();
                DataGroupValues dataGroupValues = observationInfo.getGroupColumnByType(0);
                for (int i = 0; i < dataGroupValues.getColumnCount(); ++i) {
                    arrayList.add(dataGroupValues.getColumnName(i));
                }
            }
            if (!this.editLabels.updateList(arrayList)) {
                this.editLabels.selectFirstItem();
            }
            boolean bl = this.noneColor.updateList(Arrays.asList("Red", "Density"));
            boolean bl2 = this.editProperties.updateList(workflow.getPropertyFactors().getList());
            boolean bl3 = this.editCategories.updateList(workflow.getCategoryFactors().getList());
            boolean bl4 = this.editDescriptors.updateList(workflow.getSegmentationLevelDescriptorNodes(false));
            if (!(bl || bl2 || bl3 || bl4)) {
                TreeModel object2;
                if (factor != null && (object2 = this.editCategories.getModel()) instanceof ArrayTreeModel) {
                    ArrayTreeModel arrayTreeModel = (ArrayTreeModel)object2;
                    for (Object e : arrayTreeModel.getList()) {
                        if (!factor.equals(e)) continue;
                        this.editCategories.setSelectedValue(e);
                        return;
                    }
                }
                for (EditBreezeList editBreezeList : this.editLists) {
                    if (!editBreezeList.selectFirstItem()) continue;
                    return;
                }
            }
        }

        @Override
        public Entry getRootEntry() {
            return this.entry;
        }

        @Override
        public BreezeFrame getFrame() {
            return this.breezeFrame;
        }

        public Factor getSelectedFactor() {
            if (this.editProperties.getSelectedValue() != null) {
                return (Factor)this.editProperties.getSelectedValue();
            }
            return (Factor)this.editCategories.getSelectedValue();
        }

        @Override
        public void setSelectedTypeAndValue(EditBreezeList.BreezeListType breezeListType, Object object) {
            if (object != null) {
                if (breezeListType != EditBreezeList.BreezeListType.Identifier) {
                    for (EditBreezeList object22 : this.editLists) {
                        if (object22.getType() == breezeListType) continue;
                        object22.clearSelection();
                    }
                }
                AbstractPlotLayout abstractPlotLayout = this.activeViewPanel.getVisualization();
                DataSet dataSet = this.getDataSetFromPlot(abstractPlotLayout);
                switch (breezeListType) {
                    case Category: {
                        CategoryFactor descriptorTreeNode = (CategoryFactor)object;
                        this.updateLegend(abstractPlotLayout, descriptorTreeNode.getName(), "");
                        abstractPlotLayout.setColor(new Object[]{"category", descriptorTreeNode.getName()});
                        this.setDefaultSizeAndBorder(abstractPlotLayout);
                        this.previewPanel.getToolbar().setItem(descriptorTreeNode);
                        break;
                    }
                    case Descriptor: {
                        DescriptorTreeNode propertyFactor = (DescriptorTreeNode)object;
                        this.updateLegend(abstractPlotLayout, propertyFactor.getAliasOrNodeString(), "");
                        if (dataSet != null) {
                            if (propertyFactor.getFactor() instanceof CategoryFactor) {
                                abstractPlotLayout.setColor(new Object[]{"predictioncategory", propertyFactor.getAliasOrNodeString()});
                            } else {
                                abstractPlotLayout.setColor(new Object[]{"value", dataSet.getOriginalMatrix(), propertyFactor.getAliasOrNodeString()});
                            }
                            this.setDefaultSizeAndBorder(abstractPlotLayout);
                        }
                        this.previewPanel.getToolbar().setItem(propertyFactor);
                        break;
                    }
                    case Identifier: {
                        if (object.toString().equals("None")) {
                            abstractPlotLayout.setLabel(new Object[]{"none"});
                        } else {
                            abstractPlotLayout.setLabel(new Object[]{"identifier", object.toString()});
                        }
                        this.previewPanel.getToolbar().setItem(null);
                        break;
                    }
                    case Property: {
                        PropertyFactor abstractAxisLayer = (PropertyFactor)object;
                        this.updateLegend(abstractPlotLayout, abstractAxisLayer.getName(), abstractAxisLayer.getUnit());
                        if (dataSet != null) {
                            abstractPlotLayout.setColor(new Object[]{"value", dataSet.getOriginalMatrix(), abstractAxisLayer.getName()});
                            this.setDefaultSizeAndBorder(abstractPlotLayout);
                        }
                        this.previewPanel.getToolbar().setItem(null);
                        break;
                    }
                    case Settings: {
                        if ("red".equalsIgnoreCase(object.toString())) {
                            this.updateLegend(abstractPlotLayout, "Fixed", "");
                            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setColor(new Object[]{"fixed", "red"});
                            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                            if (abstractAxisLayer != null) {
                                abstractAxisLayer.setColor(new Object[]{"fixed", "green"});
                            }
                            this.setDefaultSizeAndBorder(abstractPlotLayout);
                        } else {
                            this.updateLegend(abstractPlotLayout, "Density", "");
                            abstractPlotLayout.show("borders", Double.valueOf(0.0));
                            abstractPlotLayout.setColor(new Object[]{"density"});
                            abstractPlotLayout.setSize(new Object[]{"fixed", 2});
                        }
                        this.previewPanel.getToolbar().setItem(null);
                        break;
                    }
                }
            }
        }

        private void setDefaultSizeAndBorder(AbstractPlotLayout abstractPlotLayout) {
            abstractPlotLayout.show("borders", Double.valueOf(1.0));
            abstractPlotLayout.setSize(new Object[]{"fixed", 5});
        }

        private DataSet getDataSetFromPlot(AbstractPlotLayout abstractPlotLayout) {
            DataTreeInterface dataTreeInterface;
            PlotInit plotInit = abstractPlotLayout.getPlotInit();
            if (plotInit != null && (dataTreeInterface = DataTreeManager.getAncestor((DataTreeInterface)plotInit.getDataTreeInterface(), DataSet.class)) instanceof DataSet) {
                return (DataSet)dataTreeInterface;
            }
            return null;
        }

        private void updateLegend(AbstractPlotLayout abstractPlotLayout, String string, String string2) {
            List list = abstractPlotLayout.getMainWindow().getLegendList();
            if (!list.isEmpty()) {
                LegendWindow legendWindow = (LegendWindow)list.get(0);
                legendWindow.setTitleNoAutoText(string);
                legendWindow.setDescription(string2);
            }
        }
    }
}

