/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.evince.data.queue.CreateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.VisualizationJobQueue;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.AbstractVisualizationPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.breeze.util.UserFriendlyExceptionString;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.category.DataInfoClassEvent;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class PlotViewPanel
extends AbstractVisualizationPanel
implements ModelButtonHelper.VisualizationInterface {
    private Analyse analyse;
    private JPanel contentPanel;
    private JLabel informationLabel;
    private BreezeButton leftButton;
    private JPanel plotCenterPanel;
    private BreezeButton rightButton;
    private JPanel southPanel;
    private JLabel titleLabel;
    private JPanel toolbarPanel;
    private JLabel valueLabel;
    private final String visualizationType;
    private final String[] matrixType;
    private Object[] data;

    public PlotViewPanel() {
        this(null, "Test", "Scatter2D", "XTR");
    }

    public PlotViewPanel(PPEntryMainInterface pPEntryMainInterface, String string, String string2) {
        this(pPEntryMainInterface, string, string2, "XTR");
    }

    public PlotViewPanel(PPEntryMainInterface pPEntryMainInterface, String string, String string2, String[] stringArray, Analyse analyse) {
        this(pPEntryMainInterface, string, string2, stringArray);
        this.setAnalyse(analyse);
    }

    public PlotViewPanel(PPEntryMainInterface pPEntryMainInterface, String string, String string2, String string3) {
        this(pPEntryMainInterface, string, string2, new String[]{string3});
    }

    public PlotViewPanel(PPEntryMainInterface pPEntryMainInterface, String string, String string2, String[] stringArray) {
        super(pPEntryMainInterface);
        this.visualizationType = string2;
        this.matrixType = stringArray;
        VisualizationJobQueue.getInstance().addToQueue(new CreateDefaultPlotVisualizationMatrixJob());
        this.initComponents();
        this.setTitle(string);
        this.southPanel.setVisible(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.titleLabel.setForeground(breezeTheme.getLabelForeground());
        this.plotCenterPanel.setBackground(breezeTheme.getPanelBackground());
        this.contentPanel.setBackground(breezeTheme.getPanelBackground());
        this.leftButton.setToolTipText("Previous");
        this.leftButton.setBackground(breezeTheme.getSettingPanelBackground());
        this.leftButton.setDescForegroundReal(breezeTheme.getLabelForegroundDifuse());
        this.leftButton.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundDifuse()));
        this.rightButton.setToolTipText("Next");
        this.rightButton.setBackground(breezeTheme.getSettingPanelBackground());
        this.rightButton.setDescForegroundReal(breezeTheme.getLabelForegroundDifuse());
        this.rightButton.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundDifuse()));
        this.showNextPrev(false);
    }

    @Override
    public String getTitle() {
        return this.titleLabel.getText();
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        this.titleLabel.setVisible(!string.isEmpty());
    }

    public void addToolbarComponent(JComponent jComponent) {
        this.addToolbarComponent(jComponent, 0, 0, null);
    }

    public void addToolbarComponent(JComponent jComponent, int n, int n2, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.toolbarPanel.getComponentCount();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = n;
        gridBagConstraints.weighty = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets != null ? insets : new Insets(0, 20, 0, 0);
        this.toolbarPanel.add((Component)jComponent, gridBagConstraints);
    }

    public Properties createProperties() {
        return new Properties();
    }

    public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
        breezeContextMenu.addButtonCloseClick("Save image as...", () -> PlotPopupMenu.showSaveDialog((Frame)this.getFrame(), (String)this.getTitle(), (boolean)false, (int)abstractPlotLayout.getWidth(), (int)abstractPlotLayout.getHeight(), (boolean)true, (PlotPopupMenu.ImageSaveCallback)new PlotSaveCallback()));
        breezeContextMenu.addButtonCloseClick("Print image", () -> PlotPopupMenu.printImage((AbstractPlotLayout)abstractPlotLayout));
        breezeContextMenu.addButtonCloseClick("Copy to clipboard", () -> PlotPopupMenu.copyToClipboard((PlotPopupMenu.ImageSaveCallback)new PlotSaveCallback(), (int)abstractPlotLayout.getWidth(), (int)abstractPlotLayout.getHeight(), (boolean)true));
        breezeContextMenu.addSeparator();
        breezeContextMenu.addButtonCloseClick("Clear selection", () -> abstractPlotLayout.select(new Object[]{"clear"}));
        breezeContextMenu.addButtonCloseClick("Invert selection", () -> abstractPlotLayout.select(new Object[]{"invert", abstractPlotLayout.get("selection")}));
        breezeContextMenu.addButtonCloseClick("Select all", () -> abstractPlotLayout.select(new Object[]{"all"}));
    }

    public void selectAll() {
        AbstractPlotLayout abstractPlotLayout = this.getVisualization();
        if (abstractPlotLayout != null) {
            abstractPlotLayout.select(new Object[]{"all"});
        }
    }

    public Analyse getAnalyse() {
        return this.analyse;
    }

    @Override
    public JPanel getChildPanel() {
        return this.plotCenterPanel;
    }

    @Override
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public JPanel getInnerVisualizationPanel() {
        return this.plotCenterPanel;
    }

    @Override
    public AbstractPlotLayout getVisualization() {
        return (AbstractPlotLayout)super.getVisualization();
    }

    @Override
    public void beginUpdate() {
        AbstractPlotLayout abstractPlotLayout = this.getVisualization();
        if (abstractPlotLayout != null) {
            abstractPlotLayout.setContentReady(false);
        }
    }

    @Override
    public void endUpdate() {
        AbstractPlotLayout abstractPlotLayout = this.getVisualization();
        if (abstractPlotLayout != null) {
            abstractPlotLayout.setContentReady(true);
            abstractPlotLayout.repaint();
        }
    }

    public DataSet getDataSet() {
        AbstractPlotLayout abstractPlotLayout = this.getVisualization();
        if (abstractPlotLayout != null) {
            return abstractPlotLayout.getDataSet();
        }
        return null;
    }

    public AbstractDataMatrix getOriginalMatrix() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            return dataSet.getOriginalMatrix();
        }
        return null;
    }

    public AbstractModel getModel() {
        AbstractPlotLayout abstractPlotLayout = this.getVisualization();
        if (abstractPlotLayout != null) {
            return abstractPlotLayout.getModel();
        }
        return null;
    }

    public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
    }

    public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
    }

    public void dataUpdated(AbstractPlotLayout abstractPlotLayout, int n, boolean bl) {
    }

    public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
    }

    public void setAnalyse(Analyse analyse) {
        this.analyse = analyse;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (this.getLastentrydata() != object) {
            this.showNextPrev(false);
        }
        super.showEntry(object, object2);
        VisualizationJobQueue.getInstance().addToQueue(new UpdatePlotVisualizationMatrixJob(object, this.showProgressBar));
    }

    public void setSubLabel(String string, String string2) {
        this.informationLabel.setText(string);
        this.valueLabel.setText(string2);
        this.southPanel.setVisible(true);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    protected boolean supportChange() {
        String string = this.getVisualizationType().toLowerCase();
        return string.equals("contour2d") || string.startsWith("scatter2d") || string.startsWith("score2d");
    }

    protected void changeAxis(boolean bl) {
        try {
            String string = bl ? "next" : "previous";
            AbstractPlotLayout abstractPlotLayout = this.getVisualization();
            if (this.getVisualizationType().equalsIgnoreCase("contour2d")) {
                abstractPlotLayout.setDataRange(new Object[]{"Range", string, 1});
            } else {
                abstractPlotLayout.setDataRange(new Object[]{"X", string, 1});
                abstractPlotLayout.setDataRange(new Object[]{"Y", string, 1});
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
        }
    }

    public JPanel getLegend() {
        return null;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.toolbarPanel = new JPanel();
        this.leftButton = new BreezeButton();
        this.rightButton = new BreezeButton();
        this.southPanel = new JPanel();
        this.valueLabel = new JLabel();
        this.informationLabel = new JLabel();
        this.contentPanel = new JPanel();
        this.plotCenterPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.titleLabel.setFont(new Font("Tahoma", 0, 16));
        this.titleLabel.setForeground(new Color(150, 150, 150));
        this.titleLabel.setText("Title");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(this.titleLabel, gridBagConstraints);
        this.toolbarPanel.setOpaque(false);
        this.leftButton.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.leftButton.setDescForeground(new Color(153, 153, 153));
        this.leftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/direction/left_small.png")));
        this.leftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlotViewPanel.this.changeAxis(false);
            }
        });
        this.toolbarPanel.add(this.leftButton);
        this.rightButton.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.rightButton.setDescForeground(new Color(153, 153, 153));
        this.rightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/direction/right_small.png")));
        this.rightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlotViewPanel.this.changeAxis(true);
            }
        });
        this.toolbarPanel.add(this.rightButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.toolbarPanel, gridBagConstraints);
        this.southPanel.setLayout(new GridBagLayout());
        this.valueLabel.setFont(new Font("Tahoma", 0, 24));
        this.valueLabel.setForeground(new Color(30, 30, 30));
        this.valueLabel.setText("Value");
        this.valueLabel.setName("valueLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.southPanel.add((Component)this.valueLabel, gridBagConstraints);
        this.informationLabel.setFont(new Font("Tahoma", 0, 18));
        this.informationLabel.setForeground(new Color(150, 150, 150));
        this.informationLabel.setText("Information");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.southPanel.add((Component)this.informationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add(this.southPanel, gridBagConstraints);
        this.contentPanel.setBackground(new Color(255, 255, 255));
        this.contentPanel.setLayout(new BorderLayout());
        this.plotCenterPanel.setBackground(new Color(255, 255, 255));
        this.plotCenterPanel.setOpaque(false);
        this.plotCenterPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.plotCenterPanel, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.contentPanel, gridBagConstraints);
    }

    private void showNextPrev(boolean bl) {
        boolean bl2 = this.supportChange();
        this.leftButton.setVisible(bl && bl2);
        this.rightButton.setVisible(bl && bl2);
    }

    public String getVisualizationType() {
        return this.visualizationType;
    }

    public String[] getMatrixType() {
        return this.matrixType;
    }

    @Override
    public String getType() {
        return "Window" + String.valueOf(this.matrixType);
    }

    public Object[] getData() {
        return this.data;
    }

    public void setData(Object[] objectArray) {
        this.data = objectArray;
    }

    protected int getBand(AbstractAxisLayer abstractAxisLayer, int n) {
        AbstractDataMatrix abstractDataMatrix = abstractAxisLayer.getPlotInit().getMatrix(0);
        if (abstractDataMatrix != null) {
            return abstractDataMatrix.getBand(n);
        }
        return n;
    }

    protected boolean foldImageData() {
        return true;
    }

    private class CreateDefaultPlotVisualizationMatrixJob
    extends CreateVisualizationJob {
        private CreateDefaultPlotVisualizationMatrixJob() {
        }

        @Override
        protected void createVisualization(BreezeProgressManager breezeProgressManager) {
            PlotViewPanel.this.showProgressBar(breezeProgressManager);
            try {
                AbstractAxisPlot abstractAxisPlot;
                boolean bl;
                Object[] objectArray2;
                int n = PlotViewPanel.this.matrixType.length;
                Project_GUI project_GUI = PlotViewPanel.this.getMatrixType();
                boolean bl2 = false;
                for (Object[] objectArray2 : project_GUI) {
                    if (!objectArray2.startsWith("model")) continue;
                    bl2 = true;
                }
                Project_GUI project_GUI2 = PlotViewPanel.this.getOrCreateEvinceProject();
                Plot_GUI plot_GUI = null;
                Case case_ = null;
                if (project_GUI2 != null) {
                    case_ = AbstractVisualizationPanel.createCase(project_GUI2);
                    plot_GUI = project_GUI2.getPlot_GUI();
                } else {
                    plot_GUI = new Plot_GUI(project_GUI2, null);
                }
                objectArray2 = new AbstractDataMatrix[n];
                objectArray2[0] = (AbstractDataMatrix)VisualizationDataHelper.createDefaultData(case_, (String)project_GUI[0], PlotViewPanel.this.visualizationType);
                Properties properties = PlotViewPanel.this.createProperties();
                properties.put("show", "false");
                properties.put("labels", "true");
                properties.put("width", "5");
                properties.put("selectioncolor", "yellow");
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = bl = PlotViewPanel.this.visualizationType.equalsIgnoreCase("Contour2D") || PlotViewPanel.this.visualizationType.equalsIgnoreCase("RGBImage");
                if (bl) {
                    if (PlotViewPanel.this.foldImageData()) {
                        properties.put("fold", "true");
                        if (!bl2) {
                            properties.put("rotatefold", "false");
                        }
                        objectArray2[0].setFoldN(1);
                        bl4 = true;
                    }
                    bl3 = true;
                } else if (PlotViewPanel.this.visualizationType.equalsIgnoreCase("Line") || PlotViewPanel.this.visualizationType.equalsIgnoreCase("LineStacked")) {
                    bl3 = true;
                }
                AbstractPlotLayout abstractPlotLayout = (AbstractPlotLayout)EvinceScriptCommands.createPlot((Project_GUI)project_GUI2, (ProgressManager)breezeProgressManager, (String)PlotViewPanel.this.visualizationType, (DataTreeInterface)objectArray2[0], null, (Properties)properties);
                abstractPlotLayout.setContentReady(false);
                BreezeTheme breezeTheme = BreezeTheme.getInstance();
                abstractPlotLayout.setBackground(breezeTheme.getPanelBackground());
                abstractPlotLayout.setForeground(breezeTheme.getLabelForeground());
                abstractPlotLayout.setPlotBackgroundColor(breezeTheme.getPanelBackground());
                abstractPlotLayout.setTextColor(breezeTheme.getLabelForeground(), properties);
                FloatMainWindow floatMainWindow = abstractPlotLayout.getMainWindow();
                if (floatMainWindow instanceof AbstractAxisPlot) {
                    abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
                    abstractAxisPlot.setBackground(breezeTheme.getPanelBackground());
                    abstractAxisPlot.setForeground(breezeTheme.getLabelForeground());
                    abstractAxisPlot.setAxisColor(breezeTheme.getLabelForeground());
                    abstractAxisPlot.setZeroColor(bl ? null : breezeTheme.getLabelForeground());
                    abstractAxisPlot.setObjectBorderColor(breezeTheme.getLabelForeground());
                    abstractAxisPlot.setGridColor(breezeTheme.getPlotGridColor());
                }
                abstractPlotLayout.setTitle("");
                abstractPlotLayout.setSelectionColor("white", properties);
                abstractPlotLayout.setCustomMenuTrigger(mouseEvent -> {
                    if (mouseEvent.isPopupTrigger() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(PlotViewPanel.this.getFrame(), Color.red);
                        PlotViewPanel.this.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
                        if (breezeContextMenu.getComponentCount() > 0 && breezeContextMenu.resize()) {
                            breezeContextMenu.setPositionLater(mouseEvent);
                            PlotViewPanel.this.getFrame().addPage((JPanel)((Object)breezeContextMenu));
                        }
                    }
                });
                if (bl3) {
                    abstractPlotLayout.removeArea("all");
                    abstractAxisPlot = abstractPlotLayout.getArea("plot");
                    abstractAxisPlot.setDimension(Double.valueOf(100.0), Double.valueOf(100.0));
                    abstractAxisPlot.setPosition(Double.valueOf(0.0), Double.valueOf(0.0));
                }
                abstractPlotLayout.setCreated((AbstractWindow_GUI)plot_GUI, false);
                for (int i = 1; i < n; ++i) {
                    floatMainWindow = project_GUI[0];
                    if (i < ((Project_GUI)project_GUI).length) {
                        floatMainWindow = project_GUI[i];
                    }
                    objectArray2[i] = (AbstractDataMatrix)VisualizationDataHelper.createDefaultData(case_, (String)floatMainWindow, PlotViewPanel.this.visualizationType);
                    if (bl4) {
                        objectArray2[i].setFoldN(1);
                    }
                    abstractPlotLayout.addLayer((AbstractDataMatrix)objectArray2[i]);
                }
                if (PlotViewPanel.this.hasInteraction(bl2)) {
                    abstractPlotLayout.setInteractionFlag((byte)1);
                    abstractPlotLayout.setSelectionTool("freehand");
                } else {
                    abstractPlotLayout.setInteractionFlag((byte)0);
                    abstractPlotLayout.setSelectionTool("none");
                }
                PlotViewPanel.this.plotSetup(abstractPlotLayout);
                PlotViewPanel.this.setData(objectArray2);
                PlotViewPanel.this.setVisualization((AbstractWindow)abstractPlotLayout);
                if (project_GUI2 != null && project_GUI2.getPlot_GUI() != null) {
                    project_GUI2.getPlot_GUI().addWindowContainer((AbstractWindow)abstractPlotLayout);
                }
            }
            catch (Exception exception) {
                Logg.error((String)"Exception in createVisualization", (Throwable)exception);
                PlotViewPanel.this.setContentInformation(exception.getMessage());
            }
            PlotViewPanel.this.getContentPanel().repaint();
            PlotViewPanel.this.hideProgressBar(breezeProgressManager);
        }
    }

    private class UpdatePlotVisualizationMatrixJob
    extends UpdateVisualizationJob {
        public UpdatePlotVisualizationMatrixJob(Object object, boolean bl) {
            super(PlotViewPanel.this, object, bl);
        }

        @Override
        protected void updateVisualizationMatrix(BreezeProgressManager breezeProgressManager) {
            try {
                String string;
                String string2 = PlotViewPanel.this.getVisualizationType();
                String[] stringArray = PlotViewPanel.this.getMatrixType();
                AbstractPlotLayout abstractPlotLayout = PlotViewPanel.this.getVisualization();
                boolean bl = false;
                PlotViewPanel.this.preSetup(breezeProgressManager, abstractPlotLayout);
                AbstractDataMatrix[] abstractDataMatrixArray = (AbstractDataMatrix[])PlotViewPanel.this.getData();
                if (abstractDataMatrixArray == null) {
                    return;
                }
                Analyse analyse = PlotViewPanel.this.getAnalyse();
                for (int i = 0; i < abstractDataMatrixArray.length; ++i) {
                    AbstractDataMatrix abstractDataMatrix;
                    string = stringArray[0];
                    if (i < stringArray.length) {
                        string = stringArray[i];
                    }
                    if ((abstractDataMatrix = (AbstractDataMatrix)PlotViewPanel.this.getInData(breezeProgressManager, this, string, analyse, i)) != null) {
                        ArrayList arrayList = abstractDataMatrixArray[i].getListenerList();
                        if (arrayList != null) {
                            ArrayList arrayList2 = new ArrayList(arrayList);
                            abstractDataMatrixArray[i].copyDataTreeChangeListeners((DataTreeInterface)abstractDataMatrix);
                            abstractDataMatrix.triggerReplaceEvent(new DataTreeEvent((Object)this, (DataTreeInterface)abstractDataMatrixArray[i], (DataTreeInterface)abstractDataMatrix));
                            abstractDataMatrix.removeAllDataTreeChangeListener();
                            abstractDataMatrixArray[i].setListenerList(arrayList2);
                        }
                        if (i == 0) {
                            DataTemplatesHelper.setDefaultBand(string, string2, abstractDataMatrix, abstractPlotLayout);
                        }
                        bl = true;
                    }
                    PlotViewPanel.this.dataUpdated(abstractPlotLayout, i, abstractDataMatrix != null);
                }
                DataSet dataSet = PlotViewPanel.this.getDataSet();
                if (dataSet != null) {
                    string = dataSet.getObsDataInfo();
                    string.triggerEvent((DataInfoEvent)new DataInfoClassEvent((AbstractDataInfo)string, 0, null, null, 5));
                }
                PlotViewPanel.this.postSetup(breezeProgressManager, abstractPlotLayout);
                abstractPlotLayout.setTitle("");
                PlotViewPanel.this.showNextPrev(bl);
                PlotViewPanel.this.updateInteractionIfNeeded(abstractPlotLayout.getProject_GUI(), bl ? this.getPlotData(abstractPlotLayout) : null);
                if (bl) {
                    SwingUtilities.invokeLater(() -> {
                        abstractPlotLayout.setContentReady(true);
                        abstractPlotLayout.baseResized();
                        abstractPlotLayout.refresh();
                    });
                } else {
                    abstractPlotLayout.setContentInformation("No content available");
                }
            }
            catch (Analyse.ModelFileNotFoundException modelFileNotFoundException) {
                PlotViewPanel.this.setContentInformationAndClearSourceOnException("No calibration available");
            }
            catch (ErrorHandler.MessageException messageException) {
                PlotViewPanel.this.setContentInformationAndClearSourceOnException(messageException.getMessage());
            }
            catch (Exception exception) {
                Logg.error((String)"Exception in updateWindowMatrix", (Throwable)exception);
                PlotViewPanel.this.setContentInformationAndClearSourceOnException(new UserFriendlyExceptionString(exception).getFirstLine());
            }
            PlotViewPanel.this.getContentPanel().repaint();
            PlotViewPanel.this.setVisualisationReady(true);
        }

        private DataTreeInterface getPlotData(AbstractPlotLayout abstractPlotLayout) {
            if (abstractPlotLayout.getPlotInit() != null) {
                return abstractPlotLayout.getPlotInit().getDataTreeInterface();
            }
            return null;
        }
    }

    public class PlotSaveCallback
    implements PlotPopupMenu.ImageSaveCallback {
        public void saveSVG(File file) {
        }

        public BufferedImage makeBufferedImageScreenShot(int n, int n2, boolean bl) {
            AbstractPlotLayout abstractPlotLayout = PlotViewPanel.this.getVisualization();
            BufferedImage bufferedImage = abstractPlotLayout.makeBufferedImageScreenShot(n, n2, bl);
            JPanel jPanel = PlotViewPanel.this.getLegend();
            if (jPanel != null && jPanel.isVisible()) {
                if (jPanel instanceof PixelExploreInterface.SpectralPlotViewPanel.SpectrumLegendPanel) {
                    PixelExploreInterface.SpectralPlotViewPanel.SpectrumLegendPanel spectrumLegendPanel = (PixelExploreInterface.SpectralPlotViewPanel.SpectrumLegendPanel)jPanel;
                    return BasicPreviewPanel.createImageWithLegend(spectrumLegendPanel.getMainPanel(), bufferedImage);
                }
                return BasicPreviewPanel.createImageWithLegend(jPanel, bufferedImage);
            }
            return bufferedImage;
        }
    }
}

