/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.evince.data.queue.CreateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.VisualizationJobQueue;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.visualization.AbstractVisualizationPanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.Data_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class TableViewPanel
extends AbstractVisualizationPanel {
    private JPanel contentPanel;
    private JLabel tableLabel;
    private JPanel tablePanel;
    private JPanel toolbarPanel;
    private final String visualizationType;
    private DataTreeClass tableMatrix;
    private final String matrixType;

    public TableViewPanel() {
        this(null, "", "", "xtraining");
    }

    public TableViewPanel(PPEntryMainInterface pPEntryMainInterface, String string, String string2, String string3) {
        super(pPEntryMainInterface);
        this.visualizationType = string2;
        this.matrixType = string3;
        VisualizationJobQueue.getInstance().addToQueue(new CreateDefaultTableMatrixJob());
        this.initComponents();
        this.setTitle(string);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.tableLabel.setForeground(breezeTheme.getLabelForeground());
        this.contentPanel.setBackground(breezeTheme.getPanelBackground());
        this.tablePanel.setBackground(breezeTheme.getPanelBackground());
    }

    @Override
    public String getTitle() {
        return this.tableLabel.getText();
    }

    public void setTitle(String string) {
        this.tableLabel.setText(string);
        this.tableLabel.setVisible(!string.isEmpty());
    }

    @Override
    public JPanel getChildPanel() {
        return this.tablePanel;
    }

    @Override
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void tableSetup(AbstractTable abstractTable) throws Exception {
    }

    public void postSetup(AbstractTable abstractTable) throws Exception {
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        VisualizationJobQueue.getInstance().addToQueue(new UpdateTableVisualizationMatrixJob(object, this.showProgressBar));
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    public String getVisualizationType() {
        return this.visualizationType;
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.tablePanel = new JPanel();
        this.tableLabel = new JLabel();
        this.toolbarPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(new Color(255, 255, 255));
        this.contentPanel.setLayout(new BorderLayout());
        this.tablePanel.setBackground(new Color(255, 255, 255));
        this.tablePanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.tablePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.contentPanel, gridBagConstraints);
        this.tableLabel.setFont(new Font("Tahoma", 0, 16));
        this.tableLabel.setForeground(new Color(150, 150, 150));
        this.tableLabel.setText("Tabletitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(this.tableLabel, gridBagConstraints);
        this.toolbarPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.toolbarPanel, gridBagConstraints);
    }

    @Override
    public String getType() {
        return "Window" + this.matrixType;
    }

    private class CreateDefaultTableMatrixJob
    extends CreateVisualizationJob {
        private CreateDefaultTableMatrixJob() {
        }

        @Override
        protected void createVisualization(BreezeProgressManager breezeProgressManager) {
            TableViewPanel.this.showProgressBar(breezeProgressManager);
            try {
                Project_GUI project_GUI = TableViewPanel.this.getOrCreateEvinceProject();
                Data_GUI data_GUI = null;
                Case case_ = null;
                if (project_GUI != null) {
                    case_ = AbstractVisualizationPanel.createCase(project_GUI);
                    data_GUI = project_GUI.getData_GUI();
                } else {
                    data_GUI = new Data_GUI(project_GUI, null);
                }
                String string = TableViewPanel.this.getVisualizationType();
                TableViewPanel.this.tableMatrix = (DataTreeClass)VisualizationDataHelper.createDefaultData(case_, TableViewPanel.this.matrixType, string);
                Properties properties = new Properties();
                properties.put("show", "false");
                AbstractTable abstractTable = (AbstractTable)EvinceScriptCommands.createTable((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (String)string, (DataTreeInterface)TableViewPanel.this.tableMatrix, (Properties)properties);
                abstractTable.setContentReady(false);
                abstractTable.setCreated((AbstractWindow_GUI)data_GUI, false);
                BreezeTheme breezeTheme = BreezeTheme.getInstance();
                abstractTable.setBackground(breezeTheme.getPanelBackground());
                abstractTable.setForeground(breezeTheme.getLabelForeground());
                TableViewPanel.this.tableSetup(abstractTable);
                TableViewPanel.this.setVisualization((AbstractWindow)abstractTable);
                if (project_GUI != null && project_GUI.getData_GUI() != null) {
                    project_GUI.getData_GUI().addWindowContainer((AbstractWindow)abstractTable);
                }
            }
            catch (Exception exception) {
                Logg.error((String)"Exception in createVisualization", (Throwable)exception);
                TableViewPanel.this.setContentInformation(exception.getMessage());
            }
            TableViewPanel.this.getContentPanel().repaint();
            TableViewPanel.this.hideProgressBar(breezeProgressManager);
        }
    }

    private class UpdateTableVisualizationMatrixJob
    extends UpdateVisualizationJob {
        public UpdateTableVisualizationMatrixJob(Object object, boolean bl) {
            super(TableViewPanel.this, object, bl);
        }

        @Override
        protected void updateVisualizationMatrix(BreezeProgressManager breezeProgressManager) {
            AbstractTable abstractTable = (AbstractTable)TableViewPanel.this.getVisualization();
            try {
                if (abstractTable == null || TableViewPanel.this.tableMatrix == null) {
                    return;
                }
                Object object = TableViewPanel.this.getInData(breezeProgressManager, this, TableViewPanel.this.matrixType, null, 0);
                if (object instanceof DataTreeClass) {
                    DataTreeClass dataTreeClass = (DataTreeClass)object;
                    TableViewPanel.this.tableMatrix.copyDataTreeChangeListeners((DataTreeInterface)dataTreeClass);
                    dataTreeClass.triggerReplaceEvent(new DataTreeEvent((Object)this, (DataTreeInterface)TableViewPanel.this.tableMatrix, (DataTreeInterface)dataTreeClass));
                } else if (abstractTable instanceof BreezeInnerTable) {
                    ((BreezeInnerTable)abstractTable).setData(object);
                }
                TableViewPanel.this.updateInteractionIfNeeded(abstractTable.getProject_GUI(), object);
                TableViewPanel.this.postSetup(abstractTable);
                abstractTable.setContentReady(true);
            }
            catch (Analyse.ModelFileNotFoundException modelFileNotFoundException) {
                TableViewPanel.this.setContentInformationAndClearSourceOnException("No calibration available");
            }
            catch (ErrorHandler.MessageException messageException) {
                TableViewPanel.this.setContentInformationAndClearSourceOnException(messageException.getMessage());
            }
            catch (Exception exception) {
                Logg.error((String)"Exception in updateWindowMatrix", (Throwable)exception);
                TableViewPanel.this.setContentInformationAndClearSourceOnException(exception.getMessage());
            }
            TableViewPanel.this.getContentPanel().repaint();
            TableViewPanel.this.setVisualisationReady(true);
        }
    }
}

