/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization.camerastream;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.AverageFromIncreasingSeries;

public class AverageFrameCountTest {
    @Test
    public void shouldProduceSimpleAverage() {
        AverageFromIncreasingSeries averageFromIncreasingSeries = new AverageFromIncreasingSeries(9999);
        averageFromIncreasingSeries.push(30L);
        averageFromIncreasingSeries.push(60L);
        averageFromIncreasingSeries.push(90L);
        averageFromIncreasingSeries.push(120L);
        MatcherAssert.assertThat((Object)averageFromIncreasingSeries.get(), (Matcher)CoreMatchers.is((Object)30.0));
    }

    @Test
    public void shouldProduceComplexAverage() {
        AverageFromIncreasingSeries averageFromIncreasingSeries = new AverageFromIncreasingSeries(9999);
        averageFromIncreasingSeries.push(0L);
        averageFromIncreasingSeries.push(60L);
        averageFromIncreasingSeries.push(90L);
        averageFromIncreasingSeries.push(210L);
        MatcherAssert.assertThat((Object)averageFromIncreasingSeries.get(), (Matcher)CoreMatchers.is((Object)70.0));
    }

    @Test
    public void shouldCapSimpleAverage() {
        AverageFromIncreasingSeries averageFromIncreasingSeries = new AverageFromIncreasingSeries(3);
        averageFromIncreasingSeries.push(0L);
        averageFromIncreasingSeries.push(5L);
        averageFromIncreasingSeries.push(30L);
        averageFromIncreasingSeries.push(60L);
        averageFromIncreasingSeries.push(90L);
        averageFromIncreasingSeries.push(120L);
        MatcherAssert.assertThat((Object)averageFromIncreasingSeries.get(), (Matcher)CoreMatchers.is((Object)30.0));
    }

    @Test
    public void shouldCapLongAverage() {
        AverageFromIncreasingSeries averageFromIncreasingSeries = new AverageFromIncreasingSeries(120);
        for (int i = 0; i < 10000; i += 10) {
            averageFromIncreasingSeries.push(i);
        }
        MatcherAssert.assertThat((Object)averageFromIncreasingSeries.get(), (Matcher)CoreMatchers.is((Object)10.0));
    }
}

