/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization.camerastream;

import java.util.LinkedList;

public class AverageFromIncreasingSeries {
    private final LinkedList<Long> ticklist = new LinkedList();
    private final int bufferSize;
    private Long latestTick;
    private long latestDelta;

    public AverageFromIncreasingSeries(int n) {
        this.bufferSize = n;
    }

    public long push(long l) {
        if (this.latestTick != null) {
            long l2 = l - this.latestTick;
            this.ticklist.add(l2);
            if (this.ticklist.size() > this.bufferSize) {
                this.ticklist.pop();
            }
            this.latestTick = l;
            this.latestDelta = l2;
            return l2;
        }
        this.latestTick = l;
        return 0L;
    }

    public double get() {
        if (this.ticklist.isEmpty()) {
            return 0.0;
        }
        return (double)this.ticklist.stream().reduce(0L, (l, l2) -> l + l2).longValue() / (double)this.ticklist.size();
    }

    public String toString() {
        return String.format("avg%.1f latest%d", this.get(), this.latestDelta);
    }

    public Long latestDelta() {
        return this.latestDelta;
    }
}

