/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization.camerastream;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import javax.swing.Timer;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.performance.MeasuredFps;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.SnapshotStreamImage;
import se.prediktera.breeze.frontend.main.play.realtime.SampleTrackRenderer;
import se.prediktera.breeze.hardware.Camera;

public abstract class CameraStreamPanel
extends AbstractViewPanel
implements CameraStreamAddOn {
    private final RgbFrameRasterer frameRasterer;
    private final ImagePostProcessor postProcessor;
    private final Timer refreshTimer;
    private CameraPanelInfoText infoText;
    private long capturedFrames;
    private long lastFrameNumber;
    private StreamImage image;
    private Camera camera;
    private final MeasuredFps measuredFps = new MeasuredFps();
    public boolean showFps = true;
    private final Font font = new Font("Dialog", 0, 18);
    private String fps;
    private boolean isPushbroom;
    private FrameCount cameraHeight;
    private int maxSize;
    private boolean doPostProcessing = true;
    private final CameraRenderPanel centerPanel = new CameraRenderPanel();

    public CameraStreamPanel(CameraPanelInfoText cameraPanelInfoText) {
        this.setLayout(new BorderLayout());
        this.centerPanel.setDoubleBuffered(true);
        this.add(this.centerPanel, "Center");
        this.infoText = cameraPanelInfoText;
        this.frameRasterer = this.createFrameRasterer();
        this.postProcessor = this.createPostProcessor();
        this.refreshTimer = new Timer(40, actionEvent -> {
            if (this.image != null) {
                this.image.render(this.getWidth(), this.getHeight());
                if (this.doPostProcessing) {
                    this.postProcessor.postProcessImage(this.image, this.lastFrameNumber);
                }
                this.repaint();
            }
        });
        this.addHierarchyListener(hierarchyEvent -> {
            if (this.isShowing()) {
                this.refreshTimer.start();
            } else {
                this.refreshTimer.stop();
            }
        });
        this.refreshTimer.start();
    }

    public CameraStreamPanel() {
        this(CameraPanelInfoText.WaitingForCamera);
    }

    protected ImagePostProcessor createPostProcessor() {
        return (streamImage, l) -> {};
    }

    public ImagePostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setDoPostProcessing(boolean bl) {
        this.doPostProcessing = bl;
    }

    protected RgbFrameRasterer createFrameRasterer() {
        return new DefaultRasterer();
    }

    public void setInfoText(CameraPanelInfoText cameraPanelInfoText) {
        this.infoText = cameraPanelInfoText;
        this.repaint();
    }

    @Override
    public void init(Camera camera, FrameCount frameCount) {
        this.init(camera, frameCount, camera.getWidth());
    }

    public void init(Camera camera, FrameCount frameCount, PixelWidth pixelWidth) {
        this.camera = camera;
        this.isPushbroom = camera.getType().equals((Object)Camera.CameraCaptureType.Linescan);
        this.capturedFrames = 0L;
        this.lastFrameNumber = 0L;
        if (this.image != null) {
            this.image.cleanUp();
        }
        if (this.isPushbroom) {
            this.image = new PushbroomStreamImage(frameCount, pixelWidth);
        } else {
            this.cameraHeight = ((Camera.SnapshotCamera)camera).getHeight();
            this.image = new SnapshotStreamImage(pixelWidth, this.cameraHeight);
        }
        this.maxSize = this.image.getMaxSize();
        this.fps = null;
        this.measuredFps.reset();
    }

    @Override
    public void apply(FrameStack frameStack) {
        if (this.image != null) {
            ++this.capturedFrames;
            this.lastFrameNumber = frameStack.getFrameNumber();
            this.image.rasterNext(this.frameRasterer, frameStack);
            this.measuredFps.increase();
        }
    }

    @Override
    public void stop() {
    }

    public long getCapturedFramesCount() {
        return this.capturedFrames;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void reset() {
        this.image = null;
        ImagePostProcessor imagePostProcessor = this.postProcessor;
        if (imagePostProcessor instanceof SampleTrackRenderer) {
            SampleTrackRenderer sampleTrackRenderer = (SampleTrackRenderer)imagePostProcessor;
            sampleTrackRenderer.reset();
        }
        this.repaint();
    }

    public void clear() {
        this.image.clear();
    }

    public boolean isCleaned() {
        return false;
    }

    public Camera camera() {
        return this.camera;
    }

    @Override
    public String getType() {
        return "CameraStreamPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public void setImageDirection(PushbroomStreamImage.ImageDirection imageDirection) {
        if (this.image != null) {
            this.image.setImageDirection(imageDirection);
        }
    }

    public PushbroomStreamImage.ImageDirection getImageDirection() {
        if (this.image != null) {
            return this.image.getImageDirection();
        }
        return PushbroomStreamImage.ImageDirection.Up;
    }

    public StreamImage getImage() {
        return this.image;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.image != null) {
            this.image.cleanUp();
        }
    }

    private class CameraRenderPanel
    extends JPanel {
        private CameraRenderPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (CameraStreamPanel.this.image != null) {
                CameraStreamPanel.this.image.draw(graphics, this.getWidth(), this.getHeight());
                if (CameraStreamPanel.this.showFps) {
                    graphics.setColor(Color.white);
                    graphics.setFont(CameraStreamPanel.this.font);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    if (CameraStreamPanel.this.fps != null) {
                        graphics.drawString(CameraStreamPanel.this.fps, 10, 10 + fontMetrics.getHeight());
                    }
                    if (CameraStreamPanel.this.measuredFps.getTime().ms > 1000L) {
                        float f = CameraStreamPanel.this.measuredFps.getActual().value;
                        if (CameraStreamPanel.this.isPushbroom) {
                            CameraStreamPanel.this.fps = RtDataFormat.toString(f, 4, false) + " fps";
                            CameraStreamPanel.this.measuredFps.reset();
                        } else if (CameraStreamPanel.this.measuredFps.getFrameIndex() > CameraStreamPanel.this.cameraHeight.value) {
                            CameraStreamPanel.this.fps = RtDataFormat.toString(f / (float)CameraStreamPanel.this.cameraHeight.value, 4, false) + " fps";
                            CameraStreamPanel.this.measuredFps.reset();
                        }
                    }
                }
            } else {
                CameraStreamPanel.this.infoText.draw(graphics, this.getWidth(), this.getHeight());
            }
        }
    }

    public static interface RgbFrameRasterer {
        public void rasterIntoRgbFrame(PushbroomStreamImage.RgbFrame var1, FrameStack var2);
    }

    public static interface ImagePostProcessor {
        public void postProcessImage(StreamImage var1, long var2);
    }

    public class DefaultRasterer
    implements RgbFrameRasterer {
        @Override
        public void rasterIntoRgbFrame(PushbroomStreamImage.RgbFrame rgbFrame, FrameStack frameStack) {
            RawFrame rawFrame = frameStack.getFrame();
            RgbBands rgbBands = CameraStreamPanel.this.camera.getRgbBands();
            int n = rgbBands.get(0);
            int n2 = rgbBands.get(1);
            int n3 = rgbBands.get(2);
            float f = CameraStreamPanel.this.camera.getMaxsignal().inverted();
            for (int i = 0; i < CameraStreamPanel.this.camera.getWidth().value; ++i) {
                int n4 = i * 3;
                rgbFrame.origframe[n4] = (byte)BreezeColor.toRGB(rawFrame.getFrameValue(n, i) * f);
                rgbFrame.origframe[n4 + 1] = (byte)BreezeColor.toRGB(rawFrame.getFrameValue(n2, i) * f);
                rgbFrame.origframe[n4 + 2] = (byte)BreezeColor.toRGB(rawFrame.getFrameValue(n3, i) * f);
            }
        }
    }

    public static interface StreamImage {
        public void rasterNext(RgbFrameRasterer var1, FrameStack var2);

        public void render(int var1, int var2);

        public void draw(Graphics var1, int var2, int var3);

        public void clear();

        public void setImageDirection(PushbroomStreamImage.ImageDirection var1);

        public Graphics2D getGraphics();

        public PushbroomStreamImage.ImageDirection getImageDirection();

        public float getImageScale();

        public int getWidth();

        public int getHeight();

        public TrackInfo getFrameNumberLineIndex(long var1);

        public boolean isInside(long var1);

        public Camera.CameraCaptureType getType();

        public int getMaxSize();

        public void cleanUp();
    }

    public record TrackInfo(int line, int age) {
        public static int MaxAge = 5;
    }
}

