/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization.camerastream;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.frame.RingBuffer;

public class PushbroomStreamImage
implements CameraStreamPanel.StreamImage {
    public static final int IMAGE_MIN_HEIGHT = 2500;
    private BufferedImage image;
    private final PixelWidth cameraWidth;
    private int panelWidth;
    private int panelHeight;
    private float imageScale;
    private int[] imageScaleArray;
    private ImageDirection imageDirection = ImageDirection.Up;
    private boolean directionChanged = false;
    private final NavigableMap<Long, CameraStreamPanel.TrackInfo> frameNumberIndexMap = new TreeMap<Long, CameraStreamPanel.TrackInfo>();
    private long startFrameNumber;
    private final PushbroomFrameBuffer offscreenBuffer;

    public PushbroomStreamImage(FrameCount frameCount, PixelWidth pixelWidth) {
        this.cameraWidth = pixelWidth;
        this.offscreenBuffer = frameCount != null && frameCount.isFixed() ? new PushbroomFrameBuffer(frameCount.value, pixelWidth) : new PushbroomFrameBuffer((int)(2500.0 * Math.max(1.0, (double)pixelWidth.value / 400.0)), pixelWidth);
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public float getImageScale() {
        return this.imageScale;
    }

    @Override
    public int getMaxSize() {
        return this.offscreenBuffer.getSize();
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return Camera.CameraCaptureType.Linescan;
    }

    @Override
    public void clear() {
        this.offscreenBuffer.setEmpty();
    }

    @Override
    public Graphics2D getGraphics() {
        return (Graphics2D)this.image.getGraphics();
    }

    @Override
    public void rasterNext(CameraStreamPanel.RgbFrameRasterer rgbFrameRasterer, FrameStack frameStack) {
        this.offscreenBuffer.rasterNext(rgbFrameRasterer, frameStack);
    }

    @Override
    public void render(int n, int n2) {
        RgbFrame rgbFrame;
        this.checkImageSize(n, n2);
        int n3 = this.offscreenBuffer.getFilled();
        int[] nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        int n4 = this.image.getWidth();
        int n5 = this.image.getHeight();
        this.frameNumberIndexMap.clear();
        if (n3 > 0 && (rgbFrame = this.offscreenBuffer.getFrame(0)) != null) {
            this.startFrameNumber = rgbFrame.frameNumber;
        }
        boolean bl = this.imageDirection.isFlipped();
        boolean bl2 = this.imageDirection.isFlow();
        boolean bl3 = this.imageDirection.isForward();
        if (this.imageDirection.isVertical()) {
            int n6 = Math.min(n3, n5);
            for (int i = 0; i < n6; ++i) {
                int n7;
                RgbFrame rgbFrame2;
                int n8 = bl3 ? n5 - i - 1 : i;
                int n9 = this.imageScaleArray[i];
                if (n9 >= n3 || (rgbFrame2 = this.offscreenBuffer.getFrame(bl2 ? n3 - n9 - 1 : n9)) == null) continue;
                byte[] byArray = rgbFrame2.origframe;
                int n10 = n8 * n4;
                for (n7 = 0; n7 < n4; ++n7) {
                    int n11 = bl ? n7 : n4 - n7 - 1;
                    int n12 = this.imageScaleArray[n7];
                    int n13 = n12 * 3;
                    nArray[n10 + n11] = (byArray[n13] & 0xFF) << 16 | (byArray[n13 + 1] & 0xFF) << 8 | byArray[n13 + 2] & 0xFF;
                }
                for (n7 = n9; n7 < this.imageScaleArray[i + 1]; ++n7) {
                    RgbFrame rgbFrame3 = this.offscreenBuffer.getFrame(bl2 ? n3 - n7 - 1 : n7);
                    if (rgbFrame3 == null) continue;
                    this.frameNumberIndexMap.put(rgbFrame3.frameNumber, new CameraStreamPanel.TrackInfo(i, 0));
                    this.startFrameNumber = rgbFrame3.frameNumber;
                }
            }
        } else {
            int n14 = Math.min(n3, n4);
            for (int i = 0; i < n14; ++i) {
                int n15;
                RgbFrame rgbFrame4;
                int n16 = bl ? i : n4 - i - 1;
                int n17 = this.imageScaleArray[i];
                if (n17 >= n3 || (rgbFrame4 = this.offscreenBuffer.getFrame(bl2 ? n3 - n17 - 1 : n17)) == null) continue;
                byte[] byArray = rgbFrame4.origframe;
                for (n15 = 0; n15 < n5; ++n15) {
                    int n18 = bl3 ? n15 : n5 - n15 - 1;
                    int n19 = this.imageScaleArray[n15];
                    int n20 = n19 * 3;
                    nArray[n18 * n4 + n16] = (byArray[n20] & 0xFF) << 16 | (byArray[n20 + 1] & 0xFF) << 8 | byArray[n20 + 2] & 0xFF;
                }
                for (n15 = n17; n15 < this.imageScaleArray[i + 1]; ++n15) {
                    RgbFrame rgbFrame5 = this.offscreenBuffer.getFrame(bl2 ? n3 - n15 - 1 : n15);
                    if (rgbFrame5 == null) continue;
                    this.frameNumberIndexMap.put(rgbFrame5.frameNumber, new CameraStreamPanel.TrackInfo(i, 0));
                    this.startFrameNumber = rgbFrame5.frameNumber;
                }
            }
        }
    }

    @Override
    public CameraStreamPanel.TrackInfo getFrameNumberLineIndex(long l) {
        CameraStreamPanel.TrackInfo trackInfo = (CameraStreamPanel.TrackInfo)this.frameNumberIndexMap.get(l);
        if (trackInfo != null) {
            return trackInfo;
        }
        Map.Entry<Long, CameraStreamPanel.TrackInfo> entry = this.frameNumberIndexMap.floorEntry(l);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean isInside(long l) {
        return l >= this.startFrameNumber;
    }

    private void checkImageSize(int n, int n2) {
        if (this.image == null || this.panelWidth != n || this.panelHeight != n2 || this.directionChanged) {
            this.panelWidth = Math.max(1, n);
            this.panelHeight = Math.max(1, n2);
            int n3 = this.panelWidth;
            int n4 = this.panelHeight;
            if (this.imageDirection.isVertical()) {
                if (this.panelWidth > this.cameraWidth.value) {
                    n3 = this.cameraWidth.value;
                    n4 = (int)Math.ceil((float)this.panelHeight * ((float)this.cameraWidth.value / (float)this.panelWidth));
                }
            } else if (this.panelHeight > this.cameraWidth.value) {
                n3 = (int)Math.ceil((float)this.panelWidth * ((float)this.cameraWidth.value / (float)this.panelHeight));
                n4 = this.cameraWidth.value;
            }
            this.image = new BufferedImage(n3, n4, 1);
            this.imageScale = 1.0f;
            if (this.imageDirection.isVertical()) {
                if (this.panelWidth < this.cameraWidth.value) {
                    this.imageScale = (float)this.cameraWidth.value / (float)this.panelWidth;
                }
            } else if (this.panelHeight < this.cameraWidth.value) {
                this.imageScale = (float)this.cameraWidth.value / (float)this.panelHeight;
            }
            int n5 = Math.max(this.panelWidth, this.panelHeight);
            this.imageScaleArray = new int[n5 + 1];
            for (int i = 0; i < this.imageScaleArray.length; ++i) {
                this.imageScaleArray[i] = (int)((float)i * this.imageScale);
            }
            this.directionChanged = false;
        }
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, n, n2, null);
        } else {
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    public void setImageDirection(ImageDirection imageDirection) {
        this.imageDirection = imageDirection;
        this.directionChanged = true;
    }

    @Override
    public ImageDirection getImageDirection() {
        return this.imageDirection;
    }

    @Override
    public void cleanUp() {
        this.offscreenBuffer.cleanUp();
        this.frameNumberIndexMap.clear();
    }

    public static enum ImageDirection {
        Up(true, true),
        Down(true, false),
        Left(false, false),
        Right(false, true),
        DownScan(true, false, true, false),
        RightScan(false, false, true, false);

        private final boolean vertical;
        private final boolean forward;
        private final boolean flipped;
        private final boolean flow;

        private ImageDirection(boolean bl, boolean bl2) {
            this(bl, bl2, bl2, true);
        }

        private ImageDirection(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.vertical = bl;
            this.forward = bl2;
            this.flipped = bl3;
            this.flow = bl4;
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public boolean isForward() {
            return this.forward;
        }

        public boolean isFlipped() {
            return this.flipped;
        }

        public boolean isFlow() {
            return this.flow;
        }

        public boolean shouldRotate() {
            return !this.forward && (!this.vertical || this.flow);
        }

        public static ImageDirection getDefaultVertical(boolean bl, boolean bl2) {
            return bl2 ? (bl ? DownScan : DownScan) : Down;
        }

        public static ImageDirection getDefaultHorizontal(boolean bl, boolean bl2) {
            return bl2 ? (bl ? RightScan : RightScan) : Left;
        }
    }

    private static class PushbroomFrameBuffer {
        private final RingBuffer<RgbFrame> buffer;

        public PushbroomFrameBuffer(int n, PixelWidth pixelWidth) {
            this.buffer = new RingBuffer<RgbFrame>(RgbFrame.class, n);
            while (this.buffer.getNext() == null) {
                this.buffer.putDirect(new RgbFrame(pixelWidth));
            }
            this.buffer.clear();
        }

        public void rasterNext(CameraStreamPanel.RgbFrameRasterer rgbFrameRasterer, FrameStack frameStack) {
            RgbFrame rgbFrame = this.buffer.getNextInc();
            if (rgbFrame != null) {
                rgbFrame.frameNumber = frameStack.getFrameNumber();
                rgbFrameRasterer.rasterIntoRgbFrame(rgbFrame, frameStack);
            }
        }

        public int getFilled() {
            return this.buffer.getFilled();
        }

        public RgbFrame getFrame(int n) {
            return this.buffer.get(n);
        }

        public void setEmpty() {
            this.buffer.clear();
        }

        public int getSize() {
            return this.buffer.getSize();
        }

        public void cleanUp() {
            this.buffer.cleanUp();
        }
    }

    public static class RgbFrame {
        public long frameNumber;
        public final int columns;
        public final byte[] origframe;

        public RgbFrame(PixelWidth pixelWidth) {
            this.columns = pixelWidth.value;
            this.origframe = new byte[3 * pixelWidth.value];
        }

        public void copyFrame(ByteFrame byteFrame) {
            System.arraycopy(byteFrame.origframe[0], 0, this.origframe, 0, this.columns * 3);
        }
    }
}

