/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view.visualization.camerastream;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.hardware.Camera;

public class SnapshotStreamImage
implements CameraStreamPanel.StreamImage {
    private final PixelWidth cameraWidth;
    private final FrameCount cameraHeight;
    private BufferedImage image;
    private int panelWidth;
    private int panelHeight;
    private float imageScale;
    private final SnapshotImageBuffers offscreenBuffer;
    private long startFrameNumber;
    private float ratio;

    public SnapshotStreamImage(PixelWidth pixelWidth, FrameCount frameCount) {
        this.cameraWidth = pixelWidth;
        this.cameraHeight = frameCount;
        this.offscreenBuffer = new SnapshotImageBuffers(pixelWidth, frameCount);
    }

    @Override
    public void rasterNext(CameraStreamPanel.RgbFrameRasterer rgbFrameRasterer, FrameStack frameStack) {
        this.offscreenBuffer.rasterNext(rgbFrameRasterer, frameStack);
    }

    @Override
    public void render(int n, int n2) {
        this.checkImageSize(n, n2);
        int[] nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        int n3 = this.image.getWidth();
        SnapshotImageBuffer snapshotImageBuffer = this.offscreenBuffer.getActual();
        PushbroomStreamImage.RgbFrame[] rgbFrameArray = snapshotImageBuffer.frames;
        this.startFrameNumber = rgbFrameArray[0].frameNumber;
        for (int i = 0; i < rgbFrameArray.length; ++i) {
            PushbroomStreamImage.RgbFrame rgbFrame = rgbFrameArray[i];
            if (rgbFrame == null) continue;
            byte[] byArray = rgbFrame.origframe;
            int n4 = i * n3;
            int n5 = 0;
            int n6 = 0;
            while (n5 < n3) {
                nArray[n4++] = (byArray[n6] & 0xFF) << 16 | (byArray[n6 + 1] & 0xFF) << 8 | byArray[n6 + 2] & 0xFF;
                ++n5;
                n6 += 3;
            }
        }
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        graphics.fillRect(0, 0, n, n2);
        graphics.drawImage(this.image, 0, 0, n, (int)((float)n * this.ratio), null);
    }

    @Override
    public void clear() {
        this.offscreenBuffer.setEmpty();
    }

    @Override
    public void setImageDirection(PushbroomStreamImage.ImageDirection imageDirection) {
    }

    @Override
    public Graphics2D getGraphics() {
        return (Graphics2D)this.image.getGraphics();
    }

    @Override
    public PushbroomStreamImage.ImageDirection getImageDirection() {
        return PushbroomStreamImage.ImageDirection.Up;
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getMaxSize() {
        return 0;
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return Camera.CameraCaptureType.Snapshot;
    }

    @Override
    public float getImageScale() {
        return this.imageScale;
    }

    @Override
    public CameraStreamPanel.TrackInfo getFrameNumberLineIndex(long l) {
        long l2 = l - this.startFrameNumber;
        long l3 = l2 / (long)this.cameraHeight.value;
        if (l3 > (long)(-CameraStreamPanel.TrackInfo.MaxAge) && l3 < 10L) {
            long l4 = l - this.offscreenBuffer.getStartFrameNumber();
            if (l3 <= 0L) {
                return new CameraStreamPanel.TrackInfo((int)(l4 % (long)this.cameraHeight.value), (int)Math.abs(l3) + 1);
            }
            return new CameraStreamPanel.TrackInfo((int)(l4 % (long)this.cameraHeight.value), 0);
        }
        return null;
    }

    @Override
    public boolean isInside(long l) {
        return false;
    }

    private void checkImageSize(int n, int n2) {
        if (this.image == null || this.panelWidth != n || this.panelHeight != n2) {
            this.panelWidth = Math.max(1, n);
            this.panelHeight = Math.max(1, n2);
            int n3 = this.cameraWidth.value;
            int n4 = this.cameraHeight.value;
            this.image = new BufferedImage(n3, n4, 1);
            this.ratio = (float)this.image.getHeight() / (float)this.image.getWidth();
            this.imageScale = 1.0f;
            if (this.panelWidth < this.cameraWidth.value) {
                this.imageScale = (float)this.cameraWidth.value / (float)this.panelWidth;
            }
        }
    }

    @Override
    public void cleanUp() {
        this.offscreenBuffer.cleanUp();
    }

    private static class SnapshotImageBuffers {
        private final FrameCount cameraHeight;
        private final SnapshotImageBuffer[] buffers;
        private int current = -1;
        private boolean allBuffersRendered;
        private Long startFrameNumber;

        public SnapshotImageBuffers(PixelWidth pixelWidth, FrameCount frameCount) {
            this.cameraHeight = frameCount;
            this.buffers = new SnapshotImageBuffer[5];
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i] = new SnapshotImageBuffer(pixelWidth, frameCount);
            }
        }

        public void setEmpty() {
            this.startFrameNumber = null;
            this.current = -1;
            this.allBuffersRendered = false;
        }

        public Long getStartFrameNumber() {
            return this.startFrameNumber;
        }

        public void rasterNext(CameraStreamPanel.RgbFrameRasterer rgbFrameRasterer, FrameStack frameStack) {
            long l;
            int n;
            long l2 = frameStack.getFrameNumber();
            if (this.startFrameNumber == null) {
                this.startFrameNumber = l2;
            }
            if ((n = (int)((l = l2 - this.startFrameNumber) % (long)this.cameraHeight.value)) == 0 && ++this.current >= this.buffers.length) {
                this.current = 0;
                this.allBuffersRendered = true;
            }
            if (this.current >= 0) {
                this.buffers[this.current].rasterNext(rgbFrameRasterer, frameStack, n);
            }
        }

        public SnapshotImageBuffer getActual() {
            int n = this.current - 1;
            if (n < 0) {
                n = this.allBuffersRendered ? this.buffers.length - 1 : 0;
            }
            return this.buffers[n];
        }

        public void cleanUp() {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i] = null;
            }
        }
    }

    private static class SnapshotImageBuffer {
        private final PushbroomStreamImage.RgbFrame[] frames;

        public SnapshotImageBuffer(PixelWidth pixelWidth, FrameCount frameCount) {
            this.frames = new PushbroomStreamImage.RgbFrame[frameCount.value];
            for (int i = 0; i < frameCount.value; ++i) {
                this.frames[i] = new PushbroomStreamImage.RgbFrame(pixelWidth);
            }
        }

        public void rasterNext(CameraStreamPanel.RgbFrameRasterer rgbFrameRasterer, FrameStack frameStack, int n) {
            rgbFrameRasterer.rasterIntoRgbFrame(this.frames[n], frameStack);
            this.frames[n].frameNumber = frameStack.getFrameNumber();
        }
    }
}

