/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.virtualkeyboard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import se.prediktera.breeze.frontend.common.swing.AbstractBreezeTextPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeKeyboard;
import se.prediktera.breeze.frontend.common.virtualkeyboard.lang.KeyEnums;

public class PanelVirtualKeyboardReal
extends JPanel {
    ResourceBundle keyBundle = null;
    AbstractBreezeTextPanel textComponent;
    Window window = null;
    Locale localeL;
    boolean poitToUp = false;
    boolean shiftBs = false;
    int layer = 1;
    int gap = 8;
    int tab = 4;
    private BreezeKeyboard breezeKeyboard;
    private JButton jBBackspace;
    private BreezeButton jBCtrl;
    private JButton jBEnter;
    private BreezeButton jBExe;
    private JButton jBR1B1;
    private JButton jBR1B10;
    private JButton jBR1B11;
    private JButton jBR1B12;
    private JButton jBR1B13;
    private JButton jBR1B2;
    private JButton jBR1B3;
    private JButton jBR1B4;
    private JButton jBR1B5;
    private JButton jBR1B6;
    private JButton jBR1B7;
    private JButton jBR1B8;
    private JButton jBR1B9;
    private JButton jBR2B1;
    private JButton jBR2B10;
    private JButton jBR2B11;
    private JButton jBR2B12;
    private JButton jBR2B13;
    private JButton jBR2B2;
    private JButton jBR2B3;
    private JButton jBR2B4;
    private JButton jBR2B5;
    private JButton jBR2B6;
    private JButton jBR2B7;
    private JButton jBR2B8;
    private JButton jBR2B9;
    private JButton jBR3B10;
    private JButton jBR3B11;
    private JButton jBR3B12;
    private JButton jBR3B13;
    private JButton jBR3B2;
    private JButton jBR3B3;
    private JButton jBR3B4;
    private JButton jBR3B5;
    private JButton jBR3B6;
    private JButton jBR3B7;
    private JButton jBR3B8;
    private JButton jBR3B9;
    private JButton jBR4B10;
    private JButton jBR4B11;
    private JButton jBR4B12;
    private JButton jBR4B2;
    private JButton jBR4B3;
    private JButton jBR4B4;
    private JButton jBR4B5;
    private JButton jBR4B6;
    private JButton jBR4B7;
    private JButton jBR4B8;
    private JButton jBR4B9;
    private JButton jBSpace;
    private JToggleButton jTBAlt_Gr;
    private JToggleButton jTBR3B1;
    private JToggleButton jTBR4B1;
    private JToggleButton jTBR4B13;

    public PanelVirtualKeyboardReal() {
        this.initComponents();
        this.jBBackspace.setName("backspaceKeyboardButton");
        this.jBCtrl.setName("setKeyboardButton");
        this.localeL = Locale.getDefault();
        this.localeL = Locale.of("en", "GB");
        try {
            this.keyBundle = ResourceBundle.getBundle("i18n.virtualkeyboard.Keyboard", this.localeL);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException(missingResourceException);
        }
        this.updateGUI();
    }

    public void setLayer(int n) {
        this.layer = n;
        this.jTBR4B13.setSelected(n == 1);
        this.jTBR4B1.setSelected(n == 1);
    }

    public void addContextKeyListener(MouseListener mouseListener) {
        this.jBCtrl.addMouseListener(mouseListener);
    }

    public void clearContextKeyListener() {
        this.jBCtrl.clearMouseListeners();
    }

    public int getGap() {
        return this.gap;
    }

    public Locale getLocaleL() {
        return this.localeL;
    }

    public int getTab() {
        return this.tab;
    }

    public AbstractBreezeTextPanel getTextComponent() {
        return this.textComponent;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean isAddKeyVisible() {
        return this.jBCtrl.isVisible();
    }

    public boolean isPoitToUp() {
        return this.poitToUp;
    }

    public boolean isShiftBs() {
        return this.shiftBs;
    }

    public void setAddKeyVisible(boolean bl) {
        if (bl) {
            this.jBCtrl.setText("Add");
        } else {
            this.jBCtrl.setText("Set");
        }
    }

    public void setBreezeKeyboard(BreezeKeyboard breezeKeyboard) {
        this.breezeKeyboard = breezeKeyboard;
    }

    public void setButtonFont(Font font) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JButton)) continue;
            JButton jButton = (JButton)component;
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setFont(font);
        }
    }

    public void setColor(Color color) {
        this.jBCtrl.setBackground(color);
        this.jBCtrl.setBorderColor(color);
        this.jBExe.setBackground(color);
        this.jBExe.setBorderColor(color);
    }

    public void setFocusToEXE() {
        this.jBExe.requestFocus();
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void setLocaleL(Locale locale) {
        this.localeL = locale;
        try {
            this.keyBundle = ResourceBundle.getBundle("i18n.virtualkeyboard.Keyboard", this.localeL);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException(missingResourceException);
        }
        this.updateGUI();
    }

    public void setPoitToUp(boolean bl) {
        this.poitToUp = bl;
    }

    public void setShiftBs(boolean bl) {
        this.shiftBs = bl;
    }

    public void setTab(int n) {
        this.tab = n;
    }

    public void setTextComponent(AbstractBreezeTextPanel abstractBreezeTextPanel) {
        this.textComponent = abstractBreezeTextPanel;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public void showEnter(boolean bl) {
        this.jBEnter.setVisible(bl);
    }

    public final void updateGUI() {
        switch (this.layer) {
            case 0: {
                this.jBR1B1.setText(this.keyBundle.getString(KeyEnums.jBR1B1.toString()));
                this.jBR1B2.setText(this.keyBundle.getString(KeyEnums.jBR1B2.toString()));
                this.jBR1B3.setText(this.keyBundle.getString(KeyEnums.jBR1B3.toString()));
                this.jBR1B4.setText(this.keyBundle.getString(KeyEnums.jBR1B4.toString()));
                this.jBR1B5.setText(this.keyBundle.getString(KeyEnums.jBR1B5.toString()));
                this.jBR1B6.setText(this.keyBundle.getString(KeyEnums.jBR1B6.toString()));
                this.jBR1B7.setText(this.keyBundle.getString(KeyEnums.jBR1B7.toString()));
                this.jBR1B8.setText(this.keyBundle.getString(KeyEnums.jBR1B8.toString()));
                this.jBR1B9.setText(this.keyBundle.getString(KeyEnums.jBR1B9.toString()));
                this.jBR1B10.setText(this.keyBundle.getString(KeyEnums.jBR1B10.toString()));
                this.jBR1B11.setText(this.keyBundle.getString(KeyEnums.jBR1B11.toString()));
                this.jBR1B12.setText(this.keyBundle.getString(KeyEnums.jBR1B12.toString()));
                this.jBR1B13.setText(this.keyBundle.getString(KeyEnums.jBR1B13.toString()));
                this.jBR2B2.setText(this.keyBundle.getString(KeyEnums.jBR2B2.toString()));
                this.jBR2B3.setText(this.keyBundle.getString(KeyEnums.jBR2B3.toString()));
                this.jBR2B4.setText(this.keyBundle.getString(KeyEnums.jBR2B4.toString()));
                this.jBR2B5.setText(this.keyBundle.getString(KeyEnums.jBR2B5.toString()));
                this.jBR2B6.setText(this.keyBundle.getString(KeyEnums.jBR2B6.toString()));
                this.jBR2B7.setText(this.keyBundle.getString(KeyEnums.jBR2B7.toString()));
                this.jBR2B8.setText(this.keyBundle.getString(KeyEnums.jBR2B8.toString()));
                this.jBR2B9.setText(this.keyBundle.getString(KeyEnums.jBR2B9.toString()));
                this.jBR2B10.setText(this.keyBundle.getString(KeyEnums.jBR2B10.toString()));
                this.jBR2B11.setText(this.keyBundle.getString(KeyEnums.jBR2B11.toString()));
                this.jBR2B12.setText(this.keyBundle.getString(KeyEnums.jBR2B12.toString()));
                this.jBR2B13.setText(this.keyBundle.getString(KeyEnums.jBR2B13.toString()));
                this.jBR3B2.setText(this.keyBundle.getString(KeyEnums.jBR3B2.toString()));
                this.jBR3B3.setText(this.keyBundle.getString(KeyEnums.jBR3B3.toString()));
                this.jBR3B4.setText(this.keyBundle.getString(KeyEnums.jBR3B4.toString()));
                this.jBR3B5.setText(this.keyBundle.getString(KeyEnums.jBR3B5.toString()));
                this.jBR3B6.setText(this.keyBundle.getString(KeyEnums.jBR3B6.toString()));
                this.jBR3B7.setText(this.keyBundle.getString(KeyEnums.jBR3B7.toString()));
                this.jBR3B8.setText(this.keyBundle.getString(KeyEnums.jBR3B8.toString()));
                this.jBR3B9.setText(this.keyBundle.getString(KeyEnums.jBR3B9.toString()));
                this.jBR3B10.setText(this.keyBundle.getString(KeyEnums.jBR3B10.toString()));
                this.jBR3B11.setText(this.keyBundle.getString(KeyEnums.jBR3B11.toString()));
                this.jBR3B12.setText(this.keyBundle.getString(KeyEnums.jBR3B12.toString()));
                this.jBR3B13.setText(this.keyBundle.getString(KeyEnums.jBR3B13.toString()));
                this.jBR4B2.setText(this.keyBundle.getString(KeyEnums.jBR4B2.toString()));
                this.jBR4B3.setText(this.keyBundle.getString(KeyEnums.jBR4B3.toString()));
                this.jBR4B4.setText(this.keyBundle.getString(KeyEnums.jBR4B4.toString()));
                this.jBR4B5.setText(this.keyBundle.getString(KeyEnums.jBR4B5.toString()));
                this.jBR4B6.setText(this.keyBundle.getString(KeyEnums.jBR4B6.toString()));
                this.jBR4B7.setText(this.keyBundle.getString(KeyEnums.jBR4B7.toString()));
                this.jBR4B8.setText(this.keyBundle.getString(KeyEnums.jBR4B8.toString()));
                this.jBR4B9.setText(this.keyBundle.getString(KeyEnums.jBR4B9.toString()));
                this.jBR4B10.setText(this.keyBundle.getString(KeyEnums.jBR4B10.toString()));
                this.jBR4B11.setText(this.keyBundle.getString(KeyEnums.jBR4B11.toString()));
                this.jBR4B12.setText(this.keyBundle.getString(KeyEnums.jBR4B12.toString()));
                this.jTBAlt_Gr.setText(this.keyBundle.getString(KeyEnums.jTBALT_GR.toString()));
                this.jTBAlt_Gr.setVisible(false);
                break;
            }
            case 1: {
                this.jBR1B1.setText(this.keyBundle.getString(KeyEnums.jBR1B1_0.toString()));
                this.jBR1B2.setText(this.keyBundle.getString(KeyEnums.jBR1B2_0.toString()));
                this.jBR1B3.setText(this.keyBundle.getString(KeyEnums.jBR1B3_0.toString()));
                this.jBR1B4.setText(this.keyBundle.getString(KeyEnums.jBR1B4_0.toString()));
                this.jBR1B5.setText(this.keyBundle.getString(KeyEnums.jBR1B5_0.toString()));
                this.jBR1B6.setText(this.keyBundle.getString(KeyEnums.jBR1B6_0.toString()));
                this.jBR1B7.setText(this.keyBundle.getString(KeyEnums.jBR1B7_0.toString()));
                this.jBR1B8.setText(this.keyBundle.getString(KeyEnums.jBR1B8_0.toString()));
                this.jBR1B9.setText(this.keyBundle.getString(KeyEnums.jBR1B9_0.toString()));
                this.jBR1B10.setText(this.keyBundle.getString(KeyEnums.jBR1B10_0.toString()));
                this.jBR1B11.setText(this.keyBundle.getString(KeyEnums.jBR1B11_0.toString()));
                this.jBR1B12.setText(this.keyBundle.getString(KeyEnums.jBR1B12_0.toString()));
                this.jBR1B13.setText(this.keyBundle.getString(KeyEnums.jBR1B13_0.toString()));
                this.jBR2B2.setText(this.keyBundle.getString(KeyEnums.jBR2B2_0.toString()));
                this.jBR2B3.setText(this.keyBundle.getString(KeyEnums.jBR2B3_0.toString()));
                this.jBR2B4.setText(this.keyBundle.getString(KeyEnums.jBR2B4_0.toString()));
                this.jBR2B5.setText(this.keyBundle.getString(KeyEnums.jBR2B5_0.toString()));
                this.jBR2B6.setText(this.keyBundle.getString(KeyEnums.jBR2B6_0.toString()));
                this.jBR2B7.setText(this.keyBundle.getString(KeyEnums.jBR2B7_0.toString()));
                this.jBR2B8.setText(this.keyBundle.getString(KeyEnums.jBR2B8_0.toString()));
                this.jBR2B9.setText(this.keyBundle.getString(KeyEnums.jBR2B9_0.toString()));
                this.jBR2B10.setText(this.keyBundle.getString(KeyEnums.jBR2B10_0.toString()));
                this.jBR2B11.setText(this.keyBundle.getString(KeyEnums.jBR2B11_0.toString()));
                this.jBR2B12.setText(this.keyBundle.getString(KeyEnums.jBR2B12_0.toString()));
                this.jBR2B13.setText(this.keyBundle.getString(KeyEnums.jBR2B13_0.toString()));
                this.jBR3B2.setText(this.keyBundle.getString(KeyEnums.jBR3B2_0.toString()));
                this.jBR3B3.setText(this.keyBundle.getString(KeyEnums.jBR3B3_0.toString()));
                this.jBR3B4.setText(this.keyBundle.getString(KeyEnums.jBR3B4_0.toString()));
                this.jBR3B5.setText(this.keyBundle.getString(KeyEnums.jBR3B5_0.toString()));
                this.jBR3B6.setText(this.keyBundle.getString(KeyEnums.jBR3B6_0.toString()));
                this.jBR3B7.setText(this.keyBundle.getString(KeyEnums.jBR3B7_0.toString()));
                this.jBR3B8.setText(this.keyBundle.getString(KeyEnums.jBR3B8_0.toString()));
                this.jBR3B9.setText(this.keyBundle.getString(KeyEnums.jBR3B9_0.toString()));
                this.jBR3B10.setText(this.keyBundle.getString(KeyEnums.jBR3B10_0.toString()));
                this.jBR3B11.setText(this.keyBundle.getString(KeyEnums.jBR3B11_0.toString()));
                this.jBR3B12.setText(this.keyBundle.getString(KeyEnums.jBR3B12_0.toString()));
                this.jBR3B13.setText(this.keyBundle.getString(KeyEnums.jBR3B13_0.toString()));
                this.jBR4B2.setText(this.keyBundle.getString(KeyEnums.jBR4B2_0.toString()));
                this.jBR4B3.setText(this.keyBundle.getString(KeyEnums.jBR4B3_0.toString()));
                this.jBR4B4.setText(this.keyBundle.getString(KeyEnums.jBR4B4_0.toString()));
                this.jBR4B5.setText(this.keyBundle.getString(KeyEnums.jBR4B5_0.toString()));
                this.jBR4B6.setText(this.keyBundle.getString(KeyEnums.jBR4B6_0.toString()));
                this.jBR4B7.setText(this.keyBundle.getString(KeyEnums.jBR4B7_0.toString()));
                this.jBR4B8.setText(this.keyBundle.getString(KeyEnums.jBR4B8_0.toString()));
                this.jBR4B9.setText(this.keyBundle.getString(KeyEnums.jBR4B9_0.toString()));
                this.jBR4B10.setText(this.keyBundle.getString(KeyEnums.jBR4B10_0.toString()));
                this.jBR4B11.setText(this.keyBundle.getString(KeyEnums.jBR4B11_0.toString()));
                this.jBR4B12.setText(this.keyBundle.getString(KeyEnums.jBR4B12_0.toString()));
                this.jTBAlt_Gr.setText(this.keyBundle.getString(KeyEnums.jTBALT_GR_0.toString()));
                break;
            }
            case 2: {
                this.jBR1B1.setText(this.keyBundle.getString(KeyEnums.jBR1B1_1.toString()));
                this.jBR1B2.setText(this.keyBundle.getString(KeyEnums.jBR1B2_1.toString()));
                this.jBR1B3.setText(this.keyBundle.getString(KeyEnums.jBR1B3_1.toString()));
                this.jBR1B4.setText(this.keyBundle.getString(KeyEnums.jBR1B4_1.toString()));
                this.jBR1B5.setText(this.keyBundle.getString(KeyEnums.jBR1B5_1.toString()));
                this.jBR1B6.setText(this.keyBundle.getString(KeyEnums.jBR1B6_1.toString()));
                this.jBR1B7.setText(this.keyBundle.getString(KeyEnums.jBR1B7_1.toString()));
                this.jBR1B8.setText(this.keyBundle.getString(KeyEnums.jBR1B8_1.toString()));
                this.jBR1B9.setText(this.keyBundle.getString(KeyEnums.jBR1B9_1.toString()));
                this.jBR1B10.setText(this.keyBundle.getString(KeyEnums.jBR1B10_1.toString()));
                this.jBR1B11.setText(this.keyBundle.getString(KeyEnums.jBR1B11_1.toString()));
                this.jBR1B12.setText(this.keyBundle.getString(KeyEnums.jBR1B12_1.toString()));
                this.jBR1B13.setText(this.keyBundle.getString(KeyEnums.jBR1B13_1.toString()));
                this.jBR2B2.setText(this.keyBundle.getString(KeyEnums.jBR2B2_1.toString()));
                this.jBR2B3.setText(this.keyBundle.getString(KeyEnums.jBR2B3_1.toString()));
                this.jBR2B4.setText(this.keyBundle.getString(KeyEnums.jBR2B4_1.toString()));
                this.jBR2B5.setText(this.keyBundle.getString(KeyEnums.jBR2B5_1.toString()));
                this.jBR2B6.setText(this.keyBundle.getString(KeyEnums.jBR2B6_1.toString()));
                this.jBR2B7.setText(this.keyBundle.getString(KeyEnums.jBR2B7_1.toString()));
                this.jBR2B8.setText(this.keyBundle.getString(KeyEnums.jBR2B8_1.toString()));
                this.jBR2B9.setText(this.keyBundle.getString(KeyEnums.jBR2B9_1.toString()));
                this.jBR2B10.setText(this.keyBundle.getString(KeyEnums.jBR2B10_1.toString()));
                this.jBR2B11.setText(this.keyBundle.getString(KeyEnums.jBR2B11_1.toString()));
                this.jBR2B12.setText(this.keyBundle.getString(KeyEnums.jBR2B12_1.toString()));
                this.jBR2B13.setText(this.keyBundle.getString(KeyEnums.jBR2B13_1.toString()));
                this.jBR3B2.setText(this.keyBundle.getString(KeyEnums.jBR3B2_1.toString()));
                this.jBR3B3.setText(this.keyBundle.getString(KeyEnums.jBR3B3_1.toString()));
                this.jBR3B4.setText(this.keyBundle.getString(KeyEnums.jBR3B4_1.toString()));
                this.jBR3B5.setText(this.keyBundle.getString(KeyEnums.jBR3B5_1.toString()));
                this.jBR3B6.setText(this.keyBundle.getString(KeyEnums.jBR3B6_1.toString()));
                this.jBR3B7.setText(this.keyBundle.getString(KeyEnums.jBR3B7_1.toString()));
                this.jBR3B8.setText(this.keyBundle.getString(KeyEnums.jBR3B8_1.toString()));
                this.jBR3B9.setText(this.keyBundle.getString(KeyEnums.jBR3B9_1.toString()));
                this.jBR3B10.setText(this.keyBundle.getString(KeyEnums.jBR3B10_1.toString()));
                this.jBR3B11.setText(this.keyBundle.getString(KeyEnums.jBR3B11_1.toString()));
                this.jBR3B12.setText(this.keyBundle.getString(KeyEnums.jBR3B12_1.toString()));
                this.jBR3B13.setText(this.keyBundle.getString(KeyEnums.jBR3B13_1.toString()));
                this.jBR4B2.setText(this.keyBundle.getString(KeyEnums.jBR4B2_1.toString()));
                this.jBR4B3.setText(this.keyBundle.getString(KeyEnums.jBR4B3_1.toString()));
                this.jBR4B4.setText(this.keyBundle.getString(KeyEnums.jBR4B4_1.toString()));
                this.jBR4B5.setText(this.keyBundle.getString(KeyEnums.jBR4B5_1.toString()));
                this.jBR4B6.setText(this.keyBundle.getString(KeyEnums.jBR4B6_1.toString()));
                this.jBR4B7.setText(this.keyBundle.getString(KeyEnums.jBR4B7_1.toString()));
                this.jBR4B8.setText(this.keyBundle.getString(KeyEnums.jBR4B8_1.toString()));
                this.jBR4B9.setText(this.keyBundle.getString(KeyEnums.jBR4B9_1.toString()));
                this.jBR4B10.setText(this.keyBundle.getString(KeyEnums.jBR4B10_1.toString()));
                this.jBR4B11.setText(this.keyBundle.getString(KeyEnums.jBR4B11_1.toString()));
                this.jBR4B12.setText(this.keyBundle.getString(KeyEnums.jBR4B12_1.toString()));
                this.jTBAlt_Gr.setText(this.keyBundle.getString(KeyEnums.jTBALT_GR_1.toString()));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = n2 / 15 - this.gap;
        int n4 = n / 5 - this.gap;
        int n5 = this.gap;
        int n6 = this.gap;
        this.jBR1B1.setBounds(n5, n6, n3, n4);
        this.jBR1B2.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B3.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B4.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B5.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B6.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B7.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B8.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B9.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B10.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B11.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B12.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR1B13.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBBackspace.setBounds(n5 += n3 + this.gap, n6, n3 * 2, n4);
        n5 = this.gap;
        this.jBR2B1.setBounds(n5, n6 += n4 + this.gap, n3 + this.gap + n3 / 2, n4);
        this.jBR2B2.setBounds(n5 += n3 + this.gap + n3 / 2 + this.gap, n6, n3, n4);
        this.jBR2B3.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B4.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B5.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B6.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B7.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B8.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B9.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B10.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B11.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B12.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR2B13.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBEnter.setBounds(n5 += n3 + this.gap, n6, n3 + n3 / 2 - this.gap, n4 + this.gap + n4);
        n5 = this.gap;
        this.jTBR3B1.setBounds(n5, n6 += n4 + this.gap, n3 + this.gap + n3 / 2, n4);
        this.jBR3B2.setBounds(n5 += n3 + this.gap + n3 / 2 + this.gap, n6, n3, n4);
        this.jBR3B3.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B4.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B5.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B6.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B7.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B8.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B9.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B10.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B11.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B12.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR3B13.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        n5 = this.gap;
        this.jTBR4B1.setBounds(n5, n6 += n4 + this.gap, n3 * 2 + this.gap, n4);
        this.jBR4B2.setBounds(n5 += n3 * 2 + this.gap + this.gap, n6, n3, n4);
        this.jBR4B3.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B4.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B5.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B6.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B7.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B8.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B9.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B10.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B11.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jBR4B12.setBounds(n5 += n3 + this.gap, n6, n3, n4);
        this.jTBR4B13.setBounds(n5 += n3 + this.gap, n6, n3 * 2, n4);
        n5 = this.gap;
        this.jBExe.setBounds(n5, n6 += n4 + this.gap, n3 * 2 + n3 / 2 + this.gap * 2, n4);
        this.jBSpace.setBounds(n5 += n3 * 5 + this.gap * 5, n6, n3 * 5 + this.gap * 4, n4);
        this.jTBAlt_Gr.setBounds(n5 += n3 * 5 + this.gap * 5, n6, n3 + n3 / 2 + this.gap, n4);
        this.jBCtrl.setBounds(n5 += n3 * 2 + n3 / 2 + this.gap * 2, n6, n3 * 2 + n3 / 2 + this.gap, n4);
    }

    private void initComponents() {
        this.jBR1B1 = new JButton();
        this.jBR1B2 = new JButton();
        this.jBR1B3 = new JButton();
        this.jBR1B4 = new JButton();
        this.jBR1B5 = new JButton();
        this.jBR1B6 = new JButton();
        this.jBR1B7 = new JButton();
        this.jBR1B8 = new JButton();
        this.jBR1B9 = new JButton();
        this.jBR1B10 = new JButton();
        this.jBR1B11 = new JButton();
        this.jBR1B12 = new JButton();
        this.jBR1B13 = new JButton();
        this.jBBackspace = new JButton();
        this.jBR2B1 = new JButton();
        this.jBR2B2 = new JButton();
        this.jBR2B3 = new JButton();
        this.jBR2B4 = new JButton();
        this.jBR2B5 = new JButton();
        this.jBR2B6 = new JButton();
        this.jBR2B7 = new JButton();
        this.jBR2B8 = new JButton();
        this.jBR2B9 = new JButton();
        this.jBR2B10 = new JButton();
        this.jBR2B11 = new JButton();
        this.jBR2B12 = new JButton();
        this.jBR2B13 = new JButton();
        this.jBEnter = new JButton();
        this.jTBR3B1 = new JToggleButton();
        this.jBR3B2 = new JButton();
        this.jBR3B3 = new JButton();
        this.jBR3B4 = new JButton();
        this.jBR3B5 = new JButton();
        this.jBR3B6 = new JButton();
        this.jBR3B7 = new JButton();
        this.jBR3B8 = new JButton();
        this.jBR3B9 = new JButton();
        this.jBR3B10 = new JButton();
        this.jBR3B11 = new JButton();
        this.jBR3B12 = new JButton();
        this.jBR3B13 = new JButton();
        this.jTBR4B1 = new JToggleButton();
        this.jBR4B2 = new JButton();
        this.jBR4B3 = new JButton();
        this.jBR4B4 = new JButton();
        this.jBR4B5 = new JButton();
        this.jBR4B6 = new JButton();
        this.jBR4B7 = new JButton();
        this.jBR4B8 = new JButton();
        this.jBR4B9 = new JButton();
        this.jBR4B10 = new JButton();
        this.jBR4B11 = new JButton();
        this.jBR4B12 = new JButton();
        this.jTBR4B13 = new JToggleButton();
        this.jBCtrl = new BreezeButton();
        this.jBSpace = new JButton();
        this.jTBAlt_Gr = new JToggleButton();
        this.jBExe = new BreezeButton();
        this.jBR1B1.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B1.addActionListener(this::jBR1B1ActionPerformed);
        this.jBR1B2.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B2.addActionListener(this::jBR1B2ActionPerformed);
        this.jBR1B3.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B3.addActionListener(this::jBR1B3ActionPerformed);
        this.jBR1B4.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B4.addActionListener(this::jBR1B4ActionPerformed);
        this.jBR1B5.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B5.addActionListener(this::jBR1B5ActionPerformed);
        this.jBR1B6.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B6.addActionListener(this::jBR1B6ActionPerformed);
        this.jBR1B7.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B7.addActionListener(this::jBR1B7ActionPerformed);
        this.jBR1B8.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B8.addActionListener(this::jBR1B8ActionPerformed);
        this.jBR1B9.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B9.addActionListener(this::jBR1B9ActionPerformed);
        this.jBR1B10.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B10.addActionListener(this::jBR1B10ActionPerformed);
        this.jBR1B11.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B11.addActionListener(this::jBR1B11ActionPerformed);
        this.jBR1B12.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B12.addActionListener(this::jBR1B12ActionPerformed);
        this.jBR1B13.setFont(new Font("Tahoma", 0, 18));
        this.jBR1B13.addActionListener(this::jBR1B13ActionPerformed);
        this.jBBackspace.setFont(new Font("Tahoma", 0, 18));
        this.jBBackspace.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/backspace.gif")));
        this.jBBackspace.addActionListener(this::jBBackspaceActionPerformed);
        this.jBR2B1.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B1.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/tab.gif")));
        this.jBR2B1.addActionListener(this::jBR2B1ActionPerformed);
        this.jBR2B2.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B2.addActionListener(this::jBR2B2ActionPerformed);
        this.jBR2B3.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B3.addActionListener(this::jBR2B3ActionPerformed);
        this.jBR2B4.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B4.addActionListener(this::jBR2B4ActionPerformed);
        this.jBR2B5.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B5.addActionListener(this::jBR2B5ActionPerformed);
        this.jBR2B6.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B6.addActionListener(this::jBR2B6ActionPerformed);
        this.jBR2B7.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B7.addActionListener(this::jBR2B7ActionPerformed);
        this.jBR2B8.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B8.addActionListener(this::jBR2B8ActionPerformed);
        this.jBR2B9.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B9.addActionListener(this::jBR2B9ActionPerformed);
        this.jBR2B10.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B10.addActionListener(this::jBR2B10ActionPerformed);
        this.jBR2B11.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B11.addActionListener(this::jBR2B11ActionPerformed);
        this.jBR2B12.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B12.addActionListener(this::jBR2B12ActionPerformed);
        this.jBR2B13.setFont(new Font("Tahoma", 0, 18));
        this.jBR2B13.addActionListener(this::jBR2B13ActionPerformed);
        this.jBEnter.setFont(new Font("Tahoma", 0, 18));
        this.jBEnter.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/enter.gif")));
        this.jBEnter.addActionListener(this::jBEnterActionPerformed);
        this.jTBR3B1.setFont(new Font("Tahoma", 0, 18));
        this.jTBR3B1.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/shiftInvert.gif")));
        this.jTBR3B1.addActionListener(this::jTBR3B1ActionPerformed);
        this.jBR3B2.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B2.addActionListener(this::jBR3B2ActionPerformed);
        this.jBR3B3.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B3.addActionListener(this::jBR3B3ActionPerformed);
        this.jBR3B4.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B4.addActionListener(this::jBR3B4ActionPerformed);
        this.jBR3B5.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B5.addActionListener(this::jBR3B5ActionPerformed);
        this.jBR3B6.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B6.addActionListener(this::jBR3B6ActionPerformed);
        this.jBR3B7.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B7.addActionListener(this::jBR3B7ActionPerformed);
        this.jBR3B8.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B8.addActionListener(this::jBR3B8ActionPerformed);
        this.jBR3B9.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B9.addActionListener(this::jBR3B9ActionPerformed);
        this.jBR3B10.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B10.addActionListener(this::jBR3B10ActionPerformed);
        this.jBR3B11.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B11.addActionListener(this::jBR3B11ActionPerformed);
        this.jBR3B12.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B12.addActionListener(this::jBR3B12ActionPerformed);
        this.jBR3B13.setFont(new Font("Tahoma", 0, 18));
        this.jBR3B13.addActionListener(this::jBR3B13ActionPerformed);
        this.jTBR4B1.setFont(new Font("Tahoma", 0, 18));
        this.jTBR4B1.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/shift.gif")));
        this.jTBR4B1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PanelVirtualKeyboardReal.this.jTBR4B1MouseClicked(mouseEvent);
            }
        });
        this.jTBR4B1.addActionListener(this::jTBR4B1ActionPerformed);
        this.jBR4B2.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B2.addActionListener(this::jBR4B2ActionPerformed);
        this.jBR4B3.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B3.addActionListener(this::jBR4B3ActionPerformed);
        this.jBR4B4.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B4.addActionListener(this::jBR4B4ActionPerformed);
        this.jBR4B5.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B5.addActionListener(this::jBR4B5ActionPerformed);
        this.jBR4B6.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B6.addActionListener(this::jBR4B6ActionPerformed);
        this.jBR4B7.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B7.addActionListener(this::jBR4B7ActionPerformed);
        this.jBR4B8.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B8.addActionListener(this::jBR4B8ActionPerformed);
        this.jBR4B9.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B9.addActionListener(this::jBR4B9ActionPerformed);
        this.jBR4B10.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B10.addActionListener(this::jBR4B10ActionPerformed);
        this.jBR4B11.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B11.addActionListener(this::jBR4B11ActionPerformed);
        this.jBR4B12.setFont(new Font("Tahoma", 0, 18));
        this.jBR4B12.addActionListener(this::jBR4B12ActionPerformed);
        this.jTBR4B13.setFont(new Font("Tahoma", 0, 18));
        this.jTBR4B13.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/shift.gif")));
        this.jTBR4B13.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PanelVirtualKeyboardReal.this.jTBR4B13MouseClicked(mouseEvent);
            }
        });
        this.jTBR4B13.addActionListener(this::jTBR4B13ActionPerformed);
        this.jBCtrl.setFont(new Font("Tahoma", 0, 18));
        this.jBCtrl.setText("Set");
        this.jBCtrl.setVisible(true);
        this.jBSpace.setFont(new Font("Tahoma", 0, 18));
        this.jBSpace.setIcon(new ImageIcon(this.getClass().getResource("/images/virtualkeyboard/space.gif")));
        this.jBSpace.addActionListener(this::jBSpaceActionPerformed);
        this.jTBAlt_Gr.setFont(new Font("Tahoma", 0, 18));
        this.jTBAlt_Gr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PanelVirtualKeyboardReal.this.jTBAlt_GrMouseClicked(mouseEvent);
            }
        });
        this.jTBAlt_Gr.addActionListener(this::jTBAlt_GrActionPerformed);
        this.jBExe.setFont(new Font("Tahoma", 0, 18));
        this.jBExe.setText("Cancel                                         ");
        this.jBExe.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PanelVirtualKeyboardReal.this.jBExeActionPerformed(null);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jBR2B5).addGap(5, 5, 5).addComponent(this.jBR2B6).addGap(5, 5, 5).addComponent(this.jBR2B7).addGap(5, 5, 5).addComponent(this.jBR2B8).addGap(5, 5, 5).addComponent(this.jBR2B9).addGap(5, 5, 5).addComponent(this.jBR2B10).addGap(5, 5, 5).addComponent(this.jBR2B11).addGap(5, 5, 5).addComponent(this.jBR2B12).addGap(5, 5, 5).addComponent(this.jBR2B13)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jBEnter).addGap(5, 5, 5).addComponent(this.jTBR3B1).addGap(5, 5, 5).addComponent(this.jBR3B2).addGap(5, 5, 5).addComponent(this.jBR3B3).addGap(5, 5, 5).addComponent(this.jBR3B4).addGap(5, 5, 5).addComponent(this.jBR3B5).addGap(5, 5, 5).addComponent(this.jBR3B6).addGap(5, 5, 5).addComponent(this.jBR3B7)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B8).addGap(5, 5, 5).addComponent(this.jBR3B9).addGap(5, 5, 5).addComponent(this.jBR3B10).addGap(5, 5, 5).addComponent(this.jBR3B11).addGap(5, 5, 5).addComponent(this.jBR3B12).addGap(5, 5, 5).addComponent(this.jBR3B13).addGap(5, 5, 5).addComponent(this.jTBR4B1).addGap(5, 5, 5).addComponent(this.jBR4B2).addGap(5, 5, 5).addComponent(this.jBR4B3)).addGroup(groupLayout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jBR4B4).addGap(5, 5, 5).addComponent(this.jBR4B5).addGap(5, 5, 5).addComponent(this.jBR4B6).addGap(5, 5, 5).addComponent(this.jBR4B7).addGap(5, 5, 5).addComponent(this.jBR4B8).addGap(5, 5, 5).addComponent(this.jBR4B9).addGap(5, 5, 5).addComponent(this.jBR4B10).addGap(5, 5, 5).addComponent(this.jBR4B11).addGap(5, 5, 5).addComponent(this.jBR4B12)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jBR1B1).addGap(5, 5, 5).addComponent(this.jBR1B2).addGap(5, 5, 5).addComponent(this.jBR1B3).addGap(5, 5, 5).addComponent(this.jBR1B4).addGap(5, 5, 5).addComponent(this.jBR1B5).addGap(5, 5, 5).addComponent(this.jBR1B6).addGap(5, 5, 5).addComponent(this.jBR1B7).addGap(5, 5, 5).addComponent(this.jBR1B8).addGap(5, 5, 5).addComponent(this.jBR1B9).addGap(5, 5, 5).addComponent(this.jBR1B10)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jBR1B11).addGap(5, 5, 5).addComponent(this.jBR1B12).addGap(5, 5, 5).addComponent(this.jBR1B13).addGap(5, 5, 5).addComponent(this.jBBackspace).addGap(5, 5, 5).addComponent(this.jBR2B1).addGap(5, 5, 5).addComponent(this.jBR2B2).addGap(5, 5, 5).addComponent(this.jBR2B3).addGap(5, 5, 5).addComponent(this.jBR2B4)).addGroup(groupLayout.createSequentialGroup().addGap(102, 102, 102).addComponent(this.jTBR4B13).addGap(5, 5, 5).addComponent(this.jBExe).addGap(5, 5, 5).addComponent(this.jBSpace).addGap(5, 5, 5).addComponent(this.jTBAlt_Gr))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBCtrl))).addContainerGap(245, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBR1B1).addComponent(this.jBR1B2).addComponent(this.jBR1B3).addComponent(this.jBR1B4).addComponent(this.jBR1B5).addComponent(this.jBR1B6).addComponent(this.jBR1B7).addComponent(this.jBR1B8).addComponent(this.jBR1B9).addComponent(this.jBR1B10)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR1B11)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR1B12)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR1B13)).addComponent(this.jBBackspace).addComponent(this.jBR2B1).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR2B2)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR2B3)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR2B4))).addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBR2B5).addComponent(this.jBR2B6).addComponent(this.jBR2B7).addComponent(this.jBR2B8).addComponent(this.jBR2B9).addComponent(this.jBR2B10).addComponent(this.jBR2B11).addComponent(this.jBR2B12).addComponent(this.jBR2B13)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBEnter).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTBR3B1)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B2)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B3)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B4)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B5)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B6)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBR3B7))).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B8)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B9)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B10)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B11)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B12)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR3B13)).addComponent(this.jTBR4B1).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR4B2)).addGroup(groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jBR4B3))).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBR4B4).addComponent(this.jBR4B5).addComponent(this.jBR4B6).addComponent(this.jBR4B7).addComponent(this.jBR4B8).addComponent(this.jBR4B9).addComponent(this.jBR4B10).addComponent(this.jBR4B11).addComponent(this.jBR4B12)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jTBR4B13)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jBExe)).addComponent(this.jBSpace).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jBCtrl).addComponent(this.jTBAlt_Gr))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jBBackspaceActionPerformed(ActionEvent actionEvent) {
        if (this.textComponent == null) {
            return;
        }
        if (this.textComponent.getSelectedText() != null) {
            this.textComponent.replaceSelection("");
        } else {
            String string = this.textComponent.getText();
            int n = this.textComponent.getCaretPosition();
            if (n > 0) {
                string = new StringBuilder(string).delete(n - 1, n).toString();
                this.textComponent.setText(string);
                this.textComponent.setCaretPosition(n - 1);
            }
        }
        this.textComponent.requestFocus();
    }

    private void jBEnterActionPerformed(ActionEvent actionEvent) {
        if (this.textComponent == null) {
            return;
        }
        String string = this.textComponent.getText();
        int n = this.textComponent.getCaretPosition();
        string = new StringBuilder(string).insert(n, "\n").toString();
        this.textComponent.setText(string);
        this.textComponent.setCaretPosition(n + 1);
        this.textComponent.requestFocus();
    }

    private void jBExeActionPerformed(ActionEvent actionEvent) {
        if (this.window != null) {
            this.window.setVisible(false);
            this.window.dispose();
        }
        if (this.breezeKeyboard != null) {
            this.breezeKeyboard.closeWithoutSave();
        }
    }

    private void jBR1B10ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B11ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B12ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B13ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B1ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B2ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B3ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B4ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B5ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B6ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B7ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B8ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR1B9ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B10ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B11ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B12ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B13ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B1ActionPerformed(ActionEvent actionEvent) {
        if (this.textComponent == null) {
            return;
        }
        String string = this.textComponent.getText();
        int n = this.textComponent.getCaretPosition();
        Object object = "";
        for (int i = 0; i < this.tab; ++i) {
            object = (String)object + " ";
        }
        string = new StringBuilder(string).insert(n, (String)object).toString();
        this.textComponent.setText(string);
        this.textComponent.setCaretPosition(n + ((String)object).length());
    }

    private void jBR2B2ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B3ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B4ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B5ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B6ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B7ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B8ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR2B9ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B10ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B11ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B12ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B13ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B2ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B3ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B4ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B5ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B6ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B7ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B8ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR3B9ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B10ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B11ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B12ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B2ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B3ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B4ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B5ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B6ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B7ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B8ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBR4B9ActionPerformed(ActionEvent actionEvent) {
        this.writeValue(actionEvent);
    }

    private void jBSpaceActionPerformed(ActionEvent actionEvent) {
        if (this.textComponent == null) {
            return;
        }
        String string = this.textComponent.getText();
        int n = this.textComponent.getCaretPosition();
        string = new StringBuilder(string).insert(n, " ").toString();
        this.textComponent.setText(string);
        this.textComponent.setCaretPosition(n + 1);
    }

    private void jTBAlt_GrActionPerformed(ActionEvent actionEvent) {
        this.layer = this.jTBAlt_Gr.isSelected() ? 2 : (this.jTBR3B1.isSelected() ? (this.jTBR4B13.isSelected() ? 0 : 1) : (this.jTBR4B13.isSelected() ? 1 : 0));
        this.jTBR4B1.setSelected(this.jTBR4B13.isSelected());
        this.updateGUI();
    }

    private void jTBAlt_GrMouseClicked(MouseEvent mouseEvent) {
    }

    private void jTBR3B1ActionPerformed(ActionEvent actionEvent) {
        this.layer = this.jTBR3B1.isSelected() ? (this.jTBR4B13.isSelected() ? 0 : 1) : (this.jTBR4B13.isSelected() ? 1 : 0);
        this.jTBAlt_Gr.setSelected(false);
        this.updateGUI();
    }

    private void jTBR4B13ActionPerformed(ActionEvent actionEvent) {
        this.layer = this.jTBR3B1.isSelected() ? (this.jTBR4B13.isSelected() ? 0 : 1) : (this.jTBR4B13.isSelected() ? 1 : 0);
        this.jTBAlt_Gr.setSelected(false);
        this.jTBR4B1.setSelected(this.jTBR4B13.isSelected());
        this.updateGUI();
    }

    private void jTBR4B13MouseClicked(MouseEvent mouseEvent) {
    }

    private void jTBR4B1ActionPerformed(ActionEvent actionEvent) {
        this.jTBR4B13.setSelected(this.jTBR4B1.isSelected());
        this.jTBR4B13ActionPerformed(actionEvent);
    }

    private void jTBR4B1MouseClicked(MouseEvent mouseEvent) {
        this.jTBR4B13.setSelected(this.jTBR4B1.isSelected());
        this.jTBR4B13MouseClicked(mouseEvent);
    }

    private void writeValue(ActionEvent actionEvent) {
        if (this.textComponent == null || ((JButton)actionEvent.getSource()).getText().equals("")) {
            return;
        }
        this.textComponent.replaceSelection("");
        String string = this.textComponent.getText();
        int n = this.textComponent.getCaretPosition();
        string = new StringBuilder(string).insert(n, ((JButton)actionEvent.getSource()).getText()).toString();
        this.textComponent.setText(string);
        this.textComponent.setCaretPosition(n + ((JButton)actionEvent.getSource()).getText().length());
        if (this.jTBR4B13.isSelected() && !this.jTBAlt_Gr.isSelected()) {
            this.layer = this.layer == 0 ? 1 : 0;
            this.jTBR4B13.setSelected(false);
            this.jTBR4B1.setSelected(false);
        }
        if (this.poitToUp && ((JButton)actionEvent.getSource()).getText().equals(".") && this.layer == 0) {
            this.layer = 1;
            this.jTBR4B1.setSelected(true);
            this.jTBR4B13.setSelected(true);
            this.updateGUI();
        }
        this.updateGUI();
        this.textComponent.requestFocus();
    }
}

