/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.hardware;

import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.hardware.tcp.Command;

public class ComPort {
    public static final ComPort Auto = new ComPort("Auto");
    public final String name;
    private final ComPort autoPreferedPort;

    public static ComPort fromXmlValue(String string) {
        if (string.startsWith(ComPort.Auto.name)) {
            if (string.contains("(")) {
                String string2 = string.substring(ComPort.Auto.name.length() + 1, string.length() - 1);
                return Auto.withPreferred(new ComPort(string2));
            }
            return Auto;
        }
        return new ComPort(string);
    }

    public static ComPort fromNumber(int n) {
        return new ComPort("COM" + n);
    }

    public ComPort(String string) {
        this(string, null);
    }

    private ComPort(String string, ComPort comPort) {
        this.name = string;
        this.autoPreferedPort = comPort;
    }

    public boolean isAuto() {
        return this.equals(Auto);
    }

    public ComPort withPreferred(ComPort comPort) {
        return new ComPort("Auto", comPort);
    }

    public ComPort autoPreferedPort() {
        return this.autoPreferedPort;
    }

    private int getInt() {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return -1;
        }
        return Integer.parseInt(this.name.substring(3));
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof ComPort) {
            return ((ComPort)object).name.equals(this.name);
        }
        return false;
    }

    public String toXmlValue() {
        if (this.autoPreferedPort != null) {
            return this.name + "(" + this.autoPreferedPort.name + ")";
        }
        return this.name;
    }

    public Command.Argument toCommandArgument() {
        return new Command.Argument("SerialPort", (Object)(this.equals(Auto) ? -1 : this.getInt()));
    }
}

