/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.hardware;

import java.util.List;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public class ConnectProgressAction {
    public static boolean anyHardwareNeedsConnect() {
        HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
        List<Camera> list = hardwareRegistry.getCamerasForRecord();
        for (Camera camera : list) {
            if (camera == null || camera.isConnected()) continue;
            return true;
        }
        SampleMover sampleMover = hardwareRegistry.getSampleMover();
        return sampleMover != null && !sampleMover.isConnected();
    }

    public static List<Camera> connectAll(BreezeProgressManager breezeProgressManager, BreezeFrame breezeFrame) {
        List<Camera> list = HardwareRegistry.getInstance().getCamerasForRecord();
        ConnectProgressAction.connectAll(breezeProgressManager, breezeFrame, list);
        return list;
    }

    public static List<Camera> connectAll(BreezeProgressManager breezeProgressManager, BreezeFrame breezeFrame, List<Camera> list) {
        HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
        for (Camera camera : list) {
            if (camera == null) continue;
            new ConnectProgressAction().connectCamera(breezeProgressManager, breezeFrame, camera);
        }
        new ConnectProgressAction().connectHardware(breezeProgressManager, breezeFrame, hardwareRegistry.getSampleMover());
        return list;
    }

    private boolean connectCamera(BreezeProgress breezeProgress, BreezeInterface breezeInterface, Camera camera) {
        if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
            if (this.connectHardware(breezeProgress, breezeInterface, camera) && breezeInterface instanceof BreezeFrame && camera.useReferencesWhenRecordingWithThisCamera() && camera.hasShutter()) {
                if (camera instanceof StateCamera) {
                    breezeProgress.setIndeterminate(true);
                    breezeProgress.setInfoText("Configuring initial parameters");
                } else {
                    breezeProgress.setInfoText("Taking dark reference");
                }
                TcpManager.getInstance().takeDarkReference(breezeProgress, true, TcpManager.ReferenceAction.Reference, null, camera.getId());
                return true;
            }
        } else if (camera == null || !camera.isConnected()) {
            TcpManager.getInstance().initializeRemoteCamera(breezeProgress, camera != null ? camera.getId() : 0);
        }
        return false;
    }

    private boolean connectHardware(BreezeProgress breezeProgress, BreezeInterface breezeInterface, Hardware hardware) {
        return this.connectHardware(breezeProgress, breezeInterface, ((BreezeFrame)breezeInterface).getRuntime(), hardware);
    }

    protected boolean connectHardware(BreezeProgress breezeProgress, BreezeInterface breezeInterface, BreezeRuntime breezeRuntime, Hardware hardware) {
        if (hardware != null && !hardware.isConnected()) {
            breezeProgress.setInfoText("Connecting to " + ConnectProgressAction.getHardwareName(hardware));
            hardware.connect(breezeProgress, breezeInterface);
            return true;
        }
        return false;
    }

    public static String getHardwareName(Object object) {
        if (object instanceof Hardware) {
            Hardware hardware = (Hardware)object;
            return ConnectProgressAction.getHardwareName(hardware);
        }
        return object.toString();
    }

    public static String getHardwareName(Hardware hardware) {
        if (hardware instanceof Camera) {
            Camera camera = (Camera)hardware;
            String string = camera.toString();
            String string2 = camera.getFormattedCameraType();
            if (string2.equals("FileReader")) {
                return string;
            }
            String string3 = Camera.getCameraTypeName(camera);
            if (string.equalsIgnoreCase(string3)) {
                return string;
            }
            return string + " using " + string3;
        }
        return hardware.toString();
    }

    public static boolean logAndShowErrorMessage(BreezeFrame breezeFrame, Exception exception, String string) {
        if (!(exception instanceof ErrorHandler.InformationMessageException)) {
            ErrorHandler.logAndReportException((String)("Exception occurred while connecting to " + string), (Throwable)exception);
        } else {
            Logg.info((String)exception.getMessage(), (Object[])new Object[0]);
        }
        SwingUtilities.invokeLater(() -> BreezeOptionDialog.showErrorDialog(breezeFrame, ErrorHandler.MessageException.getTitle((Exception)exception, (String)"Connection failed"), exception));
        return true;
    }

    public static abstract class ConnectMover {
        public ConnectMover(final BreezeFrame breezeFrame, String string) {
            final SampleMover sampleMover = HardwareRegistry.getInstance().getSampleMover();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ ConnectMover this$0;
                {
                    this.this$0 = connectMover;
                }

                @Override
                public void runAction() throws Exception {
                    new ConnectProgressAction().connectHardware(this.getProgressManager(), breezeFrame, sampleMover);
                    this.this$0.afterConnectionInProgress(this.getProgressManager(), sampleMover);
                }

                @Override
                public void actionComplete() {
                    this.this$0.afterConnection(sampleMover);
                }

                @Override
                public boolean actionFailed(Exception exception) {
                    return ConnectProgressAction.logAndShowErrorMessage(breezeFrame, exception, "sample mover");
                }
            }, string);
        }

        public void afterConnectionInProgress(BreezeProgress breezeProgress, SampleMover sampleMover) {
        }

        public void afterConnection(SampleMover sampleMover) {
        }
    }

    public static abstract class ConnectCamera {
        private final boolean firstConnection;

        public ConnectCamera(final BreezeFrame breezeFrame, final Camera camera) {
            if (camera == null) {
                throw new ErrorHandler.InformationMessageException("No camera selected");
            }
            this.firstConnection = !camera.isConnected();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ ConnectCamera this$0;
                {
                    this.this$0 = connectCamera;
                }

                @Override
                public void runAction() throws Exception {
                    new ConnectProgressAction().connectCamera(this.getProgressManager(), breezeFrame, camera);
                }

                @Override
                public void actionComplete() {
                    if (this.this$0.firstConnection) {
                        this.this$0.onFirstConnection(camera);
                    }
                    this.this$0.afterConnection(this.getProgressManager(), camera);
                }

                @Override
                public boolean actionFailed(Exception exception) {
                    this.this$0.onFailedConnection(exception);
                    return ConnectProgressAction.logAndShowErrorMessage(breezeFrame, exception, "camera");
                }
            }, "Connect");
        }

        public void onFirstConnection(Camera camera) {
        }

        public abstract void afterConnection(BreezeProgress var1, Camera var2);

        public void onFailedConnection(Exception exception) {
        }
    }

    public static abstract class ConnectAll {
        public ConnectAll(final BreezeFrame breezeFrame, final int n, String string) {
            final HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ ConnectAll this$0;
                {
                    this.this$0 = connectAll;
                }

                @Override
                public void runAction() throws Exception {
                    new ConnectProgressAction().connectCamera(this.getProgressManager(), breezeFrame, hardwareRegistry.getCamera(n));
                    new ConnectProgressAction().connectHardware(this.getProgressManager(), breezeFrame, hardwareRegistry.getSampleMover());
                }

                @Override
                public void actionComplete() {
                    Camera camera = hardwareRegistry.getCamera(n);
                    if (camera != null) {
                        this.this$0.afterConnection(this.getProgressManager(), camera, hardwareRegistry.getSampleMover());
                    }
                }

                @Override
                public boolean actionFailed(Exception exception) {
                    this.this$0.connectionFailed(exception);
                    return ConnectProgressAction.logAndShowErrorMessage(breezeFrame, exception, "hardware");
                }

                @Override
                public void actionAborted() {
                    this.this$0.connectionFailed(null);
                }
            }, string);
        }

        public abstract void afterConnection(BreezeProgress var1, Camera var2, SampleMover var3);

        public void connectionFailed(Exception exception) {
        }
    }

    public static abstract class ConnectAndOpenWizard {
        public ConnectAndOpenWizard(final BreezeFrame breezeFrame) {
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                private BreezeMainPanel panel;
                final /* synthetic */ ConnectAndOpenWizard this$0;
                {
                    this.this$0 = connectAndOpenWizard;
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Opening window");
                    List<Camera> list = ConnectProgressAction.connectAll(this.getProgressManager(), breezeFrame);
                    this.panel = this.this$0.getPanelAfterConnect(this.getProgressManager(), list, HardwareRegistry.getInstance().getSampleMover());
                }

                @Override
                public void actionComplete() {
                    breezeFrame.addPage(this.panel);
                }

                @Override
                public boolean actionFailed(Exception exception) {
                    return ConnectProgressAction.logAndShowErrorMessage(breezeFrame, exception, "camera");
                }
            }, "Connecting to hardware");
        }

        public abstract BreezeMainPanel getPanelAfterConnect(BreezeProgress var1, List<Camera> var2, SampleMover var3);
    }
}

