/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.hardware;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.tcp.TcpManagerTest;

public class ConnectProgressActionTest {
    @Test
    public void testConnectOkay() {
        final BoolHolder boolHolder = new BoolHolder(false);
        var var2_2 = new FakeCamera(this){

            @Override
            public boolean isConnected() {
                return boolHolder.getValue();
            }

            @Override
            public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
                boolHolder.set(true);
            }
        };
        new ConnectProgressAction().connectHardware(BreezeProgressManager.createEmpty(), null, new TcpManagerTest.FakeRuntime(), var2_2);
        MatcherAssert.assertThat((Object)var2_2.isConnected(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testConnectFailed() {
        final BoolHolder boolHolder = new BoolHolder(false);
        ConnectProgressAction connectProgressAction = new ConnectProgressAction();
        FakeCamera fakeCamera = new FakeCamera(this){

            @Override
            public boolean isConnected() {
                return boolHolder.getValue();
            }

            @Override
            public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
                throw new Camera.FailedToConnectException("Failed");
            }
        };
        try {
            connectProgressAction.connectHardware(BreezeProgressManager.createEmpty(), null, new TcpManagerTest.FakeRuntime(), fakeCamera);
        }
        catch (Camera.FailedToConnectException failedToConnectException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)boolHolder.getValue(), (Matcher)Matchers.is((Object)false));
    }
}

