/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.MainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.card.BreezeNodePanel;
import se.prediktera.breeze.frontend.main.BreezeMainTopCleanPanel;
import se.prediktera.breeze.frontend.main.MainComponents;
import se.prediktera.map.common.update.UpdateHelper;

public abstract class AbstractMainPanel
extends JPanel
implements MainPanelInterface {
    protected final BreezeFrame frame;
    private final BreezeGradientPanel bottomGradientPanel = new BreezeGradientPanel();
    protected final BreezeMainTopCleanPanel topPanel;
    private final MainComponents.ToolbarPanel toolbarPanel;
    protected final JPanel mainPanel = new JPanel(new BorderLayout());
    private final MainComponents.WorkspacePanel workspacePanel;

    public AbstractMainPanel(BreezeFrame breezeFrame, boolean bl) {
        super(new GridBagLayout());
        this.frame = breezeFrame;
        BreezeMasterCache.getInstance().getAnalyseList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel = new BreezeMainTopCleanPanel(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.topPanel, gridBagConstraints);
        this.mainPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (bl) {
            gridBagConstraints.fill = 1;
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.bottomGradientPanel.setPreferredSize(new Dimension(0, 65));
        this.bottomGradientPanel.setMinimumSize(new Dimension(0, 65));
        this.bottomGradientPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.bottomGradientPanel.add((Component)new MainComponents.MenuButton(this), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.workspacePanel = new MainComponents.WorkspacePanel();
        this.bottomGradientPanel.add((Component)this.workspacePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.toolbarPanel = new MainComponents.ToolbarPanel(this);
        this.bottomGradientPanel.add((Component)this.toolbarPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        this.add((Component)this.bottomGradientPanel, gridBagConstraints);
    }

    public final BreezeFrame getFrame() {
        return this.frame;
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        if (bl) {
            this.toolbarPanel.init();
        }
        this.toolbarPanel.onShow();
        this.workspacePanel.onShow();
    }

    @Override
    public final void cleanUp() {
    }

    public final void changeTheme(String string) {
        AbstractMainPanel.changeThemeClearInstance(this.getFrame(), string);
        this.updateTheme();
        this.repaint();
    }

    public static void changeThemeClearInstance(BreezeFrame breezeFrame, String string) {
        BreezeTheme.changeTheme(string);
        ThumbnailManager.clearInstance();
        BreezeNodePanel.clearCache();
        BreezeOptionDialog.clearIconCache();
        ToastHandler.getInstance().showToast(breezeFrame, StringHelper.formatLabel(string) + " theme selected");
    }

    protected void updateTheme() {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        Color color = breezeTheme.getMainPanelBackground();
        this.frame.setBackgroundFromTheme();
        this.bottomGradientPanel.setForeground(breezeTheme.getPredikteraMainColor());
        if (breezeTheme.isDarkMode()) {
            this.bottomGradientPanel.setBackground(breezeTheme.getPredikteraMainColor().darker());
        } else {
            this.bottomGradientPanel.setBackground(breezeTheme.getPredikteraMainColor().brighter());
        }
        this.setBackground(color);
        this.setForeground(color);
        this.toolbarPanel.updateTheme();
        this.topPanel.updateTheme();
    }

    protected UpdateHelper.Product getProduct() {
        return UpdateHelper.Product.Breeze;
    }

    protected String getVersion() {
        return "Version " + InitClass.getBreezeVersion().format(true);
    }
}

