/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeEditorPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.BreezeMainTopCleanPanel;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.WindowsVersionHelper;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.UniqueIdManager;

public class BreezeAboutDialog {
    public static final String COPYRIGHT = "Copyright \u00a9 2015-2025 <a href=\"https://prediktera.com\">Prediktera AB</a>. All Rights Reserved";

    public static String getVersionAndLicenseInfo() {
        Object object;
        Object object2;
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Prediktera Breeze ");
        stringBuilder.append(InitClass.getBreezeVersion().format(true));
        stringBuilder.append(" [");
        if (regInfo.getItem(ExtClassLoader.LicenseLibrary.BREEZE) != null) {
            stringBuilder.append(StringUtils.capitalize((String)regInfo.getItem((ExtClassLoader.LicenseLibrary)ExtClassLoader.LicenseLibrary.BREEZE).type.toString().toLowerCase()));
        } else {
            stringBuilder.append("NO LICENSE");
        }
        stringBuilder.append("]\n");
        stringBuilder.append(BreezeAboutDialog.getBuiltString());
        stringBuilder.append("\n");
        stringBuilder.append("Features:").append("\n");
        Object object3 = regInfo.features.iterator();
        while (object3.hasNext()) {
            object2 = (RegInfo.LicenseFeature)object3.next();
            stringBuilder.append("  ").append(object2).append("\n");
        }
        object2 = TcpManager.getInstance().getBreezeRuntimeManager();
        if (object2 instanceof BreezeRuntime && (object3 = object2).isAnyBreezeRuntimeRunning()) {
            stringBuilder.append("Breeze Runtime version: ").append(object3.getVersion().format(false));
            stringBuilder.append("\n");
            object2 = object3.getRuntimeBinaryFile();
            stringBuilder.append("Breeze Runtime path: ");
            stringBuilder.append(object2 == null ? "N/A" : ((File)object2).getAbsolutePath());
            stringBuilder.append("\n");
        }
        stringBuilder.append("DeviceId: ").append(UniqueIdManager.getDeviceId()).append("\n");
        stringBuilder.append("Licensed to ");
        stringBuilder.append(regInfo.email);
        stringBuilder.append(" (");
        stringBuilder.append(regInfo.company);
        stringBuilder.append(")\n");
        stringBuilder.append("Account id: ");
        stringBuilder.append(regInfo.ID);
        stringBuilder.append(", license id: ");
        stringBuilder.append(regInfo.LID);
        stringBuilder.append("\n");
        if (regInfo.isFeatureActive(RegInfo.LicenseFeature.Record)) {
            stringBuilder.append("Perpetual Recorder");
        } else if (regInfo.getDaysUntilExpire(UpdateHelper.Product.Breeze) > 0) {
            stringBuilder.append("Subscription is active until ");
            stringBuilder.append(BreezeAboutDialog.formatDate(Date.from(Instant.now().plus((long)regInfo.getDaysUntilExpire(UpdateHelper.Product.Breeze), ChronoUnit.DAYS))));
        } else {
            stringBuilder.append("Subscription is expired");
        }
        stringBuilder.append("\n");
        object3 = SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION;
        if (SystemUtils.IS_OS_LINUX) {
            try {
                object2 = new ProcessBuilder("lsb_release", "-a").start();
                object = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                try {
                    object3 = ((BufferedReader)object).lines().filter(string -> string.startsWith("Description:")).findFirst().map(string -> string.split(":", 2)[1].trim()).orElse("Description not found");
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (IOException iOException) {}
        } else if (SystemUtils.IS_OS_WINDOWS) {
            object3 = SystemUtils.OS_NAME + " " + WindowsVersionHelper.getWindowsVersionInfo();
        }
        stringBuilder.append("OS: ").append((String)object3).append(" ").append(SystemUtils.OS_ARCH);
        stringBuilder.append("\n");
        object2 = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        stringBuilder.append("Memory: ").append(FileUtils.byteCountToDisplaySize((long)object2.getTotalMemorySize())).append("\n");
        object = Runtime.getRuntime();
        String string2 = FileUtils.byteCountToDisplaySize((long)((Runtime)object).totalMemory());
        String string3 = FileUtils.byteCountToDisplaySize((long)((Runtime)object).freeMemory());
        String string4 = FileUtils.byteCountToDisplaySize((long)((Runtime)object).maxMemory());
        int n = ((Runtime)object).availableProcessors();
        stringBuilder.append("JVM memory: ").append("Total: ").append(string2).append(" , Free: ").append(string3).append(" , Max: ").append(string4).append(" \n");
        stringBuilder.append("Available logical cores: ").append(n).append("\n");
        stringBuilder.append("Java runtime version: ").append(SystemUtils.JAVA_RUNTIME_VERSION).append(" ").append(SystemUtils.OS_ARCH);
        stringBuilder.append("\n");
        stringBuilder.append("JVM: ").append(SystemUtils.JAVA_VM_NAME).append(" by ").append(SystemUtils.JAVA_VM_VENDOR);
        stringBuilder.append("\n");
        stringBuilder.append("Java binary: ").append(SystemUtils.getJavaHome().toPath().resolve("bin", new String[]{"java"}));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static void copyToClipboard() {
        StringSelection stringSelection = new StringSelection(BreezeAboutDialog.getVersionAndLicenseInfo());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private static String getBuiltString() {
        return "Build#" + se.prediktera.map.InitClass.getBuild() + ", built on " + BreezeAboutDialog.formatDate(se.prediktera.map.InitClass.getTimestamp());
    }

    private static String formatDate(Date date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy");
        Optional<Date> optional = Optional.ofNullable(date);
        Instant instant = optional.map(Date::toInstant).orElse(Instant.now());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return dateTimeFormatter.format(localDateTime);
    }

    public static void showProductInfoPopup(BreezeFrame breezeFrame) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        boolean bl = regInfo.hasAllLibrariesExpired(true);
        StringBuilder stringBuilder = new StringBuilder("<html><body><h2>Prediktera Breeze ");
        stringBuilder.append(InitClass.getBreezeVersion().format(true));
        stringBuilder.append(" [");
        if (bl && RegInfo.isRecordFeature()) {
            stringBuilder.append("RECORDER");
        } else {
            RegInfo.Item item = regInfo.getItem(ExtClassLoader.LicenseLibrary.BREEZE);
            if (item instanceof RegInfo.Item) {
                RegInfo.Item item2 = item;
                stringBuilder.append(StringUtils.capitalize((String)item2.type.toString().toLowerCase()));
            } else {
                stringBuilder.append("UNKNOWN");
            }
        }
        stringBuilder.append("]");
        stringBuilder.append("</h2>");
        stringBuilder.append(BreezeAboutDialog.getBuiltString());
        stringBuilder.append("<br/><br/>");
        stringBuilder.append("Java Runtime version: ").append(SystemUtils.JAVA_RUNTIME_VERSION);
        stringBuilder.append("<br/>");
        stringBuilder.append("VM: ").append(SystemUtils.JAVA_VM_NAME).append(" by ").append(SystemUtils.JAVA_VM_VENDOR);
        stringBuilder.append("<br/>");
        stringBuilder.append("Architecture: ").append(SystemUtils.OS_ARCH);
        stringBuilder.append("<br/>");
        stringBuilder.append("<br/>");
        stringBuilder.append("Licenced to ");
        if (regInfo.name != null) {
            stringBuilder.append(regInfo.name).append(" (").append(regInfo.email).append(")");
        } else if (regInfo.email != null) {
            stringBuilder.append(regInfo.email);
        } else if (regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder)) {
            stringBuilder.append("HySpex Customer");
        } else {
            stringBuilder.append("UNKNOWN");
        }
        if (regInfo.company != null) {
            stringBuilder.append(" at ").append(regInfo.company);
        }
        int n = regInfo.getDaysUntilExpire(UpdateHelper.Product.Breeze);
        int n2 = regInfo.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.SUPPORT);
        if (regInfo.isTrialLicense() && n > 0) {
            stringBuilder.append("<br/>");
            object4 = BreezeAboutDialog.formatDate(Date.from(Instant.now().plus((long)n, ChronoUnit.DAYS)));
            stringBuilder.append("<b>Trial:</b> ").append(n);
            if (n2 == 1) {
                stringBuilder.append(" day left - expires <strong>tomorrow</strong>");
            } else {
                stringBuilder.append(" days left - expires ").append((String)object4);
            }
            stringBuilder.append("</span>");
        } else if (n2 > 0) {
            stringBuilder.append("<br/>");
            object4 = BreezeAboutDialog.formatDate(Date.from(Instant.now().plus((long)n2, ChronoUnit.DAYS)));
            stringBuilder.append("Support subscription is active until ").append((String)object4);
        }
        stringBuilder.append("<br/><br/>").append("<b>Modules</b><br/>");
        if (n > 0) {
            int n3;
            stringBuilder.append("<ul>");
            object4 = BreezeAboutDialog.formatDate(Date.from(Instant.now().plus((long)n, ChronoUnit.DAYS)));
            object3 = "<span class='expire'> (until " + (String)object4 + ")</span>";
            if (RegInfo.isRecordFeature()) {
                stringBuilder.append("<li>Recorder</li>");
            }
            if (RegInfo.isGeoFeature()) {
                stringBuilder.append("<li>Geological analysis ").append((String)object3).append("</li>");
                stringBuilder.append("<li>Core scanning ").append((String)object3).append("</li>");
            }
            if ((n3 = regInfo.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZEAPI)) > 0) {
                object2 = BreezeAboutDialog.formatDate(Date.from(Instant.now().plus((long)n3, ChronoUnit.DAYS)));
                object = "<span class='expire'> (until " + (String)object2 + ")</span>";
                stringBuilder.append("<li>Runtime API ").append((String)object).append("</li>");
            }
            stringBuilder.append("</ul>");
        } else {
            stringBuilder.append("<i>None</i>");
        }
        stringBuilder.append("<br/><br/></body></html>");
        object4 = new BreezeEditorPane(stringBuilder.toString());
        ((BreezeEditorPane)object4).setFontSize(13);
        ((JComponent)object4).setOpaque(false);
        object3 = new JDialog(breezeFrame);
        ((Dialog)object3).setTitle("About Breeze");
        ((Dialog)object3).setModal(true);
        ((JDialog)object3).setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 20, 10, 20));
        jPanel.add((Component)object4, "Center");
        object2 = new BreezeEditorPane(COPYRIGHT);
        ((BreezeEditorPane)object2).setFontSize(11);
        jPanel.add((Component)object2, "South");
        jPanel.setBackground(BreezeTheme.getInstance().getDialogBackground());
        object = new JPanel();
        BreezeButton breezeButton = EntryMainHelper.createSmallTextButton("Copy and close", () -> BreezeAboutDialog.lambda$showProductInfoPopup$0((JDialog)object3));
        breezeButton.setPreferredAndMinimumSize(100, 22);
        breezeButton.setToolTipText("Copy text to clipboard");
        ((JComponent)object).setOpaque(true);
        ((JComponent)object).setBackground(BreezeTheme.getInstance().getDialogBackground());
        ((Container)object).add(breezeButton);
        ((Container)object).add(EntryMainHelper.createSmallTextButton("Close", ((JDialog)object3)::dispose));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ImageIcon imageIcon = ImageHelper.getResourceIcon(BreezeTheme.getInstance().isDarkMode() ? "logo/breeze_darkmode.png" : "logo/breeze.png", false);
        BreezeMainTopCleanPanel.TrailingDotIcon trailingDotIcon = new BreezeMainTopCleanPanel.TrailingDotIcon(imageIcon, regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder) || RegInfo.isRecordFeature() ? BreezeTheme.HYSPEX_COLOR : BreezeTheme.BREEZE_COLOR);
        JLabel jLabel = new JLabel(trailingDotIcon);
        jLabel.setOpaque(false);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setBackground(BreezeTheme.getInstance().getDialogBackground());
        jPanel2.setOpaque(true);
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jPanel, "Center");
        ((JDialog)object3).getContentPane().add((Component)jPanel3, "Center");
        ((JDialog)object3).getContentPane().add((Component)object, "South");
        ((Window)object3).setMinimumSize(new Dimension(550, 400));
        ((Window)object3).setSize(new Dimension(550, 600));
        ((Window)object3).setLocationRelativeTo(breezeFrame);
        ((Dialog)object3).setVisible(true);
    }

    static void main() {
        SwingUtilities.invokeLater(() -> {
            BreezeFrame breezeFrame = new BreezeFrame(UpdateHelper.Product.Breeze);
            breezeFrame.setDefaultCloseOperation(3);
            breezeFrame.setSize(900, 700);
            breezeFrame.setLocationRelativeTo(null);
            breezeFrame.setVisible(true);
            BreezeAboutDialog.showProductInfoPopup(breezeFrame);
        });
    }

    private static /* synthetic */ void lambda$showProductInfoPopup$0(JDialog jDialog) {
        BreezeAboutDialog.copyToClipboard();
        jDialog.dispose();
    }
}

