/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeEditorPane;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.RegisterTrialCustomPanel;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class BreezeMainTopCleanPanel
extends JPanel {
    private final BreezeLabel breezeLogoLabel = new BreezeLabel("", false, 48);
    private final JPanel companiesPanel = new JPanel(new BorderLayout());
    private final JPanel featuresPanel = new JPanel();
    private final BreezeEditorPane noticeLabel = new BreezeEditorPane("", this::handleHySpexRecorderUserRegistration);
    private final AbstractMainPanel mainPanel;

    public BreezeMainTopCleanPanel(AbstractMainPanel abstractMainPanel) {
        super(new BorderLayout());
        this.mainPanel = abstractMainPanel;
        this.setOpaque(false);
        BreezeLabel breezeLabel = new BreezeLabel();
        breezeLabel.setForeground(BreezeTheme.WHITE_TEXT);
        breezeLabel.setFontSize(12);
        breezeLabel.setText(abstractMainPanel.getVersion() + " " + this.getVersionTrail());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(0, 30));
        jPanel.setMinimumSize(new Dimension(0, 30));
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(2, 20, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)breezeLabel, gridBagConstraints);
        jPanel.setBackground(BreezeTheme.getInstance().getPredikteraMainColor().brighter());
        this.add((Component)jPanel, "North");
        this.setBreezeLogo();
        this.breezeLogoLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 8, 20));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)this.breezeLogoLabel, "North");
        this.featuresPanel.setOpaque(false);
        Box box = new Box(1);
        this.featuresPanel.setLayout(new BorderLayout());
        this.featuresPanel.add((Component)box, "North");
        this.featuresPanel.setBorder(BorderFactory.createEmptyBorder(0, 23, 20, 20));
        jPanel2.add((Component)this.featuresPanel, "Center");
        this.setFeatureTexts();
        this.add((Component)jPanel2, "West");
        this.noticeLabel.setOpaque(false);
        this.noticeLabel.setFontSize(14);
        this.noticeLabel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.add((Component)this.noticeLabel, "Center");
        this.setNoticeText();
        this.companiesPanel.setOpaque(false);
        this.companiesPanel.setPreferredSize(new Dimension(400, 80));
        this.companiesPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.add((Component)this.companiesPanel, "East");
    }

    private void setNoticeText() {
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        int n = regInfo.getDaysUntilExpire(UpdateHelper.Product.Breeze);
        boolean bl = IniFileReader.getInstance().isCameraInstalled("HySpex SDK");
        StringBuilder stringBuilder = new StringBuilder("<html><div style='text-align:center;'>");
        boolean bl2 = false;
        if (n >= 1 && regInfo.isTrialLicense() && (bl || RegInfo.isRecordFeature())) {
            stringBuilder.append("You have access to all features of Breeze during your <b>trial</b>.<br/>").append("In <b>").append(n).append("</b>").append(" day").append(n == 1 ? "" : "s").append(", the software will revert back to <a href=\"").append("https://help.prediktera.com/breeze/hyspex-recorder").append("\"><span style=\"font-family:'Proxima Nova Semibold'\">Breeze&nbsp;").append(bl ? "HySpex&nbsp;" : "").append("Recorder</span></a>.<br/>").append("Contact <a href=\"mailto:sales@prediktera.se\">sales@prediktera.se</a> ").append("to discuss licensing options.");
            bl2 = true;
        } else if (n >= 1 && regInfo.isTrialLicense()) {
            stringBuilder.append("You have access to all features of Breeze during your <b>trial</b>.<br/>").append("In <b>").append(n).append("</b>").append(" day").append(n == 1 ? "" : "s").append(", your trial license will expire.<br/>").append("Contact <a href=\"mailto:sales@prediktera.se\">sales@prediktera.se</a> ").append("to discuss licensing options.");
            bl2 = true;
        } else if (regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder)) {
            stringBuilder.append("You have perpetual access to <a href=\"").append("https://help.prediktera.com/breeze/hyspex-recorder").append("\"><strong><span style=\"font-family:'Proxima Nova Semibold'\">Breeze&nbsp;").append(bl ? "HySpex&nbsp;" : "").append("Recorder</span></strong></a>.<br/>").append("To unlock the full capabilities of Breeze, <a href='breeze://start_trial'>start your 30-day free trial</a>  or contact <a href=\"mailto:sales@prediktera.se\">sales@prediktera.se</a>.");
            bl2 = true;
        } else if (RegInfo.isRecordFeature() && n <= 0 && regInfo.isTrialLicense()) {
            stringBuilder.append("You have perpetual access to <a href=\"").append("https://help.prediktera.com/breeze/hyspex-recorder").append("\"><strong>Breeze&nbsp;").append(bl ? "HySpex&nbsp;" : "").append("Recorder</strong></a>.<br/>").append("To gain access to all Breeze modules, please contact ").append("<a href=\"mailto:sales@prediktera.se\">sales@prediktera.se</a>");
            bl2 = true;
        }
        stringBuilder.append("</div></html>");
        this.noticeLabel.setText(stringBuilder.toString());
        this.noticeLabel.setVisible(bl2);
    }

    private boolean handleHySpexRecorderUserRegistration(HyperlinkEvent hyperlinkEvent) {
        if (!StringHelper.startsWith((CharSequence)hyperlinkEvent.getDescription(), (CharSequence)"breeze://")) {
            return false;
        }
        BreezeOptionDialog.showDialog(this.mainPanel.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION.setDimensionOverrideHeight(450), "Register free full trial of Breeze", "", (AbstractBreezeCustomPanel)new RegisterTrialCustomPanel(this.mainPanel.getFrame()), null, null);
        return true;
    }

    public String getVersionTrail() {
        if (se.prediktera.map.InitClass.isInternal()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Internal Build: ");
            stringBuilder.append(InitClass.getBreezeVersion().build);
            if (se.prediktera.map.InitClass.getTimestamp() != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                stringBuilder.append(", Date: ").append(simpleDateFormat.format(se.prediktera.map.InitClass.getTimestamp()));
            }
            stringBuilder.append(", JRE Version: ").append(System.getProperty("java.version"));
            return stringBuilder.toString();
        }
        int n = InitClass.getBreezeVersion().build;
        return "Build-" + String.valueOf(n == 0 ? "DEVELOPMENT" : Integer.valueOf(n));
    }

    public void setBreezeLogo() {
        String string = BreezeTheme.getInstance().isDarkMode() ? "_darkmode" : "";
        ImageIcon imageIcon = ImageHelper.getResourceIcon("logo/breeze" + string, false);
        ImageIcon imageIcon2 = ImageHelper.getResourceIcon("logo/predikteraLowRes" + string, false);
        JLabel jLabel = new JLabel(imageIcon2);
        jLabel.setOpaque(false);
        jLabel.setCursor(BreezeFrame.getHandCursor());
        jLabel.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserLauncher.open((String)"https://prediktera.com");
            }
        });
        ImageIcon imageIcon3 = ImageHelper.getResourceIcon("logo/HySpex" + string, false);
        JLabel jLabel2 = new JLabel(imageIcon3);
        jLabel2.setOpaque(false);
        jLabel2.setCursor(BreezeFrame.getHandCursor());
        jLabel2.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserLauncher.open((String)"https://www.hyspex.com");
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        if (RegInfo.isRecordFeature() && RegisterKeyManager.getRegInfo().isTrialLicense() || RegInfo.isFeatureActiveStatic((RegInfo.LicenseFeature)RegInfo.LicenseFeature.HySpexRecorder)) {
            jPanel.add((Component)jLabel2, GridBagHelper.create(0, new Insets(20, 0, 0, 0)));
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jLabel, new GridBagConstraints());
        this.companiesPanel.removeAll();
        this.companiesPanel.add((Component)jPanel, "West");
        this.companiesPanel.add((Component)jPanel2, "East");
        TrailingDotIcon trailingDotIcon = new TrailingDotIcon(imageIcon, this.getBreezeTrailingDotColor());
        this.breezeLogoLabel.setIcon(trailingDotIcon);
    }

    public void updateTheme() {
        this.setBreezeLogo();
        this.setFeatureTexts();
        this.noticeLabel.updateTheme();
        this.repaint();
    }

    private Color getBreezeTrailingDotColor() {
        if (this.mainPanel.getProduct() == UpdateHelper.Product.BreezeRuntimeClient) {
            return BreezeTheme.RUNTIME_COLOR;
        }
        if (RegInfo.isRecordFeature() && (!RegisterKeyManager.getRegInfo().isTrialLicense() || RegisterKeyManager.getRegInfo().getDaysUntilExpire(UpdateHelper.Product.Breeze) <= 0)) {
            return BreezeTheme.HYSPEX_COLOR;
        }
        return BreezeTheme.BREEZE_COLOR;
    }

    private List<FeatureRow> getFeatures() {
        ArrayList<FeatureRow> arrayList = new ArrayList<FeatureRow>();
        boolean bl = IniFileReader.getInstance().isCameraInstalled("HySpex SDK");
        boolean bl2 = RegInfo.isFeatureActiveStatic((RegInfo.LicenseFeature)RegInfo.LicenseFeature.HySpexRecorder);
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        if (bl2 || regInfo.isTrialLicense() && regInfo.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZE) <= 0) {
            if (bl2 || bl && RegInfo.isRecordFeature()) {
                arrayList.add(new FeatureRow("HySpex Recorder", BreezeTheme.HYSPEX_COLOR, "https://help.prediktera.com/breeze/hyspex-recorder", false, 17));
            } else if (RegInfo.isRecordFeature()) {
                arrayList.add(new FeatureRow("Recorder", BreezeTheme.RECORDER_COLOR, "https://help.prediktera.com/breeze/recorder", false, 17));
            }
        }
        boolean bl3 = true;
        if (RegInfo.isGeoFeature()) {
            arrayList.add(new FeatureRow("Geological analysis", BreezeTheme.GEO_COLOR, "https://prediktera.com/breeze-suite/modules-and-features/modules/geological-analysis/", true));
            arrayList.add(new FeatureRow("Core scanning", BreezeTheme.CORESCANNER_COLOR, "https://prediktera.com/breeze-suite/modules-and-features/modules/core-scanning/", true));
            bl3 = false;
        }
        if (regInfo.getDaysLeft(ExtClassLoader.LicenseLibrary.BREEZEAPI) > 0) {
            arrayList.add(new FeatureRow("Runtime API", BreezeTheme.RUNTIME_COLOR, "https://prediktera.com/breeze-suite/modules-and-features/modules/runtime-api/", true));
            bl3 = false;
        }
        if (!bl2 && RegInfo.isRecordFeature()) {
            arrayList.add(new FeatureRow("Recorder", BreezeTheme.RECORDER_COLOR, "https://help.prediktera.com/breeze/recorder", false, bl3 ? 17 : 14));
        }
        return arrayList;
    }

    public void setFeatureTexts() {
        Box box = (Box)((BorderLayout)this.featuresPanel.getLayout()).getLayoutComponent("North");
        box.removeAll();
        if (this.mainPanel.getProduct() == UpdateHelper.Product.BreezeRuntimeClient) {
            BreezeLabel breezeLabel = new BreezeLabel("Runtime Client");
            breezeLabel.setFont(new Font("ProximaNova-Semibold", 1, 17));
            box.add(breezeLabel);
        } else {
            for (final FeatureRow featureRow : this.getFeatures()) {
                BreezeLabel breezeLabel = new BreezeLabel(featureRow.text());
                breezeLabel.setFont(new Font("ProximaNova-Semibold", 1, featureRow.fontSize));
                breezeLabel.setIconTextGap(6);
                if (featureRow.showDot) {
                    breezeLabel.setIcon(new FeatureIcon(featureRow.color()));
                }
                breezeLabel.setAlignmentX(0.0f);
                breezeLabel.addMouseListener(new MouseAdapter(this){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        BrowserLauncher.open((String)featureRow.uri);
                    }
                });
                breezeLabel.setCursor(BreezeFrame.getHandCursor());
                box.add(breezeLabel);
            }
        }
        this.featuresPanel.revalidate();
        this.featuresPanel.repaint();
    }

    public static final class TrailingDotIcon
    implements Icon {
        private final Icon base;
        private final Color color;
        private final int diameter;
        private final int gap;

        public TrailingDotIcon(Icon icon, Color color) {
            this.base = icon;
            this.color = color;
            this.diameter = 14;
            this.gap = 5;
        }

        @Override
        public int getIconWidth() {
            return this.base.getIconWidth() + this.gap + this.diameter;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.base.getIconHeight(), this.diameter);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.base.paintIcon(component, graphics2D, n, n2);
            int n3 = n + this.base.getIconWidth() + this.gap;
            int n4 = n2 + 23 + (this.getIconHeight() - this.diameter) / 2;
            graphics2D.setColor(this.color);
            graphics2D.fillOval(n3, n4, this.diameter, this.diameter);
            graphics2D.dispose();
        }
    }

    public record FeatureRow(String text, Color color, String uri, boolean showDot, int fontSize) {
        public FeatureRow(String string, Color color, String string2, boolean bl) {
            this(string, color, string2, bl, 14);
        }
    }

    public static final class FeatureIcon
    implements Icon {
        private final Color color;
        private final int size;

        public FeatureIcon(Color color) {
            this.color = color;
            this.size = 12;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = n2 + Math.max(0, (component.getFontMetrics(component.getFont()).getAscent() - this.size) / 2);
            graphics2D.setColor(this.color);
            graphics2D.fillOval(n, n3, this.size, this.size);
            graphics2D.dispose();
        }
    }
}

