/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.MainComponents;
import se.prediktera.map.register.RegInfo;

public class BreezeMainTopPanel
extends JPanel {
    private final Image backgroundImage = RegInfo.isGeoFeature() ? ImageHelper.getResourceIcon("logo/geobg1", false).getImage() : (RegInfo.isApplicationFeature() ? ImageHelper.getResourceIcon("logo/bg1", false).getImage() : ImageHelper.getResourceIcon("logo/recorderbg1", false).getImage());
    private final Image gradientBackgroundImage = ImageHelper.getResourceIcon("logo/topgradient", false).getImage();

    public BreezeMainTopPanel(MainComponents.VersionPanel versionPanel) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setMinimumSize(new Dimension(0, 150));
        imagePanel.setPreferredSize(new Dimension(0, 150));
        imagePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        imagePanel.add((Component)versionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(20, 0, 20, 20);
        imagePanel.add((Component)versionPanel.getPredikteraLogoLabel(), gridBagConstraints);
        this.add((Component)imagePanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(50, 25));
        jPanel.setPreferredSize(new Dimension(50, 25));
        jPanel.setBackground(BreezeTheme.getInstance().getPredikteraMainColor());
        this.add((Component)jPanel, "South");
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (BreezeFrame.isProjectMainFeature()) {
                int n = this.getWidth();
                int n2 = BreezeMainTopPanel.this.backgroundImage.getWidth(this);
                int n3 = BreezeMainTopPanel.this.backgroundImage.getHeight(this);
                int n4 = Math.min(n, n2);
                graphics.drawImage(BreezeMainTopPanel.this.backgroundImage, 0, 0, n, 150, 0, 0, n4, n3, this);
                graphics.drawImage(BreezeMainTopPanel.this.gradientBackgroundImage, 0, 0, this.getWidth(), 150, this);
            }
        }
    }
}

