/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Date;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.common.update.UpdatePanel;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class BreezeUpdatePanel
extends AbstractBreezeCustomPanel
implements UpdatePanel.UpdateCallback {
    private final BreezeFrame frame;
    private final UpdatePanel updatePanel;
    private final BreezeCheckBox hideUpdateDialogCheckBox = new BreezeCheckBox("Don't show this dialog again", false);
    private BreezeButton okButton;
    private ProgressManager pManager;
    private final UpdateHelper.DownloadFile downloadFile;

    public BreezeUpdatePanel(BreezeFrame breezeFrame, UpdateHelper.DownloadFile downloadFile) {
        this.frame = breezeFrame;
        this.downloadFile = downloadFile;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.updatePanel = new UpdatePanel(downloadFile, (UpdatePanel.UpdateCallback)this, BreezeTheme.getInstance().getLabelForeground());
        this.updatePanel.hideButtons();
        this.updatePanel.setOpaque(false);
        this.add((Component)this.updatePanel, "Center");
        this.hideUpdateDialogCheckBox.setSelected(!BreezeProperties.getInstance().isShowUpdateDialog());
        this.hideUpdateDialogCheckBox.addItemListener(itemEvent -> BreezeProperties.getInstance().setShowUpdateDialog(!this.hideUpdateDialogCheckBox.isSelected()));
        this.add((Component)this.hideUpdateDialogCheckBox, "South");
        this.setPreferredSize(new Dimension(560, 520));
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public void okPressed(boolean bl) {
        this.okButton.setEnabled(false);
        this.pManager = this.updatePanel.startDownload();
    }

    @Override
    public void cancelPressed() {
        if (this.pManager != null) {
            this.pManager.abort();
        }
        super.cancelPressed();
    }

    public void cancel() {
    }

    public void downloadComplete(File file) {
        super.okPressed(false);
        switch (this.downloadFile.getPlatform()) {
            case Linux: 
            case LinuxArm: 
            case Unknown: {
                break;
            }
            case MacOSX: {
                BreezeOptionDialog.showDialog(this.frame, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Download complete", UpdateHelper.getMacOSXText((UpdateHelper.Product)UpdateHelper.Product.Breeze), null);
                break;
            }
            case Windows: {
                BreezeOptionDialog.showDialog(this.frame, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Download complete", UpdateHelper.getRestartText((UpdateHelper.Product)UpdateHelper.Product.Breeze), breezeActionEvent -> {
                    UpdateHelper.runExe((File)file);
                    this.frame.localWindowClosing(BreezeProgressManager.createEmpty());
                    System.exit(0);
                });
            }
        }
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        this.okButton = breezeButton2;
        RegInfo.Item item = RegisterKeyManager.getRegInfo().getItem(ExtClassLoader.LicenseLibrary.SUPPORT);
        boolean bl = true;
        if (item != null) {
            bl = new Date(item.expired).compareTo(new Date()) > 0;
        }
        breezeButton2.setVisible(bl);
        if (bl) {
            breezeButton2.setText("Download");
        } else {
            breezeButton3.setText("Close");
        }
    }
}

