/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.main.MainClass;

public class MainButton
extends JPanel
implements ListCellRenderer {
    private final JPanel borderPanel = new JPanel(new GridBagLayout());
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    private final JTextArea descTextArea = new JTextArea();
    private final JLabel iconLabel = new JLabel();
    private final BreezeGradientPanel iconPanel = new BreezeGradientPanel();
    private final JLabel textLabel = new JLabel();
    private int buttonSize;

    public MainButton() {
        super(new GridBagLayout());
        this.setBackground(new Color(0, 0, 0));
        this.setCursor(new Cursor(0));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.borderPanel.setBackground(new Color(0, 0, 0));
        this.centerPanel.setBackground(new Color(102, 102, 102));
        this.iconPanel.setLayout(new GridBagLayout());
        this.iconLabel.setBackground(new Color(102, 102, 102));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.iconPanel.add((Component)this.iconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerPanel.add((Component)this.iconPanel, gridBagConstraints);
        this.textLabel.setForeground(new Color(255, 255, 255));
        this.textLabel.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        this.centerPanel.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.borderPanel.add((Component)this.centerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 20);
        this.add((Component)this.borderPanel, gridBagConstraints);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setOpaque(false);
        this.descTextArea.setRows(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 20);
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.iconLabel.setText("");
        this.iconPanel.setRound(true);
        this.updateTheme();
    }

    public void updateTheme() {
        this.descTextArea.setForeground(BreezeTheme.getInstance().getLabelForegroundDifuse());
    }

    public void setButtonSize(int n) {
        this.buttonSize = n;
        int n2 = (int)((double)n / 1.8);
        this.iconPanel.setMinimumSize(new Dimension(n2, n2));
        this.iconPanel.setMaximumSize(new Dimension(n2, n2));
        this.iconPanel.setPreferredSize(new Dimension(n2, n2));
        int n3 = (int)((double)n / 3.5);
        this.textLabel.setFont(new Font("Tahoma", 0, (int)((double)n3 / 2.4)));
        this.descTextArea.setMinimumSize(new Dimension(0, n3));
        this.descTextArea.setMaximumSize(new Dimension(0, n3));
        this.descTextArea.setPreferredSize(new Dimension(0, n3));
        this.descTextArea.setFont(new Font("Tahoma", 0, n3 / 4));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        MainClass mainClass = (MainClass)object;
        BreezeList breezeList = (BreezeList)((Object)jList);
        breezeList.updateBorder(object, this.borderPanel, mainClass.getColor());
        this.centerPanel.setBackground(mainClass.getColor());
        this.iconLabel.setIcon(mainClass.getIcon((int)((double)this.buttonSize / 5.2)));
        this.iconPanel.setBackground(mainClass.getColor());
        this.iconPanel.setForeground(mainClass.getDColor());
        this.textLabel.setText(mainClass.getName());
        this.descTextArea.setText(mainClass.getDescription());
        return this;
    }
}

