/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class MainClass {
    private BreezeType type;
    private String name;
    private String description;
    private final Color color;
    private final Color dcolor;
    private final Color ddcolor;
    private BufferedImage image;
    private ImageIcon imageIcon;

    public MainClass(BreezeType breezeType, String string) {
        this.type = breezeType;
        this.name = breezeType.getDesc();
        this.description = string;
        URL uRL = BreezeFrame.class.getResource("/images/" + String.valueOf((Object)breezeType) + "IconLarge.png");
        if (uRL != null) {
            try {
                this.image = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.color = breezeType.getColor();
        this.dcolor = this.color.darker();
        this.ddcolor = this.dcolor.darker();
    }

    public Color getColor() {
        return this.color;
    }

    public Color getDColor() {
        return this.dcolor;
    }

    public Color getDdColor() {
        return this.ddcolor;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageIcon getIcon(int n) {
        if (this.imageIcon == null || this.imageIcon.getIconWidth() != n) {
            this.imageIcon = this.image != null && n > 0 ? new ImageIcon(ImageHelper.getScaledImage(this.image, n, n, null)) : new ImageIcon();
        }
        return this.imageIcon;
    }

    public String getName() {
        return this.name;
    }

    public BreezeType getType() {
        return this.type;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(BreezeType breezeType) {
        this.type = breezeType;
    }
}

