/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.BreezeAboutDialog;
import se.prediktera.breeze.frontend.main.NoticeButton;
import se.prediktera.breeze.frontend.main.WelcomePanel;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class MainComponents {

    public static class WorkspacePanel
    extends JPanel {
        private final BreezeLabel workspaceValue = new BreezeLabel();

        public WorkspacePanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
            BreezeLabel breezeLabel = new BreezeLabel();
            breezeLabel.setForeground(BreezeTheme.WHITE_TEXT);
            breezeLabel.setText("Workspace:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            this.add((Component)breezeLabel, gridBagConstraints);
            this.workspaceValue.setText("Location");
            this.workspaceValue.setForeground(BreezeTheme.WHITE_TEXT);
            this.workspaceValue.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    FileHelper.openExplorerOnPath(new File(workspaceValue.getText()));
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            this.workspaceValue.setHorizontalTextPosition(2);
            this.workspaceValue.setIcon(ImageHelper.changeGrayBrightness(ImageHelper.getResourceIcon("material/open_in_browser", false), 100));
            String string = "Open in Files";
            if (SystemUtils.IS_OS_WINDOWS) {
                string = "Open in File Explorer";
            } else if (SystemUtils.IS_OS_MAC) {
                string = "Open in Finder";
            }
            this.workspaceValue.setToolTipText(string);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.add((Component)this.workspaceValue, gridBagConstraints);
            this.workspaceValue.setCursor(BreezeFrame.getHandCursor());
        }

        public void onShow() {
            this.workspaceValue.setText(BreezeProperties.getWorkspace().getPath().toFile().getAbsolutePath());
        }
    }

    public static class MenuButton
    extends BreezeButton {
        private final BreezeFrame frame;

        public MenuButton(AbstractMainPanel abstractMainPanel) {
            this.frame = abstractMainPanel.getFrame();
            this.setIcon(ImageHelper.changeGrayBrightness(ImageHelper.getResourceIcon("material/menu"), 100));
            this.setDesc("Menu");
            this.setDescForegroundReal(BreezeTheme.WHITE_TEXT);
            this.setName("exitLabel");
            this.addClickCallBack(() -> {
                BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.frame, null);
                breezeContextMenu.addButtonCloseClick("Manage license...", () -> new RegisterWizard(RegisterKeyManager.getRegInfo(), abstractMainPanel.getProduct()).executeWizard((Frame)this.frame, abstractMainPanel.getProduct(), InitClass.getBreezeVersion()));
                breezeContextMenu.addButtonCloseClick("Switch workspace...", this.frame::switchWorkspace);
                breezeContextMenu.addButtonCloseClick("Empty recycle bin", () -> BreezeRecycleBin.clear(abstractMainPanel));
                breezeContextMenu.addButtonCloseClick("Export log files", () -> this.ExportLogFiles(abstractMainPanel));
                breezeContextMenu.addButtonCloseClick("About", () -> BreezeAboutDialog.showProductInfoPopup(this.frame));
                breezeContextMenu.addButtonCloseClick("Exit Breeze", this.frame::stop);
                breezeContextMenu.setDrawArrow(false);
                this.frame.add((Component)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(SwingUtilities.convertPoint(this, 0, -100, abstractMainPanel));
            });
        }

        public void ExportLogFiles(AbstractMainPanel abstractMainPanel) {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save log archive", (Component)abstractMainPanel);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH_mm");
            jopensaveDialog2.setFileName("Breeze_Log_Files_" + simpleDateFormat.format(new Date()) + ".zip");
            if (jopensaveDialog2.saveshow()) {
                Object iOException;
                WorkspaceManager.Workspace workspace;
                File file;
                File file2 = WorkspaceManager.getBreezeHome();
                File file3 = jopensaveDialog2.getSelectedFile();
                ZipManager zipManager = new ZipManager(file3);
                for (String object22 : new String[]{"BreezeRuntime.log", "error.log", "debug.log", "Settings.yaml", "configuration.yaml"}) {
                    File bl = new File(file2, object22);
                    if (!bl.exists()) continue;
                    zipManager.addFile(bl);
                }
                File file5 = new File(file2, "archives");
                if (file5.exists()) {
                    zipManager.addFolder(file5, null);
                }
                if ((file = (workspace = WorkspaceManager.getInstance().getWorkspace()).getBreezeProperties()).exists()) {
                    zipManager.addFile(file);
                }
                File file4 = workspace.getTempPath();
                boolean bl = file4.mkdirs();
                File file6 = new File(file4, "Breeze and License Info.txt");
                try {
                    iOException = new FileWriter(file6);
                    try {
                        ((Writer)iOException).write("Breeze workspace: " + String.valueOf(workspace.getPath()) + "\n\n");
                        ((Writer)iOException).write(BreezeAboutDialog.getVersionAndLicenseInfo());
                        zipManager.addFile(file6);
                    }
                    finally {
                        ((OutputStreamWriter)iOException).close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (SystemUtils.IS_OS_WINDOWS) {
                    try {
                        Object object;
                        iOException = new ProcessBuilder("SYSTEMINFO").start();
                        StringBuilder stringBuilder = new StringBuilder();
                        try (Object object2 = new BufferedReader(new InputStreamReader(((Process)iOException).getInputStream()));){
                            while ((object = ((BufferedReader)object2).readLine()) != null) {
                                stringBuilder.append((String)object).append("\n");
                            }
                        }
                        object2 = new File(file4, "Windows System Info.txt");
                        object = new FileWriter((File)object2);
                        try {
                            ((Writer)object).write(stringBuilder.toString());
                        }
                        finally {
                            ((OutputStreamWriter)object).close();
                        }
                        zipManager.addFile((File)object2);
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                zipManager.perform(BreezeProgressManager.createEmpty());
                ToastHandler.getInstance().showToast(this.frame, "Log files exported");
                FileHelper.openExplorerOnPath(file3.getParentFile());
            }
        }

        private void addShutdownOption(BreezeContextMenu breezeContextMenu) {
            breezeContextMenu.addButtonCloseClick("Shutdown System", () -> BreezeOptionDialog.showDialog(this.frame, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Shutdown system", "The computer will shutdown\n\nDo you wish to continue?", breezeActionEvent -> {
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder("shutdown", "-s", "-t", "1");
                    processBuilder.start();
                }
                catch (IOException iOException) {
                    ErrorHandler.logAndReportException((Throwable)iOException);
                }
            }));
        }
    }

    public static class ToolbarPanel
    extends JPanel {
        private final BreezeButton themeButton;
        private final NoticeButton noticeButton;
        private final BreezeButton logoutButton;

        public ToolbarPanel(AbstractMainPanel abstractMainPanel) {
            super(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = this.getComponentCount();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 20);
            this.add((Component)EntryMainHelper.createSettingsButton(abstractMainPanel.getFrame(), true), gridBagConstraints);
            gridBagConstraints.gridx = this.getComponentCount();
            this.add((Component)EntryMainHelper.createButton("Intro", "material/open_in_new", () -> BreezeOptionDialog.showDialog(abstractMainPanel.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Introduction to Breeze", "", (AbstractBreezeCustomPanel)new WelcomePanel(false), null, null), true), gridBagConstraints);
            gridBagConstraints.gridx = this.getComponentCount();
            this.add((Component)EntryMainHelper.createButton("Support", "material/support", () -> BrowserLauncher.open((String)("https://prediktera.com/resources/support?lid=" + RegisterKeyManager.getRegInfo().LID + "&uid=" + RegisterKeyManager.getRegInfo().ID)), true), gridBagConstraints);
            gridBagConstraints.gridx = this.getComponentCount();
            this.noticeButton = new NoticeButton(abstractMainPanel);
            this.add((Component)this.noticeButton, gridBagConstraints);
            gridBagConstraints.gridx = this.getComponentCount();
            this.themeButton = EntryMainHelper.createButton("Dark mode", "material/dark_mode", () -> {
                if (BreezeTheme.getInstance().isDarkMode()) {
                    abstractMainPanel.changeTheme("classic");
                } else {
                    abstractMainPanel.changeTheme("dark");
                }
            }, true);
            this.add((Component)this.themeButton, gridBagConstraints);
            gridBagConstraints.gridx = this.getComponentCount();
            this.logoutButton = EntryMainHelper.createButton("Logout", "material/logout", () -> {
                BreezeFrame breezeFrame = abstractMainPanel.getFrame();
                breezeFrame.getViewStack().removeMainPage();
                breezeFrame.login();
            }, true);
            this.add((Component)this.logoutButton, gridBagConstraints);
            this.noticeButton.updateIcon();
        }

        private static String getSystemInfo() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Breeze version: ").append(InitClass.getBreezeVersion().toString());
            stringBuilder.append("\nJava version: ").append(System.getProperty("java.version"));
            stringBuilder.append("\nLicense ID: ").append(RegisterKeyManager.getRegInfo().LID);
            Object object = SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION;
            if (SystemUtils.IS_OS_LINUX) {
                try {
                    Process process = new ProcessBuilder("lsb_release", "-a").start();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        object = bufferedReader.lines().filter(string -> string.startsWith("Description:")).findFirst().map(string -> string.split(":", 2)[1].trim()).orElse("Description not found");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            stringBuilder.append("\nOS: ").append((String)object).append(" ").append(SystemUtils.OS_ARCH);
            return stringBuilder.toString();
        }

        public void init() {
            this.noticeButton.init();
        }

        public void updateTheme() {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            if (breezeTheme.isDarkMode()) {
                this.themeButton.setDesc("Classic");
                this.themeButton.setResourceIcon("material/light_mode", true);
            } else {
                this.themeButton.setDesc(" Dark ");
                this.themeButton.setResourceIcon("material/dark_mode", true);
            }
            this.noticeButton.updateIcon();
        }

        public void onShow() {
            this.noticeButton.onShow();
            this.logoutButton.setVisible(BreezeUserManager.getInstance().isEnabled());
        }
    }

    public static class VersionPanel
    extends JPanel {
        private final AbstractMainPanel mainPanel;
        private final BreezeLabel breezeLogoLabel = new BreezeLabel("", false, 48);
        private final BreezeLabel versionLabel = new BreezeLabel("version 1.0", false, 18);
        private final BreezeLabel buildLabel = new BreezeLabel("Build 2123123121233123", false, 10);
        private final BreezeLabel companyLogoLabel = new BreezeLabel("", false, 48);
        private final ImageIcon logoIconDark;
        private final ImageIcon companyIconDark;

        public VersionPanel(AbstractMainPanel abstractMainPanel) {
            super(new GridBagLayout());
            this.mainPanel = abstractMainPanel;
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.insets = new Insets(0, 0, 20, 0);
            this.add((Component)this.breezeLogoLabel, gridBagConstraints);
            this.versionLabel.setForeground(BreezeTheme.WHITE_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 20);
            gridBagConstraints.anchor = 16;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.versionLabel, gridBagConstraints);
            this.buildLabel.setForeground(BreezeTheme.WHITE_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 10, 5, 20);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.buildLabel, gridBagConstraints);
            this.companyLogoLabel.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    BrowserLauncher.openPredikteraWebSite();
                }
            });
            this.companyLogoLabel.setCursor(BreezeFrame.getHandCursor());
            String string = this.getLogoPrefix();
            this.logoIconDark = new ImageIcon(this.getClass().getResource("/images/logo/breeze" + string + "_darkmode.png"));
            this.companyIconDark = new ImageIcon(this.getClass().getResource("/images/logo/predikteraLowRes_darkmode.png"));
        }

        private String getLogoPrefix() {
            if (this.mainPanel.getFrame().getProduct() == UpdateHelper.Product.BreezeRuntimeClient) {
                return "Client";
            }
            if (RegInfo.isGeoFeature()) {
                return "_geo";
            }
            if (RegInfo.isApplicationFeature()) {
                return "";
            }
            return "_record";
        }

        public void onShow() {
            this.versionLabel.setText(this.mainPanel.getVersion());
            if (se.prediktera.map.InitClass.isInternal()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Internal Build: ");
                stringBuilder.append(InitClass.getBreezeVersion().build);
                if (se.prediktera.map.InitClass.getTimestamp() != null) {
                    stringBuilder.append(", Date: ");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    stringBuilder.append(simpleDateFormat.format(se.prediktera.map.InitClass.getTimestamp()));
                }
                stringBuilder.append(", JRE Version: ").append(System.getProperty("java.version"));
                this.buildLabel.setText(stringBuilder.toString());
            } else {
                int n = InitClass.getBreezeVersion().build;
                this.buildLabel.setText("Build: " + String.valueOf(n == 0 ? "DEVELOPMENT" : Integer.valueOf(n)));
            }
            this.updateTheme();
        }

        public void updateTheme() {
            ImageIcon imageIcon = this.logoIconDark;
            ImageIcon imageIcon2 = this.companyIconDark;
            WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
            if (workspace != null) {
                File file;
                File file2 = workspace.getCustomizePath();
                File file3 = new File(file2, "logo.png");
                if (file3.exists()) {
                    imageIcon = new ImageIcon(file3.getAbsolutePath());
                    file = new File(file2, "logo_dark.png");
                    if (file.exists()) {
                        imageIcon = new ImageIcon(file.getAbsolutePath());
                    }
                }
                if ((file = new File(file2, "company_logo.png")).exists()) {
                    imageIcon2 = new ImageIcon(file.getAbsolutePath());
                    File file4 = new File(file2, "company_logo_dark.png");
                    if (file4.exists()) {
                        imageIcon2 = new ImageIcon(file4.getAbsolutePath());
                    }
                }
            }
            this.breezeLogoLabel.setIcon(imageIcon);
            this.companyLogoLabel.setIcon(imageIcon2);
        }

        public BreezeLabel getPredikteraLogoLabel() {
            return this.companyLogoLabel;
        }
    }
}

