/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeStudyChooserPanel;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.MainButton;
import se.prediktera.breeze.frontend.main.MainClass;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.main.play.PlayWorkflowPanel;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.breeze.frontend.main.record.RecordWorkflowPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.register.RegInfo;

public class MainPanel
extends AbstractMainPanel {
    private MainClass recordMainClass;
    private final BreezeList mainList = new BreezeList();
    private final MainButton mainButton;
    private int lastSize;

    public MainPanel() {
        this((BreezeFrame)null);
    }

    public MainPanel(BreezeFrame breezeFrame) {
        super(breezeFrame, false);
        this.mainList.setLayoutOrientation(2);
        this.mainList.setOpaque(false);
        this.mainList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting() && this.mainList.getMouseOverObject() != null) {
                MainClass mainClass = (MainClass)this.mainList.getSelectedValue();
                if (mainClass == null) {
                    return;
                }
                this.chooseStudyContextBeforeOpen(mainClass);
            }
        });
        this.mainPanel.add((Component)((Object)this.mainList), "Center");
        this.mainList.setVisibleRowCount(1);
        this.mainButton = new MainButton();
        this.mainList.setCellRenderer(this.mainButton);
        this.mainList.setDirectclick();
        this.mainList.setVisible(false);
        final SwingTimer swingTimer = new SwingTimer(10, actionEvent -> {
            int n = Math.max(200, (int)Math.min((double)this.getHeight() / 4.0, (double)this.getWidth() / 5.0));
            if (n != this.lastSize) {
                this.lastSize = n;
                this.mainButton.setButtonSize(this.lastSize);
                this.mainList.setFixedCellWidth(this.lastSize);
                this.mainList.setFixedCellHeight((int)((double)this.lastSize * 1.6));
                this.mainList.setVisible(true);
            }
        });
        this.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                swingTimer.restart();
            }
        });
        this.updateTheme();
    }

    public EntryMainPanel createEntryMainPanel(BreezeProgress breezeProgress, BreezeType breezeType, Workflow workflow) {
        return MainPanel.createEntryMainPanel(this.frame, breezeProgress, breezeType, workflow);
    }

    public static EntryMainPanel createEntryMainPanel(BreezeFrame breezeFrame, BreezeProgress breezeProgress, BreezeType breezeType, Workflow workflow) {
        if (workflow != null && !WorkspaceManager.GUITEST && breezeType.equals((Object)BreezeType.Project)) {
            return new RecordGroupPanel(breezeProgress, breezeFrame, workflow);
        }
        return switch (breezeType) {
            case BreezeType.Project -> new RecordWorkflowPanel(breezeProgress, breezeFrame);
            case BreezeType.Analyse -> new ModelMainPanel(breezeProgress, breezeFrame, workflow);
            case BreezeType.Workflow -> new PlayWorkflowPanel(breezeProgress, breezeFrame, workflow);
            case BreezeType.Settings -> new MaintenancePanel(breezeProgress, breezeFrame);
            default -> null;
        };
    }

    protected List<MainClass> createMainList() {
        BreezeUser breezeUser = BreezeUserManager.getBreezeUser();
        ArrayList<MainClass> arrayList = new ArrayList<MainClass>();
        this.recordMainClass = new MainClass(BreezeType.Project, "Capture and organise image data");
        arrayList.add(this.recordMainClass);
        if (RegInfo.isApplicationFeature()) {
            if (breezeUser.canModel()) {
                arrayList.add(new MainClass(BreezeType.Analyse, "Overview and maintain prediction models"));
            }
            arrayList.add(new MainClass(BreezeType.Workflow, "Apply model workflows"));
        }
        return arrayList;
    }

    public void chooseStudyContextBeforeOpen(BreezeType breezeType) {
        MainClass mainClass = this.findMainClassByTypeInList(this.mainList, breezeType);
        this.chooseStudyContextBeforeOpen(mainClass);
    }

    private void chooseStudyContextBeforeOpen(MainClass mainClass) {
        if (mainClass.getType().equals((Object)BreezeType.Analyse) || mainClass.getType().equals((Object)BreezeType.Workflow)) {
            List<BasicWorkflow> list = BreezeMasterCache.getInstance().getStudyList().getSortedList();
            if (list.isEmpty()) {
                BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "No study", "Open Record and create new Study?", null, breezeActionEvent -> this.openPanel(this.recordMainClass, null, null));
            } else if (list.size() == 1) {
                this.openPanel(mainClass, (Workflow)list.getFirst(), null);
            } else {
                BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, "Select Study", "", (AbstractBreezeCustomPanel)new BreezeStudyChooserPanel(list, this.frame.getViewStack().getStudyContext()), null, breezeActionEvent -> this.openPanel(mainClass, (Workflow)breezeActionEvent.result(), null));
            }
        } else {
            this.openPanel(mainClass, this.frame.getViewStack().getStudyContext(), null);
        }
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        super.showSelectedEntry(bl);
        this.mainList.setModel(new ArrayListModel(this.createMainList()));
    }

    @Override
    protected void updateTheme() {
        super.updateTheme();
        this.mainButton.updateTheme();
    }

    private MainClass findMainClassByTypeInList(BreezeList breezeList, BreezeType breezeType) {
        for (int i = 0; i < breezeList.getModel().getSize(); ++i) {
            MainClass mainClass = (MainClass)breezeList.getModel().getElementAt(i);
            if (mainClass.getType() != breezeType) continue;
            return mainClass;
        }
        throw new RuntimeException("Type " + String.valueOf((Object)breezeType) + " not found in main panel list");
    }

    public void openPanel(MainClass mainClass, Workflow workflow, OpenPanelCallback openPanelCallback) {
        this.openPanel(mainClass.getType(), workflow, openPanelCallback);
    }

    public void openPanel(final BreezeType breezeType, final Workflow workflow, final OpenPanelCallback openPanelCallback) {
        this.frame.getViewStack().setStudyContext(workflow);
        BreezeProgressDialog.startProgress(this.frame, new OpenEntryProgressAction(this, this.frame, breezeType.equals((Object)BreezeType.Settings) ? 0.9 : 1.0){
            final /* synthetic */ MainPanel this$0;
            {
                this.this$0 = mainPanel;
                super(breezeFrame, d);
            }

            @Override
            protected EntryMainPanel createOpenPanel() {
                return this.this$0.createEntryMainPanel(this.getProgressManager(), breezeType, workflow);
            }

            @Override
            public void actionComplete() {
                super.actionComplete();
                BreezeMainPanel breezeMainPanel = this.getOpenPanel();
                if (breezeMainPanel instanceof EntryMainPanel) {
                    EntryMainPanel entryMainPanel = (EntryMainPanel)breezeMainPanel;
                    entryMainPanel.openFromMainPanel();
                }
                if (openPanelCallback != null) {
                    openPanelCallback.opened(breezeMainPanel);
                }
            }
        }, "Opening...", 0, this.canCancel(breezeType));
        this.mainList.clearSelection();
    }

    private boolean canCancel(BreezeType breezeType) {
        return breezeType.equals((Object)BreezeType.Connect);
    }

    public static interface OpenPanelCallback {
        public void opened(BreezeMainPanel var1);
    }
}

