/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.cache.StudyList;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryButtonsPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.entry.EntryPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.pp.PostProcessingPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportProject;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.breeze.frontend.main.record.RecordWorkflowPanel;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.register.RegInfo;

public class MainProjectPanel
extends AbstractMainPanel {
    private final EntriesPanel entriesPanel;
    private final JPanel entryListsPanel = new JPanel();
    private boolean grouped = true;

    public MainProjectPanel() {
        this((BreezeFrame)null);
    }

    public MainProjectPanel(BreezeFrame breezeFrame) {
        super(breezeFrame, true);
        this.entriesPanel = new EntriesPanel(this, breezeFrame);
        this.updateTheme();
    }

    @Override
    protected void updateTheme() {
        super.updateTheme();
        this.entriesPanel.updateTheme(BreezeTheme.getInstance());
    }

    public void setGrouped(boolean bl) {
        this.grouped = bl;
        this.showSelectedEntry(false);
    }

    @Override
    public synchronized void showSelectedEntry(boolean bl) {
        super.showSelectedEntry(bl);
        this.entriesPanel.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                MainProjectPanel.this.entryListsPanel.setLayout(new BorderLayout());
                BreezeProgressManager breezeProgressManager = new BreezeProgressManager(MainProjectPanel.this.entryListsPanel, 10000000){

                    @Override
                    public Object doWork() {
                        this.getContentPane().setTouchScreen(MainProjectPanel.this.getBackground());
                        this.setInfoText("Loading " + BreezeType.Project.getDescs());
                        BreezeMasterCache.getInstance().getStudyList(this, false);
                        return null;
                    }

                    @Override
                    public void Finish() {
                        super.Finish();
                        SwingUtilities.invokeLater(() -> {
                            MainProjectPanel.this.entriesPanel.setModel(BreezeMasterCache.getInstance().getStudyList(), MainProjectPanel.this.grouped);
                            MainProjectPanel.this.entriesPanel.setEnabled(true);
                        });
                    }
                };
                breezeProgressManager.invokeNowAndWaitFinish();
            }
        }.start();
        this.mainPanel.add((Component)this.entriesPanel, "Center");
    }

    private class EntriesPanel
    extends JPanel {
        private final ArrayList<BreezeTree> entryLists;
        private final BreezeScrollPane entryScrollPane;
        private final MainProjectPanel mainProjectPanel;
        private final BreezeFrame frame;
        private final JPanel leftPanel;
        private final JPanel rightPanel;
        private final FilterPanel filterPanel;

        public EntriesPanel(MainProjectPanel mainProjectPanel2, BreezeFrame breezeFrame) {
            super(new GridBagLayout());
            this.entryLists = new ArrayList();
            this.mainProjectPanel = mainProjectPanel2;
            this.frame = breezeFrame;
            this.leftPanel = new JPanel(new GridBagLayout());
            this.leftPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(40, 40, 40, 40);
            this.add((Component)this.leftPanel, gridBagConstraints);
            this.leftPanel.add((Component)new BreezeLabelButton("New " + String.valueOf((Object)BreezeType.Project), "material/add_circle", () -> this.openNewDialog(0)), GridBagHelper.createLeft(this.leftPanel.getComponentCount(), new Insets(20, 10, 0, 10)));
            if (RegInfo.isApplicationFeature()) {
                this.leftPanel.add((Component)new BreezeLabelButton("Import Images", "material/photo_library", () -> this.openNewDialog(1)), GridBagHelper.createLeft(this.leftPanel.getComponentCount(), new Insets(15, 10, 0, 10)));
                this.leftPanel.add((Component)new BreezeLabelButton("Import " + String.valueOf((Object)BreezeType.Project), "material/archive", () -> this.openNewDialog(2)), GridBagHelper.createLeft(this.leftPanel.getComponentCount(), new Insets(15, 10, 0, 10)));
                this.leftPanel.add((Component)new BreezeLabelButton("Tutorial", "material/menu_book", () -> this.openNewDialog(3)), GridBagHelper.createLeft(this.leftPanel.getComponentCount(), new Insets(15, 10, 0, 10)));
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.insets = new Insets(0, 40, 40, 40);
            this.add((Component)new BreezeSeparator.Vertical(), gridBagConstraints2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(0, 40, 40, 120);
            this.add((Component)jPanel, gridBagConstraints3);
            this.entryScrollPane = new BreezeScrollPane(MainProjectPanel.this.entryListsPanel);
            this.entryScrollPane.setHorizontalScrollBarPolicy(31);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridwidth = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(10, 0, 0, 0);
            this.filterPanel = new FilterPanel(mainProjectPanel2, this.entryLists);
            jPanel.add((Component)this.filterPanel, gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)this.entryScrollPane, gridBagConstraints5);
            this.rightPanel = new JPanel(new GridBagLayout());
            this.rightPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.anchor = 11;
            gridBagConstraints6.insets = new Insets(20, 20, 0, 0);
            jPanel.add((Component)this.rightPanel, gridBagConstraints6);
            this.rightPanel.add((Component)this.createColorButton("Analyzer", BreezeType.Project), GridBagHelper.create(this.rightPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
            this.rightPanel.add((Component)this.createColorButton("Recorder", BreezeType.Recorder), GridBagHelper.create(this.rightPanel.getComponentCount(), new Insets(10, 0, 0, 0)));
            EntryMainHelper.registerKeyAction((JComponent)this, KeyStroke.getKeyStroke(127, 0), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EntriesPanel.this.deleteSelected();
                }
            });
        }

        private BreezeButton createColorButton(String string, BreezeType breezeType) {
            BreezeButton breezeButton = EntryMainHelper.createColorButton(string, breezeType, () -> this.open(breezeType));
            breezeButton.setPreferredAndMinimumSize(60, 50);
            return breezeButton;
        }

        private void deleteSelected() {
            ArrayList<Workflow> arrayList = this.getSelectedWorkflows();
            DummyWorkflowPanel dummyWorkflowPanel = new DummyWorkflowPanel(this.mainProjectPanel);
            dummyWorkflowPanel.getEntryList().setSelectedValues(arrayList.toArray());
            dummyWorkflowPanel.entryDeleteClicked(dummyWorkflowPanel.getSelectedEntry());
        }

        private void setPinnedOnSelected(boolean bl) {
            Workflow workflow = Objects.requireNonNull(this.getSelectedWorkflow());
            workflow.getEntryData().setPinnedToStartPage(bl);
            workflow.save();
            MainProjectPanel.this.showSelectedEntry(false);
        }

        private void openNewDialog(int n) {
            WorkflowMainPanel.showNewDialog(new DummyWorkflowPanel(this.mainProjectPanel, workflow -> {
                if (n != 1) {
                    SwingUtilities.invokeLater(() -> this.open(BreezeType.Project, workflow, null, null));
                }
            }), n);
        }

        public void updateTheme(BreezeTheme breezeTheme) {
            Component component;
            int n;
            this.setBackground(breezeTheme.getDialogBackground());
            BreezeScrollPane.setTheme(this.entryScrollPane);
            MainProjectPanel.this.entryListsPanel.setBackground(breezeTheme.getDialogBackground());
            for (n = 0; n < this.leftPanel.getComponentCount(); ++n) {
                component = this.leftPanel.getComponent(n);
                if (!(component instanceof BreezeLabelButton)) continue;
                BreezeLabelButton object2 = (BreezeLabelButton)component;
                object2.updateIcon();
                object2.setForeground(breezeTheme.getLabelForeground());
            }
            for (n = 0; n < this.rightPanel.getComponentCount(); ++n) {
                BreezeButton breezeButton;
                component = this.rightPanel.getComponent(n);
                if (!(component instanceof BreezeButton) || (breezeButton = (BreezeButton)component).getName() != null) continue;
                breezeButton.updateIcon();
                breezeButton.setDescForegroundReal(breezeTheme.getLabelForeground());
            }
            for (n = 0; n < MainProjectPanel.this.entryListsPanel.getComponentCount(); ++n) {
                component = MainProjectPanel.this.entryListsPanel.getComponent(n);
                if (!(component instanceof CollapsePanel)) continue;
                CollapsePanel collapsePanel = (CollapsePanel)component;
                collapsePanel.updateTheme(breezeTheme);
            }
            for (BreezeTree breezeTree : this.entryLists) {
                TreeCellRenderer treeCellRenderer = breezeTree.getCellRenderer();
                if (treeCellRenderer instanceof EntryPanel) {
                    component = (EntryPanel)treeCellRenderer;
                    ((EntryPanel)component).updateTheme(breezeTheme, breezeTheme.getPanelBackground(), breezeTheme.getDialogBackground());
                }
                breezeTree.setForeground(breezeTheme.getLabelForeground());
                breezeTree.setBackground(breezeTheme.getDialogBackground());
                breezeTree.setSelectionForeground(breezeTheme.getLabelForeground());
                breezeTree.setSelectionBackground(breezeTheme.getEntrySelectionBackground());
            }
            this.filterPanel.updateTheme(breezeTheme);
        }

        @Override
        public void setEnabled(boolean bl) {
            for (int i = 0; i < this.leftPanel.getComponentCount(); ++i) {
                Component component = this.leftPanel.getComponent(i);
                if (!(component instanceof BreezeLabelButton)) continue;
                BreezeLabelButton breezeLabelButton = (BreezeLabelButton)component;
                breezeLabelButton.setEnabled(bl);
            }
            this.setRightPanelEnabled(bl);
        }

        private void setRightPanelEnabled(boolean bl) {
            for (int i = 0; i < this.rightPanel.getComponentCount(); ++i) {
                Component component = this.rightPanel.getComponent(i);
                if (!(component instanceof BreezeButton)) continue;
                BreezeButton breezeButton = (BreezeButton)component;
                breezeButton.setEnabled(bl);
            }
        }

        private void open(BreezeType breezeType) {
            Workflow workflow = this.getSelectedWorkflow();
            if (workflow != null) {
                workflow.save();
                if (breezeType.equals((Object)BreezeType.Recorder)) {
                    BreezeOptionDialog.showDialog(this.frame, BreezeType.Recorder.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION.setCancelText("Close"), "Select Group for Recorder", "Specify the group to put recorded measurements in.", (AbstractBreezeCustomPanel)new WorkflowMainPanel.SelectOrCreateGroupPanel(workflow), null, breezeActionEvent -> this.open(breezeType, workflow, ((WorkflowMainPanel.SelectOrCreateGroupPanel)breezeActionEvent.getBreezeCustomPanel()).getOrCreateGroup(workflow), null));
                } else {
                    this.open(breezeType, workflow, null, null);
                }
            } else {
                BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No " + BreezeType.Project.getDesc(), "Create a " + BreezeType.Project.getDesc() + " and try again", null, null);
            }
        }

        private void open(final BreezeType breezeType, final Workflow workflow, final Group group, final Measurement measurement) {
            this.frame.getViewStack().setStudyContext(workflow);
            BreezeProgressDialog.startProgress(this.frame, new OpenEntryProgressAction(this, this.frame){
                final /* synthetic */ EntriesPanel this$1;
                {
                    this.this$1 = entriesPanel;
                    super(breezeFrame);
                }

                @Override
                protected BreezeMainPanel createOpenPanel() {
                    workflow.loadFully();
                    if (breezeType.equals((Object)BreezeType.Recorder)) {
                        return new BreezeRecorder(this.getProgressManager(), this.this$1.frame, breezeType, group, measurement -> {});
                    }
                    if (breezeType.equals((Object)BreezeType.Project)) {
                        return new RecordGroupPanel(this.getProgressManager(), this.this$1.frame, workflow);
                    }
                    return MainPanel.createEntryMainPanel(this.this$1.frame, this.getProgressManager(), breezeType, workflow);
                }

                @Override
                public void actionComplete() {
                    super.actionComplete();
                    if (measurement != null) {
                        EntryMainHelper.showMeasurementPanel(this.getOpenPanel(), measurement);
                    }
                }
            }, "Opening...", 0);
        }

        public Workflow getSelectedWorkflow() {
            ArrayList<Workflow> arrayList = this.getSelectedWorkflows();
            if (!arrayList.isEmpty()) {
                return arrayList.getFirst();
            }
            return null;
        }

        public ArrayList<Workflow> getSelectedWorkflows() {
            ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
            for (BreezeTree breezeTree : this.entryLists) {
                Workflow workflow = Workflow.getWorkflow(breezeTree.getSelectedValue());
                if (workflow == null) continue;
                arrayList.add(workflow);
            }
            return arrayList;
        }

        public void setModel(StudyList studyList, boolean bl) {
            this.filterPanel.clear();
            this.entryLists.clear();
            MainProjectPanel.this.entryListsPanel.removeAll();
            MainProjectPanel.this.entryListsPanel.setLayout(new GridBagLayout());
            ListHelper.sortEntriesByDate(studyList);
            if (bl) {
                LocalDate localDate = LocalDate.now();
                LocalDate localDate2 = localDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                LocalDate localDate3 = localDate2.minusWeeks(1L);
                LocalDate localDate4 = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(1L);
                LocalDate localDate5 = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(3L);
                LocalDate localDate6 = localDate.minusYears(1L);
                ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList2 = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList3 = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList4 = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList5 = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList6 = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList7 = new ArrayList<Workflow>();
                for (BasicWorkflow basicWorkflow : studyList) {
                    Workflow workflow = Workflow.getWorkflow(basicWorkflow);
                    if (workflow.getEntryData().isPinnedToStartPage()) {
                        arrayList7.add(workflow);
                        continue;
                    }
                    Date date = workflow.getEntryData().getModifiedOrCreatedDate();
                    if (date == null) {
                        arrayList6.add(workflow);
                        continue;
                    }
                    LocalDate localDate7 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (!localDate7.isBefore(localDate2)) {
                        arrayList.add(workflow);
                        continue;
                    }
                    if (!localDate7.isBefore(localDate3)) {
                        arrayList2.add(workflow);
                        continue;
                    }
                    if (!localDate7.isBefore(localDate4)) {
                        arrayList3.add(workflow);
                        continue;
                    }
                    if (!localDate7.isBefore(localDate5)) {
                        arrayList4.add(workflow);
                        continue;
                    }
                    if (!localDate7.isBefore(localDate6)) {
                        arrayList5.add(workflow);
                        continue;
                    }
                    arrayList6.add(workflow);
                }
                this.addCollapsePanel("Pinned", arrayList7, false);
                int n = arrayList7.isEmpty() ? 0 : 1;
                this.addCollapsePanel("This week", arrayList, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
                this.addCollapsePanel("Last week", arrayList2, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
                this.addCollapsePanel("This month", arrayList3, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
                this.addCollapsePanel("This quarter", arrayList4, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
                this.addCollapsePanel("This year", arrayList5, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
                this.addCollapsePanel("Older", arrayList6, MainProjectPanel.this.entryListsPanel.getComponentCount() > n);
            } else {
                ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
                ArrayList<Workflow> arrayList8 = new ArrayList<Workflow>();
                for (BasicWorkflow basicWorkflow : studyList) {
                    Workflow workflow = Workflow.getWorkflow(basicWorkflow);
                    if (workflow.getEntryData().isPinnedToStartPage()) {
                        arrayList.add(workflow);
                        continue;
                    }
                    arrayList8.add(workflow);
                }
                arrayList8.sort(new Comparator<Workflow>(this){

                    @Override
                    public int compare(Workflow workflow, Workflow workflow2) {
                        return workflow.getName().compareToIgnoreCase(workflow2.getName());
                    }
                });
                this.addCollapsePanel("Pinned", arrayList, false);
                this.addCollapsePanel("By name", arrayList8, false);
            }
            MainProjectPanel.this.entryListsPanel.add((Component)new JLabel(""), GridBagHelper.createLast(100, new Insets(0, 0, 0, 0)));
            MainProjectPanel.this.entryListsPanel.revalidate();
            MainProjectPanel.this.entryListsPanel.repaint();
        }

        private void addCollapsePanel(String string, ArrayList<Workflow> arrayList, boolean bl) {
            if (arrayList.isEmpty()) {
                return;
            }
            CollapsePanel collapsePanel = new CollapsePanel(string + " (" + arrayList.size() + ")", true, bl, 0);
            collapsePanel.setFont(new Font("Tahoma", 0, 16));
            final BreezeTree breezeTree = new BreezeTree();
            final EntryPanel entryPanel = new EntryPanel("Recordings2_big", BreezeTheme.getInstance().getDialogBackground(), 80);
            breezeTree.setCellRenderer(entryPanel);
            breezeTree.setScrollPane(this.entryScrollPane);
            breezeTree.addScroll();
            breezeTree.setName("entryList");
            breezeTree.setSelectionForeground(BreezeTheme.getInstance().getLabelForeground());
            breezeTree.setSelectionBackground(BreezeTheme.getInstance().getEntrySelectionBackground());
            breezeTree.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ EntriesPanel this$1;
                {
                    this.this$1 = entriesPanel;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    for (BreezeTree object : this.this$1.entryLists) {
                        if (object.equals(breezeTree)) continue;
                        object.clearSelection();
                    }
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        Workflow workflow = Workflow.getWorkflow(breezeTree.getList().get(breezeTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY())));
                        breezeTree.setSelectedValue(workflow);
                        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.this$1.frame, null);
                        breezeContextMenu.addButtonCloseClick("Analyzer", () -> this.this$1.open(BreezeType.Project), "material/folder_open");
                        breezeContextMenu.addButtonCloseClick("Recorder", () -> this.this$1.open(BreezeType.Recorder), "material/radio_button_checked");
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Go to measurement", () -> this.this$1.open(BreezeType.Project, workflow, null, workflow.getFirstMeasurementWithData()), "explore/tab_move");
                        breezeContextMenu.addButtonCloseClick("Rename", () -> EntryOverviewPanel.renameEntry(new DummyWorkflowPanel(this.this$1.mainProjectPanel), workflow, string -> {}), "explore/edit");
                        breezeContextMenu.addButtonCloseClick("Duplicate", () -> EntryButtonsPanel.duplicateEntry(new DummyWorkflowPanel(this.this$1.mainProjectPanel), workflow, "Project"), "material/folder_copy");
                        breezeContextMenu.addButtonCloseClick("Export", () -> PostProcessingPanel.PostProcessingButton.openWizard(new DummyWorkflowPanel(this.this$1.mainProjectPanel), "Export study", new PPExportProject.Info(), workflow), "material/upload_2");
                        breezeContextMenu.addButtonCloseClick("Delete", () -> this.this$1.deleteSelected(), "delete");
                        EntryData entryData = workflow.getEntryData();
                        if (entryData instanceof EntryData) {
                            EntryData entryData2 = entryData;
                            breezeContextMenu.addSeparator();
                            if (entryData2.isPinnedToStartPage()) {
                                breezeContextMenu.addButtonCloseClick("Unpin", () -> this.this$1.setPinnedOnSelected(false), "material/keep_off");
                            } else {
                                breezeContextMenu.addButtonCloseClick("Pin", () -> this.this$1.setPinnedOnSelected(true), "material/keep");
                            }
                        }
                        breezeContextMenu.show(mouseEvent);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    super.mouseExited(mouseEvent);
                    entryPanel.setHoverIndex(-1);
                    breezeTree.repaint();
                }
            });
            breezeTree.addMouseMotionListener(new MouseMotionAdapter(this){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    super.mouseMoved(mouseEvent);
                    int n = breezeTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (entryPanel.getHoverIndex() != n) {
                        entryPanel.setHoverIndex(n);
                        breezeTree.repaint();
                    }
                }
            });
            new ListHelper.DoubleClickedClass(breezeTree, actionEvent -> this.open(BreezeType.Project));
            breezeTree.setModel(arrayList);
            Workflow workflow = this.frame.getViewStack().getStudyContext();
            if (workflow != null) {
                breezeTree.setSelectedValue(workflow);
                if (breezeTree.getSelectedValue() != null) {
                    collapsePanel.setCollapsed(false);
                    SwingUtilities.invokeLater(() -> breezeTree.requestFocusInWindow());
                }
            } else if (MainProjectPanel.this.entryListsPanel.getComponentCount() == 0) {
                breezeTree.setSelectedIndex(0);
                SwingUtilities.invokeLater(() -> breezeTree.requestFocusInWindow());
            }
            collapsePanel.addPanel((JComponent)((Object)breezeTree));
            GridBagConstraints gridBagConstraints = GridBagHelper.create(MainProjectPanel.this.entryListsPanel.getComponentCount(), new Insets(MainProjectPanel.this.entryListsPanel.getComponentCount() > 0 ? 10 : 0, 0, 0, 0));
            gridBagConstraints.fill = 1;
            MainProjectPanel.this.entryListsPanel.add((Component)collapsePanel, gridBagConstraints);
            this.entryLists.add(breezeTree);
        }
    }

    private class DummyWorkflowPanel
    extends RecordWorkflowPanel {
        private final MainProjectPanel mainProjectPanel;
        private OnWorkflowCallback callback;

        public DummyWorkflowPanel(MainProjectPanel mainProjectPanel2) {
            this(mainProjectPanel2, null);
        }

        public DummyWorkflowPanel(MainProjectPanel mainProjectPanel2, OnWorkflowCallback onWorkflowCallback) {
            super(BreezeProgressManager.createEmpty(), mainProjectPanel2.getFrame());
            this.mainProjectPanel = mainProjectPanel2;
            this.callback = onWorkflowCallback;
        }

        @Override
        public void setDirty(boolean bl) {
            super.setDirty(bl);
            if (bl) {
                this.setSelectedWorkflow();
            }
        }

        @Override
        protected void showFirstTab() {
            this.setSelectedWorkflow();
        }

        @Override
        public void selectTab(String string) {
            this.setSelectedWorkflow();
        }

        @Override
        public void setEntryListModel(List list, ListHelper.SortType sortType, boolean bl) {
            super.setEntryListModel(list, ListHelper.SortType.Modified, false);
        }

        private synchronized void setSelectedWorkflow() {
            Workflow workflow = Workflow.getWorkflow(this.getSelectedEntry());
            if (workflow != null) {
                workflow.save();
            }
            this.frame.getViewStack().setStudyContext(workflow);
            this.mainProjectPanel.showSelectedEntry(false);
            if (this.callback != null && workflow != null) {
                this.callback.onWorkflow(workflow);
                this.callback = null;
            }
        }

        @Override
        public boolean showEmptyPageIfNoItems() {
            this.mainProjectPanel.showSelectedEntry(false);
            return super.showEmptyPageIfNoItems();
        }
    }

    private static interface OnWorkflowCallback {
        public void onWorkflow(Workflow var1);
    }

    public static class FilterPanel
    extends JPanel {
        private final BreezeLabel titleLabel = new BreezeLabel(BreezeType.Project.getDescs(), false, 20);
        private final BreezeTextField filterTextField = new BreezeTextField();
        private final BreezeButton filterButton;
        private GroupButton groupButton;

        public FilterPanel(MainProjectPanel mainProjectPanel, final ArrayList<BreezeTree> arrayList) {
            super(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.add((Component)this.titleLabel, gridBagConstraints);
            this.filterButton = EntryMainHelper.createButton("", "explore/zoom_all", () -> {
                boolean bl = this.filterTextField.isVisible();
                this.titleLabel.setVisible(bl);
                this.filterTextField.setVisible(!bl);
                if (!bl) {
                    this.filterTextField.requestFocusAndSelectAll();
                }
            });
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
            this.add((Component)this.filterButton, gridBagConstraints2);
            this.filterTextField.setEmptyText("Filter");
            this.filterTextField.setVisible(false);
            this.filterTextField.setText("");
            this.filterTextField.setLayer(0);
            this.filterTextField.addChangeListener(textActionEvent -> this.filter(arrayList));
            this.filterTextField.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ FilterPanel this$0;
                {
                    this.this$0 = filterPanel;
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    this.this$0.filter(arrayList);
                }
            });
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            this.add((Component)this.filterTextField, gridBagConstraints2);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 80);
            this.groupButton = new GroupButton(mainProjectPanel);
            this.add((Component)this.groupButton, gridBagConstraints2);
        }

        private void filter(ArrayList<BreezeTree> arrayList) {
            String string = this.filterTextField.getText().trim();
            BreezeTree breezeTree = null;
            boolean bl = false;
            for (BreezeTree breezeTree2 : arrayList) {
                Object object = breezeTree2.getSelectedValue();
                if (!string.isEmpty()) {
                    breezeTree2.setFilter(new BreezeFilter.Name(this.filterTextField.getText()), object, 1);
                } else {
                    breezeTree2.setFilter(null, object, 1);
                }
                if (breezeTree == null && breezeTree2.getItemCount() > 0) {
                    breezeTree = breezeTree2;
                }
                breezeTree2.clearSelection();
                Object object2 = breezeTree2.getParent().getParent();
                if (!(object2 instanceof CollapsePanel)) continue;
                CollapsePanel collapsePanel = (CollapsePanel)object2;
                if (collapsePanel.getTitle().startsWith("Pinned") && breezeTree2.getItemCount() > 0) {
                    collapsePanel.setCollapsed(false);
                    breezeTree = null;
                } else if (string.isEmpty() && breezeTree != breezeTree2) {
                    collapsePanel.setCollapsed(true);
                } else {
                    collapsePanel.setCollapsed(breezeTree2.getItemCount() == 0);
                }
                if (!bl && breezeTree2.getItemCount() > 0) {
                    bl = true;
                    breezeTree2.setSelectedIndex(0);
                }
                object2 = collapsePanel.getTitle();
                collapsePanel.setTitle(((String)object2).substring(0, ((String)object2).indexOf(40)) + "(" + breezeTree2.getItemCount() + ")");
            }
        }

        public void clear() {
            this.filterTextField.setText("");
        }

        public void updateTheme(BreezeTheme breezeTheme) {
            this.titleLabel.setForeground(breezeTheme.getLabelForeground());
            this.filterButton.setIcon(ImageHelper.getResourceIcon("explore/zoom_all"));
            this.groupButton.setResourceIcon("material/swap_vert");
            this.filterTextField.updateTheme(breezeTheme);
        }

        private static class GroupButton
        extends BreezeButton {
            public GroupButton(final MainProjectPanel mainProjectPanel) {
                this.setResourceIcon("material/swap_vert");
                this.addMouseListener(new MouseAdapter(this){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(mainProjectPanel.getFrame(), null);
                        breezeContextMenu.addButtonCloseClick("Group by recent", () -> mainProjectPanel.setGrouped(true));
                        breezeContextMenu.addButtonCloseClick("Alphabetical order", () -> mainProjectPanel.setGrouped(false));
                        breezeContextMenu.show(mouseEvent);
                    }
                });
            }
        }
    }

    public static interface OpenPanelCallback {
        public void opened(EntryMainPanel var1);
    }
}

