/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.InternetProbe;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.BreezeUpdatePanel;
import se.prediktera.breeze.frontend.main.RegisterTrialCustomPanel;
import se.prediktera.breeze.frontend.main.SupportPopupPanel;
import se.prediktera.breeze.frontend.main.TrialPopupPanel;
import se.prediktera.breeze.frontend.main.WelcomePanel;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.JvmInfo;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class NoticeButton
extends BreezeButton {
    private final AbstractMainPanel mainPanel;
    private static boolean welcomeMessageFirstTime = true;
    private final UpdateHelper.Product product;
    private final Collection<Notice> listOfNotices = new ConcurrentLinkedQueue<Notice>();
    private boolean firstTime = true;
    private int numberValid;

    public NoticeButton(AbstractMainPanel abstractMainPanel) {
        this.mainPanel = abstractMainPanel;
        BreezeFrame breezeFrame = abstractMainPanel.getFrame();
        this.product = breezeFrame.getProduct();
        this.setDesc("Notices");
        this.setResourceIcon("material/notifications", true);
        this.setDescForegroundReal(BreezeTheme.WHITE_TEXT);
        this.addClickCallBack(() -> {
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
            for (Notice notice : this.getValidNoticeList()) {
                breezeContextMenu.addButtonCloseClick(notice.name, () -> {
                    notice.callback().doClick();
                    this.updateIcon();
                });
            }
            if (breezeContextMenu.resize()) {
                breezeContextMenu.setDrawArrow(false);
                breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                breezeContextMenu.setPositionLater(SwingUtilities.convertPoint(this, 100, -30 - this.getValidNoticeList().size() / 2 * 32, abstractMainPanel));
            }
        });
    }

    public void init() {
        BreezeFrame breezeFrame = this.mainPanel.getFrame();
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        if (regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder)) {
            this.listOfNotices.add(new Notice("Activate full Breeze 30 day trial", Toast.IconType.Success, this::handleHySpexRecorderUserRegistration, null, false, 5));
        } else {
            int n = regInfo.getDaysUntilExpire(this.product);
            if (n < 15 && n >= 0 || BreezeFrame.development) {
                Object object = "Your license will expire in " + n + " day";
                if (n > 1) {
                    object = (String)object + "s";
                }
                if (n == 0) {
                    object = "Your license expires today";
                }
                this.listOfNotices.add(new Notice((String)object, Toast.IconType.Warning));
            }
            boolean bl = !regInfo.isTrialLicense();
            int n2 = regInfo.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.SUPPORT);
            if (InternetProbe.checkOnline().offline() && n2 < 15) {
                boolean bl2 = bl = BreezeProperties.getInstance().getAndIncrementShowSupportExpiredCount() < 5;
            }
            if (n < 0 && RegInfo.isRecordFeature()) {
                bl = false;
            }
            if (bl && n2 < 15 || BreezeFrame.development) {
                Toast.IconType iconType;
                AbstractBreezeDialog.MessageType messageType;
                String string;
                if (n2 > 0) {
                    string = "Technical support and updates subscription expiring";
                    messageType = AbstractBreezeDialog.MessageType.INFORMATION_OPTION;
                    iconType = Toast.IconType.Info;
                } else {
                    string = "Technical support and updates subscription has expired";
                    messageType = AbstractBreezeDialog.MessageType.WARNING_OPTION;
                    iconType = Toast.IconType.Warning;
                }
                this.listOfNotices.add(new Notice(string, iconType, () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), messageType, string, null, (AbstractBreezeCustomPanel)new SupportPopupPanel(n2), null, breezeActionEvent -> {}), null, false, 5));
            }
        }
        this.checkForUpdateAndWelcome(breezeFrame);
        if (JvmInfo.is32bit() || BreezeFrame.development) {
            this.listOfNotices.add(new Notice("64-bit Java recommended!", Toast.IconType.Warning, breezeFrame::show32bitJavaWarningDialog, null));
        }
        this.listOfNotices.add(new Notice("The Breeze workspace recycle bin is getting large. Empty it using the Menu-button.", Toast.IconType.Info, () -> BreezeRecycleBin.clear(this.mainPanel), BreezeRecycleBin::shouldBeEmptied));
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        this.listOfNotices.add(new Notice("Warning! Low disk space", Toast.IconType.Warning, () -> workspace.showDiscSpaceDialog(breezeFrame), workspace::hasLowDiskSpace));
        BreezeRuntime breezeRuntime = TcpManager.getInstance().getBreezeRuntimeManager();
        if (breezeRuntime != null) {
            new Thread(() -> {
                UpdateHelper.UpdateVersion updateVersion;
                UpdateHelper.UpdateVersion updateVersion2;
                if (ThreadUtil.awaitAndReturn(() -> breezeRuntime.getVersion() != null, Time.Second, new Time.Seconds(10.0)) && (updateVersion2 = breezeRuntime.getVersion()).compareTo3M(updateVersion = InitClass.getBreezeVersion()) != 0) {
                    this.listOfNotices.add(new Notice("Warning! Incompatible versions", Toast.IconType.Warning, () -> this.showIncompatibleVersionsDialog(breezeFrame, updateVersion2, updateVersion), null));
                    this.showIncompatibleVersionsDialog(breezeFrame, updateVersion2, updateVersion);
                }
            }).start();
        }
    }

    private void checkForUpdateAndWelcome(final BreezeFrame breezeFrame) {
        if (!WorkspaceManager.getInstance().isUnitTesting()) {
            UpdateHelper.getDownloadFile((UpdateHelper.Product)UpdateHelper.Product.Breeze, (UpdateHelper.UpdateCheckCallback)new UpdateHelper.UpdateCheckCallback(){
                final /* synthetic */ NoticeButton this$0;
                {
                    this.this$0 = noticeButton;
                }

                public void update(UpdateHelper.DownloadFile downloadFile) {
                    if (InitClass.getBreezeVersion().newer(downloadFile.getVersion()) || BreezeFrame.development) {
                        this.this$0.listOfNotices.add(new Notice("Update is available", Toast.IconType.Info, () -> this.showUpdateDialog(downloadFile), null));
                        if (BreezeProperties.getInstance().isShowUpdateDialog() && !BreezeFrame.development) {
                            this.showUpdateDialog(downloadFile);
                        }
                    } else {
                        this.showWelcomeDialog(breezeFrame);
                    }
                    this.this$0.updateIcon();
                }

                private void showUpdateDialog(UpdateHelper.DownloadFile downloadFile) {
                    BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Update available", "", (AbstractBreezeCustomPanel)new BreezeUpdatePanel(breezeFrame, downloadFile), null, null);
                }

                public void updateFailed(Exception exception) {
                    if (exception != null && !(exception instanceof UnknownHostException)) {
                        Logg.error((String)"Cannot receive download files", (Throwable)exception);
                    }
                    this.showWelcomeDialog(breezeFrame);
                }

                private void showWelcomeDialog(BreezeFrame breezeFrame2) {
                    boolean bl;
                    boolean bl2 = bl = RegisterKeyManager.getRegInfo().isFeatureActive(RegInfo.LicenseFeature.Record) || IniFileReader.getInstance().isCameraInstalled("HySpex SDK");
                    if (welcomeMessageFirstTime && BreezeProperties.getInstance().isShowWelcomeMessage()) {
                        BreezeOptionDialog.showDialog(breezeFrame2, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Welcome to Breeze!", "", (AbstractBreezeCustomPanel)new WelcomePanel(true), null, breezeActionEvent -> BreezeProperties.getInstance().setShowWelcomeMessage((Boolean)breezeActionEvent.result()));
                        welcomeMessageFirstTime = false;
                    } else if (welcomeMessageFirstTime && RegisterKeyManager.getRegInfo().isTrialLicense()) {
                        welcomeMessageFirstTime = !bl;
                        this.this$0.listOfNotices.add(new Notice("Your trial license", Toast.IconType.Info, () -> this.this$0.showTrialPopupDialog(breezeFrame2), null));
                    }
                }
            });
        }
    }

    private void showTrialPopupDialog(BreezeFrame breezeFrame) {
        int n = RegisterKeyManager.getRegInfo().getDaysUntilExpire(UpdateHelper.Product.Breeze);
        boolean bl = RegisterKeyManager.getRegInfo().isFeatureActive(RegInfo.LicenseFeature.Record);
        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION.setDimensionOverrideHeight(300), "Your trial license", "", (AbstractBreezeCustomPanel)new TrialPopupPanel(breezeFrame, n, bl), null, null);
    }

    private void showIncompatibleVersionsDialog(BreezeFrame breezeFrame, UpdateHelper.UpdateVersion updateVersion, UpdateHelper.UpdateVersion updateVersion2) {
        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Incompatible versions", "The Breeze version (" + updateVersion2.format(false) + ") is different from the Breeze Runtime version (" + updateVersion.format(false) + ")\n\nOnly the same versions are guaranteed to be compatible. Please uninstall all Breeze software and reinstall the latest version.");
    }

    private List<Notice> getValidNoticeList() {
        ArrayList<Notice> arrayList = new ArrayList<Notice>();
        for (Notice notice : this.listOfNotices) {
            if (notice.validCallback != null && !notice.validCallback.isValid()) continue;
            arrayList.add(notice);
        }
        return arrayList;
    }

    private List<Notice> getToastMessages() {
        ArrayList<Notice> arrayList = new ArrayList<Notice>();
        for (Notice notice : this.listOfNotices) {
            if (!notice.onlyToast && notice.validCallback != null && !notice.validCallback.isValid()) continue;
            arrayList.add(notice);
        }
        return arrayList;
    }

    @Override
    public void updateIcon() {
        List<Notice> list = this.getValidNoticeList();
        this.numberValid = list.size();
        this.setResourceIcon("material/notifications", true);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.numberValid > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 0, 10.0f));
            graphics2D.setFont(new Font("Dialog", 0, 11));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = String.valueOf(this.numberValid);
            int n = fontMetrics.stringWidth(string);
            int n2 = this.getWidth() / 2 + 10;
            int n3 = (int)((double)this.getHeight() / 3.5) + 5;
            graphics2D.setColor(Color.red);
            graphics2D.fillOval(n2 - 7, n3 - 7, 14, 14);
            graphics2D.setColor(BreezeTheme.WHITE_TEXT);
            graphics2D.drawOval(n2 - 7, n3 - 7, 14, 14);
            graphics2D.setColor(Color.white);
            graphics2D.drawString(string, n2 - n / 2 + 1, n3 + fontMetrics.getHeight() / 3);
        }
    }

    private void handleHySpexRecorderUserRegistration() {
        BreezeOptionDialog.showDialog(this.mainPanel.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION.setDimensionOverrideHeight(450), "Register free full trial of Breeze", "", (AbstractBreezeCustomPanel)new RegisterTrialCustomPanel(this.mainPanel.getFrame()), null, null);
    }

    public void onShow() {
        this.updateIcon();
        if (this.firstTime) {
            this.firstTime = false;
            new Thread(() -> {
                ThreadUtil.sleep(700L);
                SwingUtilities.invokeLater(() -> {
                    for (Notice notice : this.getToastMessages()) {
                        ToastHandler.getInstance().showToast(this.mainPanel.getFrame(), notice.name, notice.iconType, new Time.Seconds((double)notice.timeoutInSeconds), notice.onlyToast ? () -> {} : notice.callback);
                    }
                });
            }).start();
        }
    }

    private record Notice(String name, Toast.IconType iconType, EntryMainHelper.ClickCallBack callback, ValidNoticeCallback validCallback, boolean onlyToast, int timeoutInSeconds) {
        Notice(String string, Toast.IconType iconType, EntryMainHelper.ClickCallBack clickCallBack, ValidNoticeCallback validNoticeCallback) {
            this(string, iconType, clickCallBack, validNoticeCallback, false, 10);
        }

        Notice(String string, Toast.IconType iconType) {
            this(string, iconType, null, () -> false, true, 10);
        }
    }

    public static interface ValidNoticeCallback {
        public boolean isValid();
    }
}

