/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.backend.LicenseManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeEditorPane;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.validator.RegexValidator;
import se.prediktera.breeze.frontend.common.swing.validator.TextValidator;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.PasswordGenerator;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegKeyParserException;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.CreateTrialPage;

public class RegisterTrialCustomPanel
extends AbstractBreezeCustomPanel {
    private final BreezeInputField emailField;
    private final BreezeInputField firstNameField;
    private final BreezeInputField lastNameField;
    private final BreezeInputField organisationField;
    private final BreezeComboBoxInputField<String> interestsComboBox;
    private final BreezeFrame frame;
    private final BreezeInfoPanel licenseValidationWarning;
    private final BreezeCheckBox licenseAgreeCheckbox;

    public RegisterTrialCustomPanel(BreezeFrame breezeFrame) {
        this.frame = breezeFrame;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)new BreezeEditorPane("<html>\nHello HySpex customer!<br/><br/>\nRegister an account to activate your 30 days Free Trial of the full\nBreeze software suite. <a href=\"https://prediktera.com/breeze-suite\">Learn about Breeze</a>\n</html>\n", null, false), new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 10, 1, new Insets(15, 10, 10, 10), 0, 0));
        this.firstNameField = new BreezeInputField("First name*", "", "", BreezeInputFieldHelper.Format.OneRow);
        this.firstNameField.setLabelWidth(150);
        this.firstNameField.addValidator(TextValidator.nonEmpty());
        this.add((Component)this.firstNameField, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.lastNameField = new BreezeInputField("Last name*", "", "", BreezeInputFieldHelper.Format.OneRow);
        this.lastNameField.setLabelWidth(150);
        this.lastNameField.addValidator(TextValidator.nonEmpty());
        this.add((Component)this.lastNameField, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.organisationField = new BreezeInputField("Organisation*", "", "", BreezeInputFieldHelper.Format.OneRow);
        this.organisationField.setLabelWidth(150);
        this.organisationField.addValidator(TextValidator.nonEmpty());
        this.add((Component)this.organisationField, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.emailField = new BreezeInputField("Email*", "", "", BreezeInputFieldHelper.Format.OneRow);
        this.emailField.setLabelWidth(150);
        this.emailField.addValidator(RegexValidator.email());
        this.add((Component)this.emailField, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.interestsComboBox = new BreezeComboBoxInputField<String>("Usage", CreateTrialPage.INTERESTS, (String)CreateTrialPage.INTERESTS.getFirst(), BreezeInputFieldHelper.Format.OneRow);
        this.interestsComboBox.setLabelWidth(150);
        this.add(this.interestsComboBox, new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.licenseAgreeCheckbox = new BreezeCheckBox("Agree to the Prediktera Privacy Policy*", false);
        this.add((Component)new BreezeExternalLinkPanel((JComponent)this.licenseAgreeCheckbox, new URI("https://prediktera.com/privacy-policy/"), false, "material/open_in_browser"), new GridBagConstraints(0, n++, 2, 1, 1.0, 2.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        BreezeInfoPanel breezeInfoPanel = new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, "When the trial expires, the Breeze HySpex Recorder is still available.\n\nThe email must not already be associated with an existing account.", false);
        this.add((Component)breezeInfoPanel, new GridBagConstraints(0, n++, 2, 1, 1.0, 2.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.licenseValidationWarning = new BreezeInfoPanel(BreezeInfoPanel.InfoType.Error, "Line1\n\nLine2", false);
        this.licenseValidationWarning.setVisible(false);
        this.add((Component)this.licenseValidationWarning, new GridBagConstraints(0, n++, 2, 1, 1.0, 1.0, 16, 2, new Insets(0, 10, 10, 10), 0, 0));
    }

    @Override
    public Object getResult() {
        return this.getTrialRegistrationData();
    }

    private LicenseManager.TrialRegistrationData getTrialRegistrationData() {
        return new LicenseManager.TrialRegistrationData(this.emailField.getValue(), this.firstNameField.getValue(), this.lastNameField.getValue(), this.organisationField.getValue(), PasswordGenerator.generateOfLength((int)12), new String[]{this.interestsComboBox.getSelectedItem()}, IniFileReader.getInstance().getInstalledCamerasWithoutBuiltin().toArray(new String[0]));
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        breezeButton.setVisible(true);
        breezeButton.setText("Offline activation");
        breezeButton.addClickCallBack(this::offlineActivation);
        breezeButton2.setText("Register");
    }

    private void offlineActivation() {
        BreezeOptionDialog.showDialog(this.frame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_AREA_OPTION, "Offline activation", "Follow the instructions to obtain an activation code from Prediktera.\nhttps://help.prediktera.com/breeze/how-to-activate-your-license-offline\n\nPaste the license text below, and click OK to activate your license.\n", null, null, breezeActionEvent -> this.activateLicense(breezeActionEvent.result().toString()));
    }

    public void activateLicense(String string) {
        String string2;
        String string3;
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        RegInfo regInfo = this.verifyLicense(string);
        BreezeActionListener breezeActionListener = null;
        AbstractBreezeDialog.MessageType messageType = AbstractBreezeDialog.MessageType.ERROR_OPTION.setDimensionOverrideHeight(200);
        boolean bl = true;
        Color color = BreezeTheme.getInstance().getCautionColor();
        if (regInfo == null) {
            string3 = "Signature error";
            string2 = "Signature is incorrect!\n\nPlease check that the signature is correctly written and try again";
        } else if (regInfo.hasLicenseExpired()) {
            string3 = "License expired";
            string2 = "The license is expired";
        } else if (!regInfo.matchSerial()) {
            string3 = "Invalid device id";
            string2 = "The license does not contain this device's identification code";
        } else if (!regInfo.matchIp()) {
            string3 = "Invalid IP address";
            string2 = "Your IP address is not within the range of the IP specified in your license\nIf your IP is within range, Please check that your computer is connected to Internet and try again";
        } else {
            messageType = AbstractBreezeDialog.MessageType.INFORMATION_OPTION.setOkText("Shutdown Breeze").setDimensionOverrideHeight(200);
            string3 = "License activation successful";
            string2 = "Your license is now activated!\n\nBreeze will exit. Restart it to use your license.";
            color = BreezeType.Project.getColor();
            breezeActionListener = breezeActionEvent -> {
                regInfo.save(IniManager.getEvinceSettingsFile((String)"license.key"));
                BreezeProperties.getInstance().setShowWelcomeMessage(true);
                BreezeFrame.getRunningProduct().exit();
            };
            bl = false;
        }
        BreezeOptionDialog.showDialog(this.frame, color, messageType, string3, string2, null, null, breezeActionListener);
        this.licenseValidationWarning.setText(string2);
        this.licenseValidationWarning.setVisible(bl);
    }

    @Override
    public void okPressed(boolean bl) {
        if (!this.validateFields()) {
            return;
        }
        BreezeProgressDialog.startProgress(this.frame, new ProgressAction(){
            private String result;

            @Override
            public void runAction() {
                try {
                    this.getProgressManager().setInfoText("Creating trial user...");
                    this.result = LicenseManager.createTrialUser(RegisterTrialCustomPanel.this.getTrialRegistrationData(), List.of(RegInfo.LicenseFeature.Record, RegInfo.LicenseFeature.Geo));
                }
                catch (ErrorHandler.MessageException messageException) {
                    RegisterTrialCustomPanel.this.showError(messageException.getMessage());
                }
            }

            @Override
            public void actionFinished() {
                super.actionFinished();
                if (RegisterTrialCustomPanel.this.verifyLicense(this.result) != null) {
                    RegisterTrialCustomPanel.this.activateLicense(this.result);
                }
            }
        }, "Creating a trial account");
    }

    private RegInfo verifyLicense(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        try {
            RegInfo regInfo = new RegInfo(string);
            if (RegisterKeyManager.verifyRegInfo((RegInfo)regInfo)) {
                return regInfo;
            }
        }
        catch (RegKeyParserException regKeyParserException) {
            // empty catch block
        }
        return null;
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!this.licenseAgreeCheckbox.isSelected()) {
            this.licenseAgreeCheckbox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this.licenseAgreeCheckbox.setBorderPainted(true);
            bl = false;
        }
        boolean bl2 = this.emailField.triggerChange(true, true).isPresent();
        boolean bl3 = this.firstNameField.triggerChange(true, true).isPresent();
        boolean bl4 = this.lastNameField.triggerChange(true, true).isPresent();
        boolean bl5 = this.organisationField.triggerChange(true, true).isPresent();
        if (bl2 || bl3 || bl4 || bl5) {
            bl = false;
        }
        return bl;
    }

    private void showError(String string) {
        ToastHandler.getInstance().showToast(string, Toast.IconType.Error);
        this.licenseValidationWarning.setText(string);
        this.licenseValidationWarning.setVisible(true);
    }

    static void main() {
        SwingUtilities.invokeLater(() -> {
            BreezeFrame breezeFrame = new BreezeFrame(UpdateHelper.Product.Breeze);
            breezeFrame.setDefaultCloseOperation(3);
            breezeFrame.setSize(900, 1000);
            breezeFrame.setLocationRelativeTo(null);
            breezeFrame.setVisible(true);
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION.setDimensionOverride(600, 450), "Register Free Trial", "", (AbstractBreezeCustomPanel)new RegisterTrialCustomPanel(breezeFrame), null, breezeActionEvent -> System.out.println("OK pressed, result: " + String.valueOf(breezeActionEvent.result())));
        });
    }
}

