/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeEditorPane;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class TrialPopupPanel
extends AbstractBreezeCustomPanel {
    private final BreezeFrame breezeFrame;

    public TrialPopupPanel(BreezeFrame breezeFrame, int n, boolean bl) {
        this.breezeFrame = breezeFrame;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        StringBuilder stringBuilder = new StringBuilder("<br/>");
        stringBuilder.append("Thanks for trying Breeze! ");
        if (n <= 0) {
            stringBuilder.append("Your trial period has now <b>ended</b>.");
        } else if (n == 1) {
            stringBuilder.append("Your trial will expire <b>tomorrow</b>.");
        } else {
            stringBuilder.append("Your trial will expire in <b>").append(n).append("</b> days.");
        }
        stringBuilder.append("<br/><br/>").append("To continue enjoying all Breeze features, please contact ").append("<a href='mailto:sales@prediktera.se?subject=%5BBreeze%5D%20License%20inquiry'>").append("sales@prediktera.se</a>").append(" for licensing options.");
        if (bl) {
            stringBuilder.append("<br/><br/><i>");
            if (n <= 0) {
                stringBuilder.append("You can still do data acquisition using the Breeze HySpex Recorder. ");
            } else {
                stringBuilder.append("When the trial expires, the Breeze HySpex Recorder is still available. ");
            }
            stringBuilder.append("Modeling and analysis features require a license upgrade.</i>");
        }
        stringBuilder.append("<br/><br/>");
        stringBuilder.append("Online Documentation: <a href='https://help.prediktera.com/breeze'>https://help.prediktera.com</a>");
        stringBuilder.append("<br/>");
        stringBuilder.append("Customer Support: <a href='https://prediktera.com/resources/support?lid=").append(RegisterKeyManager.getRegInfo().LID).append("&uid=").append(RegisterKeyManager.getRegInfo().ID).append("'>https://prediktera.com</a>");
        stringBuilder.append("<br/>");
        stringBuilder.append("Activate license: <a href='breeze://show_license_wizards'>Show wizard</a>");
        BreezeEditorPane breezeEditorPane = new BreezeEditorPane(stringBuilder.toString(), this::showLicenseWizard);
        this.add((Component)breezeEditorPane, GridBagHelper.createLast(0, new Insets(0, 0, 0, 0)));
        this.setPreferredSize(new Dimension(680, 400));
    }

    private boolean showLicenseWizard(HyperlinkEvent hyperlinkEvent) {
        if (!StringHelper.startsWith((CharSequence)hyperlinkEvent.getDescription(), (CharSequence)"breeze://")) {
            return false;
        }
        new RegisterWizard(RegisterKeyManager.getRegInfo(), UpdateHelper.Product.Breeze).executeWizard((Frame)this.breezeFrame, UpdateHelper.Product.Breeze, InitClass.getBreezeVersion());
        return true;
    }

    @Override
    public Object getResult() {
        return true;
    }

    static void main() {
        SwingUtilities.invokeLater(() -> {
            BreezeFrame breezeFrame = new BreezeFrame(UpdateHelper.Product.Breeze);
            breezeFrame.setDefaultCloseOperation(3);
            breezeFrame.setSize(900, 700);
            breezeFrame.setLocationRelativeTo(null);
            breezeFrame.setVisible(true);
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION.setDimensionOverrideHeight(300), "Your trial license", "", (AbstractBreezeCustomPanel)new TrialPopupPanel(breezeFrame, 0, true), null, breezeActionEvent -> System.out.println("OK pressed, result: " + String.valueOf(breezeActionEvent.result())));
        });
    }
}

