/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeEditorPane;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.main.settings.help.HelpPanel;
import se.prediktera.map.common.swing.LinkLabel;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.IniFileReader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class WelcomePanel
extends AbstractBreezeCustomPanel {
    private final BreezeCheckBox hideDialogCheckBox = new BreezeCheckBox("Don't show this window when Breeze starts (click Intro to re-open it later)", false);

    public WelcomePanel(boolean bl) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        boolean bl2 = regInfo.isFeatureActive(RegInfo.LicenseFeature.HySpexRecorder) || RegInfo.isRecordFeature() && regInfo.getDaysUntilExpire(UpdateHelper.Product.Breeze) <= 0 && regInfo.isTrialLicense();
        String string = InitClass.getBreezeVersion().formatMajorMinor();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        stringBuilder.append("<b>Learn about Breeze</b>");
        stringBuilder.append("<br>");
        stringBuilder.append("<ul style='padding-left:18px;'>");
        if (bl2 || regInfo.isTrialLicense()) {
            stringBuilder.append("<li style='margin-top:10px'><a href='https://prediktera.com/breeze-suite')>Why choose Breeze</a></li>");
        }
        stringBuilder.append("<li style='margin-top:10px'><a href='https://help.prediktera.com/breeze/v").append(string).append("'>New features in Breeze ").append(string).append("</a></li>");
        if (bl2) {
            stringBuilder.append("<li style='margin-top:10px'><a href='https://help.prediktera.com/breeze/hyspex-recorder'>Breeze HySpex Recorder</a> - features and differences from Breeze</li>");
        }
        stringBuilder.append("<li style='margin-top:10px'><a href='https://help.prediktera.com/breeze/system-overview'>Breeze system overview</a></li>");
        if (regInfo.isFeatureActive(RegInfo.LicenseFeature.Industrial)) {
            stringBuilder.append("<li style='margin-top:10px'><a href='https://help.prediktera.com/breeze-runtime/introduction-to-breeze-runtime-development'>Introduction to Breeze Runtime development</a></li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("<br>Browse and search the full help at <a href='https://help.prediktera.com'>help.prediktera.com</a>");
        stringBuilder.append("<br<br><b>Tutorials</b>");
        stringBuilder.append("<br><a href='https://help.prediktera.com/breeze/tutorials'>View all tutorials</a>");
        stringBuilder.append("</html>");
        BreezeEditorPane breezeEditorPane = new BreezeEditorPane(stringBuilder.toString());
        breezeEditorPane.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.add((Component)breezeEditorPane, "First");
        this.add((Component)WelcomePanel.createTutorialAndVideoPanel(regInfo, bl2), "Before");
        if (bl) {
            this.add((Component)this.hideDialogCheckBox, "Last");
        }
        this.setPreferredSize(new Dimension(650, bl2 ? 450 : 800));
    }

    private static JPanel createTutorialAndVideoPanel(RegInfo regInfo, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        try {
            if (IniFileReader.getInstance().isCameraInstalled("HySpex SDK")) {
                WelcomePanel.addTutorial(new Tutorial("Breeze HySpex Recorder Guide", "breeze/breeze-hyspex-recorder-guide", null, RegInfo.LicenseFeature.HySpexRecorder), jPanel, n++);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            Tutorial[] tutorialArray;
            for (Tutorial tutorial : tutorialArray = new Tutorial[]{new Tutorial("Using Recorder for data acquisition", "breeze/recorder", null, RegInfo.LicenseFeature.Record), new Tutorial("Quantification of powder samples", "breeze/quantification-of-powder-samples", "PxCQsFmD4qw", RegInfo.LicenseFeature.Application), new Tutorial("Classification of nuts \u2013 step 1 basic", "breeze/classification-of-nuts-step-1", "xye91D6ILJQ", RegInfo.LicenseFeature.Application), new Tutorial("Classification of nuts \u2013 step 2 advanced", "breeze/classification-of-nuts-step-2", "BwG-5fctJ4g", RegInfo.LicenseFeature.Application), new Tutorial("Classification of nuts \u2013 step 3 machine learning", "breeze/classification-of-nuts-step-3", "VkrS291kxec", RegInfo.LicenseFeature.Application), new Tutorial("Classification of plastics", "breeze/plastic-classification", null, RegInfo.LicenseFeature.Application), new Tutorial("Core logging and classification", "breeze/logging-and-classification-tutorial", null, RegInfo.LicenseFeature.Geo), new Tutorial("Peru Mineral Mosaic SAM Classification", "breeze/peru-mosaic", null, RegInfo.LicenseFeature.Geo), new Tutorial("Field shapefile classification", "breeze/shapefile-classification", null, RegInfo.LicenseFeature.Geo), new Tutorial("Runtime classification of nuts", "breeze-runtime/runtime-classification-of-nuts", null, RegInfo.LicenseFeature.Industrial)}) {
                if (!regInfo.isFeatureActive(tutorial.licenseFeature)) continue;
                WelcomePanel.addTutorial(tutorial, jPanel, n);
                ++n;
            }
        }
        return jPanel;
    }

    private static void addTutorial(Tutorial tutorial, JPanel jPanel, int n) {
        LinkLabel linkLabel = HelpPanel.createLink(tutorial.title, "open_in_browser", "https://help.prediktera.com/" + tutorial.slug);
        linkLabel.setPreferredSize(new Dimension(440, 32));
        jPanel.add((Component)linkLabel, GridBagHelper.create(0, n, new Insets(n == 0 ? 0 : 6, 24, 0, 0), false));
        if (tutorial.videoId != null) {
            jPanel.add((Component)HelpPanel.createLink("Video", "smart_display", "https://youtu.be/" + tutorial.videoId), GridBagHelper.create(1, n, new Insets(n == 0 ? 0 : 6, 24, 0, 0), true));
        }
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return !this.hideDialogCheckBox.isSelected();
    }

    private record Tutorial(String title, String slug, String videoId, RegInfo.LicenseFeature licenseFeature) {
    }
}

