/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.ModelListHelper;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.GroupNode;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.RecordGroupHolder;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.util.PPModelInfo;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.DeleteEntryCustomPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportModel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.BreezeNodeTogglePanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.preview.AnalysePopup;
import se.prediktera.breeze.frontend.main.model.ModelOverviewPanel;
import se.prediktera.breeze.frontend.main.model.ModelStatisticsViewContainer;
import se.prediktera.breeze.frontend.main.model.PostProcessingModelPanel;
import se.prediktera.breeze.frontend.main.model.table.ModelCompareViewContainer;
import se.prediktera.breeze.frontend.main.model.table.ModelTableViewContainer;
import se.prediktera.breeze.frontend.main.model.table.ModelVersionsViewContainer;
import se.prediktera.breeze.frontend.main.model.table.PredictionTableViewContainer;
import se.prediktera.breeze.frontend.wizard.model.ANNModelWizard;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationSimcaModelWizard;
import se.prediktera.breeze.frontend.wizard.model.CurveSeparationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectVariablePanelStep;
import se.prediktera.map.common.error.ErrorHandler;

public class ModelMainPanel
extends EntryMainSwitchPanel {
    public ModelMainPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame) {
        this(breezeProgress, breezeFrame, null);
    }

    public ModelMainPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame, Workflow workflow) {
        super(breezeFrame, BreezeType.Analyse);
        for (BasicAnalyse basicAnalyse : BreezeMasterCache.getInstance().getAnalyseList()) {
            if (!(basicAnalyse instanceof Analyse)) continue;
            Analyse analyse = (Analyse)basicAnalyse;
            analyse.setDefaultProperties(workflow);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new ViewClass("Overview", new ModelOverviewPanel(this)));
        arrayList.add(new ViewClass("Statistics", new ModelStatisticsViewContainer(breezeProgress, this)));
        arrayList.add(new ViewClass("Table", new ModelTableViewContainer(this)));
        arrayList.add(new ViewClass("Classification", new PredictionTableViewContainer(this)));
        arrayList.add(new ViewClass("Compare", new ModelCompareViewContainer(this)));
        arrayList.add(new ViewClass("Versions", new ModelVersionsViewContainer(this)));
        arrayList.add(new ViewClass("Import / Export", new PostProcessingModelPanel(this)));
        this.setLists(arrayList, BreezeMasterCache.getInstance().getAnalyseList(), "ModelTree_big");
        this.setStudyContext(workflow);
        this.setStatusPanel(this.createStatusPanel());
    }

    @Override
    protected BreezeButton createNextButton() {
        return EntryMainHelper.createColorNextButton("Train", "AnalyseIconSmall", () -> this.openButtonClicked(this.getSelectedEntry()), BreezeType.Analyse.getColor());
    }

    @Override
    protected int getMainHeight() {
        return 90;
    }

    protected void groupLocal(HashMap<Object, BasicEntry> hashMap, List list, BasicEntry basicEntry, String string) {
        Analyse analyse;
        if (string.equals("none")) {
            list.add(basicEntry);
        } else if (basicEntry instanceof Analyse && this.contextFilter.matches(analyse = (Analyse)basicEntry)) {
            BasicAnalyse.ModelType modelType = analyse.getModelMethod().getType();
            GroupNode groupNode = (GroupNode)hashMap.get((Object)modelType);
            if (groupNode == null) {
                groupNode = new GroupNode();
                groupNode.setName(modelType.name());
                groupNode.setUid(modelType.name());
                list.add(groupNode);
                hashMap.put((Object)modelType, groupNode);
            }
            groupNode.addChild(analyse);
        }
    }

    @Override
    protected BreezeMainPanel createOpenPanel(BreezeProgress breezeProgress, Object object) {
        return ModelMainPanel.createModelWizard(breezeProgress, this, (Analyse)object, () -> this.setDirty(true));
    }

    @Override
    protected double getOpenEntrySizePercent() {
        return 0.9;
    }

    protected void showCardDialog() {
        List<AbstractCardInfo> list = ModelListHelper.getModelTypesSorted(this.getStudyContext());
        ArrayList<BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>> arrayList = new ArrayList<BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>>();
        Workflow workflow = this.getStudyContext();
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("All", "All", "Method", list));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("Sample", "Add new sample model", "Method", ModelMainPanel.getModels(list, AbstractCardInfo.GroupType.Sample)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("Quantification", "Add new quantification model", "Method", ModelMainPanel.getModels(list, AbstractCardInfo.GroupType.Quantification)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("Classification", "Add new classification model", "Method", ModelMainPanel.getModels(list, AbstractCardInfo.GroupType.Classification)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("Import", "Import existing models", "Method", ModelMainPanel.getModels(list, AbstractCardInfo.GroupType.Import)));
        BreezeNodeTogglePanel breezeNodeTogglePanel = new BreezeNodeTogglePanel(arrayList, this.getPageType(), null);
        breezeNodeTogglePanel.setPreferredSize(new Dimension(1000, 650));
        breezeNodeTogglePanel.setMinimumSize(new Dimension(500, 500));
        breezeNodeTogglePanel.setMaximumSize(new Dimension(this.frame.getWidth() - 100, this.frame.getHeight() - 100));
        BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, "Add new model", "", (AbstractBreezeCustomPanel)breezeNodeTogglePanel, null, breezeActionEvent2 -> {
            AbstractCardInfo abstractCardInfo = ((BreezeNodeTogglePanel)breezeActionEvent2.getBreezeCustomPanel()).getType();
            if (abstractCardInfo instanceof ModelListHelper.AbstrtactImportCard) {
                final ModelListHelper.AbstrtactImportCard abstrtactImportCard = (ModelListHelper.AbstrtactImportCard)abstractCardInfo;
                BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this, this.getFrame(), 0.9){
                    final /* synthetic */ ModelMainPanel this$0;
                    {
                        this.this$0 = modelMainPanel;
                        super(breezeFrame, d);
                    }

                    @Override
                    protected BreezeMainPanel createOpenPanel() {
                        return abstrtactImportCard.createWizard(this.this$0, this.this$0.getStudyContext());
                    }
                }, "Opening...");
                this.showFirstTab();
                return;
            }
            PPModelInfo pPModelInfo = (PPModelInfo)abstractCardInfo;
            Object object = pPModelInfo.getGroup().toString();
            if (workflow != null) {
                object = (String)object + " - " + workflow.getName();
            }
            String string = "New " + StringUtils.uncapitalize((String)pPModelInfo.getGroup().toString()) + " model";
            String string2 = "Enter a name for the new model:\n(" + pPModelInfo.getShortDescription() + ")";
            BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, string, string2, object, breezeActionEvent -> {
                Analyse analyse = ModelMainPanel.createAnalyseAndSave(workflow, EntryMainHelper.getUniqueName(breezeActionEvent.getInputText(), this.getEntryList().getList()), pPModelInfo);
                this.addEntry(analyse);
                this.openButtonClicked(analyse);
            });
        });
    }

    public static List<AbstractCardInfo> getModels(List<AbstractCardInfo> list, AbstractCardInfo.GroupType groupType) {
        ArrayList<AbstractCardInfo> arrayList = new ArrayList<AbstractCardInfo>();
        for (AbstractCardInfo abstractCardInfo : list) {
            if (groupType != AbstractCardInfo.GroupType.All && groupType != abstractCardInfo.getGroup()) continue;
            arrayList.add(abstractCardInfo);
        }
        return arrayList;
    }

    @Override
    protected void createLocal() {
        if (BreezeFrame.isModelCardDialog()) {
            this.showCardDialog();
            return;
        }
        ArrayList<BreezeTogglePanel.ToggleItem> arrayList = new ArrayList<BreezeTogglePanel.ToggleItem>();
        Workflow workflow = this.getStudyContext();
        arrayList.add(new ModelToggleItem(workflow, new SampleModelWizard.Info()));
        arrayList.add(new ModelToggleItem(workflow, new QuantificationModelWizard.Info()));
        arrayList.add(new ModelToggleItem(workflow, new ClassificationModelWizard.Info()));
        arrayList.add(new BreezeTogglePanel.ToggleItem("Import", "Import model from file", "material/download_2"));
        BreezeOptionDialog.showDialog(this.frame, this.getPageColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, "New Model", "", (AbstractBreezeCustomPanel)new BreezeTogglePanel(arrayList, this.getPageType(), "", (breezeTogglePanel, toggleItem) -> {
            if (workflow != null) {
                breezeTogglePanel.setInputName(toggleItem.getName() + " - " + workflow.getName());
            } else {
                breezeTogglePanel.setInputName(toggleItem.getName());
            }
            breezeTogglePanel.getNameInputField().setEnabled(!toggleItem.getName().equals("Import"));
        }, 0), null, breezeActionEvent -> {
            BreezeTogglePanel.ToggleItem toggleItem = (BreezeTogglePanel.ToggleItem)breezeActionEvent.result();
            if (toggleItem.getName().equals("Import")) {
                BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this.getFrame()){

                    @Override
                    protected BreezeMainPanel createOpenPanel() {
                        return new PPImportModel(ModelMainPanel.this, "Import Model");
                    }
                }, "Opening...");
                this.showFirstTab();
            } else if (toggleItem instanceof ModelToggleItem) {
                ModelToggleItem modelToggleItem = (ModelToggleItem)breezeActionEvent.result();
                BreezeTogglePanel breezeTogglePanel = (BreezeTogglePanel)breezeActionEvent.getBreezeCustomPanel();
                PPModelInfo pPModelInfo = modelToggleItem.getPPInfo(breezeTogglePanel.getType());
                Analyse analyse = ModelMainPanel.createAnalyseAndSave(workflow, EntryMainHelper.getUniqueName(breezeTogglePanel.getInputName(), this.getEntryList().getList()), pPModelInfo);
                this.addEntry(analyse);
                this.openButtonClicked(analyse);
            }
        });
    }

    @Override
    public void rightClickOnSelected(MouseEvent mouseEvent) {
        AnalysePopup.showAnalysisPopup(this, this.getSelectedEntries(), mouseEvent);
    }

    @Override
    protected Entry duplicateEntry(BreezeProgressManager breezeProgressManager, Object object, String string, boolean bl, boolean bl2) {
        return ((Analyse)object).createDuplicateAndSave(string);
    }

    @Override
    protected DeleteEntryCustomPanel getDependantMessageBeforeDelete(Object object) {
        Analyse analyse = (Analyse)object;
        ArrayList<BasicWorkflow> arrayList = new ArrayList<BasicWorkflow>(analyse.getAssociatedStudies());
        ArrayList<BasicWorkflow> arrayList2 = new ArrayList<BasicWorkflow>(analyse.getAssociatedWorkflows());
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return null;
        }
        DeleteEntryCustomPanel deleteEntryCustomPanel = new DeleteEntryCustomPanel(analyse, "Model \"" + analyse.getName() + "\" is used in following:", "Confirm remove model from workflow(s)");
        deleteEntryCustomPanel.add(arrayList, BreezeType.Project);
        deleteEntryCustomPanel.add(arrayList2, BreezeType.Workflow);
        return deleteEntryCustomPanel;
    }

    @Override
    protected void showEmptyPage() {
        super.showEmptyPage();
        this.nextButton.setDesc("Train");
    }

    @Override
    protected void entrySelected(Object object) {
        List<Object> list;
        GroupNode groupNode;
        this.nextButton.setEnabled(true);
        if (object instanceof Analyse) {
            Analyse analyse = (Analyse)object;
            if (analyse.isGrayed()) {
                this.nextButton.setDesc("Train");
                return;
            }
            this.nextButton.setDesc("Retrain");
        } else if (object instanceof GroupNode && (groupNode = (GroupNode)object).isExpanded() && !(list = groupNode.getChildList()).isEmpty()) {
            this.selectEntry(list.getFirst());
        }
    }

    @Override
    public String getEntryName() {
        return "Model";
    }

    public static BreezeMainPanel createModelWizard(BreezeProgress breezeProgress, BreezeMainPanel breezeMainPanel, Analyse analyse, AbstractModelWizard.OnFinishWizardCallback onFinishWizardCallback) {
        RecordGroupHolder recordGroupHolder = analyse.getRecordGroupHolder();
        if (recordGroupHolder.getGroups().isEmpty()) {
            BreezeOptionDialog.showDialog(breezeMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "No record group(s)", "At least one record group is required to continue.\n\nDo you want to Edit this Model and add one or several Record group(s)?", breezeActionEvent -> EntryMainHelper.showEditPanel(breezeMainPanel, false));
            return null;
        }
        PPModelInfo pPModelInfo = PPModelInfo.fromModelMethod(analyse.getModelMethod());
        return pPModelInfo.createWizard(breezeProgress, breezeMainPanel, new PPViewClass(pPModelInfo), analyse, onFinishWizardCallback);
    }

    public static Analyse createAnalyseAndSave(Workflow workflow, String string, PPModelInfo pPModelInfo) {
        Analyse analyse = ModelMainPanel.createAnalyse(workflow, string, pPModelInfo.getModelMethod());
        ModelMainPanel.checkModelMeasurementsAndVariables(workflow, analyse);
        analyse.save();
        return analyse;
    }

    private static void checkModelMeasurementsAndVariables(Workflow workflow, Analyse analyse) {
        Measurement measurement = analyse.getRecordGroupHolder().getFirstMeasurementWithData();
        if (measurement == null) {
            throw new ErrorHandler.InformationMessageException("No measurement(s) found in any configured Record Groups");
        }
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        FactorHolder factorHolder = workflow.getFactorHolder();
        List<DescriptorTreeNode> list = workflow.getAllDescriptorNodes();
        if (modelMethod.isClassification() && factorHolder.getCategoryFactors().isEmpty() && !ModelMainPanel.supportedCategoryDescriptors(list)) {
            throw new ErrorHandler.InformationMessageException("No categories found in the Record Study");
        }
        if (modelMethod.isQuantification() && factorHolder.getPropertyFactors().isEmpty() && !ModelMainPanel.supportedPropertyDescriptors(list)) {
            throw new ErrorHandler.InformationMessageException("No properties found in the Record Study");
        }
    }

    private static boolean supportedCategoryDescriptors(List<DescriptorTreeNode> list) {
        for (DescriptorTreeNode descriptorTreeNode : list) {
            if (!SelectVariablePanelStep.supportDescriptorAsCategory(descriptorTreeNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean supportedPropertyDescriptors(List<DescriptorTreeNode> list) {
        for (DescriptorTreeNode descriptorTreeNode : list) {
            if (!SelectVariablePanelStep.supportDescriptorAsProperty(descriptorTreeNode)) continue;
            return true;
        }
        return false;
    }

    public static Analyse createAnalyse(Workflow workflow, String string, BasicAnalyse.ModelMethod modelMethod) {
        Analyse analyse = new Analyse(string, modelMethod);
        if (workflow != null) {
            analyse.setStudyId(workflow.getUid());
            for (Group group : workflow.getChildList()) {
                analyse.getRecordGroupHolder().addGroup(group);
            }
        }
        analyse.setDefaultProperties(workflow);
        return analyse;
    }

    public static class ModelToggleItem
    extends BreezeTogglePanel.ToggleItem<BasicAnalyse.ModelMethod> {
        private final PPModelInfo info;

        public ModelToggleItem(Workflow workflow, PPModelInfo pPModelInfo) {
            super(pPModelInfo.getShortName(), pPModelInfo.getDescription(), "Method", pPModelInfo.getTypes(workflow));
            this.info = pPModelInfo;
        }

        @Override
        public String getDescription(Object object) {
            return this.getPPInfo(object).getDescription();
        }

        public PPModelInfo getPPInfo(Object object) {
            if (object != null) {
                if (object.equals((Object)BasicAnalyse.ModelMethod.SimcaClassification)) {
                    return new ClassificationSimcaModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.ClassificationCurveSeparation)) {
                    return new CurveSeparationModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.ClassificationRuntime)) {
                    return new ClassificationRuntimeModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.QuantificationRuntime)) {
                    return new QuantificationRuntimeModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.ClassificationANN)) {
                    return new ANNModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.SamplePca)) {
                    return new SampleModelWizard.Info();
                }
                if (object.equals((Object)BasicAnalyse.ModelMethod.SampleRuntime)) {
                    return new SampleRuntimeModelWizard.Info();
                }
            }
            return this.info;
        }
    }
}

