/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.ModelInformation;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeListReadOnlyField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.model.AbstractModel;

public class ModelOverviewPanel
extends EntryOverviewPanel {
    private final BreezeLabelField typeLabelField;
    private final BreezeLabelField modelTypeLabelField;
    private final BreezeListReadOnlyField factorListField = new BreezeListReadOnlyField("Factors");
    private final BreezeListReadOnlyField setupListField = new BreezeListReadOnlyField("Information");
    private final BreezeListReadOnlyField rangesListField = new BreezeListReadOnlyField("Wavelength ranges");
    private final BreezeListReadOnlyField pretreatmentListField = new BreezeListReadOnlyField("Pretreatments (In applied order)");
    private final BreezeListReadOnlyField crossvalidationListField = new BreezeListReadOnlyField("Crossvalidation");
    private final BreezeListReadOnlyField segmentationListField = new BreezeListReadOnlyField("Segmentation");
    private final BreezeListReadOnlyField recordListField = new BreezeListReadOnlyField("Record groups");
    private final BreezeListReadOnlyField externalRecordListField = new BreezeListReadOnlyField("External record test groups");
    private final BreezeLabelField machineLearningTrainerLabelField;
    private Analyse analyse;
    private final RatingPanel ratingPanel;

    public ModelOverviewPanel(EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.typeLabelField = this.addLabelField("Type");
        this.modelTypeLabelField = this.addLabelField("Method");
        this.machineLearningTrainerLabelField = this.addLabelField("Algorithm");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.ratingPanel = new RatingPanel();
        this.add(this.ratingPanel, gridBagConstraints);
        this.addComponentToField(this.factorListField);
        this.addComponentToField(this.setupListField);
        this.addComponentToField(this.rangesListField);
        this.addComponentToField(this.pretreatmentListField);
        this.addComponentToField(this.crossvalidationListField);
        this.addComponentToField(this.segmentationListField);
        this.addComponentToField(this.recordListField);
        this.addComponentToField(this.externalRecordListField);
        this.recordListField.setLayoutOrientation(0);
        this.externalRecordListField.setLayoutOrientation(0);
        this.segmentationListField.setLayoutOrientation(0);
    }

    @Override
    protected Image getDefaultImage() {
        URL uRL = this.getClass().getResource("/images/ModelTree_big.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon.getImage();
    }

    @Override
    protected void setListsToField(BasicEntry basicEntry) {
        Object object;
        this.analyse = (Analyse)basicEntry;
        BasicAnalyse.ModelMethod modelMethod = this.analyse.getModelMethod();
        this.typeLabelField.setValue(modelMethod.getTypeName());
        this.modelTypeLabelField.setValue(StringHelper.formatLabel(modelMethod.getMethod()));
        if (modelMethod.isRuntime()) {
            object = this.analyse.getTopRuntimeMLResults();
            this.machineLearningTrainerLabelField.setValue((String)object.getLeft());
            this.machineLearningTrainerLabelField.setVisible(true);
        } else {
            this.machineLearningTrainerLabelField.setVisible(false);
        }
        this.recordListField.setList(this.analyse.getGroups());
        this.externalRecordListField.setList(this.analyse.getExternalGroups());
        this.externalRecordListField.setVisibleIfItems();
        object = new ArrayList();
        try {
            Integer n = this.analyse.getSegmentationIdentifier().Level;
            if (n >= 0) {
                this.analyse.checkFullyParsed();
                object.addAll(this.analyse.getWorkflow().getSegmentationNodes(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.segmentationListField.setList((List)object);
        this.segmentationListField.setVisibleIfItems();
        this.addModelInformation(this.analyse);
        if (modelMethod.isClassification()) {
            this.factorListField.setLabelText("Category");
            this.factorListField.setList(this.analyse.getCategoryFactors().getList());
        } else if (modelMethod.isQuantification()) {
            this.factorListField.setLabelText("Properties");
            this.factorListField.setList(this.analyse.getPropertyFactors().getList());
        } else {
            this.factorListField.setEmptyList();
        }
        this.factorListField.setVisibleIfItems();
    }

    private void addModelInformation(Analyse analyse) {
        List<Object> list;
        Object object;
        List<Object> list2;
        ArrayList arrayList = new ArrayList();
        ArrayList<ViewClass> arrayList2 = new ArrayList<ViewClass>();
        ModelInformation modelInformation = analyse.getModelInformation();
        if (modelInformation != null) {
            list2 = modelInformation.getListOfPretreatments().stream().map(ViewClass::new).collect(Collectors.toList());
            modelInformation.getNumberOfSamples().ifPresent(n -> this.addSetupEntry((List<ViewClass>)arrayList, n.intValue(), analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.SamplePca) ? "Measurements" : "Samples"));
            modelInformation.getNumberOfWaveLenghts().ifPresent(n -> this.addSetupEntry((List<ViewClass>)arrayList, n.intValue(), "Wavelengths"));
            modelInformation.getNumberComponents().ifPresent(n -> this.addSetupEntry((List<ViewClass>)arrayList, n.intValue(), "Components"));
            modelInformation.getDcrit().ifPresent(d -> this.addSetupEntry((List<ViewClass>)arrayList, NiceDataFormat.toString((double)d), "Dcrit"));
            modelInformation.getHotelling().ifPresent(d -> this.addSetupEntry((List<ViewClass>)arrayList, NiceDataFormat.toString((double)d), "Hotelling T2"));
            modelInformation.getMLTrainingSeconds().ifPresent(n -> this.addSetupEntry((List<ViewClass>)arrayList, n.intValue(), "Sec"));
            object = analyse.getWorkflowElseNull();
            if (object != null && (list = modelInformation.getFormatedRanges((Workflow)object)) != null) {
                for (String string : list) {
                    this.addSetupEntry(arrayList2, string);
                }
            }
        } else {
            list2 = new ArrayList();
        }
        if ((object = analyse.getFormatedRating()) != null) {
            this.ratingPanel.setValue((String)object);
            this.ratingPanel.setVisible(true);
        } else {
            this.ratingPanel.setVisible(false);
        }
        this.setupListField.setList(arrayList);
        this.setupListField.setVisibleIfItems();
        this.rangesListField.setList(arrayList2);
        this.rangesListField.setVisibleIfItems();
        this.pretreatmentListField.setList(list2);
        this.pretreatmentListField.setVisibleIfItems();
        list = new ArrayList<ViewClass>();
        if (analyse.getModelMethod().hasCrossvalidation()) {
            XmlProperties xmlProperties = analyse.getProperties();
            this.addSetupEntry(list, xmlProperties.getPropertyBoolLocal("modelling/cvFull", false) ? "Full" : "Partial");
            this.addSetupEntry(list, xmlProperties.getPropertyIntLocal("modelling/cvGroups", 7), "Groups");
            this.addSetupEntry(list, StringHelper.formatLabel(xmlProperties.getPropertyLocal("modelling/cvType", "EvenlySpread")));
        }
        this.crossvalidationListField.setList(list);
        this.crossvalidationListField.setVisibleIfItems();
        this.getFieldPanel().revalidate();
        this.getFieldPanel().repaint();
    }

    public static List<AbstractModel> getModels(AbstractModel abstractModel) {
        ArrayList<AbstractModel> arrayList = new ArrayList<AbstractModel>();
        for (int i = 0; i < abstractModel.getTreeNodeCount(); ++i) {
            if (!(abstractModel.getTreeNodeAt(i) instanceof AbstractModel)) continue;
            arrayList.add((AbstractModel)abstractModel.getTreeNodeAt(i));
        }
        return arrayList;
    }

    public void addSetupEntry(List<ViewClass> list, float f, String string) {
        this.addSetupEntry(list, NiceDataFormat.toString((double)f), string);
    }

    public void addSetupEntry(List<ViewClass> list, String string, String string2) {
        if (string != null) {
            list.add(new ViewClass(string + " " + string2));
        }
    }

    public void addSetupEntry(List<ViewClass> list, String string) {
        if (string != null) {
            list.add(new ViewClass(string));
        }
    }

    private static class RatingPanel
    extends JPanel {
        private final JLabel ratingLabel = new JLabel();

        public RatingPanel() {
            super(new GridBagLayout());
            this.setBackground(BreezeType.Analyse.getColor());
            this.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse(), 4));
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(100, 100));
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            jLabel.setForeground(new Color(255, 255, 255));
            jLabel.setText("Rating");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            this.ratingLabel.setBackground(new Color(102, 102, 102));
            this.ratingLabel.setFont(new Font("Tahoma", 0, 30));
            this.ratingLabel.setForeground(new Color(255, 255, 255));
            this.ratingLabel.setHorizontalAlignment(0);
            this.ratingLabel.setText("0");
            this.ratingLabel.setVerticalAlignment(0);
            this.ratingLabel.setHorizontalTextPosition(0);
            this.ratingLabel.setMaximumSize(new Dimension(60, 60));
            this.ratingLabel.setMinimumSize(new Dimension(60, 60));
            this.ratingLabel.setPreferredSize(new Dimension(60, 30));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.ratingLabel, gridBagConstraints);
        }

        public void setValue(String string) {
            this.ratingLabel.setText(string);
        }
    }
}

