/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.CurveSeparationPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ExcludeOutlierPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.SampleOutlierPanelStep;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class ModelStatisticsViewContainer
extends ViewContainer {
    private final List<VisualizationType> visualizations = new ArrayList<VisualizationType>();
    private Analyse analyse;
    private EvaluatePanelStep.ModelYcalcPlot modelYcalcPlot;
    private TabViewContainer tabViewContainer;

    public ModelStatisticsViewContainer(BreezeProgress breezeProgress, EntryMainPanel entryMainPanel) {
        super(entryMainPanel, false);
        this.addPlsOverviewPlots(entryMainPanel, true);
        this.addPcaOverviewPlots();
        this.addSimcaOverviewPlots(entryMainPanel);
        this.addCurveSeparationOverviewPlots(entryMainPanel);
    }

    private void addPlsOverviewPlots(final EntryMainPanel entryMainPanel, final boolean bl) {
        ExcludeOutlierPanelStep.ScoreVariancePlot scoreVariancePlot = new ExcludeOutlierPanelStep.ScoreVariancePlot((PPEntryMainInterface)entryMainPanel, null, null);
        scoreVariancePlot.setName("statisticsscore2d");
        this.addViewPanel((Component)((Object)scoreVariancePlot), 0, 0, 1, 2, BasicAnalyse.ModelMethod.QuantificationPls, BasicAnalyse.ModelMethod.ClassificationPlsDa);
        this.modelYcalcPlot = new EvaluatePanelStep.ModelYcalcPlot((PPEntryMainInterface)this.mainpanel, null, null);
        this.tabViewContainer = new TabViewContainer(this.mainpanel){

            @Override
            public void updateSelected(ViewClass viewClass) {
                ModelStatisticsViewContainer.this.modelYcalcPlot.setVariable(this.getSelectedTabIndex() + 1);
                super.updateSelected(viewClass);
            }
        };
        this.addViewPanel((Component)((Object)this.tabViewContainer), 0, 2, 1, 2, BasicAnalyse.ModelMethod.QuantificationPls, BasicAnalyse.ModelMethod.ClassificationPlsDa);
        this.tabViewContainer.addTab(this.modelYcalcPlot);
        this.addViewPanel((Component)((Object)new PlotViewPanel(this.mainpanel, "Overview (Total for all Y)", "Column", new String[]{"model_q2y_cum", "model_r2y_cum"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(2)});
                abstractPlotLayout.addLegend(new Object[]{"color", "right"});
            }
        }), 1, 0, 1, 2, BasicAnalyse.ModelMethod.QuantificationPls, BasicAnalyse.ModelMethod.ClassificationPlsDa);
        this.addViewPanel((Component)((Object)new EvaluatePanelStep.VariableOverviewPanel(entryMainPanel)), 1, 2, 1, 1, BasicAnalyse.ModelMethod.QuantificationPls, BasicAnalyse.ModelMethod.ClassificationPlsDa);
        this.addViewPanel((Component)((Object)new PlotViewPanel(this, entryMainPanel, "Distance to model in X", "Column", new String[]{"model_obsdmx", "model_obsdmxpred"}){
            final /* synthetic */ ModelStatisticsViewContainer this$0;
            {
                this.this$0 = modelStatisticsViewContainer;
                super(pPEntryMainInterface, string, string2, stringArray);
            }

            @Override
            public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.preSetup(breezeProgressManager, abstractPlotLayout);
                abstractPlotLayout.show("autorescale", Double.valueOf(0.0));
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                this.this$0.setClassesColor(bl, abstractPlotLayout, entryMainPanel);
                abstractPlotLayout.setStatistics(new Object[]{"dcrit"});
                AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPlotLayout.getPlotInit().getDataTreeInterface();
                AbstractModel abstractModel = (AbstractModel)abstractDataMatrix.getTreeParent();
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)abstractModel.getComponentsInt()});
                double[] dArray = ((AbstractAxisPlot)abstractPlotLayout.getMainWindow()).getMinmax(0, 0);
                double d = (dArray[1] - dArray[0]) * 0.1;
                abstractPlotLayout.show("xmin", Double.valueOf(dArray[0] - d));
                abstractPlotLayout.show("xmax", Double.valueOf(dArray[1] + d));
                double[] dArray2 = ((AbstractAxisPlot)abstractPlotLayout.getMainWindow()).getMinmax(1, 0);
                double d2 = (dArray2[1] - dArray2[0]) * 0.1;
                double d3 = dArray2[1] + d2;
                if (abstractModel.isUseDcrit()) {
                    d3 = Math.max(d3, abstractModel.getDcritX()) * 2.0;
                }
                abstractPlotLayout.show("ymin", Double.valueOf(dArray2[0] - d2));
                abstractPlotLayout.show("ymax", Double.valueOf(d3));
            }
        }), 1, 3, 1, 1, BasicAnalyse.ModelMethod.QuantificationPls, BasicAnalyse.ModelMethod.ClassificationPlsDa);
    }

    private void addPcaOverviewPlots() {
        this.addViewPanel((Component)((Object)new SampleOutlierPanelStep.DistanceToModelPlot(this.mainpanel, "Histogram", false)), 0, 0, 1, 1, BasicAnalyse.ModelMethod.SamplePca);
        this.addViewPanel((Component)((Object)new SampleOutlierPanelStep.TpredHotellingPlot(this.mainpanel, false)), 0, 1, 1, 1, BasicAnalyse.ModelMethod.SamplePca);
        Properties properties = new Properties();
        properties.setProperty("colorscheme", "[custom]");
        properties.setProperty("colors", "2");
        properties.setProperty("color1", "rgba(255,255,255,1)");
        properties.setProperty("color2", "rgba(0,0,0,0.01)");
        this.addViewPanel((Component)((Object)new PlotViewPanel(this.mainpanel, "Measurements", "Contour2D", new String[]{"xtr", "xtr", "xtr"}){

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                AbstractDataMatrix abstractDataMatrix = abstractPlotLayout.getPlotInit().getMatrix(0);
                int[] nArray = this.calculateDefaultBand(abstractDataMatrix.getK());
                for (int i = 0; i < 3; ++i) {
                    AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf((double)i + 1.0));
                    PlotInit plotInit = abstractAxisLayer.getPlotInit();
                    plotInit.ccolorindex = Plot_GUI.getCsh().getRgbIndex(i);
                    abstractAxisLayer.setLayerName(Plot_GUI.RGB_NAMES[i]);
                    Properties properties = new Properties();
                    properties.setProperty("colorscheme", Plot_GUI.RGB_NAMES[i]);
                    properties.put("forcereflectance", String.valueOf(abstractPlotLayout.isAbsorbanceData()));
                    abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", (double)nArray[i], properties});
                }
            }

            private int[] calculateDefaultBand(int n) {
                int[] nArray = new int[Math.min(n, 3)];
                for (int i = 0; i < nArray.length; ++i) {
                    if (n > 10) {
                        int n2 = n / 4;
                        nArray[i] = n2 * i + n2;
                        continue;
                    }
                    nArray[i] = i;
                }
                return nArray;
            }

            @Override
            public boolean supportChange() {
                return false;
            }

            @Override
            public boolean hasInteraction(boolean bl) {
                return false;
            }
        }), 1, 0, 1, 2, BasicAnalyse.ModelMethod.SamplePca);
    }

    private void addSimcaOverviewPlots(EntryMainPanel entryMainPanel) {
        this.addViewPanel((Component)((Object)new PlotViewPanel(entryMainPanel, "Coomans plot", "Scatter2D", new String[]{"model_obsdmx", "model_predicteddistancetomodel"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractPlotLayout.addLegend(new Object[]{abstractAxisLayer, "color", "right"});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer2.setShape(new Object[]{"fixed", "hollowcircle"});
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                Properties properties = new Properties();
                properties.put("editable", Boolean.toString(false));
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer.setStatistics(new Object[]{"coomans", properties});
                abstractPlotLayout.setColor(new Object[]{"category", ModelStatisticsViewContainer.this.analyse.getCategoryFactor().getName()});
                abstractPlotLayout.setDataRange(new Object[]{"x", "value", 1.0});
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", 2.0});
            }
        }), 0, 0, 1, 1, BasicAnalyse.ModelMethod.SimcaClassification);
    }

    private void addCurveSeparationOverviewPlots(EntryMainPanel entryMainPanel) {
        this.addViewPanel((Component)((Object)new CurveSeparationPanelStep.CurveSeparationScatterPlot(entryMainPanel, false, null, true)), 0, 0, 1, 1, BasicAnalyse.ModelMethod.ClassificationCurveSeparation);
    }

    public void addViewPanel(Component component, int n, int n2, int n3, int n4, BasicAnalyse.ModelMethod ... modelMethodArray) {
        super.addViewPanel(component, n, n2, n3, n4);
        this.visualizations.add(new VisualizationType(component, modelMethodArray));
    }

    public void setClassesColor(boolean bl, AbstractPlotLayout abstractPlotLayout, EntryMainPanel entryMainPanel) {
        if (bl) {
            Analyse analyse = (Analyse)entryMainPanel.getSelectedEntry();
            if (analyse != null && analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.ClassificationPlsDa)) {
                abstractPlotLayout.setColor(new Object[]{"category", analyse.getCategoryFactors().get(0).toString()});
            } else {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(0)});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer2.setColor(new Object[]{"fixed", RtPerfectSpread.generateColor(1)});
            }
        }
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.analyse = (Analyse)object;
        BasicAnalyse.ModelMethod modelMethod = this.analyse != null ? this.analyse.getModelMethod() : null;
        for (VisualizationType visualizationType : this.visualizations) {
            visualizationType.setAnalyseAndShowIfSupported(this.analyse, modelMethod);
        }
        if (this.tabViewContainer.isVisible()) {
            this.onContentReady(() -> SwingUtilities.invokeLater(() -> {
                this.tabViewContainer.clearTabs();
                this.modelYcalcPlot.setAnalyse(this.analyse);
                if (this.analyse.getModelMethod().isClassification()) {
                    CategoryFactor categoryFactor = this.analyse.getCategoryFactor();
                    if (categoryFactor != null) {
                        for (CatClass catClass : categoryFactor.getClasses()) {
                            if (!catClass.isIncluded() || catClass.isNoClass()) continue;
                            this.tabViewContainer.addTab(catClass.getName(), this.modelYcalcPlot);
                        }
                    }
                } else {
                    for (Object f : this.analyse.getFactorList()) {
                        this.tabViewContainer.addTab(((Factor)f).getName(), this.modelYcalcPlot);
                    }
                }
                this.tabViewContainer.setSelectedTab(0, 0);
                this.tabViewContainer.repaint();
            }));
        }
        super.showEntry(object, object2);
    }

    private class VisualizationType {
        private final Component panel;
        private final List<BasicAnalyse.ModelMethod> modelTypes;

        public VisualizationType(Component component, BasicAnalyse.ModelMethod ... modelMethodArray) {
            this.panel = component;
            this.modelTypes = Arrays.asList(modelMethodArray);
        }

        public void setAnalyseAndShowIfSupported(Analyse analyse, BasicAnalyse.ModelMethod modelMethod) {
            boolean bl = this.modelTypes.contains((Object)modelMethod);
            this.panel.setVisible(bl);
            if (bl && this.panel instanceof PlotViewPanel) {
                ModelStatisticsViewContainer.this.onContentReady(() -> ((PlotViewPanel)((Object)this.panel)).setAnalyse(analyse));
            }
        }
    }
}

