/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.cache.BaseWorkflowList;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.model.edit.EditModelPanel;

public class EditRecordGroupPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private AnalyseSpectralGroup analyseSpectralGroup;
    private final EditModelPanel workflowPanel;
    private boolean settingdata = true;
    private final BreezeButton duplicateButton;
    private final DescriptorListCellRenderer descriptorListCellRenderer = new DescriptorListCellRenderer();
    private JPanel emptyPanel;
    private BreezeComboBox recordComboBox;
    private JLabel recordLabel;
    private BreezeComboBox studyComboBox;
    private JLabel studyLabel;

    public EditRecordGroupPanel(final EditModelPanel editModelPanel, final Analyse analyse, boolean bl) {
        this.workflowPanel = editModelPanel;
        this.initComponents();
        for (BasicWorkflow basicWorkflow : BreezeMasterCache.getInstance().getStudyList()) {
            this.studyComboBox.addItem(basicWorkflow);
        }
        this.studyComboBox.setRenderer(this.descriptorListCellRenderer);
        this.studyComboBox.setName("study");
        Workflow workflow = (Workflow)this.studyComboBox.getSelectedItem();
        if (workflow != null) {
            this.setStudy(workflow);
        }
        this.recordComboBox.setRenderer(this.descriptorListCellRenderer);
        this.recordComboBox.setName("group");
        this.duplicateButton = new BreezeButton();
        this.duplicateButton.setDesc("Duplicate");
        this.duplicateButton.setDescForeground(new Color(110, 110, 110));
        this.duplicateButton.setIcon(new ImageIcon(editModelPanel.getClass().getResource("/images/material/content_copy.png")));
        this.duplicateButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EditRecordGroupPanel this$0;
            {
                this.this$0 = editRecordGroupPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AnalyseSpectralGroup analyseSpectralGroup = this.this$0.analyseSpectralGroup.copy();
                analyse.getGroups().add(analyseSpectralGroup);
                editModelPanel.selectEntryAndSave(analyseSpectralGroup);
            }
        });
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.duplicateButton);
    }

    @Override
    public String getType() {
        return "RecordGroups";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.settingdata = true;
        if (object instanceof AnalyseSpectralGroup) {
            Object object3;
            this.analyseSpectralGroup = (AnalyseSpectralGroup)object;
            Group group = this.analyseSpectralGroup.getGroup();
            if (group == null) {
                object3 = this.analyseSpectralGroup.getStudyId();
                if (object3 == null) {
                    group = (Group)this.recordComboBox.getSelectedItem();
                    if (this.analyseSpectralGroup != null) {
                        this.analyseSpectralGroup.setGroup(group);
                    }
                } else {
                    BaseWorkflowList baseWorkflowList = (BaseWorkflowList)EditRecordGroupPanel.getParent(BreezeType.Project);
                    Workflow workflow = baseWorkflowList.byId((String)object3);
                    if (workflow != null) {
                        group = this.getGroupById(workflow, this.analyseSpectralGroup.getGroupId());
                    }
                }
            }
            if (group != null) {
                object3 = group.getParent();
                this.studyComboBox.setSelectedItem(object3);
                this.setStudy((Workflow)object3);
                this.recordComboBox.setSelectedItem(group);
            }
        }
        this.settingdata = false;
    }

    public Group getGroupById(Workflow workflow, String string) {
        if (string != null) {
            for (Group group : workflow.getChildList()) {
                if (!string.equals(group.getUid())) continue;
                return group;
            }
        }
        return null;
    }

    private static Iterable getParent(BreezeType breezeType) {
        return EditRecordGroupPanel.getRootEntry(breezeType);
    }

    private static Iterable getRootEntry(BreezeType breezeType) {
        return switch (breezeType) {
            case BreezeType.Analyse -> BreezeMasterCache.getInstance().getAnalyseList();
            case BreezeType.Workflow -> BreezeMasterCache.getInstance().getWorkflowList();
            case BreezeType.Project -> BreezeMasterCache.getInstance().getStudyList();
            default -> null;
        };
    }

    private void recordGroupChanged() {
        this.workflowPanel.selectEntryAndSave(this.analyseSpectralGroup);
        this.workflowPanel.updateSelected();
    }

    private void initComponents() {
        this.recordLabel = new JLabel();
        this.recordComboBox = new BreezeComboBox();
        this.studyLabel = new JLabel();
        this.studyComboBox = new BreezeComboBox();
        this.emptyPanel = new JPanel();
        this.setBackground(new Color(51, 51, 51));
        this.setLayout(new GridBagLayout());
        this.recordLabel.setFont(new Font("Tahoma", 0, 18));
        this.recordLabel.setForeground(new Color(255, 255, 255));
        this.recordLabel.setText("Group");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.add(this.recordLabel, gridBagConstraints);
        this.recordComboBox.addItemListener(this::recordComboBoxItemStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add(this.recordComboBox, gridBagConstraints);
        this.studyLabel.setFont(new Font("Tahoma", 0, 18));
        this.studyLabel.setForeground(new Color(255, 255, 255));
        this.studyLabel.setText("Study");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.add(this.studyLabel, gridBagConstraints);
        this.studyComboBox.addItemListener(this::studyComboBoxItemStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add(this.studyComboBox, gridBagConstraints);
        this.emptyPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.emptyPanel, gridBagConstraints);
    }

    private void studyComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.settingdata || itemEvent.getStateChange() != 1) {
            return;
        }
        Workflow workflow = (Workflow)this.studyComboBox.getSelectedItem();
        this.settingdata = true;
        this.setStudy(workflow);
        this.settingdata = false;
        this.updateSelectedRecordGroup();
    }

    private void setStudy(Workflow workflow) {
        this.recordComboBox.removeAllItems();
        for (Group group : workflow.getChildList()) {
            this.recordComboBox.addItem(group);
        }
    }

    private void recordComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.settingdata || itemEvent.getStateChange() != 1) {
            return;
        }
        this.updateSelectedRecordGroup();
    }

    private void updateSelectedRecordGroup() {
        Group group = (Group)this.recordComboBox.getSelectedItem();
        if (this.analyseSpectralGroup != null) {
            this.analyseSpectralGroup.setGroup(group);
        }
        this.recordGroupChanged();
    }

    private class DescriptorListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        public DescriptorListCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof AbstractDescriptorInfo) {
                AbstractDescriptorInfo abstractDescriptorInfo = (AbstractDescriptorInfo)object;
                object = abstractDescriptorInfo.getDescription();
            } else if (object instanceof Entry) {
                Entry entry = (Entry)object;
                object = entry.getName();
            }
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

