/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.evince.data.AnalyseDataHelper;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.main.model.table.BreezeClassificationRenderer;
import se.prediktera.breeze.frontend.main.model.table.BreezeClassificationTableModel;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;

public class BreezeClassificationTable
extends BreezeInnerTable {
    private BreezeClassificationTableModel model;
    private AbstractDataSource dataSource;
    private SampleListCreator creator;

    public BreezeClassificationTable(DataInit dataInit) {
        super(dataInit, false, false);
        BreezeTable breezeTable = this.innerTable.getTable();
        this.innerTable.addColumnSelectionListener();
        breezeTable.setCellSelectionEnabled(true);
        breezeTable.setCellFocusEnabled(false);
        breezeTable.getSelectionModel().setSelectionMode(0);
        breezeTable.setDefaultRenderer(BreezeClassificationTableModel.PredictionClass.class, new BreezeClassificationRenderer());
        this.innerTable.setInteractionTable(this);
    }

    @Override
    protected BreezeTablePanelInterface createTableModel() {
        this.model = new BreezeClassificationTableModel();
        return this.model;
    }

    public String getGUI_Name() {
        return "BreezeClassificationTable";
    }

    protected String getDefaultTitle() {
        return "Breeze Classification Table";
    }

    public boolean hasInteractivity() {
        return true;
    }

    public int getInteractiveTag() {
        return 1;
    }

    public void setCreator(SampleListCreator sampleListCreator) {
        this.creator = sampleListCreator;
    }

    @Override
    public void prepareInteraction() {
        BreezeTable breezeTable = this.innerTable.getTable();
        BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)breezeTable.getModel());
        if (breezeTableModel.isSorting() || this.dataSource == null) {
            return;
        }
        InteractionArray interactionArray = this.project_GUI.getInteractionArray((DataTreeInterface)this.dataSource.getCase(), this.getInteractiveTag(), this.dataSource.getRowCount(), 0);
        int[] nArray = breezeTable.getSelectedRows();
        int[] nArray2 = breezeTable.getSelectedColumns();
        for (int n : nArray) {
            BreezeClassificationTableModel.PredictionRow predictionRow = (BreezeClassificationTableModel.PredictionRow)breezeTableModel.getObjectAt(n);
            for (int n2 : nArray2) {
                Object object = breezeTableModel.getValueAt(n, n2);
                if (!(object instanceof BreezeClassificationTableModel.PredictionClass)) continue;
                for (Sample sample : predictionRow.getSampleAt((BreezeClassificationTableModel.PredictionClass)object)) {
                    interactionArray.set(sample.getCachedInteractionTableIndex());
                }
            }
        }
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        super.nodeReplaced(dataTreeEvent);
        if (dataTreeEvent.getDataTreeInterface() instanceof AbstractDataMatrix) {
            AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataTreeEvent.getReplaceDataTreeInterface();
            this.dataSource = abstractDataMatrix.getCase().getDataSource();
            this.getDataInit().setDataTreeInterface((DataTreeInterface)abstractDataMatrix);
            if (this.dataSource instanceof AnalyseDataHelper.PredictionDataSource) {
                this.setSamplePredictionList(((AnalyseDataHelper.PredictionDataSource)this.dataSource).getSamplePredictionList());
            } else if (this.creator != null) {
                this.setSamplePredictionList(this.creator.create(this.dataSource));
            } else {
                this.setSamplePredictionList(null);
            }
        }
    }

    public void setSamplePredictionList(SamplePredictionList samplePredictionList) {
        if (samplePredictionList != null && samplePredictionList.getActualFactor() instanceof CategoryFactor) {
            SharedPredictionTable sharedPredictionTable = samplePredictionList.createPredictionMatrix();
            this.model.setSamplePredictionList(samplePredictionList);
            ArrayList<BreezeClassificationTableModel.PredictionRow> arrayList = new ArrayList<BreezeClassificationTableModel.PredictionRow>();
            for (CatClass catClass : samplePredictionList.getActualClasses()) {
                if (catClass.isNoClass() || !catClass.isIncluded()) continue;
                arrayList.add(new BreezeClassificationTableModel.PredictionRowClass(sharedPredictionTable, catClass));
            }
            arrayList.add(new BreezeClassificationTableModel.PredictionRow());
            arrayList.add(new BreezeClassificationTableModel.PredictionRowPredicted(sharedPredictionTable));
            arrayList.add(new BreezeClassificationTableModel.PredictionRowNameNumber(sharedPredictionTable, "Correctly", sharedPredictionTable.getCorrectly(), sharedPredictionTable.getTotal()));
            arrayList.add(new BreezeClassificationTableModel.PredictionRowNameNumber(sharedPredictionTable, "Incorrectly", sharedPredictionTable.getTotal() - sharedPredictionTable.getCorrectly(), sharedPredictionTable.getTotal()));
            arrayList.add(new BreezeClassificationTableModel.PredictionRow());
            arrayList.add(new BreezeClassificationTableModel.PredictionRowStatistics(sharedPredictionTable, BreezeClassificationTableModel.StatisticsType.Precision));
            arrayList.add(new BreezeClassificationTableModel.PredictionRowStatistics(sharedPredictionTable, BreezeClassificationTableModel.StatisticsType.Recall));
            arrayList.add(new BreezeClassificationTableModel.PredictionRowStatistics(sharedPredictionTable, BreezeClassificationTableModel.StatisticsType.Fscore));
            this.innerTable.setTableList(arrayList, null);
        } else {
            this.innerTable.setTableList(new ArrayList(), null);
        }
    }

    @Override
    protected String getSaveFilename(String string) {
        return "Confusion Matrix " + string + " " + new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date());
    }

    public static interface SampleListCreator {
        public SamplePredictionList create(AbstractDataSource var1);
    }

    public static class Info
    extends AbstractTableInfo {
        public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
            return new BreezeClassificationTable((DataInit)abstractInit);
        }

        public ImageIcon getWizardImage() {
            return null;
        }

        public String getWizardInfo() {
            return "Creates a classification table";
        }

        public boolean supportData(DataTreeInterface dataTreeInterface) {
            return VisualizationDataHelper.isBreezeMatrix(dataTreeInterface);
        }

        public String toString() {
            return "Breeze Classification Table";
        }
    }
}

