/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;

public class BreezeClassificationTableModel
extends DefaultBreezeTableImpl {
    private SamplePredictionList samplePredictionList;

    public void setSamplePredictionList(SamplePredictionList samplePredictionList) {
        this.samplePredictionList = samplePredictionList;
    }

    @Override
    public Vector createVOVector(Object object) {
        PredictionRow predictionRow = (PredictionRow)object;
        Vector<Object> vector = new Vector<Object>();
        vector.add(predictionRow.getName());
        vector.add(predictionRow.getTotal());
        CatClass catClass = null;
        for (CatClass catClass2 : this.samplePredictionList.getPredictedClasses()) {
            if (catClass2.isNoClass() || !catClass2.isIncluded()) {
                if (catClass2.isNoClass()) {
                    catClass = catClass2;
                    continue;
                }
                if (this.samplePredictionList.isModel()) continue;
            }
            vector.add(predictionRow.getPrediction(catClass2));
        }
        if (catClass != null) {
            vector.add(predictionRow.getPrediction(catClass));
        }
        return vector;
    }

    @Override
    public List<Object> getTableHeader(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list.isEmpty()) {
            return arrayList;
        }
        arrayList.add("Actual classes");
        arrayList.add("Total");
        if (this.samplePredictionList != null) {
            CatClass catClass = null;
            for (CatClass catClass2 : this.samplePredictionList.getPredictedClasses()) {
                if (catClass2.isNoClass() || !catClass2.isIncluded()) {
                    if (catClass2.isNoClass()) {
                        catClass = catClass2;
                        continue;
                    }
                    if (this.samplePredictionList.isModel()) continue;
                }
                arrayList.add(catClass2.getName());
            }
            if (catClass != null) {
                arrayList.add("No class");
            }
        }
        return arrayList;
    }

    public static class PredictionRow {
        public String getName() {
            return "";
        }

        public PredictionClass getTotal() {
            return new PredictionClass(null);
        }

        public PredictionClass getPrediction(CatClass catClass) {
            return new PredictionClass(catClass);
        }

        public List<Sample> getSampleAt(PredictionClass predictionClass) {
            return new ArrayList<Sample>();
        }
    }

    public static class PredictionClass {
        private final CatClass catClass;
        private final float number;
        private final float percent;
        private final Type type;

        public PredictionClass(CatClass catClass) {
            this.catClass = catClass;
            this.number = 0.0f;
            this.percent = 0.0f;
            this.type = Type.None;
        }

        public PredictionClass(CatClass catClass, float f, float f2, Type type) {
            this.catClass = catClass;
            this.number = f;
            this.type = type;
            this.percent = f2 > 0.0f ? f / f2 : 0.0f;
        }

        public String toString() {
            if (this.showData()) {
                if (this.type == Type.Statistics) {
                    return NiceDataFormat.toPercent((double)this.percent, (boolean)true);
                }
                String string = NiceDataFormat.toString((double)this.number);
                if (this.percent > 0.0f) {
                    return string + " (" + NiceDataFormat.toPercent((double)this.percent, (boolean)true) + ")";
                }
                return string;
            }
            return "";
        }

        public float getPercent() {
            return this.percent;
        }

        public Type getType() {
            if (this.showData()) {
                return this.type;
            }
            return Type.None;
        }

        private boolean showData() {
            return this.number > 0.0f || this.type.equals((Object)Type.Total) || this.type.equals((Object)Type.Diagonal) || this.type.equals((Object)Type.Statistics);
        }

        public CatClass getCatClass() {
            return this.catClass;
        }
    }

    public static class PredictionRowNameNumber
    extends PredictionRow {
        private final SharedPredictionTable predictionTable;
        private final String name;
        private final int number;
        private final int total;

        public PredictionRowNameNumber(SharedPredictionTable sharedPredictionTable, String string, int n, int n2) {
            this.predictionTable = sharedPredictionTable;
            this.name = string;
            this.number = n;
            this.total = n2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public PredictionClass getTotal() {
            return new PredictionClass(null, this.number, this.total, Type.None);
        }

        @Override
        public PredictionClass getPrediction(CatClass catClass) {
            return new PredictionClass(catClass);
        }

        @Override
        public List<Sample> getSampleAt(PredictionClass predictionClass) {
            if (this.name.equals("Correctly")) {
                return this.predictionTable.getCorrectlyObjects();
            }
            return this.predictionTable.getIncorrectlyObjects();
        }
    }

    public static class PredictionRowStatistics
    extends PredictionRow {
        private final SharedPredictionTable predictionTable;
        private final StatisticsType type;

        public PredictionRowStatistics(SharedPredictionTable sharedPredictionTable, StatisticsType statisticsType) {
            this.predictionTable = sharedPredictionTable;
            this.type = statisticsType;
        }

        @Override
        public String getName() {
            return this.type.toString();
        }

        @Override
        public PredictionClass getTotal() {
            return null;
        }

        @Override
        public PredictionClass getPrediction(CatClass catClass) {
            if (!catClass.isNoClass()) {
                int n = catClass.getValueIdx();
                int n2 = this.predictionTable.get(n, n);
                int n3 = this.predictionTable.getTotal(n);
                int n4 = this.predictionTable.get(n);
                return switch (this.type.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new PredictionClass(catClass, n2, n3, Type.Statistics);
                    case 1 -> new PredictionClass(catClass, n2, n4, Type.Statistics);
                    case 2 -> {
                        float var6_6 = (float)n2 / (float)n3;
                        float var7_7 = (float)n2 / (float)n4;
                        yield new PredictionClass(catClass, 2.0f * var6_6 * var7_7, var6_6 + var7_7, Type.Statistics);
                    }
                };
            }
            return null;
        }
    }

    public static enum StatisticsType {
        Precision(""),
        Recall(""),
        Fscore("F-score");

        private final String name;

        private StatisticsType(String string2) {
            this.name = string2.length() > 0 ? string2 : this.name();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PredictionRowPredicted
    extends PredictionRow {
        protected final SharedPredictionTable predictionTable;

        public PredictionRowPredicted(SharedPredictionTable sharedPredictionTable) {
            this.predictionTable = sharedPredictionTable;
        }

        @Override
        public String getName() {
            return "# Predicted";
        }

        @Override
        public PredictionClass getTotal() {
            return new PredictionClass(null, this.predictionTable.getTotal(), this.predictionTable.getTotal(), Type.Total);
        }

        @Override
        public PredictionClass getPrediction(CatClass catClass) {
            return new PredictionClass(catClass, this.predictionTable.getTotal(catClass.getValueIdx()), this.predictionTable.getTotal(), Type.Total);
        }

        @Override
        public List<Sample> getSampleAt(PredictionClass predictionClass) {
            if (predictionClass.getCatClass() != null) {
                return this.predictionTable.getTotalObject(predictionClass.getCatClass().getValueIdx() + 1);
            }
            return new ArrayList<Sample>(this.predictionTable.getAllObjects());
        }
    }

    public static class PredictionRowClass
    extends PredictionRow {
        private final CatClass actualClass;
        private final SharedPredictionTable predictionTable;

        public PredictionRowClass(SharedPredictionTable sharedPredictionTable, CatClass catClass) {
            this.predictionTable = sharedPredictionTable;
            this.actualClass = catClass;
        }

        @Override
        public PredictionClass getPrediction(CatClass catClass) {
            return new PredictionClass(catClass, this.predictionTable.get(this.actualClass.getValueIdx(), catClass.getValueIdx()), this.predictionTable.get(this.actualClass.getValueIdx()), this.getType(catClass));
        }

        private Type getType(CatClass catClass) {
            if (catClass.isAdded()) {
                return Type.Added;
            }
            return this.actualClass.getValueIdx() == catClass.getValueIdx() ? Type.Diagonal : Type.Error;
        }

        @Override
        public PredictionClass getTotal() {
            return new PredictionClass(null, this.predictionTable.get(this.actualClass.getValueIdx()), this.predictionTable.getTotal(), Type.TotalClass);
        }

        @Override
        public List<Sample> getSampleAt(PredictionClass predictionClass) {
            if (predictionClass.getCatClass() != null) {
                return this.predictionTable.getObject(this.actualClass.getValueIdx(), predictionClass.getCatClass().getValueIdx() + 1);
            }
            if (predictionClass.getType().equals((Object)Type.TotalClass)) {
                return this.predictionTable.getObject(this.actualClass.getValueIdx(), 0);
            }
            return new ArrayList<Sample>();
        }

        @Override
        public String getName() {
            if (this.actualClass.isNoClass()) {
                return "No class";
            }
            return this.actualClass.getName();
        }
    }

    public static enum Type {
        Diagonal(Color.green),
        Error(Color.red),
        TotalClass(Color.white),
        Total(Color.orange),
        None(Color.white),
        Statistics(Color.white),
        Added(Color.yellow);

        private final Color color;

        private Type(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return RtPerfectSpread.blendWhite(this.color, 0.6, 0.0);
        }
    }
}

