/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelCompareTableModel;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class BreezeModelCompareTable
extends BreezeInnerTable {
    private Analyse analyse;

    public BreezeModelCompareTable(DataInit dataInit) {
        super(dataInit, false, false);
        this.innerTable.getTable().getSelectionModel().setSelectionMode(2);
    }

    @Override
    protected BreezeTablePanelInterface createTableModel() {
        return new BreezeModelCompareTableModel();
    }

    public String getGUI_Name() {
        return "BreezeModelCompareTable";
    }

    protected String getDefaultTitle() {
        return "Breeze Model Compare Table";
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        ArrayList<Analyse> arrayList = new ArrayList<Analyse>();
        if (this.analyse != null) {
            List<BasicAnalyse> list = BasicMasterCache.getInstance().getAnalyseLists();
            List<BasicAnalyse> list2 = BasicAnalyseList.get(list, Collections.singletonList(this.analyse.getModelMethod().getType()));
            String string = this.analyse.getStudyId();
            if (string != null && string.length() > 0) {
                for (BasicAnalyse basicAnalyse : list2) {
                    if (!(basicAnalyse instanceof Analyse) || !basicAnalyse.partOfStudy(string)) continue;
                    arrayList.add((Analyse)basicAnalyse);
                }
            }
        }
        this.innerTable.setTableList(arrayList, this.analyse, true);
    }

    public void setAnalyse(Analyse analyse) {
        this.analyse = analyse;
    }

    public static class Info
    extends AbstractTableInfo {
        public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
            return new BreezeModelCompareTable((DataInit)abstractInit);
        }

        public ImageIcon getWizardImage() {
            return null;
        }

        public String getWizardInfo() {
            return "Creates a table per model";
        }

        public boolean supportData(DataTreeInterface dataTreeInterface) {
            return VisualizationDataHelper.isBreezeModelMatrix(dataTreeInterface);
        }

        public String toString() {
            return "Breeze Model Compare Table";
        }
    }
}

